/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.twitter;

import com.sonyericsson.twitter.APIListener;
import com.sonyericsson.twitter.AvatarButton;
import com.sonyericsson.twitter.Tweet;
import com.sonyericsson.twitter.TwitterButton;
import com.sonyericsson.twitter.TwitterCanvas;
import com.sonyericsson.twitter.TwitterClient;
import com.sonyericsson.twitter.TwitterDialog;
import javax.microedition.lcdui.Graphics;
import se.vitamin.ui.ButtonList;
import se.vitamin.ui.Canvas;
import se.vitamin.ui.UI;
import se.vitamin.ui.Window;

public class TweetDialog
extends TwitterDialog
implements APIListener {
    AvatarButton _userButton = null;
    String _screenName;
    String _profileName;
    ButtonList _buttons;
    Tweet _t;
    int _id = -1;
    boolean favorite;

    public TweetDialog(Canvas canvas, Window parent) {
        super(canvas, parent);
        this.favorite = false;
        this._x = 5;
        this._y = 10;
        this._w = 230;
        this._h = TwitterCanvas.largeScreen ? 377 : 265;
    }

    public TweetDialog(Canvas canvas, Window parent, boolean favorites) {
        super(canvas, parent);
        this.favorite = favorites;
        this._x = 5;
        this._y = 10;
        this._w = 230;
        this._h = 265;
    }

    public boolean handleKeyDown(int key) {
        switch (key) {
            case -2: {
                if (this._userButton.isActive()) {
                    if (!this._userButton.nextLink()) {
                        this._userButton.deactivate();
                        this._buttons.activate();
                        this._buttons.selectButton(0);
                        ((TwitterCanvas)this._canvas).setCommands();
                        return true;
                    }
                    return true;
                }
                this._buttons.handleKeyDown(key);
                return true;
            }
            case -1: {
                if (this._userButton.isActive()) {
                    if (!this._userButton.prevLink() && !this._userButton.activateText()) {
                        return this._buttons.handleKeyDown(key);
                    }
                    return true;
                }
                if (this._buttons.getIndex() == 0) {
                    if (!this._userButton.activeLastLink()) {
                        return this._buttons.handleKeyDown(key);
                    }
                    this._buttons.deactivate();
                    this._userButton.activate();
                    ((TwitterCanvas)this._canvas).setCommands();
                    return true;
                }
                this._buttons.handleKeyDown(key);
                return true;
            }
            case -5: {
                if (this._userButton.isActive()) {
                    try {
                        TwitterClient._instance.platformRequest(this._userButton.getLink());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return true;
                }
                this._buttons.handleKeyDown(key);
                return true;
            }
        }
        return super.handleKeyDown(key);
    }

    public void setTweet(Tweet t) {
        this._t = t;
        this.removeAllWidgets();
        this._userButton = new AvatarButton(this, -1, t, UI.smallFont, UI.largeFont);
        this._userButton.setColors(0, 0);
        this._userButton.setTextColors(549498, 549498);
        this._userButton.setPosition(5, 5);
        this._userButton.setDimensions(this._w - 10, 0);
        this._buttons = new ButtonList(this, 0, 10, this._userButton.getHeight() + 20, 210);
        this._buttons.setAlignment(0);
        this._buttons.addButton(new TwitterButton(null, 103, 129, -1, UI.mediumFont, null));
        this._buttons.addButton(new TwitterButton(null, 104, 132, -1, UI.mediumFont, null));
        if (this.favorite) {
            this._buttons.addButton(new TwitterButton(null, 105, 126, -1, UI.mediumFont, null));
        } else {
            this._buttons.addButton(new TwitterButton(null, 106, 33, -1, UI.mediumFont, null));
        }
        this._screenName = t.screenname;
        this.selectFirstWidget();
        this._userButton.deactivate();
        this._buttons.activate();
        this._buttons.selectButton(0);
        if (this._userButton.activateText()) {
            this._userButton.activate();
            this._buttons.deactivate();
        } else {
            this.selectNextWidget();
        }
    }

    public void update(long deltaTime) {
    }

    public void paint(Graphics g) {
        if (this._active) {
            // empty if block
        }
        super.paint(g);
    }

    public void widgetEvent(int id, int event) {
        this._id = id;
        switch (id) {
            case 103: {
                ((TwitterCanvas)this._canvas).showReplyTweet(this._t);
                break;
            }
            case 104: {
                ((TwitterCanvas)this._canvas).showForwardTweet(this._t);
                break;
            }
            case 106: {
                ((TwitterCanvas)this._canvas).createfavorite(this._t);
                break;
            }
            default: {
                super.widgetEvent(id, event);
            }
        }
    }

    public void activate() {
        this._active = true;
    }

    public void cancel() {
    }

    public void twitterEvent(int ID, String response) {
    }

    public boolean linkActive() {
        return this._userButton.isActive();
    }

    public void languageUpdate() {
        if (this._buttons != null) {
            this._buttons.languageUpdate();
        }
    }
}

