/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.twitter;

import com.sonyericsson.twitter.APIListener;
import com.sonyericsson.twitter.TwitterButton;
import com.sonyericsson.twitter.TwitterCanvas;
import com.sonyericsson.twitter.TwitterCheckBox;
import com.sonyericsson.twitter.TwitterClient;
import com.sonyericsson.twitter.TwitterTextBox;
import javax.microedition.lcdui.Graphics;
import se.vitamin.ui.Canvas;
import se.vitamin.ui.TextLabel;
import se.vitamin.ui.UI;
import se.vitamin.ui.Window;

public class TweetScreen
extends Window
implements APIListener {
    private static final int TWITTER_TEXTBOX = 0;
    private static final int TWITTER_TYPE_NEW = 0;
    private static final int TWITTER_TYPE_REPLY = 1;
    private static final int TWITTER_TYPE_FORWARD = 2;
    private static final int TWITTER_TYPE_DIRECT_MESSAGE = 3;
    private String messageID = "";
    private String username = "";
    int locID = -1;
    private static final int TWITTER_CHECK_ID = 1;
    private TwitterCheckBox checkBox = null;
    private int type = 0;
    private TwitterTextBox textbox;
    private TextLabel title = new TextLabel(this, 199, UI.mediumFont, 0, 40);
    private TwitterButton _button;

    public TweetScreen(Canvas parent, Window screen) {
        super(parent, screen);
        this.title.setAlignment(0);
        this.title.setColors(9353926, 549498);
        this.title.setPosition(0, 40);
        this._w = 220;
        this.textbox = new TwitterTextBox(this, 0, 10, 0, UI.smallFont, false);
        this.textbox.setMinimumHeight(88);
        this.textbox.setMaxSize(140);
        if (TwitterClient.useLocation) {
            this.checkBox = new TwitterCheckBox(this, 1);
            this.checkBox.setFont(UI.smallFont);
            this.checkBox.setLabel(1);
            this.checkBox.setPosition(20, TwitterCanvas.largeScreen ? 243 : 183);
            this.checkBox.set();
        }
        this._button = new TwitterButton((Window)this, 15, 104, -1, UI.mediumFont, null);
        this._button.setPosition(66, TwitterCanvas.largeScreen ? 275 : 215);
        this._button.setDimensions(120, 0);
        this._button.setAlignment(0);
        this._currentWidget = 1;
        this.textbox.activate();
    }

    public void activate() {
        Canvas._activeScreen = this;
        this._active = true;
        this._currentWidget = 1;
        this.textbox.activate();
        if (TwitterClient.useLocation) {
            this.checkBox.deactivate();
            if (TwitterClient.addLocation == 1) {
                this.checkBox.set();
            } else {
                this.checkBox.unset();
            }
        }
        this._button.deactivate();
    }

    public boolean handleKeyDown(int key) {
        if (key == -7) {
            this.textbox.deactivate();
            if (TwitterClient.useLocation) {
                this.checkBox.deactivate();
            }
            this._button.deactivate();
            ((TwitterCanvas)this._canvas).doneMessage(false, true);
            return true;
        }
        if (this.textbox.isActive()) {
            if (this.textbox.handleKeyDown(key)) {
                return true;
            }
            switch (key) {
                case -5: {
                    this.widgetEvent(77, 0);
                    break;
                }
                case -7: {
                    this.textbox.deactivate();
                    if (TwitterClient.useLocation) {
                        this.checkBox.deactivate();
                    }
                    this._button.deactivate();
                    ((TwitterCanvas)this._canvas).doneMessage(false, true);
                    return true;
                }
                default: {
                    this.textbox.deactivate();
                    break;
                }
                case 35: 
                case 42: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    return true;
                }
            }
        }
        return super.handleKeyDown(key);
    }

    public void deactivate() {
        super.deactivate();
    }

    public boolean handleKeyUp(int key) {
        return this.textbox.handleKeyUp(key);
    }

    public boolean handleLongPress(int key) {
        return this.textbox.handleLongPress(key);
    }

    public void selectNextWidget() {
        super.selectNextWidget();
        ((TwitterCanvas)this._canvas).setCommands();
    }

    public void selectPrevWidget() {
        super.selectPrevWidget();
        ((TwitterCanvas)this._canvas).setCommands();
    }

    public int getActiveComponent() {
        if (this.textbox.isActive()) {
            return 10;
        }
        if (this._button.isActive()) {
            return 1;
        }
        if (TwitterClient.useLocation) {
            if (this.checkBox.isChecked()) {
                return 12;
            }
            return 11;
        }
        return 1;
    }

    public void update() {
        super.update();
    }

    public void paint(Graphics g) {
        g.drawImage(TwitterClient.createGradient(230, 240, 8, 255), 5, TwitterCanvas.largeScreen ? 80 : 20, 0);
        super.paint(g);
        g.setColor(0);
        g.setFont(UI.smallFont);
        g.drawString(Integer.toString(this.textbox.getCharsLeft()), 230, TwitterCanvas.largeScreen ? 235 : 175, 24);
    }

    public void handlePointerDown(int x, int y) {
    }

    public void clear() {
        this.textbox.setString("");
    }

    public void widgetEvent(int id, int event) {
        System.out.println("widgetEvent " + id);
        if (id == 15) {
            if (this.textbox.getString().length() > 140) {
                ((TwitterCanvas)this._canvas).showPopup(77, false);
            } else {
                if (TwitterClient.useLocation && this.checkBox.isChecked()) {
                    this.locID = TwitterClient.apiHandler.updateMyLocation(this);
                    this.textbox.deactivate();
                    if (this.locID == -1) {
                        this.sendTweet(true);
                    } else {
                        ((TwitterCanvas)this._canvas).doneMessage(true, false);
                    }
                } else {
                    this.sendTweet(true);
                }
                System.out.println("Location id " + this.locID);
            }
        } else if (id == 77) {
            ((TwitterCanvas)this._canvas).openTextBox(this.textbox);
        } else if (id == 1) {
            ((TwitterCanvas)this._canvas).setCommands();
        }
    }

    public void sendTweet(boolean popup) {
        int connID = -1;
        if (this.type == 0) {
            connID = TwitterClient.apiHandler.tweet(this.textbox.getString(), this);
        } else if (this.type == 1) {
            connID = TwitterClient.apiHandler.tweetReply(this.textbox.getString(), this.messageID, this.username, this);
        } else if (this.type == 2) {
            connID = this.textbox.getString().length() > 140 ? TwitterClient.apiHandler.tweet(this.textbox.getString().substring(0, 140), this) : TwitterClient.apiHandler.tweet(this.textbox.getString(), this);
        } else if (this.type == 3) {
            connID = TwitterClient.apiHandler.sendPrivateMessage(this.username, this.textbox.getString(), this);
        }
        this.textbox.deactivate();
        ((TwitterCanvas)this._canvas).doneMessage(popup, false);
    }

    public void twitterEvent(int ID, String response) {
        if (ID == this.locID) {
            System.out.println("Got loc id");
            this.sendTweet(false);
        }
    }

    public void setNew() {
        this.title.setTitle(199);
        this.textbox.setString("");
        this.type = 0;
    }

    public void setReplyto(String username, String messageID) {
        this.username = username;
        this.messageID = messageID;
        this.title.setTitle(129);
        this.textbox.setString("@" + username + " ");
        this.type = 1;
    }

    public void setReTweet(String username, String message) {
        this.title.setTitle(132);
        this.textbox.setString(" RT @" + username + ": " + this.cleanText(message));
        this.textbox.caretToStart();
        this.type = 2;
    }

    public void setDirectMessage(String username, String message) {
        this.title.setTitle(17);
        this.textbox.setString("");
        this.username = username;
        this.textbox.caretToStart();
        this.type = 3;
    }

    private String cleanText(String in) {
        in = in.replace('\n', ' ');
        in = in.replace('\r', ' ');
        return in.replace('\u2029', ' ');
    }

    public void cancel() {
        System.out.println("TweetScreen.cancel");
    }

    public void languageUpdate() {
        this.title.updateWidth();
        this._button.reCenter();
    }
}

