/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.twitter;

import com.sonyericsson.twitter.APIListener;
import com.sonyericsson.twitter.JSONStatusParser;
import com.sonyericsson.twitter.StatusParser;
import com.sonyericsson.twitter.TimeStamp;
import com.sonyericsson.twitter.Tweet;
import com.sonyericsson.twitter.TweetDialog;
import com.sonyericsson.twitter.TweetMessage;
import com.sonyericsson.twitter.TweetScreen;
import com.sonyericsson.twitter.TwitterClient;
import com.sonyericsson.twitter.TwitterLocationDialog;
import com.sonyericsson.twitter.TwitterPopup;
import com.sonyericsson.twitter.TwitterTrendDialog;
import com.sonyericsson.twitter.TwitterTypeDialog;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import se.vitamin.ui.Canvas;
import se.vitamin.ui.QuestionListener;
import se.vitamin.ui.TextBox;
import se.vitamin.ui.UI;

public class TwitterCanvas
extends Canvas
implements APIListener,
CommandListener {
    private static final int BOUNCE_WAITING = 0;
    private static final int BOUNCE_INCOMING = 1;
    private static final int BOUNCE_SHUNTING = 2;
    private static final int BOUNCE_BOUNCING = 3;
    public static final int PUBLIC_TIMELINE = 4;
    public static final int TRENDS = 2;
    public static final int NEARBY = 1;
    public static final int MY_TIMELINE = 0;
    public static boolean largeScreen = false;
    private TweetDialog tweetDialog;
    private boolean showTweetDialog = false;
    private boolean showingTrendView = false;
    private TwitterTrendDialog trendDialog = null;
    private String trend = "null";
    private boolean cancelled = false;
    private int current_preference = -1;
    private int old_preference;
    private Image[] bird;
    private Image[] bird_t;
    private TwitterClient callingMidlet;
    public boolean activeMode;
    private Graphics paintDevice;
    private boolean drawnOnce;
    private boolean loadingTwitter;
    private int main_y_offset = 80;
    private int scrollSpeed;
    private boolean decreaseSpeed;
    private int min_y_offset = 80;
    private boolean scrolling;
    private boolean retrieved;
    private boolean bumb_phase_one;
    private boolean bump_phase_two;
    private int bump_cnt_one;
    private int bump_cnt_two;
    private int[] bump_array_one = new int[]{45, 35};
    private int[] bump_array_two = new int[]{10, 10, 8, 8, 8, 7, 7, 5, 4, 3, 3, 2};
    private int[] smallBounceArray = new int[]{-25, -14, -8, -4, -2, -1, -1, 1, 1, 2, 4, 8, 14, 25};
    private boolean smallBounce;
    private int bounce_counter;
    private boolean showingTypeView = false;
    private static final int SOFTKEY_BAR_HEIGHT = 24;
    private boolean showingDistanceView;
    private TwitterLocationDialog locationDialog = null;
    private TwitterTypeDialog typeDialog = null;
    private int range = 2;
    private String lastID = null;
    private boolean firstShow = true;
    private TwitterPopup popup;
    public TweetQueue tweetQueue = new TweetQueue();
    private boolean retrievedMyTimeLineOnce = false;
    public TextBox textListener = null;
    private static boolean updating;
    private boolean sending;
    private boolean createdFav;
    private static Image sk_bar;
    private Font boldFont;
    private Font plainFont;
    private boolean changedTimeLine = true;
    private boolean receivedMessagesOnce = false;
    private static final int bold_style = 1;
    private static final int size = 8;
    private static final int face = 64;
    private TweetScreen tweetScreen;
    private boolean messagesFallingIn;
    private boolean bump;
    public Vector tweetsForCurrentView;
    private int currentlySelected;
    private boolean replying;
    private boolean newTweet;
    private boolean privateMessage;
    private int public_timeline_id;
    private int my_timeline_id;
    private int trends_id;
    private int nearby_id;
    private int create_favourite_id;
    private int sendTimer;
    private static final int sendingTime = 4000;
    private StatusParser statusParser;
    private final int DELAY;
    private int update_delay = 5;
    private final int GAP_BETWEEN_MESSAGES;
    private Scheduler scheduler;
    private boolean paused;
    private boolean timerStarted;
    private int lastKey = 0;
    private Command[] allcommands = null;
    private Command back;
    private Command select;
    private Command newtweet;
    private Command refresh;
    private Command show;
    private Command home;
    private Command ok;
    private Command open;
    private Command yes;
    private Command no;
    private Command edit;
    private Command mark;
    private Command unmark;
    private TwitterPopup question_popup = null;
    private boolean singleScroll = false;
    private boolean error = false;
    private int startID = -1;
    public TweetMessage incoming = null;
    private int bounceState = -1;
    private int bounceCounter = -1;
    private long bounceWait = -1L;
    public Vector areIn;
    public Vector outGoing;
    private int bounceArea = 177;
    private int bounceStart = 30;
    private int bounceDelimit = 20;
    private int startShunting = -1;
    private int bounceFallSpeed = 15;
    private int[] bounceArray = new int[]{10, 4, -1, -7, -10, -12, -11, -8, -3, 0, 5, 7, 8, 8, 5, 2, 0, -3, -4, -5, -4, -3, -1, 0, 1, 1, 1, 1, 0, 0};
    private int[] friendsBounceArray = new int[]{8, 5, 2, 0, -3, -4, -5, -4, -3, -1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private int birdCounter = 0;
    public boolean showBird = false;
    javax.microedition.lcdui.TextBox tb;
    private Command textOkCommand;
    private Command textBackCommand;
    private boolean fromProfile = false;
    private JSONStatusParser jsonParser;
    public static Image blackoutImage;
    public static Image background;
    public static long frameTime;
    public boolean active = false;
    private static Thread t;
    private static long nextUpdate;
    private static boolean exit;
    private static boolean threadPaused;
    private Runnable refreshRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!exit) {
                1 var1_2 = this;
                synchronized (var1_2) {
                    while ((threadPaused || TwitterCanvas.this.update_delay == 100) && !exit) {
                        try {
                            this.wait();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                long now = System.currentTimeMillis();
                if (nextUpdate == -1L || TwitterCanvas.this.activeMode) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception e) {}
                    continue;
                }
                if (nextUpdate <= now) {
                    if (TwitterCanvas.this.update_delay == 100 || threadPaused) continue;
                    TwitterCanvas.this.requestTimeLine(TwitterCanvas.this.current_preference, false);
                    nextUpdate = -1L;
                    continue;
                }
                System.out.println("Sleeping " + (nextUpdate - now));
                try {
                    Thread.sleep(nextUpdate - now);
                }
                catch (Exception exception) {}
            }
        }
    };

    public TwitterCanvas(TwitterClient caller) {
        super((MIDlet)caller);
        this.DELAY = 60;
        this.GAP_BETWEEN_MESSAGES = 20;
        this.setCommandListener(this);
        this.old_preference = -1;
        this.range = 2;
        this.areIn = new Vector(3, 1);
        this.outGoing = new Vector(3, 1);
        this.setFullScreenMode(false);
        try {
            int i;
            int[] rgb = new int[240];
            for (i = 0; i < 240; ++i) {
                rgb[i] = -1073741824;
            }
            blackoutImage = Image.createRGBImage((int[])rgb, (int)240, (int)1, (boolean)true);
            this.bird = new Image[10];
            for (i = 0; i < 10; ++i) {
                this.bird[i] = Image.createImage((String)("/bird/spinner" + i + ".png"));
            }
            this.bird_t = new Image[10];
            for (i = 0; i < 10; ++i) {
                this.bird_t[i] = Image.createImage((String)("/bird_trans/spinner" + i + ".png"));
            }
            background = Image.createImage((String)"/Headline_background2.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.sendTimer = 10000000;
        this.public_timeline_id = -10000000;
        this.my_timeline_id = -10000000;
        this.trends_id = -10000000;
        this.nearby_id = -10000000;
        this.create_favourite_id = -10000000;
        UI.SCREEN_WIDTH = this.getWidth();
        UI.SCREEN_HEIGHT = this.getHeight();
        this.drawnOnce = false;
        this.callingMidlet = caller;
        this.activeMode = false;
        this.tweetsForCurrentView = new Vector();
        this.boldFont = Font.getFont((int)64, (int)1, (int)8);
        this.plainFont = Font.getFont((int)64, (int)0, (int)8);
        this.scrolling = false;
        this.scheduler = null;
        this.paused = true;
        this.timerStarted = false;
        updating = false;
        this.changedTimeLine = true;
        String s = System.getProperty("microedition.platform");
        System.out.println(s);
        if (s != null && (s.indexOf("Aino") != -1 || s.indexOf("U10") != -1 && s.indexOf("U100") == -1)) {
            this.bounceArea = 290;
            largeScreen = true;
        }
        this.statusParser = new StatusParser();
        this.jsonParser = new JSONStatusParser();
        this.tweetDialog = new TweetDialog(this, null);
    }

    public void init() {
        this.showingDistanceView = false;
        this.showingTrendView = false;
        this.showingTypeView = false;
        this.bounce_counter = 0;
        this.smallBounce = true;
        this.retrieved = false;
        this.loadingTwitter = false;
        this.messagesFallingIn = false;
        this.bumb_phase_one = false;
        this.bump_phase_two = false;
        this.bump_cnt_one = 0;
        this.bump_cnt_two = 0;
        this.bump = false;
        this.main_y_offset = 80;
        this.decreaseSpeed = false;
        this.sending = false;
        this.createdFav = false;
        this.back = new Command(UI.getString(7), 2, 9999);
        this.select = new Command(UI.getString(139), 8, 0);
        this.newtweet = new Command(UI.getString(94), 8, 1);
        this.refresh = new Command(UI.getString(121), 8, 4);
        this.show = new Command(UI.getString(173), 8, 5);
        this.home = new Command(UI.getString(56), 8, 6);
        this.open = new Command(UI.getString(108), 8, 0);
        this.ok = new Command(UI.getString(104), 8, 0);
        this.yes = new Command(UI.getString(205), 8, 0);
        this.no = new Command(UI.getString(97), 3, 9999);
        this.edit = new Command(UI.getString(26), 8, 0);
        this.mark = new Command(UI.getString(206), 8, 0);
        this.unmark = new Command(UI.getString(207), 8, 0);
        this.textOkCommand = new Command(UI.getString(104), 8, 0);
        this.textBackCommand = new Command(UI.getString(7), 2, 2);
        this.allcommands = new Command[13];
        this.allcommands[0] = this.back;
        this.allcommands[1] = this.select;
        this.allcommands[2] = this.home;
        this.allcommands[3] = this.newtweet;
        this.allcommands[4] = this.ok;
        this.allcommands[5] = this.show;
        this.allcommands[6] = this.refresh;
        this.allcommands[7] = this.open;
        this.allcommands[8] = this.yes;
        this.allcommands[9] = this.no;
        this.allcommands[10] = this.edit;
        this.allcommands[11] = this.mark;
        this.allcommands[12] = this.unmark;
        this.showBird = true;
        this.newTweet = false;
        this.replying = false;
        this.privateMessage = false;
        this.setInActiveScreenMode();
        this.tweetScreen = new TweetScreen(this, null);
        this.setCommands();
    }

    public void setCommands() {
        System.out.println("setCommands");
        for (int i = 0; i < this.allcommands.length; ++i) {
            this.removeCommand(this.allcommands[i]);
        }
        if (this.question_popup != null) {
            this.addCommand(this.yes);
            this.addCommand(this.no);
            return;
        }
        if (this.popup != null) {
            this.addCommand(this.ok);
            return;
        }
        if (this.showTweetDialog) {
            if (this.tweetDialog.linkActive()) {
                this.addCommand(this.open);
                this.addCommand(this.back);
            } else {
                this.addCommand(this.select);
                this.addCommand(this.back);
            }
            return;
        }
        if (this.showingDistanceView || this.showingTrendView) {
            this.addCommand(this.select);
            this.addCommand(this.back);
            return;
        }
        if (this.showingTypeView) {
            this.addCommand(this.select);
            this.addCommand(this.back);
            return;
        }
        if (this.privateMessage || this.newTweet || this.replying) {
            this.addCommand(this.allcommands[this.tweetScreen.getActiveComponent()]);
            this.addCommand(this.back);
            return;
        }
        if (this.showBird) {
            this.addCommand(this.back);
            return;
        }
        this.addCommand(this.open);
        this.addCommand(this.newtweet);
        this.addCommand(this.refresh);
        this.addCommand(this.show);
        this.addCommand(this.home);
        this.addCommand(this.back);
    }

    public void startRMSParser(Vector v) {
        new RMSparser(this.current_preference, v);
    }

    public boolean setPreference(int pref, int range, String trendterm) {
        System.out.println("old=" + this.current_preference + "," + this.range + " new=" + pref + "," + range);
        if (pref == 3) {
            pref = 0;
        }
        int oldpref = this.current_preference;
        int oldrange = this.range;
        String oldtrend = this.trend;
        this.trend = trendterm;
        this.range = range;
        this.current_preference = pref;
        if (oldpref != pref) {
            this.showBird = true;
            Vector v = this.callingMidlet.getTimelineRMS(false);
            updating = true;
            if (v == null || v.size() == 0) {
                this.requestTimeLine(this.current_preference, true);
            } else if (this.current_preference == 0) {
                this.my_timeline_id = --this.startID;
                new RMSparser(0, v);
            } else if (this.current_preference == 4) {
                this.public_timeline_id = --this.startID;
                new RMSparser(4, v);
            } else if (this.current_preference == 1) {
                this.nearby_id = --this.startID;
                new RMSparser(1, v);
            } else if (this.current_preference == 2) {
                this.trends_id = --this.startID;
                new RMSparser(2, v);
            }
            return true;
        }
        if (pref == 1 && this.range != oldrange) {
            this.showBird = true;
            Vector v = this.callingMidlet.getTimelineRMS(false);
            updating = true;
            if (v == null || v.size() == 0) {
                this.requestTimeLine(this.current_preference, true);
            } else {
                this.nearby_id = --this.startID;
                new RMSparser(1, v);
            }
            return true;
        }
        if (pref == 2 && !this.trend.equals(oldtrend)) {
            this.showBird = true;
            Vector v = this.callingMidlet.getTimelineRMS(false);
            updating = true;
            if (v == null || v.size() == 0) {
                this.requestTimeLine(this.current_preference, true);
            } else {
                this.trends_id = --this.startID;
                new RMSparser(2, v);
            }
            return true;
        }
        Vector v = this.callingMidlet.getTimelineRMS(true);
        if (v == null || v.size() == 0) {
            return false;
        }
        this.showBird = true;
        updating = true;
        if (this.current_preference == 0) {
            this.my_timeline_id = --this.startID;
            new RMSparser(0, v);
        } else if (this.current_preference == 4) {
            this.public_timeline_id = --this.startID;
            new RMSparser(4, v);
        } else if (this.current_preference == 1) {
            this.nearby_id = --this.startID;
            new RMSparser(1, v);
        } else if (this.current_preference == 2) {
            this.trends_id = --this.startID;
            new RMSparser(2, v);
        }
        return true;
    }

    public void setRefreshRate(int update_delay) {
        int oldrate = this.update_delay;
        this.update_delay = update_delay;
        if (t != null && oldrate != this.update_delay && !updating) {
            if (oldrate == 100) {
                nextUpdate = System.currentTimeMillis() + (long)(60000 * this.update_delay);
                this.startRefresh();
            } else if (this.update_delay > oldrate) {
                nextUpdate += (long)(60000 * (this.update_delay - oldrate));
            } else {
                nextUpdate += (long)(60000 * (this.update_delay - oldrate));
                t.interrupt();
            }
        }
    }

    public void showNotify() {
        TwitterClient.apiHandler.loadLocation();
        if (TwitterClient._instance.checkRoaming()) {
            this.callingMidlet.launchMainApplication();
            return;
        }
        this.callingMidlet.loadSettings();
        UI.languageCheck();
        if (this.firstShow) {
            this.firstShow = false;
            this.startScheduler();
            if (!this.receivedMessagesOnce) {
                this.receivedMessagesOnce = true;
            }
        }
        if (this.replying || this.newTweet || this.privateMessage) {
            this.hidePopup();
            this.sendTimer = 10000000;
        }
        if (this.scheduler != null) {
            this.scheduler.resume();
            this.paused = false;
        }
        this.startRefresh();
        this.active = true;
    }

    public void languageUpdate() {
        this.back = new Command(UI.getString(7), 2, 9999);
        this.select = new Command(UI.getString(139), 8, 0);
        this.newtweet = new Command(UI.getString(94), 8, 1);
        this.refresh = new Command(UI.getString(121), 8, 4);
        this.show = new Command(UI.getString(173), 8, 5);
        this.home = new Command(UI.getString(56), 8, 6);
        this.open = new Command(UI.getString(108), 8, 0);
        this.ok = new Command(UI.getString(104), 8, 0);
        this.yes = new Command(UI.getString(205), 8, 0);
        this.no = new Command(UI.getString(97), 3, 9999);
        this.edit = new Command(UI.getString(26), 8, 0);
        this.mark = new Command(UI.getString(206), 8, 0);
        this.unmark = new Command(UI.getString(207), 8, 0);
        for (int i = 0; i < this.allcommands.length; ++i) {
            this.removeCommand(this.allcommands[i]);
        }
        this.allcommands[0] = this.back;
        this.allcommands[1] = this.select;
        this.allcommands[2] = this.home;
        this.allcommands[3] = this.newtweet;
        this.allcommands[4] = this.ok;
        this.allcommands[5] = this.show;
        this.allcommands[6] = this.refresh;
        this.allcommands[7] = this.open;
        this.allcommands[8] = this.yes;
        this.allcommands[9] = this.no;
        this.allcommands[10] = this.edit;
        this.allcommands[11] = this.mark;
        this.allcommands[12] = this.unmark;
        this.setCommands();
        if (this.trendDialog != null) {
            this.trendDialog.languageUpdate();
        }
        if (this.typeDialog != null) {
            this.typeDialog.languageUpdate();
        }
        if (this.locationDialog != null) {
            this.locationDialog.languageUpdate();
        }
        if (this.tweetDialog != null) {
            this.tweetDialog.languageUpdate();
        }
        if (this.tweetScreen != null) {
            this.tweetScreen.languageUpdate();
        }
        this.textOkCommand = new Command(UI.getString(104), 4, 0);
        this.textBackCommand = new Command(UI.getString(7), 2, 0);
    }

    public void hideNotify() {
        if (this.scheduler != null) {
            this.scheduler.pause();
            this.paused = true;
        }
        if (!TwitterClient.refreshInSleepMode) {
            this.pauseRefresh();
        }
        this.active = false;
    }

    public void showPopup(int string, boolean respond) {
        this.popup = new TwitterPopup(null, 0, string, 10, (UI.SCREEN_HEIGHT - 100) / 2, 100, UI.mediumFont, respond);
        this.setCommands();
    }

    public void hidePopup() {
        if (this.popup != null) {
            this.error = false;
            this.popup = null;
            this.setCommands();
        }
    }

    public void refreshTweets() {
    }

    public void twitterEvent(int ID, String response) {
        System.out.println("twitterEvent");
        this.twitterEvent(ID, response, true);
    }

    public void twitterEvent(int ID, String response, boolean real) {
        if (ID == this.create_favourite_id) {
            System.out.println("a1");
            this.resumeToNormal();
            return;
        }
        if (ID != this.public_timeline_id && ID != this.my_timeline_id && ID != this.trends_id && ID != this.nearby_id) {
            System.out.println("a2");
            this.resumeToNormal();
            return;
        }
        int type = -1;
        if (ID == this.public_timeline_id) {
            type = 4;
        } else if (ID == this.my_timeline_id) {
            type = 0;
        } else if (ID == this.trends_id) {
            type = 2;
        } else if (ID == this.nearby_id) {
            type = 1;
        }
        if (this.cancelled) {
            if (this.update_delay != 100) {
                nextUpdate = System.currentTimeMillis() + (long)(60000 * this.update_delay);
            }
            updating = false;
            return;
        }
        if (!(response.startsWith("90") || response.startsWith("{") || response.startsWith("<?xml"))) {
            System.out.println("a3");
            this.resumeToNormal();
            this.error = true;
            this.showPopup(147, true);
            this.sendTimer = 0;
            this.sending = true;
            if (this.update_delay != 100) {
                nextUpdate = System.currentTimeMillis() + (long)(60000 * this.update_delay);
            }
            return;
        }
        if (response.startsWith("90")) {
            System.out.println("a35");
            this.resumeToNormal();
            this.error = true;
            this.showPopup(13, true);
            this.sendTimer = 0;
            this.sending = true;
            if (this.update_delay != 100) {
                nextUpdate = System.currentTimeMillis() + (long)(60000 * this.update_delay);
            }
            return;
        }
        if (type != this.current_preference) {
            if (this.update_delay != 100) {
                nextUpdate = System.currentTimeMillis() + (long)(60000 * this.update_delay);
            }
            updating = false;
            return;
        }
        this.showBird = true;
        this.tweetsForCurrentView.removeAllElements();
        TwitterClient.clearAvatars();
        this.scrolling = false;
        this.scrollSpeed = 0;
        this.decreaseSpeed();
        this.setCommands();
        int nrOfTweets = 0;
        Vector tweets = new Vector();
        if (response.startsWith("<?xml")) {
            tweets = this.statusParser.finishParse();
        } else if (response.startsWith("{")) {
            tweets = this.jsonParser.finishParse();
        }
        nrOfTweets = tweets.size();
        System.out.println("Size: " + nrOfTweets);
        if (real && nrOfTweets > 0) {
            this.callingMidlet.saveTimelineRMS(tweets);
        }
        for (int cnt = 0; cnt < nrOfTweets; ++cnt) {
            Tweet t = (Tweet)tweets.elementAt(cnt);
            TweetMessage tm = null;
            System.gc();
            try {
                tm = new TweetMessage(t, t.screenname.equals(TwitterClient.userName));
            }
            catch (Exception e) {
                e.printStackTrace();
                tm = null;
            }
            if (tm == null) continue;
            tm.setTimeStamp(new TimeStamp(tm.getTweet().createdAt));
            this.tweetsForCurrentView.addElement(tm);
        }
        if (this.tweetsForCurrentView.isEmpty()) {
            System.out.println("a4");
            this.resumeToNormal();
            this.error = true;
            this.showPopup(103, true);
            this.sendTimer = 0;
            this.sending = true;
            if (this.update_delay != 100) {
                nextUpdate = System.currentTimeMillis() + (long)(60000 * this.update_delay);
            }
            this.showBird = false;
            return;
        }
        this.limitCurrentView();
        this.syncLists();
        System.gc();
        if (this.activeMode) {
            this.setFallingStyle(nrOfTweets);
        } else {
            this.setStandardPositionsForBubbles();
        }
        this.paused = false;
        if (this.update_delay != 100) {
            nextUpdate = System.currentTimeMillis() + (long)(60000 * this.update_delay);
        }
        this.showBird = false;
        this.hidePopup();
        updating = false;
        this.setCommands();
        tweets.removeAllElements();
        System.gc();
        for (int i = this.tweetsForCurrentView.size() - 1; i >= 0; --i) {
            if (updating) {
                return;
            }
            TweetMessage tm = (TweetMessage)this.tweetsForCurrentView.elementAt(i);
            tm.loadAvatar(this.current_preference == 0);
            this.tweetQueue.add(tm, type);
        }
    }

    private void resumeToNormal() {
        this.showBird = false;
        this.hidePopup();
        updating = false;
        this.setCommands();
    }

    private void setFallingStyle(int nrOfNewTweets) {
        this.setStandardPositionsForBubbles();
        this.messagesFallingIn = false;
        this.bump = false;
        boolean newMessages = true;
        if (this.changedTimeLine) {
            this.changedTimeLine = false;
        } else if (this.current_preference == 0) {
            if (nrOfNewTweets > 0) {
                TweetMessage tm2 = (TweetMessage)this.tweetsForCurrentView.elementAt(nrOfNewTweets - 1);
                TweetMessage first = (TweetMessage)this.tweetsForCurrentView.elementAt(0);
                if (first.getY() + first.getHeight() + this.main_y_offset < 0) {
                    this.bump = true;
                    this.bumb_phase_one = true;
                    this.bump_phase_two = false;
                    this.bump_cnt_one = 0;
                    this.bump_cnt_two = 0;
                    this.main_y_offset -= tm2.getY() + tm2.getHeight() + 20;
                }
            } else {
                newMessages = false;
            }
        }
        if (!this.bump && newMessages) {
            System.out.println("!bump && newMessages");
            this.messagesFallingIn = true;
            this.computeFallingPositions(0, 4);
            this.main_y_offset = -70;
            this.smallBounce = false;
            this.bounce_counter = 0;
            this.currentlySelected = 0;
        }
    }

    private void limitCurrentView() {
        int nrOfMsgs = this.tweetsForCurrentView.size();
        if (nrOfMsgs > 20) {
            for (int i = nrOfMsgs - 1; i > 19; --i) {
                this.tweetsForCurrentView.removeElementAt(i);
            }
        }
    }

    private void computeFallingPositions(int start, int nrOfFallingTweets) {
        int startPos = 20;
        int upperLimit = start + nrOfFallingTweets;
        if (upperLimit > this.tweetsForCurrentView.size()) {
            upperLimit = this.tweetsForCurrentView.size();
        }
        for (int i = start; i < upperLimit; ++i) {
            TweetMessage tm = (TweetMessage)this.tweetsForCurrentView.elementAt(i);
            tm.setY(startPos);
            startPos += tm.getHeight();
        }
    }

    public void syncLists() {
        long v2;
        long v;
        if (this.incoming != null) {
            v = Long.parseLong(this.incoming.getTweet().messageId);
            for (int j = 0; j < this.tweetsForCurrentView.size() && !this.incoming.equals(this.tweetsForCurrentView.elementAt(j)); ++j) {
                v2 = Long.parseLong(((TweetMessage)this.tweetsForCurrentView.elementAt((int)j)).getTweet().messageId);
                if (v != v2) continue;
                TweetMessage t = (TweetMessage)this.tweetsForCurrentView.elementAt(j);
                t.setBounceY(this.incoming.getBounceY());
                t.setTargetY(this.incoming.getTargetY());
                this.incoming = t;
                break;
            }
        }
        block1: for (int i = 0; i < this.areIn.size(); ++i) {
            v = Long.parseLong(((TweetMessage)this.areIn.elementAt((int)i)).getTweet().messageId);
            for (int j = 0; j < this.tweetsForCurrentView.size() && !this.areIn.elementAt(i).equals(this.tweetsForCurrentView.elementAt(j)); ++j) {
                v2 = Long.parseLong(((TweetMessage)this.tweetsForCurrentView.elementAt((int)j)).getTweet().messageId);
                if (v != v2) continue;
                TweetMessage t = (TweetMessage)this.tweetsForCurrentView.elementAt(j);
                t.setBounceY(((TweetMessage)this.areIn.elementAt(i)).getBounceY());
                t.setTargetY(((TweetMessage)this.areIn.elementAt(i)).getTargetY());
                this.areIn.setElementAt(t, i);
                continue block1;
            }
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.back) {
            if (this.showTweetDialog) {
                this.showTweetDialog = false;
                this.setCommands();
            } else if (this.privateMessage || this.newTweet || this.replying) {
                this.tweetScreen.handleKeyDown(-7);
            } else if (this.showingDistanceView) {
                if (this.typeDialog == null) {
                    this.typeDialog = new TwitterTypeDialog(this, null);
                    this.typeDialog.setDimensions(220, UI.SCREEN_HEIGHT);
                }
                this.typeDialog.reset(false);
                this.showingTypeView = true;
                this.showingDistanceView = false;
                this.setCommands();
            } else if (this.showingTrendView) {
                if (this.typeDialog == null) {
                    this.typeDialog = new TwitterTypeDialog(this, null);
                    this.typeDialog.setDimensions(220, UI.SCREEN_HEIGHT);
                }
                this.typeDialog.reset(false);
                this.showingTypeView = true;
                this.showingTrendView = false;
                this.setCommands();
            } else if (this.showingTypeView) {
                this.showingTypeView = false;
                this.setCommands();
            } else {
                this.setStandardPositionsForBubbles();
                this.main_y_offset = 80;
                this.callingMidlet.enterStandByMode();
            }
        } else if (c == this.select || c == this.edit || c == this.mark || c == this.unmark) {
            if (this.showTweetDialog) {
                this.tweetDialog.handleKeyDown(-5);
            } else if (this.privateMessage || this.newTweet || this.replying) {
                this.tweetScreen.handleKeyDown(-5);
            } else if (this.showingDistanceView) {
                this.locationDialog.handleKeyDown(-5);
            } else if (this.showingTrendView) {
                this.trendDialog.handleKeyDown(-5);
            } else if (this.showingTypeView) {
                this.typeDialog.handleKeyDown(-5);
            }
        } else if (c == this.newtweet) {
            this.tweetScreen.setNew();
            this.tweetScreen.activate();
            this.newTweet = true;
            this.setCommands();
        } else if (c == this.open) {
            if (this.showTweetDialog) {
                this.tweetDialog.handleKeyDown(-5);
            } else if (this.tweetsForCurrentView.size() > 0) {
                this.tweetDialog.setTweet(((TweetMessage)this.tweetsForCurrentView.elementAt(this.currentlySelected)).getTweet());
                this.showTweetDialog = true;
                this.setCommands();
            }
        } else if (c == this.refresh) {
            this.showBird = true;
            this.old_preference = this.current_preference;
            this.requestTimeLine(this.current_preference, false);
            this.setCommands();
        } else if (c == this.show) {
            if (this.typeDialog == null) {
                this.typeDialog = new TwitterTypeDialog(this, null);
                this.typeDialog.setDimensions(220, UI.SCREEN_HEIGHT);
            }
            this.typeDialog.reset(true);
            this.showingTypeView = true;
            this.setCommands();
        } else if (c == this.home) {
            this.callingMidlet.launchMainApplication();
        } else if (c == this.ok) {
            this.hidePopup();
        } else if (c == this.textOkCommand) {
            this.textListener.setString(((javax.microedition.lcdui.TextBox)d).getString());
            TwitterClient._instance.openTextBox((Displayable)this);
            this.textListener = null;
        } else if (c == this.textBackCommand) {
            TwitterClient._instance.openTextBox((Displayable)this);
            this.textListener = null;
        } else if (c == this.yes) {
            this.question_popup.handleKeyDown(-5);
            this.question_popup = null;
            this.setCommands();
        } else if (c == this.no) {
            this.question_popup.handleKeyDown(-7);
            this.question_popup = null;
            this.setCommands();
        }
    }

    public void showReplyTweet(Tweet t) {
        this.fromProfile = true;
        this.showTweetDialog = false;
        this.tweetScreen.setReplyto(t.screenname, t.messageId);
        this.tweetScreen.activate();
        this.replying = true;
        this.setCommands();
    }

    public void showForwardTweet(Tweet t) {
        this.fromProfile = true;
        this.showTweetDialog = false;
        this.tweetScreen.setReTweet(t.screenname, t.text);
        this.tweetScreen.activate();
        this.replying = true;
        this.setCommands();
    }

    public void createfavorite(Tweet t) {
        this.showTweetDialog = false;
        this.showPopup(76, false);
        this.create_favourite_id = TwitterClient.apiHandler.createFavourite(t.messageId, this);
        this.createdFav = true;
        this.sendTimer = 0;
        this.setCommands();
    }

    public void keyRepeated(int key) {
        this.lastKey = 0;
        if (updating) {
            return;
        }
        if (this.activeMode) {
            if (this.newTweet || this.replying || this.privateMessage) {
                this.tweetScreen.handleLongPress(key);
            } else {
                if (key == -2 && this.scrolling) {
                    this.scrollSpeed -= 2;
                    if (this.scrollSpeed < -44) {
                        this.scrollSpeed = -44;
                    }
                }
                if (key == -1 && this.scrolling) {
                    this.scrollSpeed += 2;
                    if (this.scrollSpeed > 44) {
                        this.scrollSpeed = 44;
                    }
                }
            }
        }
    }

    public void keyReleased(int key) {
        if (this.activeMode) {
            if (this.newTweet || this.replying || this.privateMessage) {
                this.tweetScreen.handleKeyUp(key);
            } else if (this.lastKey != 0 && key == this.lastKey) {
                this.scrolling = false;
                this.scrollSpeed = 0;
                this.decreaseSpeed();
                if (key == -1 && this.currentlySelected > 0) {
                    --this.currentlySelected;
                    this.singleScroll = true;
                } else if (key == -2 && this.currentlySelected < this.tweetsForCurrentView.size() - 1) {
                    ++this.currentlySelected;
                    this.singleScroll = true;
                }
            } else if (key == -1 || key == -2) {
                this.decreaseSpeed = true;
                this.scrolling = false;
            }
        }
    }

    private void decreaseSpeed() {
        if (this.scrollSpeed < 0) {
            this.scrollSpeed += 5;
            if (this.scrollSpeed > 0) {
                this.scrollSpeed = 0;
            }
        } else if (this.scrollSpeed > 0) {
            this.scrollSpeed -= 5;
            if (this.scrollSpeed < 0) {
                this.scrollSpeed = 0;
            }
        }
        if (this.scrollSpeed == 0) {
            this.decreaseSpeed = false;
            this.highlightTweet();
        }
    }

    private void highlightTweet() {
        int nrOfTweetMessages = this.tweetsForCurrentView.size();
        int prev = -1;
        int current = -1;
        int next = -1;
        for (int i = 0; i < nrOfTweetMessages; ++i) {
            prev = current;
            current = next;
            if (i == nrOfTweetMessages - 1) {
                if (current >= prev) continue;
                this.currentlySelected = i;
                continue;
            }
            next = Math.abs(((TweetMessage)this.tweetsForCurrentView.elementAt(i + 1)).getY() + this.main_y_offset - this.getHeight() / 2 + ((TweetMessage)this.tweetsForCurrentView.elementAt(i + 1)).getHeight() / 2);
            if (i == 0) {
                current = Math.abs(((TweetMessage)this.tweetsForCurrentView.elementAt(i)).getY() + this.main_y_offset - this.getHeight() / 2 + ((TweetMessage)this.tweetsForCurrentView.elementAt(i)).getHeight() / 2);
            }
            if (current >= prev && i != 0 || current >= next) continue;
            this.currentlySelected = i;
            break;
        }
    }

    public void notifyTrendError() {
        this.showingTypeView = false;
        this.showingTrendView = false;
        this.showPopup(147, true);
        this.sendTimer = 0;
        this.sending = true;
        this.setCommands();
    }

    public int getPreference() {
        return this.current_preference;
    }

    public void pushMessage(String message) {
    }

    public void doneMessage(boolean update, boolean returnPossible) {
        this.replying = false;
        this.newTweet = false;
        this.privateMessage = false;
        this.setCommands();
        if (update) {
            this.sendTimer = 0;
            this.showPopup(172, false);
            this.sending = true;
            this.sendTimer = 0;
        } else if (this.fromProfile && returnPossible) {
            this.showTweetDialog = true;
            this.setCommands();
        }
        this.fromProfile = false;
    }

    public void keyPressed(int key) {
        if (this.activeMode) {
            if (this.showTweetDialog) {
                this.tweetDialog.handleKeyDown(key);
                return;
            }
            if (this.newTweet || this.replying || this.privateMessage) {
                this.tweetScreen.handleKeyDown(key);
                return;
            }
            if (this.showingDistanceView) {
                if (key != -7) {
                    this.locationDialog.handleKeyDown(key);
                } else {
                    this.showingDistanceView = false;
                    this.setCommands();
                }
                return;
            }
            if (this.showingTrendView) {
                if (key != -7) {
                    this.trendDialog.handleKeyDown(key);
                } else {
                    this.showingTrendView = false;
                    this.setCommands();
                }
                return;
            }
            if (this.showingTypeView) {
                if (key != -7) {
                    this.typeDialog.handleKeyDown(key);
                } else {
                    this.showingDistanceView = false;
                    this.setCommands();
                }
                return;
            }
            if (this.popup == null) {
                if (key == -1) {
                    this.scrollUp();
                    this.lastKey = -1;
                }
                if (key == -2) {
                    this.scrollDown();
                    this.lastKey = -2;
                }
            }
        }
    }

    public void setActiveScreenMode() {
        this.main_y_offset = this.areIn.size() == 0 ? (this.outGoing.size() == 0 ? (this.incoming == null ? 80 : 80 - this.incoming.getY()) : (this.tweetsForCurrentView != null && this.tweetsForCurrentView.size() > 0 && this.tweetsForCurrentView.contains(this.outGoing.lastElement()) ? ((TweetMessage)this.outGoing.lastElement()).getBounceY() - ((TweetMessage)this.outGoing.lastElement()).getY() : 80)) : (this.tweetsForCurrentView != null && this.tweetsForCurrentView.size() > 0 && this.tweetsForCurrentView.contains(this.areIn.lastElement()) ? ((TweetMessage)this.areIn.lastElement()).getBounceY() - ((TweetMessage)this.areIn.lastElement()).getY() : 80);
        this.setStandardPositionsForBubbles();
        this.messagesFallingIn = false;
        this.bump_phase_two = false;
        this.bumb_phase_one = false;
        this.bump = false;
        this.smallBounce = false;
        this.activeMode = true;
        this.highlightTweet();
        this.repaint();
    }

    public void selectLatestMessage() {
        this.currentlySelected = 0;
    }

    public void setInActiveScreenMode() {
        this.activeMode = false;
    }

    public void drawBird(Graphics g) {
        if (this.activeMode) {
            int h = this.getHeight();
            for (int i = 0; i < h; ++i) {
                g.drawImage(blackoutImage, 0, i, 0);
            }
            g.drawImage(this.bird[this.birdCounter / 2], 100, (this.getHeight() - this.bird[this.birdCounter / 2].getHeight()) / 2 - 10, 17);
            g.setColor(0xFFFFFF);
            g.setFont(UI.mediumFont);
            g.drawString(UI.getString(113), 120, (this.getHeight() + this.bird[this.birdCounter / 2].getHeight()) / 2 - 10, 17);
        } else {
            g.drawImage(this.bird_t[this.birdCounter / 2], 100, (this.getHeight() - this.bird[this.birdCounter / 2].getHeight()) / 2 - 10, 17);
        }
    }

    public void drawError(Graphics g) {
    }

    public void paint(Graphics g) {
        if (!this.drawnOnce) {
            this.paintDevice = g;
            this.drawnOnce = true;
            return;
        }
        frameTime = System.currentTimeMillis();
        if (!this.activeMode) {
            int i;
            for (i = 0; i < this.outGoing.size(); ++i) {
                ((TweetMessage)this.outGoing.elementAt(i)).paintBounce(g);
            }
            for (i = 0; i < this.areIn.size(); ++i) {
                ((TweetMessage)this.areIn.elementAt(i)).paintBounce(g);
            }
            if (this.incoming != null) {
                this.incoming.paintBounce(g);
            }
            if (!this.retrieved) {
                this.drawBird(g);
            }
            return;
        }
        if (this.showTweetDialog) {
            this.tweetDialog.paint(this.paintDevice);
            if (this.question_popup != null) {
                this.question_popup.paint(this.paintDevice, 0, 0);
            }
            return;
        }
        if (this.showingDistanceView) {
            this.locationDialog.paint(this.paintDevice);
            if (this.question_popup != null) {
                this.question_popup.paint(this.paintDevice, 0, 0);
            }
            return;
        }
        if (this.showingTrendView) {
            this.trendDialog.paint(this.paintDevice);
            if (this.question_popup != null) {
                this.question_popup.paint(this.paintDevice, 0, 0);
            }
            return;
        }
        if (this.showingTypeView) {
            this.typeDialog.paint(this.paintDevice);
            if (this.question_popup != null) {
                this.question_popup.paint(this.paintDevice, 0, 0);
            }
            return;
        }
        if (this.privateMessage || this.newTweet || this.replying) {
            this.showTweetScreen();
            if (this.question_popup != null) {
                this.question_popup.paint(this.paintDevice, 0, 0);
            }
            return;
        }
        if (this.showBird) {
            this.drawBird(g);
        } else {
            if (this.singleScroll) {
                int pos = ((TweetMessage)this.tweetsForCurrentView.elementAt(this.currentlySelected)).getY() + this.main_y_offset - this.getHeight() / 2 + ((TweetMessage)this.tweetsForCurrentView.elementAt(this.currentlySelected)).getHeight() / 2;
                if (pos < 0) {
                    this.main_y_offset = pos <= -10 ? (this.main_y_offset += 10) : (this.main_y_offset -= pos);
                } else if (pos > 0) {
                    this.main_y_offset = pos >= 10 ? (this.main_y_offset -= 10) : (this.main_y_offset -= pos);
                } else {
                    this.singleScroll = false;
                }
            }
            if (!this.paused) {
                if (this.messagesFallingIn) {
                    this.dropThem(0, 4);
                } else if (this.smallBounce) {
                    this.smallBounce(0, 4);
                } else if (this.bump) {
                    if (this.bumb_phase_one) {
                        this.bump_phase_one();
                    } else if (this.bump_phase_two) {
                        this.bump_phase_two();
                    }
                }
                this.drawMessageBubbles();
            } else {
                try {
                    this.redrawTextMessages();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.drawPopups();
        if (this.question_popup != null) {
            this.question_popup.paint(this.paintDevice, 0, 0);
        }
    }

    private void drawPopups() {
        if (this.popup != null) {
            this.popup.paint(this.paintDevice, 0, 0);
        }
        if (this.sendTimer < 4000) {
            if (this.activeMode) {
                this.sendTimer += 60;
            }
        } else {
            if (!updating && !this.error) {
                this.hidePopup();
            }
            if (this.sending) {
                this.hidePopup();
                this.sending = false;
            }
            if (this.createdFav) {
                this.hidePopup();
                this.createdFav = false;
            }
            if (this.loadingTwitter) {
                this.hidePopup();
                this.loadingTwitter = false;
            }
        }
    }

    private void showTweetScreen() {
        this.tweetScreen.update();
        this.tweetScreen.paint(this.paintDevice);
    }

    private void dropThem(int start, int nrOfFallingTweets) {
        this.main_y_offset += 50;
        if (this.main_y_offset > 80) {
            this.main_y_offset = 80;
            this.messagesFallingIn = false;
            this.smallBounce = true;
        }
    }

    private void smallBounce(int start, int nrOfFallingTweets) {
        if (this.bounce_counter > 13) {
            this.smallBounce = false;
            this.bounce_counter = 0;
            this.setStandardPositionsForBubbles();
            this.paused = true;
            return;
        }
        int upTo = nrOfFallingTweets;
        int allTweets = this.tweetsForCurrentView.size();
        if (nrOfFallingTweets > allTweets) {
            upTo = allTweets;
        }
        for (int cnt = start; cnt < start + upTo; ++cnt) {
            TweetMessage tm = (TweetMessage)this.tweetsForCurrentView.elementAt(cnt);
            tm.modify_y(this.smallBounceArray[this.bounce_counter] + cnt * 2);
        }
        ++this.bounce_counter;
    }

    private void bump_phase_one() {
        if (this.bump_cnt_one > 1) {
            this.bumb_phase_one = false;
            this.bump_phase_two = true;
            this.bump_cnt_one = 0;
            return;
        }
        this.main_y_offset += this.bump_array_one[this.bump_cnt_one];
        ++this.bump_cnt_one;
    }

    private void bump_phase_two() {
        if (this.bump_cnt_two > 11) {
            this.bump_phase_two = false;
            this.bump_cnt_two = 0;
            this.highlightTweet();
            this.bump = false;
            return;
        }
        this.main_y_offset -= this.bump_array_two[this.bump_cnt_two];
        ++this.bump_cnt_two;
    }

    private void drawMessageBubbles() {
        if (this.withinBounds()) {
            this.main_y_offset += this.scrollSpeed;
        }
        int nrOfBubbles = this.tweetsForCurrentView.size();
        for (int cnt = 0; cnt < nrOfBubbles; ++cnt) {
            TweetMessage tm = (TweetMessage)this.tweetsForCurrentView.elementAt(cnt);
            tm.paint(this.paintDevice, this.main_y_offset, cnt == this.currentlySelected && this.activeMode, this.activeMode);
        }
        if (this.decreaseSpeed) {
            this.decreaseSpeed();
        }
    }

    public void computePositionsForBubbles() {
        int nrOfBubbles = this.tweetsForCurrentView.size();
        int landing_position = 20;
        for (int cnt = 0; cnt < nrOfBubbles; ++cnt) {
            TweetMessage bubble = (TweetMessage)this.tweetsForCurrentView.elementAt(cnt);
            bubble.setLandingPosition(landing_position);
            bubble.setLanded(false);
            landing_position += 20 + bubble.getHeight();
        }
    }

    public void setStandardPositionsForBubbles() {
        int nrOfBubbles = this.tweetsForCurrentView.size();
        int y_pos = 20;
        for (int cnt = 0; cnt < nrOfBubbles; ++cnt) {
            TweetMessage bubble = (TweetMessage)this.tweetsForCurrentView.elementAt(cnt);
            bubble.setY(y_pos);
            bubble.setLandingPosition(y_pos);
            bubble.setLanded(true);
            y_pos += 20 + bubble.getHeight();
        }
        if (nrOfBubbles > 0) {
            this.min_y_offset = 80 - ((TweetMessage)this.tweetsForCurrentView.elementAt(nrOfBubbles - 1)).getY() + 20;
        }
    }

    public void refresh() {
        this.showBird = true;
        this.callingMidlet.saveSettings(this.current_preference, this.range, this.trend);
        this.requestTimeLine(this.current_preference, true);
    }

    public void notifyRangeUpdated(int range) {
        this.showingDistanceView = false;
        int oldrange = this.range;
        this.range = range;
        this.current_preference = 1;
        if (this.old_preference != this.current_preference || oldrange != this.range) {
            this.changedTimeLine = true;
            this.refresh();
        }
        this.setCommands();
    }

    public void notifyTrendUpdated(String trend) {
        this.showingTrendView = false;
        String oldtrend = this.trend;
        this.trend = trend;
        this.current_preference = 2;
        System.out.println(this.trend + " - " + oldtrend);
        if (this.old_preference != this.current_preference || !this.trend.equals(oldtrend)) {
            this.changedTimeLine = true;
            this.refresh();
        }
        this.setCommands();
    }

    public void notifyTypeUpdated(int type) {
        if (type == 2) {
            this.old_preference = this.current_preference;
            if (this.trendDialog == null) {
                this.trendDialog = new TwitterTrendDialog(this, null);
                this.trendDialog.setDimensions(220, UI.SCREEN_HEIGHT);
            }
            this.trendDialog.reset();
            this.showingTrendView = true;
        } else if (type == 1) {
            this.old_preference = this.current_preference;
            if (this.locationDialog == null) {
                this.locationDialog = new TwitterLocationDialog(this, null);
                this.locationDialog.setDimensions(220, UI.SCREEN_HEIGHT);
            }
            this.locationDialog.reset();
            this.showingDistanceView = true;
        } else {
            this.old_preference = this.current_preference;
            this.current_preference = type;
            if (this.old_preference != this.current_preference) {
                this.changedTimeLine = true;
                this.refresh();
            }
        }
        this.showingTypeView = false;
        this.setCommands();
    }

    public void requestTimeLine(int pref, boolean override) {
        if (updating && !override) {
            System.out.println("Already updating");
            return;
        }
        System.out.println("getting for screen: " + pref);
        this.cancelled = false;
        switch (pref) {
            case 2: {
                this.trends_id = TwitterClient.apiHandler.searchAny(this.trend, -1, -1, this, this.jsonParser);
                updating = true;
                break;
            }
            case 4: {
                this.public_timeline_id = TwitterClient.apiHandler.getPublicTimeline(this, this.statusParser);
                updating = true;
                break;
            }
            case 1: {
                this.nearby_id = TwitterClient.apiHandler.searchLocation(this.range, TwitterClient.useKilometers, true, -1, -1, this, this.jsonParser);
                updating = true;
                break;
            }
            case 0: {
                this.my_timeline_id = TwitterClient.apiHandler.getFriendsTimeline(null, null, -1, -1, this, this.statusParser);
                updating = true;
            }
        }
    }

    public TwitterPopup showQuestionPopup(int string, QuestionListener listener) {
        this.question_popup = null;
        this.question_popup = new TwitterPopup(null, 0, string, 10, (UI.SCREEN_HEIGHT - 100) / 2, 100, UI.mediumFont, listener);
        this.setCommands();
        this.repaint();
        return this.question_popup;
    }

    private void redrawTextMessages() {
        int nrOfBubbles = this.tweetsForCurrentView.size();
        for (int cnt = nrOfBubbles - 1; cnt > -1; --cnt) {
            TweetMessage tm = (TweetMessage)this.tweetsForCurrentView.elementAt(cnt);
            tm.paint(this.paintDevice, this.main_y_offset, cnt == this.currentlySelected && this.activeMode, this.activeMode);
        }
    }

    private void scrollDown() {
        this.scrollSpeed = -14;
        this.paused = false;
        this.scrolling = true;
    }

    private void scrollUp() {
        this.scrollSpeed = 14;
        this.paused = false;
        this.scrolling = true;
    }

    private boolean withinBounds() {
        if (this.main_y_offset > 80) {
            this.main_y_offset = 80;
            this.scrollSpeed = 0;
            this.decreaseSpeed = false;
            this.paused = true;
            this.currentlySelected = 0;
            return false;
        }
        if (this.main_y_offset < this.min_y_offset) {
            this.main_y_offset = this.min_y_offset;
            this.scrollSpeed = 0;
            this.decreaseSpeed = false;
            this.paused = true;
            this.currentlySelected = this.tweetsForCurrentView.size() - 1;
            return false;
        }
        return true;
    }

    private void startScheduler() {
        this.scheduler = new Scheduler(this);
        this.paused = false;
    }

    public void update() {
        switch (this.bounceState) {
            case 0: {
                TweetMessage nextIn;
                if (System.currentTimeMillis() < this.bounceWait || (nextIn = this.tweetQueue.getNext()) == null) break;
                this.retrieved = true;
                int height = nextIn.getHeight();
                if (height >= this.bounceArea) {
                    while (!this.areIn.isEmpty()) {
                        this.outGoing.addElement(this.areIn.firstElement());
                        this.areIn.removeElementAt(0);
                    }
                    this.startShunting = -9999;
                    this.bounceState = 1;
                    this.incoming = nextIn;
                    this.incoming.setBounceY(-this.incoming.getHeight());
                    break;
                }
                int currentH = -1;
                boolean first = true;
                do {
                    if (!first) {
                        this.outGoing.addElement(this.areIn.firstElement());
                        this.areIn.removeElementAt(0);
                    }
                    currentH = 0;
                    for (int i = 0; i < this.areIn.size(); ++i) {
                        currentH += ((TweetMessage)this.areIn.elementAt(i)).getHeight();
                        currentH += this.bounceDelimit;
                    }
                    if (!first) continue;
                    first = false;
                    this.startShunting = currentH == 0 ? -9999 : this.bounceStart + this.bounceArea - currentH - nextIn.getHeight();
                } while (currentH + height > this.bounceArea);
                this.bounceState = 1;
                this.incoming = nextIn;
                this.incoming.setBounceY(-this.incoming.getHeight());
                break;
            }
            case 1: {
                this.incoming.incBounceY(this.bounceFallSpeed);
                if (this.startShunting == -9999) {
                    int p = this.bounceStart + this.bounceArea - this.incoming.getHeight();
                    if (this.incoming.getBounceY() < p) break;
                    this.incoming.setTargetY(p);
                    this.areIn.addElement(this.incoming);
                    this.incoming = null;
                    this.bounceCounter = 0;
                    this.bounceState = 3;
                    break;
                }
                if (this.incoming.getBounceY() < this.startShunting) break;
                this.areIn.addElement(this.incoming);
                this.incoming = null;
                int tH = this.bounceStart + this.bounceArea;
                for (int i = 0; i < this.areIn.size(); ++i) {
                    TweetMessage tm = (TweetMessage)this.areIn.elementAt(i);
                    tm.setTargetY(tH -= tm.getHeight());
                    tH -= this.bounceDelimit;
                }
                this.bounceState = 2;
                break;
            }
            case 2: {
                TweetMessage tm;
                int i;
                boolean done = true;
                for (i = 0; i < this.areIn.size(); ++i) {
                    tm = (TweetMessage)this.areIn.elementAt(i);
                    if (tm.getBounceY() < tm.getTargetY()) {
                        tm.incBounceY(this.bounceFallSpeed);
                    }
                    if (tm.getBounceY() >= tm.getTargetY()) {
                        if (i <= 0) continue;
                        tm.setBounceY(tm.getTargetY());
                        continue;
                    }
                    done = false;
                }
                for (i = 0; i < this.outGoing.size(); ++i) {
                    tm = (TweetMessage)this.outGoing.elementAt(i);
                    tm.incBounceY(this.bounceFallSpeed);
                    if (tm.getBounceY() < this.getHeight()) continue;
                    tm.setBounceY(-1000);
                    this.outGoing.removeElementAt(i);
                    --i;
                }
                if (!done) break;
                this.bounceCounter = 0;
                this.bounceState = 3;
                break;
            }
            case 3: {
                TweetMessage tm = (TweetMessage)this.areIn.firstElement();
                tm.setBounceY(tm.getTargetY() + this.bounceArray[this.bounceCounter]);
                ++this.bounceCounter;
                if (this.bounceCounter == this.bounceArray.length) {
                    this.bounceWait = System.currentTimeMillis() + 3000L;
                    this.bounceState = 0;
                }
                for (int i = 0; i < this.outGoing.size(); ++i) {
                    tm = (TweetMessage)this.outGoing.elementAt(i);
                    tm.incBounceY(this.bounceFallSpeed);
                    if (tm.getBounceY() < this.getHeight()) continue;
                    this.outGoing.removeElementAt(i);
                    --i;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRefresh() {
        if (t == null) {
            t = new Thread(this.refreshRunnable);
            t.start();
        } else {
            threadPaused = false;
            Runnable runnable = this.refreshRunnable;
            synchronized (runnable) {
                this.refreshRunnable.notify();
            }
        }
    }

    public void pauseRefresh() {
        threadPaused = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endRefresh() {
        threadPaused = false;
        exit = true;
        nextUpdate = -1L;
        if (this.scheduler != null) {
            this.scheduler.exit();
        }
        if (t != null) {
            Runnable runnable = this.refreshRunnable;
            synchronized (runnable) {
                this.refreshRunnable.notify();
            }
            t.interrupt();
        }
    }

    public void openTextBox(TextBox l) {
        System.out.println("openTextbox");
        this.textListener = l;
        this.tb = null;
        this.tb = new javax.microedition.lcdui.TextBox("", l.getString(), l.getMaxSize(), 0);
        this.tb.addCommand(this.textOkCommand);
        this.tb.addCommand(this.textBackCommand);
        this.tb.setCommandListener((CommandListener)this);
        if (l.isPassword()) {
            this.tb.setConstraints(65537);
        } else if (!l.isCapitalized()) {
            this.tb.setConstraints(1);
        } else {
            this.tb.setConstraints(0);
        }
        Canvas.getDisplay().setCurrent((Displayable)this.tb);
        TwitterClient._instance.openTextBox((Displayable)this.tb);
    }

    static {
        sk_bar = null;
        frameTime = -1L;
        t = null;
        nextUpdate = -1L;
        exit = false;
        threadPaused = false;
    }

    public class TweetQueue {
        private Vector v = new Vector(20);
        private long newest = -1L;
        private int currentType = -1;

        public void add(TweetMessage t, int type) {
            block6: {
                block5: {
                    if (type != TwitterCanvas.this.current_preference) {
                        return;
                    }
                    if (this.currentType == -1) {
                        this.currentType = type;
                    } else if (this.currentType != type) {
                        this.v.removeAllElements();
                        this.newest = -1L;
                        this.currentType = type;
                    }
                    long messageID = Long.parseLong(t.getTweet().messageId);
                    if (messageID <= this.newest) break block5;
                    this.newest = messageID;
                    this.v.addElement(t);
                    if (this.v.size() <= 20) break block6;
                    this.v.removeElementAt(0);
                    break block6;
                }
                for (int i = 0; i < this.v.size(); ++i) {
                    if (!t.getTweet().messageId.equalsIgnoreCase(((TweetMessage)this.v.elementAt((int)i)).getTweet().messageId)) continue;
                    this.v.setElementAt(t, i);
                    break;
                }
            }
        }

        public TweetMessage getNext() {
            if (this.v.isEmpty()) {
                return null;
            }
            TweetMessage t = (TweetMessage)this.v.firstElement();
            this.v.removeElementAt(0);
            return t;
        }

        public Vector getAll() {
            return this.v;
        }

        public void removeAll() {
            this.v.removeAllElements();
        }
    }

    private class Scheduler
    implements Runnable {
        private TwitterCanvas canvas;
        private boolean pause;
        private int gcCounter = 0;
        private boolean schedulerExit = false;

        public Scheduler(TwitterCanvas canvas) {
            TwitterCanvas.this.bounceWait = System.currentTimeMillis();
            TwitterCanvas.this.bounceState = 0;
            this.canvas = canvas;
            this.pause = true;
            Thread t = new Thread(this);
            t.start();
        }

        public void pause() {
            this.pause = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resume() {
            this.pause = false;
            Scheduler scheduler = this;
            synchronized (scheduler) {
                this.notifyAll();
            }
        }

        public void exit() {
            this.schedulerExit = true;
            this.resume();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!exit) {
                while (this.pause) {
                    System.out.println("Thread sleeping");
                    Scheduler scheduler = this;
                    synchronized (scheduler) {
                        try {
                            this.wait();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    System.out.println("Thread waking");
                }
                TwitterCanvas.this.birdCounter = (TwitterCanvas.this.birdCounter + 1) % 20;
                if (!TwitterCanvas.this.activeMode) {
                    TwitterCanvas.this.update();
                }
                this.canvas.repaint();
                ++this.gcCounter;
                if (this.gcCounter == 10) {
                    System.gc();
                    this.gcCounter = 0;
                }
                try {
                    Thread.sleep(60L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class RMSparser
    implements Runnable {
        int type;
        Vector v;

        public RMSparser(int id, Vector v) {
            System.out.println("Homescreen reading from RMS");
            this.type = id;
            this.v = v;
            Thread t = new Thread(this);
            t.start();
        }

        public void run() {
            TwitterCanvas.this.showBird = true;
            TwitterCanvas.this.tweetsForCurrentView.removeAllElements();
            TwitterClient.clearAvatars();
            TwitterCanvas.this.scrollSpeed = 0;
            TwitterCanvas.this.decreaseSpeed();
            TwitterCanvas.this.setCommands();
            int nrOfTweets = this.v.size();
            for (int cnt = 0; cnt < nrOfTweets; ++cnt) {
                Tweet t = (Tweet)this.v.elementAt(cnt);
                TweetMessage tm = null;
                System.gc();
                try {
                    tm = new TweetMessage(t, t.screenname.equals(TwitterClient.userName));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    tm = null;
                }
                if (tm == null) continue;
                tm.setTimeStamp(new TimeStamp(tm.getTweet().createdAt));
                TwitterCanvas.this.tweetsForCurrentView.addElement(tm);
            }
            if (TwitterCanvas.this.tweetsForCurrentView.isEmpty()) {
                System.out.println("a4");
                TwitterCanvas.this.resumeToNormal();
                TwitterCanvas.this.error = true;
                TwitterCanvas.this.showPopup(103, true);
                TwitterCanvas.this.sendTimer = 0;
                TwitterCanvas.this.sending = true;
                if (TwitterCanvas.this.update_delay != 100) {
                    nextUpdate = System.currentTimeMillis() + (long)(60000 * TwitterCanvas.this.update_delay);
                }
                TwitterCanvas.this.showBird = false;
                return;
            }
            TwitterCanvas.this.limitCurrentView();
            TwitterCanvas.this.syncLists();
            System.gc();
            if (TwitterCanvas.this.activeMode) {
                TwitterCanvas.this.setFallingStyle(nrOfTweets);
            } else {
                TwitterCanvas.this.setStandardPositionsForBubbles();
            }
            TwitterCanvas.this.paused = false;
            if (TwitterCanvas.this.update_delay != 100) {
                nextUpdate = System.currentTimeMillis() + (long)(60000 * TwitterCanvas.this.update_delay);
            }
            TwitterCanvas.this.showBird = false;
            TwitterCanvas.this.hidePopup();
            updating = false;
            TwitterCanvas.this.setCommands();
            this.v.removeAllElements();
            System.gc();
            for (int i = TwitterCanvas.this.tweetsForCurrentView.size() - 1; i >= 0; --i) {
                if (updating) {
                    return;
                }
                TweetMessage tm = (TweetMessage)TwitterCanvas.this.tweetsForCurrentView.elementAt(i);
                tm.loadAvatar(TwitterCanvas.this.current_preference == 0);
                TwitterCanvas.this.tweetQueue.add(tm, this.type);
            }
        }
    }
}

