/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.twitter;

import com.sonyericsson.twitter.APIListener;
import com.sonyericsson.twitter.JSONTrendParser;
import com.sonyericsson.twitter.TwitterButton;
import com.sonyericsson.twitter.TwitterCanvas;
import com.sonyericsson.twitter.TwitterClient;
import com.sonyericsson.twitter.TwitterDialog;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import se.vitamin.ui.ButtonList;
import se.vitamin.ui.Canvas;
import se.vitamin.ui.UI;
import se.vitamin.ui.Window;

public class TwitterTrendDialog
extends TwitterDialog
implements APIListener {
    private int y_offset = 300;
    private ButtonList _options;
    private static final int TWITTER_NEARBY = 1;
    private int _margin;
    private boolean done = false;
    private boolean cancelled = false;
    private boolean error = false;
    private int[] _floatUpArray = new int[]{-140, -70, -45, -35, -15, -12, -8, -5};
    private int _floatCnt = 0;
    private boolean awaiting = false;
    private JSONTrendParser trendParser;

    public TwitterTrendDialog(Canvas canvas, Window parent) {
        super(canvas, parent);
        int width = UI.mediumFont.stringWidth(UI.getString(23));
        this._margin = (UI.SCREEN_WIDTH - width) / 2;
        this._options = new ButtonList(this, 1, 6, 62, 227);
        this.trendParser = new JSONTrendParser();
    }

    public boolean handleKeyDown(int key) {
        if (this.awaiting) {
            return true;
        }
        if (key != -2 && key != -1 && super.handleKeyDown(key)) {
            return true;
        }
        switch (key) {
            case -7: {
                break;
            }
            case -3: {
                break;
            }
            case -4: {
                break;
            }
            default: {
                return this._options.handleKeyDown(key);
            }
        }
        return true;
    }

    public boolean handleKeyUp(int key) {
        return false;
    }

    public boolean handleLongPress(int key) {
        return false;
    }

    public void reset() {
        this.cancelled = false;
        this.y_offset = 300;
        this._floatCnt = 0;
        this.done = false;
        this._options.clear();
        if (!this.awaiting) {
            this.awaiting = true;
            TwitterClient.apiHandler.getTrends(false, this);
        }
    }

    public void cancel() {
        this.cancelled = true;
        this.trendParser.cancel();
    }

    public void paint(Graphics g) {
        if (this.awaiting) {
            ((TwitterCanvas)this._canvas).drawBird(g);
            return;
        }
        g.drawImage(TwitterCanvas.background, 0, 0, 0);
        g.setFont(UI.mediumFont);
        g.setColor(255, 255, 255);
        g.drawString(UI.getString(166), 120, 6, 17);
        if (this._floatCnt < 8) {
            this.y_offset += this._floatUpArray[this._floatCnt];
            ++this._floatCnt;
        }
        this._options.paint(g, 0, 10 + this.y_offset);
    }

    public void widgetEvent(int id, int event) {
        if (this.awaiting) {
            return;
        }
        System.out.println("widgetEvent " + id);
        this.done = true;
        ((TwitterCanvas)this._canvas).notifyTrendUpdated(((TwitterButton)this._options.getButton((int)this._options.getIndex())).secondary);
    }

    public boolean isDone() {
        return this.done;
    }

    public void twitterEvent(int ID, String response) {
        if (this.cancelled) {
            return;
        }
        if (response.startsWith("90")) {
            ((TwitterCanvas)this._canvas).notifyTrendError();
            return;
        }
        Vector v = this.trendParser.parse(response);
        if (this.cancelled) {
            return;
        }
        if (v.size() == 0) {
            ((TwitterCanvas)this._canvas).notifyTrendError();
            return;
        }
        for (int i = 0; i < v.size(); ++i) {
            JSONTrendParser.Trend t = (JSONTrendParser.Trend)v.elementAt(i);
            TwitterButton b = new TwitterButton(null, i, t.name, null, UI.mediumFont, null);
            b.setDimensions(204, 0);
            b.secondary = t.query;
            this._options.addButton(b);
        }
        this._options.selectButton(0);
        this.selectFirstWidget();
        this.awaiting = false;
    }

    public void activate() {
    }

    public void languageUpdate() {
    }
}

