/*
 * Decompiled with CFR 0.152.
 */
package se.vitamin.ui;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import se.vitamin.ui.UI;
import se.vitamin.ui.Widget;
import se.vitamin.ui.Window;

public abstract class CheckBox
extends Widget {
    Font _font = UI.smallFont;
    int _label;
    protected boolean _active = false;
    protected boolean _checked = false;
    private static final int CHECKBOX_OFFSET = 2;

    public CheckBox(Window parent, int ID) {
        super(parent, ID);
        this._selectable = true;
    }

    public boolean isChecked() {
        return this._checked;
    }

    public void activate() {
        this._active = true;
    }

    public void deactivate() {
        this._active = false;
    }

    public boolean handleKeyDown(int key) {
        if (key == -5) {
            this.select();
            return true;
        }
        return false;
    }

    public boolean handleKeyUp(int key) {
        return false;
    }

    public boolean handleLongPress(int key) {
        return false;
    }

    protected void drawCheckBox(Graphics g, int x, int y) {
        g.setColor(0xFFFFFF);
        g.fillRect(x, y, this._h, this._h);
        g.setColor(0);
        g.drawRect(x, y, this._h, this._h);
        if (this._checked) {
            g.drawLine(x, y, x + this._h, y + this._h);
            g.drawLine(x, y + this._h, x + this._h, y);
        }
    }

    public void paint(Graphics g, int x, int y) {
        this._h = this._font.getHeight();
        this.drawCheckBox(g, x + this._x, y + this._y);
        g.setColor(0);
        g.setFont(this._font);
        g.drawString(UI.getString(this._label), x + this._x + this._h + 12, y + this._y + 3, 0);
        if (this._active) {
            g.setColor(0);
            g.setStrokeStyle(1);
            g.drawRect(x + this._x - 2, y + this._y - 2, this._h + 13 + this._font.stringWidth(UI.getString(this._label)) + 4, this._h + 4 + 4);
            g.setStrokeStyle(0);
        }
    }

    public void setLabel(int label) {
        this._label = label;
    }

    public void select() {
        this._checked = !this._checked;
        this._parent.widgetEvent(this._id, 0);
    }

    public void set() {
        this._checked = true;
    }

    public void unset() {
        this._checked = false;
    }

    public void setDimensions(int x, int y, int w, int h) {
    }

    public void setFont(Font f) {
    }

    public void update() {
    }
}

