/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.email.dataplan;

import com.sonyericsson.email.dataplan.ContentHandlerInvoker;
import com.sonyericsson.email.dataplan.Debug;
import java.io.IOException;
import javax.microedition.content.ContentHandlerException;
import javax.microedition.content.ContentHandlerServer;
import javax.microedition.content.Invocation;
import javax.microedition.content.Registry;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class DataPlanCheck
extends MIDlet
implements CommandListener,
Runnable {
    private static final String DEBUG_ENABLE_TYPE_PROPERTY_NAME = "Debug-Enable-Type";
    private static final String DEBUG_SIM_SWAP_PROPERTY_NAME = "Debug-Sim-Swap";
    private static final String NATIVE_EMAIL_CHAPI_ID = "com.sonyericsson.email.general";
    private static final String RECORD_STORE_NAME = "DataPlanCheck-Tmobile";
    private static final String PLEASE_WAIT_TXT = "Please Wait";
    private static final String CANCEL_TXT = "Cancel";
    private static final String GOTO_TXT = "Goto";
    private static final String EMAIL_TXT = "Email";
    private static final String BROWSER_LAUNCH_TXT = "Your current service level does not include email.  Press Goto to upgrade your account.";
    private RecordStore rs;
    public static final String RECORD_RC_KEY = "RC:";
    public static final String RECORD_SI_KEY = "SI:";
    private int rcKeyId;
    private int rcValue;
    private int siKeyId;
    private String siValue;
    private static final String DEFAULT_TMO_URL = "http://tmosearch.t-zones.com/dsb/t-mobile/upsell?source=CS8emailclient";
    private static final String TMO_URL_PROPERTY_NAME = "TMobile-Url";
    private String tmoUrl;
    private static final String DEFAULT_PING_URL = "http://www.sony.com";
    private static final String PING_URL_PROPERTY_NAME = "Ping-Url";
    private String pingUrl;
    private Alert alert;
    private Command cancelCommand;
    private Display display;
    private boolean forceSimSwap;
    private static final String NO_LAUNCH_EMAIL_CLIENT = "no_launch_email_client";
    private static byte INVOC_RC_UNKNOWN = 0;
    private static byte INVOC_RC_LAUNCH_EMAIL = 1;
    private static byte INVOC_RC_LAUNCHED_EMAIL = (byte)2;
    private static byte INVOC_RC_LAUNCHED_BROWSER = (byte)3;
    private Invocation invoc;
    private ContentHandlerServer handler;
    private boolean launchEmail;

    public DataPlanCheck() {
        block15: {
            this.rcKeyId = -1;
            this.rcValue = -1;
            this.siKeyId = -1;
            this.siValue = "";
            this.tmoUrl = DEFAULT_TMO_URL;
            this.pingUrl = DEFAULT_PING_URL;
            this.forceSimSwap = false;
            this.launchEmail = true;
            int debugEnableType = 0;
            try {
                debugEnableType = Integer.parseInt(this.getAppProperty(DEBUG_ENABLE_TYPE_PROPERTY_NAME));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            Debug.init(debugEnableType);
            try {
                String forceSimSwapStr = this.getAppProperty(DEBUG_SIM_SWAP_PROPERTY_NAME);
                if (forceSimSwapStr != null && (forceSimSwapStr.equalsIgnoreCase("Y") || forceSimSwapStr.equalsIgnoreCase("TRUE"))) {
                    this.forceSimSwap = true;
                }
            }
            catch (Exception e) {
                if (!Debug.isDebugEnable()) break block15;
                Debug.write("Unable to read the Debug-Sim-Swap.  Using a default value");
            }
        }
        if (Debug.isDebugEnable()) {
            Debug.write("forceSimSwap = " + this.forceSimSwap);
        }
        if (Debug.isDebugEnable()) {
            Debug.write("Ping Url: " + this.pingUrl);
        }
        try {
            this.handler = Registry.getServer((String)this.getClass().getName());
        }
        catch (ContentHandlerException e) {
            if (Debug.isDebugEnable()) {
                Debug.write("Unable to retrieve content handler. Exception " + (Object)((Object)e));
            }
            this.shutdown();
        }
        this.display = Display.getDisplay((MIDlet)this);
        this.alert = new Alert(null, PLEASE_WAIT_TXT, null, null);
        this.alert.setTimeout(-2);
        this.alert.setIndicator(new Gauge(null, false, -1, 3));
        this.cancelCommand = new Command(CANCEL_TXT, 3, 1);
        this.alert.addCommand(this.cancelCommand);
        this.alert.setCommandListener((CommandListener)this);
        try {
            this.rs = RecordStore.openRecordStore((String)RECORD_STORE_NAME, (boolean)true);
            this.getData();
        }
        catch (RecordStoreFullException e) {
            e.printStackTrace();
        }
        catch (RecordStoreNotFoundException e) {
            e.printStackTrace();
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
        if (Debug.isDebugEnable()) {
            Debug.write("RC:; id = " + this.rcKeyId + "; value " + this.rcValue);
            Debug.write("SI:; id = " + this.siKeyId + "; value " + this.siValue);
        }
    }

    protected void destroyApp(boolean arg0) throws MIDletStateChangeException {
        if (Debug.isDebugEnable()) {
            Debug.write("DestroyApp");
        }
        this.shutdown();
    }

    protected void pauseApp() {
    }

    private void shutdown() {
        if (Debug.isDebugEnable()) {
            Debug.write("Ending the MIDlet");
        }
        if (this.rs != null) {
            try {
                this.rs.closeRecordStore();
            }
            catch (RecordStoreNotOpenException e) {
                e.printStackTrace();
            }
            catch (RecordStoreException e) {
                e.printStackTrace();
            }
        }
        if (this.invoc != null) {
            this.handler.finish(this.invoc, 5);
        }
        if (this.handler != null) {
            this.handler.setListener(null);
        }
        this.notifyDestroyed();
    }

    protected void startApp() throws MIDletStateChangeException {
        block7: {
            block6: {
                try {
                    this.tmoUrl = this.getAppProperty(TMO_URL_PROPERTY_NAME);
                }
                catch (Exception e) {
                    if (!Debug.isDebugEnable()) break block6;
                    Debug.write("Unable to read the Tmobile Url.  Using a default value");
                }
            }
            if (Debug.isDebugEnable()) {
                Debug.write("Tmobile Url: " + this.tmoUrl);
            }
            try {
                this.pingUrl = this.getAppProperty(PING_URL_PROPERTY_NAME);
            }
            catch (Exception e) {
                if (!Debug.isDebugEnable()) break block7;
                Debug.write("Unable to read the Ping Url.  Using a default value");
            }
        }
        if (Debug.isDebugEnable()) {
            Debug.write("Ping Url: " + this.pingUrl);
        }
        this.processInvocationRequest(this.handler);
        this.display.setCurrent((Displayable)this.alert);
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.cancelCommand) {
            this.shutdown();
        }
    }

    /*
     * Loose catch block
     */
    public void run() {
        if (Debug.isDebugEnable()) {
            Debug.write("In thread Run() method...");
        }
        boolean shutdown = true;
        HttpConnection conn = null;
        try {
            try {
                if (!this.checkSimSwap() && this.rcValue == 200) {
                    if (Debug.isDebugEnable()) {
                        Debug.write("launching app w/o checking connection");
                    }
                    shutdown = this.launchApp(this.rcValue);
                } else {
                    if (Debug.isDebugEnable()) {
                        Debug.write("Opening connection -pinging " + this.pingUrl);
                    }
                    conn = (HttpConnection)Connector.open((String)this.pingUrl);
                    int rc = conn.getResponseCode();
                    if (Debug.isDebugEnable()) {
                        String key;
                        Debug.write("Response code: " + rc);
                        Debug.write("Response message: " + conn.getResponseMessage());
                        int i = 0;
                        while ((key = conn.getHeaderFieldKey(i)) != null) {
                            Debug.write(String.valueOf(key) + ": " + conn.getHeaderField(i));
                            ++i;
                        }
                    }
                    shutdown = this.launchApp(rc);
                    String rcStr = new String(RECORD_RC_KEY + rc);
                    if (this.rcKeyId == -1) {
                        if (this.rs != null) {
                            this.rcKeyId = this.rs.addRecord(rcStr.getBytes(), 0, rcStr.length());
                        }
                    } else if (this.rs != null) {
                        this.rs.setRecord(this.rcKeyId, rcStr.getBytes(), 0, rcStr.length());
                    }
                }
            }
            catch (IOException e) {
                if (Debug.isDebugEnable()) {
                    Debug.write("IOException in pinging!!");
                }
                e.printStackTrace();
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (IOException e2) {
                        if (Debug.isDebugEnable()) {
                            Debug.write("Error in closing connection!");
                        }
                        e2.printStackTrace();
                    }
                }
                if (shutdown) {
                    this.shutdown();
                }
            }
            catch (RuntimeException e) {
                block44: {
                    if (Debug.isDebugEnable()) {
                        Debug.write("RuntimeException occured!!");
                    }
                    e.printStackTrace();
                    if (conn == null) break block44;
                    try {
                        conn.close();
                    }
                    catch (IOException e3) {
                        if (Debug.isDebugEnable()) {
                            Debug.write("Error in closing connection!");
                        }
                        e3.printStackTrace();
                    }
                }
                if (shutdown) {
                    this.shutdown();
                }
            }
            catch (Exception e) {
                block45: {
                    if (Debug.isDebugEnable()) {
                        Debug.write("Unexpected Exception occured");
                    }
                    e.printStackTrace();
                    if (conn == null) break block45;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    try {
                        conn.close();
                    }
                    catch (IOException e4) {
                        if (Debug.isDebugEnable()) {
                            Debug.write("Error in closing connection!");
                        }
                        e4.printStackTrace();
                    }
                }
                if (shutdown) {
                    this.shutdown();
                }
            }
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (IOException e) {
                    if (Debug.isDebugEnable()) {
                        Debug.write("Error in closing connection!");
                    }
                    e.printStackTrace();
                }
            }
            if (shutdown) {
                this.shutdown();
            }
        }
    }

    private boolean checkSimSwap() {
        if (this.forceSimSwap) {
            return true;
        }
        if (this.rs == null) {
            return true;
        }
        String curSubNumber = System.getProperty("com.sonyericsson.sim.subscribernumber");
        if (Debug.isDebugEnable()) {
            Debug.write("current subscriber number " + curSubNumber);
        }
        if (this.siKeyId != -1 && curSubNumber.equals(this.siValue)) {
            return false;
        }
        String siStr = new String(RECORD_SI_KEY + curSubNumber);
        try {
            if (this.siKeyId == -1) {
                this.siKeyId = this.rs.addRecord(siStr.getBytes(), 0, siStr.length());
            } else {
                this.rs.setRecord(this.siKeyId, siStr.getBytes(), 0, siStr.length());
            }
        }
        catch (RecordStoreNotOpenException e1) {
            e1.printStackTrace();
            this.siKeyId = -1;
        }
        catch (RecordStoreFullException e1) {
            e1.printStackTrace();
            this.siKeyId = -1;
        }
        catch (RecordStoreException e1) {
            e1.printStackTrace();
            this.siKeyId = -1;
        }
        if (this.rcKeyId != -1) {
            try {
                this.rs.deleteRecord(this.rcKeyId);
            }
            catch (RecordStoreNotOpenException e) {
                e.printStackTrace();
            }
            catch (InvalidRecordIDException e) {
                e.printStackTrace();
            }
            catch (RecordStoreException e) {
                e.printStackTrace();
            }
        }
        this.rcKeyId = -1;
        return true;
    }

    private boolean launchApp(int rc) {
        if (rc == 200) {
            if (this.launchEmail) {
                if (this.invoc != null) {
                    byte[] data = new byte[]{INVOC_RC_LAUNCHED_EMAIL};
                    this.invoc.setData(data);
                }
                if (Debug.isDebugEnable()) {
                    Debug.write("launch email...");
                }
                ContentHandlerInvoker chi = new ContentHandlerInvoker(NATIVE_EMAIL_CHAPI_ID, this.getClass().getName());
                chi.start();
            } else {
                if (Debug.isDebugEnable()) {
                    Debug.write("No launching email.  return appropriate code");
                }
                if (this.invoc != null) {
                    byte[] data = new byte[]{INVOC_RC_LAUNCH_EMAIL};
                    this.invoc.setData(data);
                }
            }
            return true;
        }
        if (rc == 302) {
            if (this.invoc != null) {
                byte[] data = new byte[]{INVOC_RC_LAUNCHED_BROWSER};
                this.invoc.setData(data);
            }
            Form browserLaunchForm = new Form(EMAIL_TXT);
            final Command gotoCmd = new Command(GOTO_TXT, 4, 1);
            final Command cancelCmd = new Command(CANCEL_TXT, 2, 1);
            browserLaunchForm.addCommand(gotoCmd);
            browserLaunchForm.addCommand(cancelCmd);
            StringItem browserLaunchText = new StringItem(null, BROWSER_LAUNCH_TXT);
            browserLaunchText.setLayout(563);
            browserLaunchForm.append((Item)browserLaunchText);
            browserLaunchForm.setCommandListener(new CommandListener(){

                public void commandAction(Command command, Displayable display) {
                    if (command == cancelCmd) {
                        DataPlanCheck.this.shutdown();
                    } else if (command == gotoCmd) {
                        Debug.write("launch browser...");
                        try {
                            DataPlanCheck.this.platformRequest(DataPlanCheck.this.tmoUrl);
                        }
                        catch (ConnectionNotFoundException e) {
                            if (Debug.isDebugEnable()) {
                                Debug.write("Failed to launch browser");
                            }
                            e.printStackTrace();
                        }
                        DataPlanCheck.this.shutdown();
                    }
                }
            });
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)browserLaunchForm);
            return false;
        }
        if (Debug.isDebugEnable()) {
            Debug.write("An unexpected result code " + rc);
        }
        if (this.invoc != null) {
            byte[] data = new byte[]{INVOC_RC_UNKNOWN};
            this.invoc.setData(data);
        }
        return true;
    }

    private void getData() {
        if (this.rs == null) {
            return;
        }
        try {
            RecordEnumeration recEum = this.rs.enumerateRecords(null, null, false);
            while (recEum.hasNextElement()) {
                try {
                    int id = recEum.nextRecordId();
                    String r = new String(this.rs.getRecord(id));
                    if (Debug.isDebugEnable()) {
                        Debug.write("found record " + id + "; data = " + r);
                    }
                    if (r.startsWith(RECORD_RC_KEY)) {
                        try {
                            this.rcValue = Integer.parseInt(r.substring(RECORD_RC_KEY.length()));
                            this.rcKeyId = id;
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    if (!r.startsWith(RECORD_SI_KEY)) continue;
                    this.siValue = r.substring(RECORD_SI_KEY.length());
                    this.siKeyId = id;
                }
                catch (InvalidRecordIDException e1) {
                    e1.printStackTrace();
                }
                catch (RecordStoreException e1) {
                    e1.printStackTrace();
                }
            }
        }
        catch (RecordStoreNotOpenException e) {
            e.printStackTrace();
        }
    }

    public void processInvocationRequest(ContentHandlerServer chs) {
        if (Debug.isDebugEnable()) {
            Debug.write("[processInvocationRequest]");
        }
        try {
            if (chs != null) {
                if (Debug.isDebugEnable()) {
                    Debug.write("getting invocation from the ContentHandlerServer");
                }
                if (this.invoc != null) {
                    chs.finish(this.invoc, 5);
                }
                this.invoc = chs.getRequest(false);
                if (this.invoc != null) {
                    String[] args = this.invoc.getArgs();
                    if (args != null && args.length > 0 && NO_LAUNCH_EMAIL_CLIENT.equals(args[0])) {
                        if (Debug.isDebugEnable()) {
                            Debug.write("receive argument NO_LAUNCH_EMAIL_CLIENT");
                        }
                        this.launchEmail = false;
                    }
                    byte[] data = new byte[]{INVOC_RC_UNKNOWN};
                    this.invoc.setData(data);
                } else if (Debug.isDebugEnable()) {
                    Debug.write("No immediate handler request");
                }
            }
            if (Debug.isDebugEnable()) {
                Debug.write("launchEmail " + this.launchEmail);
            }
            Thread t = new Thread(this);
            t.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.shutdown();
        }
    }
}

