/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.email.dataplan;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public class Debug {
    private static final String DEBUGPATH = "c:/other/debug/";
    public static final int DEBUG_DISABLE = 0;
    public static final int DEBUG_TO_STANDARD_OUT = 1;
    public static final int DEBUG_TO_FILE = 2;
    public static final int DEBUG_ENABLE_ALL = 3;
    public static String debugSessionFilename;
    private static boolean writeToFile;
    private static boolean writeToSyso;

    public static void init(int debugEnableType) {
        switch (debugEnableType) {
            case 0: {
                writeToFile = false;
                writeToSyso = false;
                break;
            }
            case 1: {
                writeToFile = false;
                writeToSyso = true;
                break;
            }
            case 2: {
                writeToFile = true;
                writeToSyso = false;
                break;
            }
            case 3: {
                writeToFile = true;
                writeToSyso = true;
                break;
            }
            default: {
                writeToFile = false;
                writeToSyso = false;
            }
        }
        if (writeToFile) {
            try {
                FileConnection fcon = (FileConnection)Connector.open((String)"file:///c:/other/debug/");
                if (!fcon.exists()) {
                    fcon.mkdir();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (debugSessionFilename == null) {
                debugSessionFilename = Debug.createSessionFilename();
            }
        }
    }

    private static String createSessionFilename() {
        Calendar now = Calendar.getInstance();
        now.setTime(new Date(System.currentTimeMillis()));
        StringBuffer buffer = new StringBuffer();
        int year = now.get(1);
        buffer.append(year);
        buffer.append('-');
        int month = now.get(2);
        if (month < 10) {
            buffer.append('0');
        }
        buffer.append(month);
        buffer.append('-');
        int day = now.get(5);
        if (day < 10) {
            buffer.append('0');
        }
        buffer.append(day);
        buffer.append(' ');
        int hour = now.get(11);
        if (hour < 10) {
            buffer.append('0');
        }
        buffer.append(hour);
        buffer.append('.');
        int minute = now.get(12);
        if (minute < 10) {
            buffer.append('0');
        }
        buffer.append(minute);
        buffer.append('.');
        int second = now.get(13);
        if (second < 10) {
            buffer.append('0');
        }
        buffer.append(second);
        buffer.append(" (dbg).txt");
        return buffer.toString();
    }

    public static void write(String message) {
        Debug.printInternal("[DataPlanCheck]: ", message);
    }

    public static void trace(String message) {
        Debug.trace(true, message);
    }

    public static void trace(boolean guard, String message) {
        if (guard) {
            Debug.printInternal("[DataPlanCheck]: -- ", message);
        }
    }

    public static void warn(String message) {
        Debug.printInternal("[DataPlanCheck]: ## WARNING ## ", message);
    }

    public static void error(String message) {
        Debug.printInternal("[DataPlanCheck]: *** ERROR *** ", message);
    }

    private static void printInternal(String prefix, String message) {
        StringBuffer output = new StringBuffer();
        if (writeToFile) {
            Debug.appendDate(output);
        }
        output.append(message);
        if (writeToSyso) {
            System.out.println(String.valueOf(prefix) + output.toString());
        }
        Debug.writeToFile(output.toString());
    }

    private static void writeToFile(String output) {
        if (writeToFile && debugSessionFilename != null) {
            try {
                String url = "file:///c:/other/debug/" + debugSessionFilename;
                FileConnection fcon = (FileConnection)Connector.open((String)url);
                if (!fcon.exists()) {
                    fcon.create();
                }
                OutputStream os = fcon.openOutputStream(fcon.fileSize());
                os.write(10);
                os.write(output.getBytes());
                os.flush();
                os.close();
                fcon.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void appendDate(StringBuffer output) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(System.currentTimeMillis()));
        if (cal.get(11) < 10) {
            output.append('0');
        }
        output.append(cal.get(11));
        output.append('.');
        if (cal.get(12) < 10) {
            output.append('0');
        }
        output.append(cal.get(12));
        output.append('.');
        if (cal.get(13) < 10) {
            output.append('0');
        }
        output.append(cal.get(13));
        output.append(": ");
    }

    public static boolean isDebugEnable() {
        return writeToFile || writeToSyso;
    }
}

