/*
 * Decompiled with CFR 0.152.
 */
package com.naviexpert.activator;

import com.naviexpert.activator.Waitable;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SplashAnimation
extends Canvas
implements Runnable {
    private static final int BG_COLOR = 16606720;
    private static final int WAITING_TIME = 2000;
    private Image[] images;
    private int indicator;
    private final int imagesSize;
    private Waitable waitable;
    private Image currentImage;

    public SplashAnimation(Waitable waitable) {
        this.imagesSize = 3;
        this.waitable = waitable;
        this.loadImages();
    }

    private void loadImages() {
        this.images = new Image[4];
        try {
            this.images[0] = Image.createImage((InputStream)this.getClass().getResourceAsStream(this.getFolderSize() + "splash.png"));
            for (int i = 1; i < 4; ++i) {
                this.images[i] = Image.createImage((InputStream)this.getClass().getResourceAsStream(this.getFolderSize() + i + ".png"));
            }
        }
        catch (IOException e1) {
            throw new RuntimeException("test" + e1.getMessage());
        }
    }

    private String getFolderSize() {
        StringBuffer path = new StringBuffer("/res/");
        if (this.getHeight() > this.getWidth()) {
            path.append("height/");
        } else {
            path.append("width/");
        }
        return path.toString();
    }

    protected void paint(Graphics g) {
        g.setColor(16606720);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.images != null) {
            this.currentImage = this.images[this.indicator];
            g.drawImage(this.currentImage, this.getWidth() / 2, this.getHeight() / 2, 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.indicator = 0;
            while (this.indicator < this.images.length) {
                this.repaint();
                Thread.sleep(this.indicator == 0 ? 4000L : 2000L);
                ++this.indicator;
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.waitable.waitingEndNotify();
        }
    }

    protected void showNotify() {
        new Thread(this).start();
    }

    protected void sizeChanged(int w, int h) {
        this.loadImages();
    }
}

