/*
 * Decompiled with CFR 0.152.
 */
package com.mgie.darkchess;

import com.mgie.darkchess.ChessUnit;
import com.mgie.darkchess.DarkChessAI;
import com.mgie.darkchess.DarkChessConfig;
import com.mgie.darkchess.DarkChessRes;
import com.mgie.darkchess.GameFunction;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;

public class DarkChessControl
implements DarkChessConfig {
    public DarkChessRes res = new DarkChessRes();
    public DarkChessAI ai = new DarkChessAI(this.res);

    public void initGame() {
        int n;
        this.res.game_ready = false;
        this.res.attack_ready = false;
        this.ai.initAI();
        this.res.game_hide_total = 32;
        this.res.game_hide_total_red = 16;
        this.res.game_hide_total_black = 16;
        this.res.player_chess_color = 0;
        this.res.running_chess_color = 0;
        this.res.lastChessRedCount = 0;
        this.res.lastChessBlackCount = 0;
        this.res.emptyStepCount = 0;
        this.res.delete_chess_red = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        this.res.delete_chess_black = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        Vector<Byte> vector = new Vector<Byte>();
        byte[] byArray = new byte[32];
        byte[] byArray2 = new byte[32];
        for (n = 0; n < 32; ++n) {
            byArray2[n] = 10;
            Byte by = new Byte(DarkChessConfig.FINAL_CHESS_MAP[n]);
            vector.addElement(by);
        }
        for (n = 0; n < byArray.length; ++n) {
            int n2 = GameFunction.random(0, vector.size());
            byArray[n] = Byte.parseByte(vector.elementAt(n2).toString());
            vector.removeElementAt(n2);
        }
        this.res.display_chess_map = byArray2;
        this.res.type_chess_map = byArray;
    }

    public byte[] getGameChessMap() {
        return this.copyChessMap(this.res.type_chess_map);
    }

    public void setPlayerRivalID(int n) {
        this.res.player_rival = n;
    }

    public int getPlayerRivalID() {
        return this.res.player_rival;
    }

    public byte[] getDisplayChessMap() {
        return this.copyChessMap(this.res.display_chess_map);
    }

    public byte[] getRivalChessDeleteTotal() {
        if (this.res.player_chess_color == 1) {
            return this.res.delete_chess_black;
        }
        return this.res.delete_chess_red;
    }

    private byte[] copyChessMap(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i] = byArray[i];
        }
        return byArray2;
    }

    public int checkInputForChooseState(int n, int n2) {
        int n3 = n * 4 + n2;
        byte by = this.res.display_chess_map[n3];
        byte by2 = this.res.type_chess_map[n3];
        if (by2 == 0) {
            return this.checkMove(n, n2);
        }
        if (by != 10 && this.checkMyChessColor(-by2)) {
            return this.checkAttack(by2, n, n2);
        }
        return 1;
    }

    private int checkMove(int n, int n2) {
        if (!this.checkMoveSpace(n, n2)) {
            return 1;
        }
        this.moveSuccee(n, n2);
        return 11;
    }

    private boolean checkMoveSpace(int n, int n2) {
        int n3 = Math.abs(n - this.res.attack_chess_row);
        int n4 = Math.abs(n2 - this.res.attack_chess_col);
        return n3 == 0 && n4 == 1 || n3 == 1 && n4 == 0;
    }

    private void moveSuccee(int n, int n2) {
        this.ai.chessMoveSuccee(this.res.attack_chess_row, this.res.attack_chess_col, n, n2);
        this.turnControl();
    }

    private int checkAttack(int n, int n2, int n3) {
        if (!this.checkAttackSpace(n2, n3)) {
            return 1;
        }
        if (Math.abs(this.res.attack_chess_value) == 6) {
            this.attackSuccee(n2, n3);
        } else if (Math.abs(this.res.attack_chess_value) == 1) {
            if (Math.abs(n) != 7) {
                this.attackSuccee(n2, n3);
            }
        } else if (Math.abs(this.res.attack_chess_value) == 7) {
            if (Math.abs(n) == 1 || Math.abs(n) == 7) {
                this.attackSuccee(n2, n3);
            }
        } else {
            int n4 = Math.abs(this.res.attack_chess_value) - Math.abs(n);
            if (n4 <= 0) {
                this.attackSuccee(n2, n3);
            }
        }
        return 11;
    }

    private void attackSuccee(int n, int n2) {
        this.ai.chessAttackSuccee(this.res.attack_chess_row, this.res.attack_chess_col, n, n2);
        this.turnControl();
    }

    private boolean checkAttackSpace(int n, int n2) {
        if (Math.abs(this.res.attack_chess_value) == 6) {
            int n3 = 0;
            int n4 = 0;
            if (this.res.attack_chess_row == n) {
                int n5 = this.res.attack_chess_col - n2;
                int n6 = n2;
                if (n5 > 1) {
                    for (int i = 1; i < Math.abs(n5); ++i) {
                        if (this.res.type_chess_map[n3 = n * 4 + ++n6] == 0) continue;
                        ++n4;
                    }
                } else if (n5 < -1) {
                    for (int i = 1; i < Math.abs(n5); ++i) {
                        if (this.res.type_chess_map[n3 = n * 4 + --n6] == 0) continue;
                        ++n4;
                    }
                }
                if (n4 == 1) {
                    return true;
                }
            } else if (this.res.attack_chess_col == n2) {
                int n7 = this.res.attack_chess_row - n;
                int n8 = n;
                if (n7 > 1) {
                    for (int i = 1; i < Math.abs(n7); ++i) {
                        if (this.res.type_chess_map[n3 = ++n8 * 4 + n2] == 0) continue;
                        ++n4;
                    }
                } else if (n7 < -1) {
                    for (int i = 1; i < Math.abs(n7); ++i) {
                        if (this.res.type_chess_map[n3 = --n8 * 4 + n2] == 0) continue;
                        ++n4;
                    }
                }
                if (n4 == 1) {
                    return true;
                }
            }
        } else {
            int n9 = Math.abs(n - this.res.attack_chess_row);
            int n10 = Math.abs(n2 - this.res.attack_chess_col);
            if (n9 == 0 && n10 == 1 || n9 == 1 && n10 == 0) {
                return true;
            }
        }
        return false;
    }

    public int checkInputForMoveState(int n, int n2) {
        int n3 = n * 4 + n2;
        byte by = this.res.display_chess_map[n3];
        byte by2 = this.res.type_chess_map[n3];
        if (by == 10) {
            this.ai.chessTurnSuccee(n3);
            if (!this.res.game_ready) {
                return this.initGameReady(n3);
            }
            this.turnControl();
            return 11;
        }
        if (this.checkMyChessColor(by2)) {
            this.res.attack_chess_value = by2;
            this.res.attack_chess_col = n2;
            this.res.attack_chess_row = n;
            return 2;
        }
        return 1;
    }

    public ChessUnit getLiseChess() {
        return this.res.lastChess;
    }

    public int getPlayerChessColor() {
        return this.res.player_chess_color;
    }

    private boolean checkMyChessColor(int n) {
        return this.checkSelfChessColor(n, this.res.player_chess_color);
    }

    private void turnControl() {
        this.res.running_chess_color = -this.res.running_chess_color;
    }

    public boolean checkMyTurn() {
        if (!this.res.game_ready && this.res.player_first) {
            return true;
        }
        return this.res.running_chess_color == this.res.player_chess_color;
    }

    public int getTurnState() {
        if (this.checkMyTurn()) {
            if (this.res.attack_ready) {
                this.res.attack_ready = false;
                return -3;
            }
            return 1;
        }
        if (this.res.attack_ready) {
            this.res.attack_ready = false;
            return 3;
        }
        return -1;
    }

    public boolean getPlayerFirst() {
        return this.res.player_first;
    }

    private boolean checkSelfChessColor(int n, int n2) {
        if (Math.abs(n) == 0) {
            return false;
        }
        int n3 = 1;
        if (n < 0) {
            n3 = -1;
        }
        return n3 == n2;
    }

    private int initGameReady(int n) {
        byte by;
        this.res.display_chess_map[n] = by = this.res.type_chess_map[n];
        int n2 = -1;
        if (by > 0) {
            n2 = 1;
        }
        this.res.running_chess_color = -n2;
        this.res.game_ready = true;
        this.res.player_chess_color = this.res.player_first ? n2 : -n2;
        return 11;
    }

    public int selectFirstPlayer(boolean bl) {
        this.res.player_first = bl;
        if (!bl) {
            return -1;
        }
        return 1;
    }

    public int AIRunning(int n) {
        switch (n) {
            case -1: {
                switch (this.ai.checking()) {
                    case 23: {
                        if (!this.res.game_ready) {
                            return this.initGameReady(this.ai.chessTurn());
                        }
                        if (GameFunction.random(0, 8) > 3) {
                            this.ai.chessTurn_cheat();
                            break;
                        }
                        this.ai.chessTurn();
                        break;
                    }
                    case 20: {
                        this.ai.chessAttack();
                        break;
                    }
                    case 21: {
                        this.ai.chessRandomMove();
                        break;
                    }
                    case 22: {
                        this.ai.chessMoveAttack();
                        break;
                    }
                    case 27: {
                        this.ai.chessCounterattack();
                        break;
                    }
                    case 26: {
                        break;
                    }
                    case 25: {
                        break;
                    }
                    default: {
                        System.out.println("doing....what....?");
                    }
                }
                this.turnControl();
                return 11;
            }
        }
        return 11;
    }

    public boolean checkWin(int n) {
        int n2 = -n;
        if (this.ai.chessTurnAble(n2)) {
            return false;
        }
        if (this.ai.chessMoveAble(n2)) {
            return false;
        }
        if (this.ai.chessAttackAble(n2)) {
            return false;
        }
        return this.ai.getMyChessSize(n2) <= 0 || !this.ai.chessTurnAble();
    }

    public boolean checkLost(int n) {
        if (this.ai.chessTurnAble(n)) {
            return false;
        }
        if (this.ai.chessMoveAble(n)) {
            return false;
        }
        if (this.ai.chessAttackAble(n)) {
            return false;
        }
        return this.ai.getMyChessSize(n) <= 0 || !this.ai.chessTurnAble();
    }

    public boolean checkStandoff() {
        return this.ai.checkStandoff();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] sequenceData() {
        ByteArrayOutputStream byteArrayOutputStream = null;
        DataOutputStream dataOutputStream = null;
        byteArrayOutputStream = new ByteArrayOutputStream();
        dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        byte[] byArray = null;
        try {
            int n;
            dataOutputStream.writeBoolean(this.res.game_ready);
            dataOutputStream.writeBoolean(this.res.player_first);
            dataOutputStream.writeInt(this.res.player_chess_color);
            dataOutputStream.writeInt(this.res.running_chess_color);
            dataOutputStream.writeInt(this.res.player_rival);
            dataOutputStream.writeInt(this.res.delete_chess_red.length);
            for (n = 0; n < this.res.delete_chess_red.length; ++n) {
                dataOutputStream.writeByte(this.res.delete_chess_red[n]);
            }
            dataOutputStream.writeInt(this.res.delete_chess_black.length);
            for (n = 0; n < this.res.delete_chess_black.length; ++n) {
                dataOutputStream.writeByte(this.res.delete_chess_black[n]);
            }
            dataOutputStream.writeInt(this.res.display_chess_map.length);
            for (n = 0; n < this.res.display_chess_map.length; ++n) {
                dataOutputStream.writeByte(this.res.display_chess_map[n]);
            }
            dataOutputStream.writeInt(this.res.type_chess_map.length);
            for (n = 0; n < this.res.type_chess_map.length; ++n) {
                dataOutputStream.writeByte(this.res.type_chess_map[n]);
            }
            dataOutputStream.writeInt(this.res.game_hide_total_red);
            dataOutputStream.writeInt(this.res.game_hide_total_black);
            dataOutputStream.writeInt(this.res.game_hide_total);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
        }
        finally {
            if (dataOutputStream != null) {
                try {
                    dataOutputStream.close();
                    dataOutputStream = null;
                }
                catch (IOException iOException) {}
            }
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                    byteArrayOutputStream = null;
                }
                catch (IOException iOException) {}
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importData(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = null;
        DataInputStream dataInputStream = null;
        byteArrayInputStream = new ByteArrayInputStream(byArray);
        dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            int n;
            this.res.attack_ready = false;
            this.ai.initAI();
            this.res.game_hide_total = 32;
            this.res.game_hide_total_red = 16;
            this.res.game_hide_total_black = 16;
            this.res.lastChessRedCount = 0;
            this.res.lastChessBlackCount = 0;
            this.res.emptyStepCount = 0;
            this.res.game_ready = dataInputStream.readBoolean();
            this.res.player_first = dataInputStream.readBoolean();
            this.res.player_chess_color = dataInputStream.readInt();
            this.res.running_chess_color = dataInputStream.readInt();
            this.res.player_rival = dataInputStream.readInt();
            this.res.delete_chess_red = new byte[dataInputStream.readInt()];
            for (n = 0; n < this.res.delete_chess_red.length; ++n) {
                this.res.delete_chess_red[n] = dataInputStream.readByte();
            }
            this.res.delete_chess_black = new byte[dataInputStream.readInt()];
            for (n = 0; n < this.res.delete_chess_black.length; ++n) {
                this.res.delete_chess_black[n] = dataInputStream.readByte();
            }
            this.res.display_chess_map = new byte[dataInputStream.readInt()];
            for (n = 0; n < this.res.display_chess_map.length; ++n) {
                this.res.display_chess_map[n] = dataInputStream.readByte();
            }
            this.res.type_chess_map = new byte[dataInputStream.readInt()];
            for (n = 0; n < this.res.type_chess_map.length; ++n) {
                this.res.type_chess_map[n] = dataInputStream.readByte();
            }
            for (n = 0; n < this.res.display_chess_map.length; ++n) {
                byte by = this.res.display_chess_map[n];
                if (by == 10 || by == 0) continue;
                int n2 = n / 4;
                int n3 = n % 4;
                ChessUnit chessUnit = new ChessUnit(by, n2, n3, this.res.game_hide_total);
                if (this.res.display_chess_map[n] > 0) {
                    this.res.vt_chess_red.addElement(chessUnit);
                } else if (this.res.display_chess_map[n] < 0) {
                    this.res.vt_chess_black.addElement(chessUnit);
                }
                --this.res.game_hide_total;
            }
            this.res.game_hide_total_red = dataInputStream.readInt();
            this.res.game_hide_total_black = dataInputStream.readInt();
            this.res.game_hide_total = dataInputStream.readInt();
        }
        catch (Exception exception) {
        }
        finally {
            if (dataInputStream != null) {
                try {
                    dataInputStream.close();
                    dataInputStream = null;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                    byteArrayInputStream = null;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public void saveGame() {
        byte[] byArray = this.sequenceData();
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"SAVE__STORE", (boolean)true);
            if (recordStore.getNumRecords() > 0) {
                recordStore.setRecord(1, byArray, 0, byArray.length);
            } else {
                recordStore.addRecord(byArray, 0, byArray.length);
            }
            recordStore.closeRecordStore();
        }
        catch (RecordStoreFullException recordStoreFullException) {
            recordStoreFullException.printStackTrace();
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            recordStoreNotFoundException.printStackTrace();
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadGame() {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)"SAVE__STORE", (boolean)false);
            if (recordStore != null && recordStore.getNumRecords() > 0) {
                this.importData(recordStore.getRecord(1));
            }
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            this.saveGame();
            recordStoreNotFoundException.printStackTrace();
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                }
                catch (RecordStoreException recordStoreException) {
                    recordStoreException.printStackTrace();
                }
            }
        }
    }
}

