/*
 * Decompiled with CFR 0.152.
 */
package com.bpi.encryption;

public class GenerationLibrary {
    public static final boolean DEBUG = false;
    public static final int TOTAL_VALUE_BASE32 = 32;
    public static final int TOTAL_INT_BIT = 32;
    public static final int TOTAL_BPC = 5;
    public static final int TOTAL_CODE = 13;
    public static final int TOTAL_CODE_WITH_CHECKBITS = 15;
    public static final int MAX_RANGE = 1000000000;
    public static final int TOTAL_NUMBER_DIGIT = 10;
    public static final int TOTAL_DIGIT = 9;
    public static final int[] DIGIT_TABLE = new int[]{10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    public static final int UID = 0;
    public static final int SCORE = 1;
    public static final int MASK1 = -1431655766;
    public static final int MASK2 = 0x55555555;
    public static final int SINGLE_BIT_MARK = 1;
    public static final int[][] UID_TABLE = new int[][]{{5, 2, 4, 1, 7, 0, 3, 9, 6, 8}, {2, 4, 1, 7, 0, 3, 9, 6, 8, 5}, {4, 1, 7, 0, 3, 9, 6, 8, 5, 2}, {1, 7, 0, 3, 9, 6, 8, 5, 2, 4}, {7, 0, 3, 9, 6, 8, 5, 2, 4, 1}, {0, 3, 9, 6, 8, 5, 2, 4, 1, 7}, {3, 9, 6, 8, 5, 2, 4, 1, 7, 0}, {9, 6, 8, 5, 2, 4, 1, 7, 0, 3}, {6, 8, 5, 2, 4, 1, 7, 0, 3, 9}, {8, 5, 2, 4, 1, 7, 0, 3, 9, 6}};
    public static final int[][] SOURCE_TABLE = new int[][]{{7, 4, 5, 2, 3, 6, 1, 8, 9, 0}, {4, 5, 2, 3, 6, 1, 8, 9, 0, 7}, {5, 2, 3, 6, 1, 8, 9, 0, 7, 4}, {2, 3, 6, 1, 8, 9, 0, 7, 4, 5}, {3, 6, 1, 8, 9, 0, 7, 4, 5, 2}, {6, 1, 8, 9, 0, 7, 4, 5, 2, 3}, {1, 8, 9, 0, 7, 4, 5, 2, 3, 6}, {8, 9, 0, 7, 4, 5, 2, 3, 6, 1}, {9, 0, 7, 4, 5, 2, 3, 6, 1, 8}, {0, 7, 4, 5, 2, 3, 6, 1, 8, 9}};
    public static long seed1 = 1010002406L;
    public static long seed2 = 501L;
    public static int seed3 = 23;
    public static char[] BASE32 = new char[]{'4', 'H', 'J', 'K', '9', 'R', 'S', '8', 'X', 'U', '6', 'E', '7', 'D', 'G', 'W', '2', 'N', 'A', '3', 'Z', 'B', 'C', 'L', 'F', 'P', 'V', '5', 'Y', 'T', 'Q', 'M'};
    public static String BASE32_STR;

    public static int[] decryption(String string) {
        int[] nArray = new int[]{-1, -1};
        try {
            if (string.length() == 13) {
                nArray = GenerationLibrary.base32DecodingData32(string, BASE32_STR);
                int n2 = nArray[0] & 0xAAAAAAAA | nArray[1] & 0x55555555;
                int n3 = nArray[0] & 0x55555555 | nArray[1] & 0xAAAAAAAA;
                nArray[0] = GenerationLibrary.decodeNumber(n2, UID_TABLE);
                nArray[1] = GenerationLibrary.decodeNumber(n3, SOURCE_TABLE);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nArray;
    }

    public static String encryption(int n2, int n3) {
        String string = null;
        n2 = GenerationLibrary.encodeNumber(n2, UID_TABLE);
        n3 = GenerationLibrary.encodeNumber(n3, SOURCE_TABLE);
        int n4 = n2 & 0xAAAAAAAA | n3 & 0x55555555;
        int n5 = n2 & 0x55555555 | n3 & 0xAAAAAAAA;
        int[] nArray = new int[]{n4, n5};
        try {
            string = GenerationLibrary.base32Encoding(nArray, BASE32_STR);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public static int encodeNumber(int n2, int[][] nArray) {
        int n3 = 0;
        if (n2 >= 0 && n2 < 1000000000) {
            for (int i2 = 8; i2 >= 0; --i2) {
                int n4 = DIGIT_TABLE[i2];
                int n5 = n4 / 10;
                int n6 = n2 % n4;
                int n7 = n6 / n5;
                int n8 = nArray[i2][n7];
                n3 += n8 * n5;
            }
        }
        return n3;
    }

    public static int decodeNumber(int n2, int[][] nArray) {
        int n3 = 0;
        if (n2 >= 0 && n2 < 1000000000) {
            for (int i2 = 8; i2 >= 0; --i2) {
                int n4 = DIGIT_TABLE[i2];
                int n5 = n4 / 10;
                int n6 = n2 % n4;
                int n7 = n6 / n5;
                int n8 = 0;
                for (int i3 = 0; i3 < 10; ++i3) {
                    if (nArray[i2][i3] != n7) continue;
                    n8 = i3;
                }
                n3 += n8 * n5;
            }
        }
        return n3;
    }

    public static String base32Encoding(int[] nArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 5;
        int n3 = 0;
        int n4 = 0;
        try {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                for (int i3 = 31; i3 >= 0; --i3) {
                    if (n2 == 0) {
                        stringBuffer.append(string.charAt(n3));
                        n3 = 0;
                        n2 = 5;
                    }
                    n4 = nArray[i2] & 1 << i3;
                    n3 |= (n4 >>= i3) << --n2;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringBuffer.append(BASE32[n3]);
        return stringBuffer.toString();
    }

    public static int[] base32DecodingData32(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 32;
        int n3 = 0;
        int n4 = 0;
        int n5 = string.length() * 5 / 32;
        int n6 = 0;
        char[] cArray = string.toCharArray();
        int[] nArray = new int[n5];
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            int n7;
            n3 = string2.indexOf(cArray[i2]);
            if (n2 > 5) {
                nArray[n6] = nArray[n6] | n3 << (n2 -= 5);
                continue;
            }
            int n8 = 0;
            while (0 < n2) {
                n7 = 5 - n8 - 1;
                n4 = n3 & 1 << n7;
                nArray[n6] = nArray[n6] | (n4 >>= n7) << n2 - 1;
                --n2;
                ++n8;
            }
            if (++n6 >= n5) continue;
            n2 = 32;
            while (n8 < 5) {
                n7 = 5 - n8 - 1;
                n4 = n3 & 1 << n7;
                nArray[n6] = nArray[n6] | (n4 >>= n7) << --n2;
                ++n8;
            }
        }
        stringBuffer.append(BASE32[n3]);
        return nArray;
    }

    static {
        for (int i2 = 0; i2 < BASE32.length; ++i2) {
            int n2 = (int)((seed1 -= seed2 * (long)i2) % (long)BASE32.length);
            char c2 = BASE32[n2];
            GenerationLibrary.BASE32[n2] = BASE32[i2];
            GenerationLibrary.BASE32[i2] = c2;
            BASE32_STR = new String(BASE32);
        }
    }
}

