/*
 * Decompiled with CFR 0.152.
 */
import com.mgie.hkmj.MJConfig;
import com.mgie.hkmj.MJGame;
import com.mgie.hkmj.MJPlayer;
import com.mgie.hkmj.ThinkingOrder;
import com.mgie.lib.MGIECanvas;
import com.mgie.tools.StringFunction;
import com.mgie.ui.UIHelper;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

public class GameDisplay
extends MGIECanvas
implements GameConfig,
DisplayString,
DisplayConfig,
MJConfig {
    public GameResource res;
    long timer = 0L;
    int dlb = 0;
    public static final int[] mainGameImgList = new int[]{11, 40, 41, 42, 43, 46, 0, 71, 55, 13, 65, 6, 3, 4, 5, 66, 10, 44, 45, 7, 57, 58, 59, 56, 37, 68, 69, 47, 2, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 8, 9, 54, 53};
    public boolean tryAndBuy = true;
    private int renderTick = 0;
    public static final int MENU_MAX_SHOW_ROW = 3;
    public static final int MENU_PADY = 3;
    public static final int SEL_BIG_HEAD_X = 0;
    public static final int SEL_BIG_HEAD_Y = 135;
    public static final int SEL_PLAYER_NAME_Y = 110;
    public static final int SEL_PLAYER_NAME_W = 50;
    public static final int SEL_PLAYER_HEAD_W = 50;
    public static final int SEL_PLAYER_HEAD_H = 54;
    public static final int SEL_PLAYER_PANE_Y = 130;
    public static final int SEL_PLAYER_PANE_H = 110;
    public static final int SEL_DIALOG_PANE_X = 80;
    public static final int SEL_DIALOG_PANE_Y = 40;
    public static final int COLOR_GREEN = 1275434;
    public static final int TITLE_EACH_WIDTH = 120;
    public static final int TITLE_EACH_HEIGHT = 34;
    public static final int[] markupDetailPos = new int[]{1, 1, 20, 0xFCFFCC, 0xFCFFCC, 217, 1, 24, 0xFCFFCC, 0xFCFFCC};

    public GameDisplay(MIDlet mIDlet) {
        super(mIDlet);
    }

    public void drawMGMenuButton(Graphics graphics, int n, Object object, int n2, int n3, int n4, boolean bl) {
    }

    public void drawLoadingBar(Graphics graphics) {
        graphics.setFont(GameResource.font);
        String string = this.res.iGameText[97];
        String string2 = this.res.iGameText[125].substring(0, 1);
        int n = GameDisplay.getStringWidth(string2, GameResource.font) * 4 + GameDisplay.getStringWidth(string, GameResource.font) + 4;
        int n2 = (239 - n >> 1) + 2;
        int n3 = 119;
        this.timer = System.currentTimeMillis();
        ++this.dlb;
        this.dlb %= 4;
        for (int i = 0; i < this.dlb; ++i) {
            string = string + string2;
        }
        GameDisplay.drawRoundString(graphics, string, n2, n3, 20, 0xFFFFFF, 1275434);
    }

    public void initState(int n) {
        this.res.gameStateOld = this.res.gameState;
        this.res.isReady = false;
        this.res.frameCount = 0;
        this.res.frameCountDown = 0;
        this.res.isDraw = false;
        try {
            if (this.res.gameState == 7) {
                this.res.mgsound.stop();
            }
            MGIECanvas.unloadAllImage();
            switch (n) {
                case 16: {
                    this.initSeletePlayer();
                    break;
                }
                case 1: {
                    this.initGamePlay();
                    break;
                }
                case 2: {
                    this.initGameResult();
                    break;
                }
                case 5: {
                    this.initLogo();
                    break;
                }
                case 7: {
                    this.res.roomID = "-1";
                    this.res.mjGame = null;
                    this.initMainMenu();
                    break;
                }
                case 10: {
                    this.initIntroduction();
                    break;
                }
                case 11: {
                    this.initSetting();
                    break;
                }
                case 12: {
                    this.initCredit();
                    break;
                }
                case 13: {
                    this.initExitAlert();
                    break;
                }
                case 15: {
                    this.initBalance();
                    break;
                }
                case 17: {
                    this.initGameResultDraw();
                    break;
                }
                case 18: {
                    this.initGamePause();
                    break;
                }
                case 19: {
                    this.initGameExitThanks();
                    break;
                }
                case 20: {
                    this.initDetailRecord();
                    break;
                }
                case 21: {
                    this.initCloseSound();
                    break;
                }
                case 31: {
                    this.initPressAnyKey();
                    break;
                }
                case 33: {
                    this.initPlayAgain();
                }
            }
            this.res.backState = this.res.backErrorState;
            if (this.res.backErrorState == -1) {
                this.res.backState = this.res.gameState;
            }
            this.res.gameState = n;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        super.handleKey();
        this.res.isReady = true;
    }

    public void initPlayAgain() throws Exception {
        int[] nArray = new int[]{1, 36, 35};
        GameDisplay.loadImage(nArray);
        this.res.currentIndex = 0;
        if (this.res.pageSize < 1) {
            this.res.pageSize = 1;
        }
    }

    public void initBalance() throws Exception {
        int[] nArray = new int[]{1, 36, 67, 70, 69};
        GameDisplay.loadImage(nArray);
        this.res.menuIndex = 0;
    }

    public void initCredit() throws Exception {
        int[] nArray = new int[]{1, 67, 34};
        GameDisplay.loadImage(nArray);
        this.res.displayTexts = StringFunction.stringToDisplayArray(GameResource.font, this.res.iGameText[69], 217);
        this.res.currentIndex = 0;
        this.res.pageSize = this.res.displayTexts.length - 8 + 1;
        if (this.res.pageSize < 1) {
            this.res.pageSize = 1;
        }
    }

    public void initExitAlert() throws Exception {
        int[] nArray = new int[]{1, 36, 35};
        GameDisplay.loadImage(nArray);
        this.res.displayTexts = StringFunction.stringToDisplayArray(GameResource.font, this.res.iGameText[20], 217);
        this.res.currentIndex = 0;
        this.res.pageSize = this.res.displayTexts.length - 8 + 1;
        if (this.res.pageSize < 1) {
            this.res.pageSize = 1;
        }
    }

    public void initExitGamePlayAlert() throws Exception {
        int[] nArray = new int[]{1, 36, 35};
        GameDisplay.loadImage(nArray);
        this.res.displayTexts = StringFunction.stringToDisplayArray(GameResource.font, this.res.iGameText[20], 217);
        this.res.currentIndex = 0;
        this.res.pageSize = this.res.displayTexts.length - 8 + 1;
        if (this.res.pageSize < 1) {
            this.res.pageSize = 1;
        }
    }

    public void initGameExitThanks() throws Exception {
        int[] nArray = new int[]{1, 35};
        GameDisplay.loadImage(nArray);
        this.res.currentIndex = 0;
        this.res.pageSize = this.res.displayTexts.length - 8 + 1;
        if (this.res.pageSize < 1) {
            this.res.pageSize = 1;
        }
        this.res.frameCountDown = 10;
    }

    public void initDetailRecord() throws Exception {
        int[] nArray = new int[]{1, 34, 67};
        GameDisplay.loadImage(nArray);
        this.res.currentIndex = 0;
        this.res.frameCountDown = 10;
        int n = 10;
        GameResource.detailRecordList = new String[(32 + n) * 2];
        String[] stringArray = GameResource.detailRecordList;
        int[] nArray2 = this.res.playerRecord.totalData;
        int n2 = nArray2[5];
        if (n2 <= 0) {
            n2 = 1;
        }
        nArray2[13] = nArray2[6] * 100 / n2;
        nArray2[14] = nArray2[8] * 100 / n2;
        nArray2[15] = nArray2[11] * 100 / n2;
        nArray2[16] = nArray2[12] * 100 / n2;
        int n3 = 0;
        stringArray[n3++] = this.res.iGameText[123];
        stringArray[n3++] = Integer.toString(nArray2[10]);
        stringArray[n3++] = this.res.iGameText[111];
        stringArray[n3++] = Integer.toString(nArray2[11]);
        stringArray[n3++] = this.res.iGameText[71];
        stringArray[n3++] = Integer.toString(nArray2[5]);
        stringArray[n3++] = this.res.iGameText[72];
        stringArray[n3++] = Integer.toString(nArray2[6]);
        stringArray[n3++] = this.res.iGameText[73];
        stringArray[n3++] = Integer.toString(nArray2[7]);
        stringArray[n3++] = this.res.iGameText[74];
        stringArray[n3++] = Integer.toString(nArray2[8]);
        stringArray[n3++] = this.res.iGameText[75];
        stringArray[n3++] = Integer.toString(nArray2[9]);
        stringArray[n3++] = this.res.iGameText[115];
        stringArray[n3++] = Integer.toString(nArray2[13]) + this.res.iGameText[141];
        stringArray[n3++] = this.res.iGameText[116];
        stringArray[n3++] = Integer.toString(nArray2[14]) + this.res.iGameText[141];
        stringArray[n3++] = this.res.iGameText[117];
        stringArray[n3++] = Integer.toString(nArray2[15]) + this.res.iGameText[141];
        for (int i = 0; i < 32; ++i) {
            stringArray[n3++] = MJGame.WO_INFO_NAME[i];
            stringArray[n3++] = Integer.toString(nArray2[17 + i]);
        }
        this.res.pageSize = GameResource.detailRecordList.length - 8 + 1;
        if (this.res.pageSize < 1) {
            this.res.pageSize = 1;
        }
        this.res.frameCountDown = 10;
    }

    public void initCloseSound() throws Exception {
        int[] nArray = new int[]{1, 36, 35};
        GameDisplay.loadImage(nArray);
        this.res.currentIndex = 0;
        this.res.displayTexts = StringFunction.stringToDisplayArray(GameResource.font, this.res.iGameText[76], 217);
        this.res.pageSize = this.res.displayTexts.length - 8 + 1;
        if (this.res.pageSize < 1) {
            this.res.pageSize = 1;
        }
        this.res.frameCountDown = 15;
    }

    public void initGamePlay() throws Exception {
        int[] nArray = mainGameImgList;
        GameDisplay.loadImage(nArray);
        if (this.res.isNewGame) {
            if (this.res.mjGame != null) {
                this.res.mjGame.initGame(0, 0);
            } else {
                this.res.mjGame = new MJGame();
            }
            this.res.mjGame.initGame(0, 0);
            GameResource.genGameSeed();
            GameMidlet.resetPlayerCount();
            this.res.checkTryAndBuy();
            for (int i = 0; i < 4; ++i) {
                this.res.playersScore[i] = 1000;
                this.res.lastOffsetScore[i] = 0;
            }
            this.res.isNewGame = false;
        } else {
            this.res.mjGame.gameState = 0;
            GameResource.genGameSeed();
            this.res.playerHoldTime = 0;
            this.res.mjGame.winPlayer = -1;
            this.res.mjGame.event = -1;
            GameMidlet.resetPlayerCount();
            this.res.checkTryAndBuy();
        }
    }

    public void initGameResult() throws Exception {
        int n;
        this.res.playerRecord.totalData[5] = this.res.playerRecord.totalData[5] + 1;
        int[] nArray = new int[]{1, 66, 40, 36, 68, 69, 48, 70, 67};
        GameDisplay.loadImage(nArray);
        if (this.res.mjGame.gameResult == 1 || this.res.mjGame.gameResult == 2) {
            int n2;
            this.res.winPattern = this.res.mjGame.winScore(this.res.mjGame.winPlayer);
            this.res.winScore = 0;
            for (n = 0; n < this.res.winPattern.length; ++n) {
                this.res.winScore += MJGame.WO_INFO_SCORE[this.res.winPattern[n]];
            }
            if (this.res.winScore > MJGame.SCORE_MONEY.length - 1) {
                this.res.winScore = MJGame.SCORE_MONEY.length - 1;
            }
            if (this.res.mjGame.winPlayer == this.res.currentPlayerPos) {
                this.res.mgsound.play(2, 1, this.res.soundVol * 100 / 5);
                if (this.res.winScore == MJGame.SCORE_MONEY.length - 1) {
                    this.res.playerRecord.totalData[9] = this.res.playerRecord.totalData[9] + 1;
                }
                for (n = 0; n < this.res.winPattern.length; ++n) {
                    int n3 = n2 = 17 + this.res.winPattern[n];
                    this.res.playerRecord.totalData[n3] = this.res.playerRecord.totalData[n3] + 1;
                }
                this.res.playerRecord.totalData[6] = this.res.playerRecord.totalData[6] + 1;
                this.res.playerRecord.totalData[10] = this.res.playerRecord.totalData[10] + this.res.winScore;
                if (this.res.mjGame.loser < 0) {
                    this.res.playerRecord.totalData[11] = this.res.playerRecord.totalData[11] + 1;
                }
            } else {
                this.res.mgsound.play(2, 1, this.res.soundVol * 100 / 5);
                if (this.res.mjGame.loser == this.res.currentPlayerPos) {
                    this.res.playerRecord.totalData[8] = this.res.playerRecord.totalData[8] + 1;
                }
            }
            this.res.saveStat();
            if (this.res.mjGame.gameResult == 1) {
                for (n = 0; n < 4; ++n) {
                    this.res.lastOffsetScore[n] = 0;
                }
                this.res.lastOffsetScore[this.res.mjGame.loser] = -2 * MJGame.SCORE_MONEY[this.res.winScore];
                this.res.lastOffsetScore[this.res.mjGame.winPlayer] = 2 * MJGame.SCORE_MONEY[this.res.winScore];
            } else if (this.res.mjGame.gameResult == 2) {
                for (n = 0; n < 4; ++n) {
                    this.res.lastOffsetScore[n] = -1 * MJGame.SCORE_MONEY[this.res.winScore];
                }
                this.res.lastOffsetScore[this.res.mjGame.winPlayer] = MJGame.SCORE_MONEY[this.res.winScore] * 3;
            } else if (this.res.mjGame.gameResult == 3) {
                for (n = 0; n < 4; ++n) {
                    this.res.lastOffsetScore[n] = 0;
                }
            }
            for (n = 0; n < 4; ++n) {
                n2 = this.res.lastOffsetScore[n];
                int n4 = this.res.playersScore[n];
                this.res.playersScore[n] = n4 + n2;
            }
            this.res.maxPlayerScore = this.res.playersScore[0];
            this.res.minPlayerScore = this.res.playersScore[0];
            for (n = 1; n < 4; ++n) {
                if (this.res.playersScore[n] > this.res.maxPlayerScore) {
                    this.res.maxPlayerScore = this.res.playersScore[n];
                    continue;
                }
                if (this.res.playersScore[n] >= this.res.minPlayerScore) continue;
                this.res.minPlayerScore = this.res.playersScore[n];
            }
        } else {
            this.res.winPattern = null;
            for (n = 0; n < 4; ++n) {
                this.res.lastOffsetScore[n] = 0;
            }
        }
        GameResource.genGameSeed();
        this.res.currentIndex = 0;
        for (n = 0; n < this.res.playerRecord.totalData.length; ++n) {
            if (this.res.playerRecord.totalData[n] <= 999999999) continue;
            this.res.playerRecord.totalData[n] = 999999999;
        }
    }

    public void initGameResultDraw() throws Exception {
        this.res.mgsound.play(2, 1, this.res.soundVol * 100 / 5);
        for (int i = 0; i < 4; ++i) {
            this.res.lastOffsetScore[i] = 0;
        }
        this.res.playerRecord.totalData[7] = this.res.playerRecord.totalData[7] + 1;
        this.res.playerRecord.totalData[5] = this.res.playerRecord.totalData[5] + 1;
        this.res.saveStat();
        int[] nArray = new int[]{1, 36, 70, 40, 66, 67};
        GameDisplay.loadImage(nArray);
    }

    public void initIntroduction() throws Exception {
        int[] nArray = new int[]{1, 34, 67};
        GameDisplay.loadImage(nArray);
        this.res.displayTexts = StringFunction.stringToDisplayArray(GameResource.font, this.res.iGameText[151], 217);
        this.res.currentIndex = 0;
        this.res.pageSize = this.res.displayTexts.length - 8 + 1;
        if (this.res.pageSize < 1) {
            this.res.pageSize = 1;
        }
    }

    public void initLogo() throws Exception {
        int[] nArray = new int[]{39};
        GameDisplay.loadImage(nArray);
    }

    public void initPressAnyKey() throws Exception {
        int[] nArray = new int[]{12, 37, 56};
        GameDisplay.loadImage(nArray);
    }

    public void initMainMenu() throws Exception {
        this.res.mgsound.play(1, 1, this.res.soundVol * 100 / 5);
        int[] nArray = new int[]{12, 37, 58, 56, 36, 35, 38};
        GameDisplay.loadImage(nArray);
        this.res.menuIndex = 0;
        this.initMenuString();
    }

    public void initMenuString() {
        if (!GameMidlet.productIsActivated()) {
            this.res.menuStringIdx = new int[]{0, 2, 1, 3, 4, 168, 169, 6};
        } else {
            this.tryAndBuy = false;
            this.res.menuStringIdx = new int[]{0, 2, 1, 3, 4, 169, 6};
        }
        this.res.menuString = new String[this.res.menuStringIdx.length];
        for (int i = 0; i < this.res.menuStringIdx.length; ++i) {
            this.res.menuString[i] = this.res.iGameText[this.res.menuStringIdx[i]];
        }
    }

    public void initSetting() throws Exception {
        this.res.currentIndex = 0;
        int[] nArray = new int[]{1, 67, 34};
        GameDisplay.loadImage(nArray);
        this.res.currentIndex = 0;
    }

    public void drawTitleMessage(Graphics graphics, String string) {
        GameDisplay.fillRect(graphics, 0, 0, 240, 23, 0);
        GameDisplay.drawString(graphics, string, 120, 1, 17, 0xFCFFCC);
    }

    public void drawCanvas(Graphics graphics) {
        try {
            this.res.isDraw = true;
            this.drawCanvasCore(graphics);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.res.isDraw = false;
    }

    public void drawCanvasCore(Graphics graphics) {
        ++this.renderTick;
        graphics.setFont(GameResource.font);
        if (this.res.isReady) {
            switch (this.res.gameState) {
                case 16: {
                    this.drawSeletePlayer(graphics);
                    break;
                }
                case 1: {
                    this.drawMJGame(graphics);
                    break;
                }
                case 2: {
                    this.drawMJGameResult(graphics);
                    break;
                }
                case 5: {
                    this.drawLogo(graphics);
                    break;
                }
                case 7: {
                    this.drawMainMenu(graphics);
                    break;
                }
                case 10: {
                    this.drawIntroduction(graphics);
                    break;
                }
                case 11: {
                    this.drawSetting(graphics);
                    break;
                }
                case 12: {
                    this.drawCredit(graphics);
                    break;
                }
                case 13: {
                    this.drawExitAlert(graphics);
                    break;
                }
                case 14: {
                    this.drawExitAlert(graphics);
                    break;
                }
                case 15: {
                    this.drawBalance(graphics);
                    break;
                }
                case 17: {
                    this.drawGameResultDraw(graphics);
                    break;
                }
                case 18: {
                    this.drawGamePause(graphics);
                    break;
                }
                case 19: {
                    this.drawGameExitThanks(graphics);
                    break;
                }
                case 20: {
                    this.drawDetailRecord(graphics);
                    break;
                }
                case 21: {
                    this.drawCloseSound(graphics);
                    break;
                }
                case 31: {
                    this.drawPressAnyKey(graphics);
                    break;
                }
                case 33: {
                    this.drawPlayAgain(graphics);
                }
            }
            GameDisplay.resetClip(graphics);
        } else {
            this.drawLoadingBar(graphics);
        }
    }

    void drawPlayAgain(Graphics graphics) {
        GameDisplay.drawImage(graphics, images[1], 0, 0, 20);
        GameDisplay.drawString(graphics, this.res.iGameText[167], 120, 120, 17, 0xFCFFCC);
        GameDisplay.drawImage(graphics, images[36], 0, 260, 36);
        GameDisplay.drawImage(graphics, images[35], 240, 260, 40);
    }

    public int getWindPos(int n) {
        return (n + 4 - this.res.mjGame.gameStarter) % 4;
    }

    public void drawBoxString(Graphics graphics, int n, int n2, String string, int n3, int n4) {
        int n5 = Math.max(n4, GameDisplay.getStringWidth(string, graphics.getFont()));
        int n6 = 21;
        GameDisplay.fillRect(graphics, n - n5 / 2 - 2, n2 - 2, n5 + 4, n6 + 4, 0xFFFFFF);
        GameDisplay.fillRect(graphics, n - n5 / 2 - 1, n2 - 1, n5 + 2, n6 + 2, 0);
        GameDisplay.drawString(graphics, string, n, n2, 17, n3);
    }

    void drawIntroduction(Graphics graphics) {
        this.drawAlertPage(graphics, 0);
        this.drawButton(graphics, 1);
    }

    void drawLogo(Graphics graphics) {
        GameDisplay.fillRect(graphics, 0, 0, 240, 260, 0xFFFFFF);
        GameDisplay.drawImage(graphics, images[39], 120, 130, 3);
    }

    void drawPressAnyKey(Graphics graphics) {
        GameDisplay.drawImage(graphics, images[12], 0, 0, 20);
        if (this.res.frameCount / 2 % 3 != 1) {
            GameDisplay.drawRoundString(graphics, this.res.iGameText[155], 120, 209, 17, 0xFFFFFF, 1275434);
        }
    }

    void drawMainMenu(Graphics graphics) {
        this.drawMenu(graphics, this.res.menuString);
    }

    void drawMenu(Graphics graphics, String[] stringArray) {
        GameDisplay.drawImage(graphics, images[12], 0, 0, 20);
        this.drawMainMenuCore(graphics, stringArray, this.res.menuIndex);
        int n = 208 + (GameDisplay.getStringHeight(graphics.getFont()) - GameDisplay.getImageHeight(images[37])) / 2;
        GameDisplay.drawImage(graphics, images[58], 60, n - 5, 17);
        GameDisplay.drawImage(graphics, images[58], 177, n - 5, 17);
    }

    private void drawMainMenuCore(Graphics graphics, String[] stringArray, int n) {
        int n2 = 75;
        int n3 = 205;
        int n4 = 0;
        int n5 = 0;
        switch (this.res.menuStringIdx[this.res.menuIndex]) {
            case 0: {
                n5 = 0;
                break;
            }
            case 2: {
                n5 = 26;
                break;
            }
            case 1: {
                n5 = 52;
                break;
            }
            case 3: {
                n5 = 78;
                break;
            }
            case 4: {
                n5 = 104;
                break;
            }
            case 168: {
                n5 = 130;
                break;
            }
            case 169: {
                n5 = 156;
                break;
            }
            case 6: {
                n5 = 182;
            }
        }
        GameDisplay.drawClipImage(graphics, images[38], n2, n3, n4, n5, 90, 26);
        GameDisplay.resetClip(graphics);
    }

    public void initSeletePlayer() throws Exception {
        int[] nArray = new int[]{1, 60, 61, 62, 63, 92, 93, 94, 95, 36, 35, 30, 31, 32, 33, 88, 89, 90, 91, 64, 15, 19, 23, 27, 73, 77, 81, 85, 96};
        GameDisplay.loadImage(nArray);
        this.res.currentIndex = 0;
        this.res.menuIndex = 0;
        this.res.selectedPlayer = 1;
        this.res.players[0] = 0;
    }

    private void drawSeletePlayer(Graphics graphics) {
        GameDisplay.drawImage(graphics, images[1], 0, 0, 20);
        GameDisplay.drawImage(graphics, images[64], 120, 0, 17);
        GameDisplay.drawImage(graphics, images[GameResource.PLAYER_HEAD_IMAGE[this.res.menuIndex + this.res.currentIndex][0][1]], GameResource.PLAYER_HEAD_X[this.res.menuIndex + this.res.currentIndex][2][1], 130, 36);
        int n = 0;
        n = this.res.menuIndex + this.res.currentIndex > 3 ? 92 + (this.res.menuIndex + this.res.currentIndex) - 4 : 60 + this.res.menuIndex;
        GameDisplay.drawImage(graphics, images[n], 80, 40, 20);
        int n2 = this.res.menuIndex + this.res.currentIndex;
        int n3 = GameDisplay.getStringHeight(graphics.getFont());
        GameDisplay.fillRect(graphics, 30, 110, 50, n3 + 4, 1275434);
        String string = this.res.playerInfos[n2].stringMessage1;
        GameDisplay.drawString(graphics, string, 55, 112, 17, 0xFCFFCC);
        int n4 = 8;
        int n5 = 0;
        int n6 = 0;
        GameDisplay.fillRect(graphics, 10, 130, 220, 110, 1275434);
        for (int i = 0; i < n4; ++i) {
            int n7 = this.res.currentIndex + i;
            if (i < 4) {
                n5 = 130;
                n6 = i;
            } else {
                n6 = i - 4;
                n5 = 130 + GameDisplay.getImageHeight(images[96]);
            }
            int n8 = 10 + n6 * 55;
            this.drawFace(graphics, i, n8, n5, this.res.menuIndex + this.res.currentIndex == i);
        }
        this.drawButton(graphics, 0);
        this.drawButton(graphics, 2);
    }

    private void drawFace(Graphics graphics, int n, int n2, int n3, boolean bl) {
        int n4 = 0;
        if (n > 3) {
            n -= 4;
            n4 = 88;
        } else {
            n4 = 30;
        }
        if (bl) {
            GameDisplay.drawImage(graphics, images[96], n2 + 6, n3, 0);
        }
        int n5 = (55 - GameDisplay.getImageWidth(images[n + n4])) / 2;
        int n6 = (55 - GameDisplay.getImageHeight(images[n + n4])) / 2;
        GameDisplay.drawImage(graphics, images[n + n4], n2 + n5, n3 + n6, 0);
    }

    private void drawPlayerDialog(Graphics graphics) {
        for (int i = 1; i < this.res.playerInfos.length; ++i) {
            if (this.res.playerDialogString[i] == null) continue;
            this.drawDialogueSection(graphics, this.res.startXForPlayerDialogue[i], this.res.startYForPlayerDialogue[i], this.res.playerDialogString[i], 0xFCFFCC, 0, i == 1 ? 8 : 9);
        }
    }

    private void drawDialogueSection(Graphics graphics, int n, int n2, String string, int n3, int n4, int n5) {
        int n6 = Math.max(n4, GameDisplay.getStringWidth(string, graphics.getFont()));
        int n7 = 21;
        int n8 = n;
        if (n8 - n6 / 2 < 0) {
            n8 = n6 / 2;
        } else if (n8 + n6 / 2 > 240) {
            n8 = 240 - n6 / 2;
        }
        GameDisplay.fillRoundRect(graphics, n8 - n6 / 2 - 2, n2 - 2, n6 + 4, n7 + 4, 5, 5, this.res.THEME_DIALOGUE_SECTION_BORDER_COLOR);
        GameDisplay.fillRoundRect(graphics, n8 - n6 / 2 - 1, n2 - 1, n6 + 2, n7 + 2, 5, 5, this.res.THEME_DIALOGUE_SECTION_COLOR);
        if (n5 == 8) {
            GameDisplay.drawImage(graphics, images[8], n - n6 / 2 - 2 + n6 + 2, n2 - 2 + (n7 + 4) / 2, 20);
        } else if (n5 == 9) {
            GameDisplay.drawImage(graphics, images[9], n - n6 / 2 - 2 + (n6 + 4) / 2, n2 - 2 + n7 + 2, 20);
        }
        GameDisplay.drawString(graphics, string, n8, n2, 17, n3);
    }

    private void drawPlayer(Graphics graphics) {
        if (this.res.mjGame.event != -1) {
            int n = (4 - this.res.currentPlayerPos + this.res.mjGame.eventPlayer) % 4;
            for (int i = 1; i < 4; ++i) {
                if (i == n) {
                    GameDisplay.drawImage(graphics, images[GameResource.PLAYER_HEAD_IMAGE[this.res.players[i]][0][1]], GameResource.PLAYER_HEAD_X[this.res.players[i]][i - 1][1], GameResource.PLAYER_HEAD_Y[this.res.players[i]][i - 1][1], 20);
                    continue;
                }
                GameDisplay.drawImage(graphics, images[GameResource.PLAYER_HEAD_IMAGE[this.res.players[i]][i - 1][0]], GameResource.PLAYER_HEAD_X[this.res.players[i]][i - 1][0], GameResource.PLAYER_HEAD_Y[this.res.players[i]][i - 1][0], 20);
            }
        } else {
            for (int i = 1; i < 4; ++i) {
                GameDisplay.drawImage(graphics, images[GameResource.PLAYER_HEAD_IMAGE[this.res.players[i]][i - 1][0]], GameResource.PLAYER_HEAD_X[this.res.players[i]][i - 1][0], GameResource.PLAYER_HEAD_Y[this.res.players[i]][i - 1][0], 20);
            }
        }
    }

    public void drawMJGame(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        this.drawMJGameBG(graphics);
        int n9 = this.res.mjGame.getCardToken;
        int n10 = 0;
        if (this.res.mjGame.throwCardLength > 44) {
            n10 = this.res.mjGame.throwCardLength - 44;
        }
        int n11 = 0;
        int n12 = 0;
        int n13 = 72;
        int n14 = 0;
        while (n10 < this.res.mjGame.throwCardLength) {
            if (n14 < 8) {
                n11 = 0;
                n12 = n14 % 8;
            } else if (n14 < 18) {
                n11 = 1;
                n12 = (n14 - 8) % 10;
                n13 = 60;
            } else if (n14 < 30) {
                n11 = 2;
                n12 = (n14 - 8 - 10) % 12;
                n13 = 48;
            } else if (n14 < 44) {
                n11 = 3;
                n12 = (n14 - 8 - 10 - 12) % 14;
                n13 = 36;
            }
            this.drawThrowCardCenter(graphics, n13 + n12 * 12, 156 + n11 * 16, this.res.mjGame.throwedCard[n10]);
            ++n14;
            ++n10;
        }
        if (this.res.mjGame.event == -1) {
            this.drawPlayer(graphics);
        }
        this.drawMJGamePlayer3(graphics, this.res.mjGame.mjPlayers[(this.res.currentPlayerPos + 2) % 4]);
        this.drawMJGamePlayer2(graphics, this.res.mjGame.mjPlayers[(this.res.currentPlayerPos + 1) % 4]);
        this.drawMJGamePlayer4(graphics, this.res.mjGame.mjPlayers[(this.res.currentPlayerPos + 3) % 4]);
        this.drawMJGamePlayer1(graphics, this.res.mjGame.mjPlayers[(this.res.currentPlayerPos + 0) % 4]);
        if (this.res.mjGame.event != -1) {
            this.drawPlayer(graphics);
        }
        if (this.res.mjGame.event != -1) {
            GameDisplay.resetClip(graphics);
            n14 = 0;
            int n15 = -1;
            if (this.res.frameCount % 2 == 1) {
                n14 = 37;
            }
            switch (this.res.mjGame.event) {
                case 0: {
                    n15 = 65;
                    break;
                }
                case 1: {
                    n15 = 55;
                    break;
                }
                case 2: {
                    n15 = 13;
                    break;
                }
                case 3: {
                    n15 = 71;
                }
            }
            if (n15 != -1) {
                n8 = (4 - this.res.currentPlayerPos + this.res.mjGame.eventPlayer) % 4;
                n7 = 21;
                int n16 = 93;
                n6 = 78;
                n5 = 0;
                n4 = 0;
                n3 = 0;
                n2 = 0;
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = true;
                int n17 = 90;
                int n18 = 130;
                int n19 = GameDisplay.getImageWidth(images[57]);
                int n20 = GameDisplay.getImageHeight(images[57]);
                int n21 = GameDisplay.getImageWidth(images[58]);
                int n22 = GameDisplay.getImageHeight(images[58]);
                int n23 = GameDisplay.getImageWidth(images[n15]);
                int n24 = GameDisplay.getImageHeight(images[n15]) / 2;
                int n25 = 0;
                int n26 = 0;
                int n27 = 25;
                switch (n8) {
                    case 0: {
                        n16 = 240 - n17 >> 1;
                        n6 = 260 - n20;
                        bl3 = true;
                        n5 = n16 + n17 - n19 / 3;
                        n4 = n6 - n20 / 5;
                        n3 = n5 + 5;
                        n2 = n4 + n20 - n22;
                        break;
                    }
                    case 2: {
                        n16 = 240 - n17 >> 1;
                        n6 = 0;
                        bl3 = false;
                        n5 = n16 - n19 * 2 / 4;
                        n4 = n6 + n20 * 1 / 5;
                        n3 = n5 + n19 - n21 - 5;
                        n2 = n4 + n20 - n22;
                        break;
                    }
                    case 1: {
                        n16 = 240 - n17;
                        n6 = 260 - n18 >> 1;
                        bl3 = false;
                        n5 = n16 - n19 * 2 / 3;
                        n4 = n6 - n20 / 5;
                        n3 = n5 + n19 - n21 - 5;
                        n2 = n4 + n20 - n22;
                        break;
                    }
                    case 3: {
                        n16 = 20;
                        n16 = 0;
                        n6 = 260 - n18 >> 1;
                        bl3 = true;
                        n5 = n16 + n17 - n19 / 3;
                        n4 = n6 - n20 / 5;
                        n3 = n5 + 5;
                        n2 = n4 + n20 - n22;
                    }
                }
                GameDisplay.drawImage(graphics, images[57], n5, n4, 20);
                GameDisplay.drawImage(graphics, images[bl3 ? 58 : 59], n3, n2 + 10, 20);
                n26 = n5 + (n19 - n23) / 2;
                n25 = n4 + (n20 - n24) / 2;
                if (n14 != 0) {
                    n14 = n24;
                }
                GameDisplay.drawClipImage(graphics, images[n15], n26, n25, 0, n14, 45, n24);
                GameDisplay.resetClip(graphics);
            }
        } else if (this.res.mjGame.reply == -2 && this.res.mjGame.processingThinkingOrder != null && this.res.mjGame.processingThinkingOrder.size() > this.res.mjGame.replyThinkingIndex && this.res.mjGame.replyThinkingIndex >= 0) {
            Vector[] vectorArray = new Vector[4];
            for (int i = 0; i < 4; ++i) {
                vectorArray[i] = new Vector();
            }
            ThinkingOrder thinkingOrder = (ThinkingOrder)this.res.mjGame.processingThinkingOrder.elementAt(this.res.mjGame.replyThinkingIndex);
            n8 = -1;
            switch (thinkingOrder.iActionIndex) {
                case 0: 
                case 1: 
                case 2: {
                    n8 = 1;
                    break;
                }
                case 3: {
                    n8 = 0;
                    break;
                }
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    n8 = 2;
                    break;
                }
                case 5: 
                case 16: 
                case 20: {
                    n8 = 3;
                }
            }
            block42: for (n7 = 0; n7 < this.res.mjGame.processingThinkingOrder.size(); ++n7) {
                short s = ((ThinkingOrder)this.res.mjGame.processingThinkingOrder.elementAt((int)n7)).iActionIndex;
                switch (s) {
                    case 0: 
                    case 1: 
                    case 2: {
                        vectorArray[1].addElement(new Integer(n7));
                        continue block42;
                    }
                    case 3: {
                        vectorArray[0].addElement(new Integer(n7));
                        continue block42;
                    }
                    case 4: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        vectorArray[2].addElement(new Integer(n7));
                        continue block42;
                    }
                    case 5: 
                    case 16: 
                    case 20: {
                        vectorArray[3].addElement(new Integer(n7));
                    }
                }
            }
            n7 = 0;
            int[] nArray = new int[3];
            n9 = thinkingOrder.iIndexPlayer;
            if (thinkingOrder.iIndexPlayer == this.res.currentPlayerPos) {
                n6 = -1;
                switch (thinkingOrder.iActionIndex) {
                    case 0: {
                        n7 = 0;
                        n6 = 2;
                        nArray[0] = thinkingOrder.iRefCard - 8;
                        nArray[1] = nArray[0] + 4;
                        nArray[2] = nArray[0] + 8;
                        break;
                    }
                    case 1: {
                        n7 = 0;
                        n6 = 1;
                        nArray[0] = thinkingOrder.iRefCard - 4;
                        nArray[1] = nArray[0] + 4;
                        nArray[2] = nArray[0] + 8;
                        break;
                    }
                    case 2: {
                        n7 = 0;
                        n6 = 0;
                        nArray[0] = thinkingOrder.iRefCard;
                        nArray[1] = nArray[0] + 4;
                        nArray[2] = nArray[0] + 8;
                        break;
                    }
                    case 3: {
                        n7 = 40;
                        n6 = 0;
                        nArray[0] = thinkingOrder.iRefCard;
                        nArray[1] = nArray[0];
                        nArray[2] = nArray[0];
                        break;
                    }
                    case 4: {
                        n6 = 0;
                        n7 = 80;
                        nArray = new int[]{thinkingOrder.iRefCard, nArray[0], nArray[0], nArray[0]};
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        n6 = 0;
                        n7 = 80;
                        nArray = new int[]{thinkingOrder.iRefCard - 144, nArray[0], nArray[0], nArray[0]};
                        break;
                    }
                    case 5: 
                    case 16: {
                        n6 = 1;
                        nArray[0] = -1;
                        nArray[1] = thinkingOrder.iRefCard;
                        nArray[2] = -1;
                        n7 = 120;
                        break;
                    }
                    case 20: {
                        nArray = new int[]{};
                        n7 = 120;
                        break;
                    }
                    case 21: {
                        n7 = this.res.mjGame.isCancelGetCardAction ? -1 : 160;
                    }
                }
                GameDisplay.resetClip(graphics);
                this.drawPlayerDialog(graphics);
                if (n7 >= 0) {
                    GameDisplay.drawImage(graphics, images[2], 23, 30, 20);
                    GameDisplay.drawRect(graphics, 80, 91, 84, 30, 1, 1, 0);
                    GameDisplay.fillRect(graphics, 81, 92, 82, 28, 0x444444);
                    n5 = 130;
                    for (n4 = 0; n4 < 4; ++n4) {
                        n3 = 55;
                        if (n4 == 0) {
                            n3 = 4;
                        } else if (n4 == 1) {
                            n3 = 5;
                        } else if (n4 == 2) {
                            n3 = 3;
                        } else if (n4 == 3) {
                            n3 = 6;
                        }
                        GameDisplay.drawImage(graphics, images[n3], 95, n5, 0);
                        if (vectorArray[n4].size() > 0) {
                            if (n4 == n8) {
                                GameDisplay.drawRoundString(graphics, this.res.iGameText[31], 80, n5 + 1, 0, 0xFFFFFF, 1275434);
                                GameDisplay.drawRoundString(graphics, this.res.iGameText[32], 153, n5 + 1, 0, 0xFFFFFF, 1275434);
                            }
                        } else {
                            GameDisplay.drawImage(graphics, images[0], 95, n5, 0);
                        }
                        n5 += 23;
                    }
                    n4 = 80 + (84 - nArray.length * 16 >> 1);
                    for (n3 = 0; n3 < nArray.length; ++n3) {
                        if (nArray[n3] >= 0) {
                            this.drawP1HoldCard(graphics, n4, 93, nArray[n3]);
                            if (n3 == n6) {
                                GameDisplay.drawRect(graphics, n4, 93, 16, 26, 1, 1, 0xFF0000);
                            }
                        }
                        n4 += 16;
                    }
                    for (n3 = 0; n3 < 4; ++n3) {
                        vectorArray[n3].removeAllElements();
                    }
                }
            }
        }
        if ((n = (n9 - this.res.currentPlayerPos + 4) % 4) != 0) {
            n8 = 53;
            n7 = 120;
            int n28 = 248;
            n6 = 0;
            n5 = 0;
            n4 = this.res.frameCount % 6 / 3;
            switch (n) {
                case 1: {
                    n8 = 56;
                    n7 = 228;
                    n28 = 190;
                    if (n4 != 0) break;
                    n6 = 4;
                    break;
                }
                case 2: {
                    n8 = 54;
                    n7 = 120;
                    n28 = 12;
                    if (n4 != 0) break;
                    n5 = -4;
                    break;
                }
                case 3: {
                    n8 = 37;
                    n7 = 12;
                    n28 = 190;
                    if (n4 != 0) break;
                    n6 = -4;
                }
            }
            n3 = GameDisplay.getImageWidth(images[n8]);
            n2 = GameDisplay.getImageHeight(images[n8]);
            n7 = n7 + n6 - (n3 >> 1);
            n28 = n28 + n5 - (n2 >> 1);
            GameDisplay.drawImage(graphics, images[n8], n7, n28, 20);
        }
    }

    void drawMJGameBG(Graphics graphics) {
        GameDisplay.resetClip(graphics);
        GameDisplay.drawImage(graphics, images[11], 0, 0, 20);
        int n = GameDisplay.getImageWidth(images[69]);
        n /= 9;
        int n2 = 5;
        int n3 = GameDisplay.getImageHeight(images[47]);
        int n4 = 0;
        int n5 = 4;
        int n6 = n2 + 9;
        GameDisplay.drawImage(graphics, images[47], n2, n4, 20);
        GameDisplay.drawClipImage(graphics, images[69], n6, n4 + 5, 13 * this.res.mjGame.gameWind, 0, 13, 13);
        int n7 = GameDisplay.getImageHeight(images[69]);
        int n8 = n3 - n7 >> 1;
        GameDisplay.drawClipImage(graphics, images[69], n6 += n + n5, n4 + n8, (4 + this.res.mjGame.gameStarter) * n, 0, n, n7);
        GameDisplay.drawClipImage(graphics, images[69], n6 += n + 1, n4 + n8, 8 * n, 0, n, n7);
        GameDisplay.resetClip(graphics);
        int n9 = 10;
        int n10 = 17;
        GameDisplay.drawClipImage(graphics, images[66], n6 += n + n5 * 3, n4 + (n3 - n10) / 2, 96, 9, 10, 17);
        int n11 = GameDisplay.getImageHeight(images[46]);
        int n12 = (n3 - n11) / 2;
        GameDisplay.drawClipImage(graphics, images[46], n6 += n9 + 1, n4 + n12, 80, 0, 8, 11);
        this.drawTableDig(graphics, n6 += n5, n4 + n12, 144 - this.res.mjGame.nextCard);
        GameDisplay.resetClip(graphics);
    }

    void drawMJGamePlayer1(Graphics graphics, MJPlayer mJPlayer) {
        int n;
        int n2;
        int n3 = -1;
        int n4 = 0;
        int n5 = 7;
        int n6 = 233;
        for (n2 = 0; n2 < mJPlayer.cardPatternIndex.size(); ++n2) {
            n3 = (Integer)mJPlayer.cardPatternIndex.elementAt(n2);
            for (n = 0; n < 3; ++n) {
                this.drawThrowCard(graphics, n5, n6, mJPlayer.cardShow[n4]);
                ++n4;
                n5 += 16;
            }
            if (n3 != 2) continue;
            this.drawThrowCard(graphics, n5 - 32, n6 + -5, mJPlayer.cardShow[n4]);
            ++n4;
        }
        ++n5;
        if (this.res.mjGame.winPlayer != mJPlayer.position) {
            n2 = -1;
            if (mJPlayer.holdingLength % 3 == 2) {
                n2 = this.res.mjGame.replyCardIndex;
            }
            n = 0;
            for (n4 = 0; n4 < mJPlayer.holdingLength - 1; ++n4) {
                n = n2 == n4 ? -4 : 0;
                this.drawP1HoldCard(graphics, n5, n6 + n, mJPlayer.cardHolding[mJPlayer.cardDisplayHolding[n4]]);
                n5 += 16;
            }
            if (mJPlayer.holdingLength % 3 == 2) {
                ++n5;
            }
            n = n2 == n4 ? -4 : 0;
            this.drawP1HoldCard(graphics, n5, n6 + n, mJPlayer.cardHolding[mJPlayer.cardDisplayHolding[n4]]);
        } else {
            for (n4 = 0; n4 < mJPlayer.holdingLength; ++n4) {
                this.drawThrowCard(graphics, n5, n6, mJPlayer.cardHolding[n4]);
                n5 += 16;
            }
        }
    }

    void drawMJGamePlayer2(Graphics graphics, MJPlayer mJPlayer) {
        int n;
        int n2 = -1;
        int n3 = 0;
        int n4 = 133;
        int n5 = 188;
        int n6 = mJPlayer.holdingLength + mJPlayer.cardPatternIndex.size() * 3;
        if (n6 > 13) {
            if (this.res.mjGame.winPlayer != mJPlayer.position) {
                GameDisplay.drawClipImage(graphics, images[66], n5, n4, 64, 1, 12, 25);
                n3 = 2;
            } else {
                n3 = 1;
            }
        } else {
            n3 = 1;
        }
        n4 += 6;
        n5 += 3;
        if (this.res.mjGame.winPlayer != mJPlayer.position) {
            GameDisplay.drawClipImage(graphics, images[66], n5, n4, 64, 1, 12, 25);
            n4 += 6;
            n5 += 3;
            while (n3 < mJPlayer.holdingLength - 1) {
                GameDisplay.drawClipImage(graphics, images[66], n5, n4, 64, 1, 12, 25);
                n4 += 6;
                n5 += 3;
                ++n3;
            }
            if (mJPlayer.holdingLength % 3 == 2) {
                GameDisplay.drawClipImage(graphics, images[66], n5, n4, 64, 1, 12, 25);
            } else if (mJPlayer.holdingLength > 1) {
                GameDisplay.drawClipImage(graphics, images[66], n5, n4, 64, 1, 12, 25);
            }
            n4 = n4 + 12 + 3;
            n5 += 3;
            GameDisplay.resetClip(graphics);
        } else {
            for (n3 = 0; n3 < mJPlayer.holdingLength; ++n3) {
                this.drawThrowCard2(graphics, n5, n4, mJPlayer.cardHolding[n3], false);
                n4 += 7;
                n5 += 3;
            }
        }
        n3 = 0;
        int n7 = 0;
        for (n = 0; n < mJPlayer.cardPatternIndex.size(); ++n) {
            n2 = (Integer)mJPlayer.cardPatternIndex.elementAt(n);
            if (n2 == 2) {
                n7 += 4;
                continue;
            }
            n7 += 3;
        }
        n3 = n7 - 1;
        for (n = mJPlayer.cardPatternIndex.size() - 1; n >= 0; --n) {
            n2 = (Integer)mJPlayer.cardPatternIndex.elementAt(n);
            int n8 = 0;
            if (n3 == n7 - 1) {
                this.drawThrowCard2(graphics, n5, n4, mJPlayer.cardShow[n3], true);
                n4 += 7;
                n5 += 3;
                --n3;
                n8 = 1;
            }
            while (n8 < 3) {
                this.drawThrowCard2(graphics, n5, n4, mJPlayer.cardShow[n3], false);
                n4 += 7;
                n5 += 3;
                --n3;
                ++n8;
            }
            if (n2 != 2) continue;
            this.drawThrowCard2(graphics, n5 - 5, n4 - 22, mJPlayer.cardShow[n3], true);
            --n3;
        }
    }

    void drawMJGamePlayer3(Graphics graphics, MJPlayer mJPlayer) {
        int n = -1;
        int n2 = 0;
        int n3 = 179;
        int n4 = 126;
        for (int i = 0; i < mJPlayer.cardPatternIndex.size(); ++i) {
            n = (Integer)mJPlayer.cardPatternIndex.elementAt(i);
            for (int j = 0; j < 3; ++j) {
                this.drawThrowCard3(graphics, n3, n4, mJPlayer.cardShow[n2]);
                ++n2;
                n3 -= 10;
            }
            if (n != 2) continue;
            this.drawThrowCard3(graphics, n3 + 20, n4 + -4, mJPlayer.cardShow[n2]);
            ++n2;
        }
        n3 += -2;
        if (this.res.mjGame.winPlayer != mJPlayer.position) {
            for (n2 = 0; n2 < mJPlayer.holdingLength - 1; ++n2) {
                GameDisplay.drawClipImage(graphics, images[66], n3, n4, 96, 9, 10, 17);
                n3 -= 10;
            }
            if (mJPlayer.holdingLength % 3 == 2) {
                n3 += -2;
            }
            GameDisplay.drawClipImage(graphics, images[66], n3, n4, 96, 9, 10, 17);
            GameDisplay.resetClip(graphics);
        } else {
            for (n2 = 0; n2 < mJPlayer.holdingLength; ++n2) {
                this.drawThrowCard3(graphics, n3, n4, mJPlayer.cardHolding[n2]);
                n3 -= 10;
            }
        }
    }

    void drawMJGamePlayer4(Graphics graphics, MJPlayer mJPlayer) {
        int n = -1;
        int n2 = 0;
        int n3 = 133;
        int n4 = 40;
        for (int i = 0; i < mJPlayer.cardPatternIndex.size(); ++i) {
            n = (Integer)mJPlayer.cardPatternIndex.elementAt(i);
            int n5 = 0;
            for (n5 = 0; n5 < 3; ++n5) {
                if (i == mJPlayer.cardPatternIndex.size() - 1 && n5 == 2) {
                    this.drawThrowCard4(graphics, n4, n3, mJPlayer.cardShow[n2], true);
                    ++n2;
                } else {
                    this.drawThrowCard4(graphics, n4, n3, mJPlayer.cardShow[n2], false);
                    ++n2;
                }
                n3 += 7;
                n4 -= 3;
            }
            if (n != 2) continue;
            this.drawThrowCard4(graphics, n4 + 5, n3 + -22, mJPlayer.cardShow[n2], true);
            ++n2;
        }
        if (this.res.mjGame.winPlayer != mJPlayer.position) {
            for (n2 = 0; n2 < mJPlayer.holdingLength; ++n2) {
                GameDisplay.drawClipImage(graphics, images[66], n4, n3, 32, 1, 12, 25);
                n3 += 6;
                n4 -= 3;
            }
        } else {
            for (n2 = 0; n2 < mJPlayer.holdingLength; ++n2) {
                this.drawThrowCard4(graphics, n4, n3, mJPlayer.cardHolding[n2], true);
                n3 += 7;
                n4 -= 3;
            }
        }
    }

    void drawMJGameResult(Graphics graphics) {
        int n;
        int n2;
        int n3;
        GameDisplay.resetClip(graphics);
        GameDisplay.drawImage(graphics, images[1], 0, 0, 20);
        this.drawImageTitle(graphics, 1);
        int n4 = 1;
        int n5 = 52;
        GameDisplay.drawImage(graphics, images[70], 0, n5, 20);
        GameDisplay.drawImage(graphics, images[68], 0, n5 + 2, 20);
        GameDisplay.drawClipImage(graphics, images[69], 8, n5 + 9, 13 * this.res.mjGame.winPlayer, 0, 13, 13);
        GameDisplay.resetClip(graphics);
        int n6 = this.res.mjGame.winPlayer;
        int n7 = this.res.players[n6];
        int n8 = 6;
        graphics.setFont(F_SMALL);
        GameDisplay.drawString(graphics, GameResource.trimString(this.res.getPlayername(this.res.mjGame.winPlayer), GameResource.font, 120), n4 += GameDisplay.getImageWidth(images[68]) + 4, n5 + n8, 0, 0xFCFFCC);
        String string = this.res.iGameText[150] + this.res.lastOffsetScore[n6];
        GameDisplay.drawRoundString(graphics, string, n4 += GameDisplay.getStringWidth(GameResource.trimString(this.res.getPlayername(this.res.mjGame.winPlayer), GameResource.font, 120), F_SMALL) + 20, n5 + n8, 20, 0xFFFFFF, 255);
        String string2 = String.valueOf(this.res.playersScore[this.res.mjGame.winPlayer]);
        GameDisplay.drawRoundString(graphics, string2, n4 += GameDisplay.getStringWidth(string, F_SMALL) + 10, n5 + n8, 20, 0xFFFFFF, 1275434);
        n4 = 1;
        n5 += GameDisplay.getImageHeight(images[68]) + 4;
        MJPlayer mJPlayer = this.res.mjGame.mjPlayers[this.res.winPlayer];
        int n9 = 0;
        block4: for (n3 = 0; n3 < mJPlayer.cardPatternIndex.size(); ++n3) {
            n2 = (Integer)mJPlayer.cardPatternIndex.elementAt(n3);
            switch (n2) {
                case 0: 
                case 1: {
                    for (n = 0; n < 3; ++n) {
                        this.drawThrowCard(graphics, n4, n5, mJPlayer.cardShow[n9]);
                        n4 += 16;
                        ++n9;
                    }
                    continue block4;
                }
                case 2: {
                    for (n = 0; n < 3; ++n) {
                        this.drawThrowCard(graphics, n4, n5, mJPlayer.cardShow[n9]);
                        n4 += 16;
                        ++n9;
                    }
                    this.drawThrowCard(graphics, n4 + -31, n5 + -5, mJPlayer.cardShow[n9]);
                    ++n9;
                }
            }
        }
        while (n9 < mJPlayer.showLength) {
            this.drawThrowCard(graphics, n4, n5, mJPlayer.cardShow[n9]);
            n4 += 16;
            ++n9;
        }
        n4 = 6;
        n5 = 89;
        n3 = 60;
        n2 = 180;
        for (n = 0; n < this.res.winPattern.length; ++n) {
            int n10 = (n & 1) == 0 ? n3 : n2;
            int n11 = (n >> 1) * 22 + n5 + 30;
            GameDisplay.drawRoundString(graphics, MJGame.WO_INFO_NAME[this.res.winPattern[n]], n10, n11, 17, 0xFFFFFF, 1275434);
            if (n11 >= 159) break;
        }
        n4 = 0;
        n5 = 180;
        n = GameDisplay.getImageHeight(images[48]);
        GameDisplay.drawImage(graphics, images[48], 283, n5 + 1 - (n - F_SMALL.getHeight()) / 2, 24);
        String string3 = this.res.iGameText[35] + this.res.winScore;
        GameDisplay.drawString(graphics, string3, 238, n5 + 1, 24, 0xFCFFCC);
        this.drawButton(graphics, 0);
    }

    void drawP1HoldCard(Graphics graphics, int n, int n2, int n3) {
        int n4 = (n3 >>= 2) / 9;
        int n5 = n3 % 9;
        GameDisplay.drawClipImage(graphics, images[66], n, n2, 0, 0, 16, 26);
        GameDisplay.drawClipImage(graphics, images[40], n + 1, n2 + 7, n5 * 13, n4 * 17, 13, 17);
        GameDisplay.resetClip(graphics);
    }

    public int getSettingColor(int n, int n2) {
        if (n == n2) {
            return 1275434;
        }
        return 0xFCFFCC;
    }

    void drawSetting(Graphics graphics) {
        GameDisplay.drawImage(graphics, images[1], 0, 0, 20);
        int n = 110;
        int n2 = this.getSettingColor(this.res.currentIndex, 0);
        GameDisplay.drawRoundString(graphics, this.res.iGameText[30], n, 90, 24, 0xFCFFCC, n2);
        switch (this.res.soundVol) {
            case 5: {
                GameDisplay.fillRect(graphics, 181, 78, 12, 25, 13784064);
            }
            case 4: {
                GameDisplay.fillRect(graphics, 168, 81, 12, 22, 16150016);
            }
            case 3: {
                GameDisplay.fillRect(graphics, 155, 84, 12, 19, 16746762);
            }
            case 2: {
                GameDisplay.fillRect(graphics, 142, 87, 12, 16, 16754504);
            }
            case 1: {
                GameDisplay.fillRect(graphics, 129, 90, 12, 13, 16761472);
            }
        }
        GameDisplay.drawRect(graphics, 181, 78, 12, 25, 1, 1, 0xFCFFCC);
        GameDisplay.drawRect(graphics, 168, 81, 12, 22, 1, 1, 0xFCFFCC);
        GameDisplay.drawRect(graphics, 155, 84, 12, 19, 1, 1, 0xFCFFCC);
        GameDisplay.drawRect(graphics, 142, 87, 12, 16, 1, 1, 0xFCFFCC);
        GameDisplay.drawRect(graphics, 129, 90, 12, 13, 1, 1, 0xFCFFCC);
        this.drawImageTitle(graphics, 2);
        this.drawButton(graphics, 1);
    }

    void drawTableDig(Graphics graphics, int n, int n2, int n3) {
        int n4 = n3 / 100;
        int n5 = n3 % 100 / 10;
        int n6 = n3 % 10;
        if (n4 > 0) {
            GameDisplay.drawClipImage(graphics, images[46], n, n2, 8 * n4, 0, 8, 11);
        }
        n = n + 8 + 1;
        if (n4 > 0 || n5 > 0) {
            GameDisplay.drawClipImage(graphics, images[46], n, n2, 8 * n5, 0, 8, 11);
        }
        n = n + 8 + 1;
        GameDisplay.drawClipImage(graphics, images[46], n, n2, 8 * n6, 0, 8, 11);
        GameDisplay.resetClip(graphics);
    }

    void drawThrowCardCenter(Graphics graphics, int n, int n2, int n3) {
        boolean bl = false;
        if (n3 >= 200) {
            bl = true;
            n3 %= 200;
        }
        int n4 = (n3 >>= 2) / 9;
        int n5 = n3 % 9;
        GameDisplay.drawImage(graphics, images[45], n, n2, 20);
        GameDisplay.drawClipImage(graphics, images[44], n + 1, n2 + 2, 10 * n5, 13 * n4, 10, 13);
        GameDisplay.resetClip(graphics);
        if (bl) {
            GameDisplay.drawImage(graphics, images[7], n, n2, 20);
        }
    }

    void drawThrowCard(Graphics graphics, int n, int n2, int n3) {
        boolean bl = false;
        if (n3 >= 200) {
            bl = true;
            n3 %= 200;
        }
        int n4 = (n3 >>= 2) / 9;
        int n5 = n3 % 9;
        GameDisplay.drawClipImage(graphics, images[66], n, n2, 16, 0, 16, 26);
        GameDisplay.drawClipImage(graphics, images[40], n + 1, n2 + 1, n5 * 13, n4 * 17, 13, 17);
        GameDisplay.resetClip(graphics);
        if (bl) {
            GameDisplay.drawImage(graphics, images[7], n, n2, 20);
        }
        GameDisplay.resetClip(graphics);
    }

    void drawThrowCard2(Graphics graphics, int n, int n2, int n3, boolean bl) {
        int n4 = (n3 >>= 2) / 9;
        int n5 = n3 % 9;
        int n6 = 15;
        GameDisplay.drawClipImage(graphics, images[66], n, n2, 44, 11, 20, n6);
        GameDisplay.drawClipImage(graphics, images[41], n + 1, n2 + 1, n4 * 19, (8 - n5) * 6, 19, 6);
        GameDisplay.resetClip(graphics);
    }

    void drawThrowCard3(Graphics graphics, int n, int n2, int n3) {
        int n4 = 3 - (n3 >>= 2) / 9;
        int n5 = 8 - n3 % 9;
        GameDisplay.drawClipImage(graphics, images[66], n, n2, 106, 9, 10, 17);
        GameDisplay.drawClipImage(graphics, images[42], n + 1, n2 + 0, n5 * 10, n4 * 13, 10, 13);
        GameDisplay.resetClip(graphics);
    }

    void drawThrowCard4(Graphics graphics, int n, int n2, int n3, boolean bl) {
        int n4 = 3 - (n3 >>= 2) / 9;
        int n5 = 8 - n3 % 9;
        int n6 = 15;
        GameDisplay.drawClipImage(graphics, images[66], n, n2, 76, 12, 20, n6);
        GameDisplay.drawClipImage(graphics, images[43], n + 0, n2 + 1, n4 * 19, (8 - n5) * 6, 19, 6);
        GameDisplay.resetClip(graphics);
    }

    void drawTitle(Graphics graphics, int n) {
        int n2 = 120;
        int n3 = 3;
        String string = "";
        switch (n) {
            case 0: {
                string = this.res.iGameText[1];
                break;
            }
            case 1: {
                string = this.res.iGameText[157];
                break;
            }
            case 2: {
                string = this.res.iGameText[3];
                break;
            }
            case 3: {
                string = this.res.iGameText[4];
                break;
            }
            case 5: {
                string = this.res.iGameText[2];
                break;
            }
            case 6: {
                string = this.res.iGameText[159];
                break;
            }
            case 4: {
                string = this.res.iGameText[73];
            }
        }
        graphics.setFont(F_SMALL);
        graphics.setColor(0xFCFFCC);
        int n4 = F_SMALL.stringWidth(string);
        graphics.drawString(string, (240 - n4) / 2, 3, 20);
    }

    private void drawImageTitle(Graphics graphics, int n) {
        int n2 = 60;
        int n3 = 3;
        int n4 = 0;
        switch (n) {
            case 0: {
                n4 = 34;
                break;
            }
            case 1: {
                n4 = 170;
                break;
            }
            case 2: {
                n4 = 68;
                break;
            }
            case 3: {
                n4 = 102;
                break;
            }
            case 5: {
                n4 = 136;
                break;
            }
            case 6: {
                n4 = 0;
                break;
            }
        }
        GameDisplay.drawClipImage(graphics, images[67], n2, n3, 0, n4, 120, 34);
        GameDisplay.resetClip(graphics);
    }

    void drawBalance(Graphics graphics) {
        GameDisplay.drawImage(graphics, images[1], 0, 0, 20);
        this.drawImageTitle(graphics, 6);
        int n = 29;
        int n2 = 260 - n - 21 - 4;
        int n3 = 240;
        int n4 = n2 / 4;
        try {
            this.drawBalancePlayer(graphics, 0, 0, n, n3, n4);
            this.drawBalancePlayer(graphics, 1, 0, n + n4, n3, n4);
            this.drawBalancePlayer(graphics, 2, 0, n + 2 * n4, n3, n4);
            this.drawBalancePlayer(graphics, 3, 0, n + 3 * n4, n3, n4);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.drawButton(graphics, 0);
    }

    void drawBalancePlayer(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        String string = GameResource.trimString(this.res.playerInfos[this.res.players[n]].stringName, GameResource.font, 120);
        int n6 = (GameDisplay.getImageHeight(images[70]) - 21) / 2;
        GameDisplay.drawString(graphics, string, 10, n3 + n6, 20, 0xFCFFCC);
        int n7 = this.res.playersScore[n];
        int n8 = this.res.lastOffsetScore[n];
        String string2 = Integer.toString(n7);
        GameDisplay.drawRoundString(graphics, string2, 235, n3 + n6, 24, 0xFFFFFF, 0xFF0000);
        string2 = "";
        string2 = n8 >= 0 ? this.res.iGameText[152] + n8 : this.res.iGameText[153] + -1 * n8;
        GameDisplay.drawRoundString(graphics, string2, 160, n3 + n6, 24, 0xFFFFFF, 255);
    }

    void drawBigFaceWithName(Graphics graphics, int n, int n2, int n3) {
        GameDisplay.drawImage(graphics, images[n + 30], n2, n3 + 21, 0);
        if (n == 0) {
            this.drawBigTabString(graphics, GameResource.trimString(this.res.playerInfo.nickname, GameResource.font, 120), n2, n3, 0, 0xFFFFFF);
        } else {
            this.drawBigTabString(graphics, this.res.playerInfos[n].stringName, n2, n3, 0, 0xFFFFFF);
        }
    }

    void drawBigTabString(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.drawBigTabString(graphics, this.res.iGameText[n], n2, n3, n4, n5);
    }

    void drawBigTabString(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        GameDisplay.drawRoundString(graphics, string, n, n2, 20, n3, n4);
    }

    void drawBox(Graphics graphics, int n, int n2, int n3, int n4) {
        this.drawBoxOutSide(graphics, n, n2, n3, n4);
        GameDisplay.fillRect(graphics, n + 5, n2 + 5, n3 - 10, n4 - 10, 0xFFFFFF);
    }

    void drawBoxOutSide(Graphics graphics, int n, int n2, int n3, int n4) {
        GameDisplay.drawRect(graphics, n, n2, n3, n4, 1, 1, 0);
        GameDisplay.drawRect(graphics, n + 1, n2 + 1, n3 - 2, n4 - 2, 1, 1, 0x7A7A7A);
        GameDisplay.drawRect(graphics, n + 2, n2 + 2, n3 - 4, n4 - 4, 1, 1, 0xFFFFFF);
        GameDisplay.drawRect(graphics, n + 3, n2 + 3, n3 - 6, n4 - 6, 1, 1, 0xA9A9A9);
        GameDisplay.drawRect(graphics, n + 4, n2 + 4, n3 - 8, n4 - 8, 1, 1, 0xA9A9A9);
    }

    void drawButton(Graphics graphics, int n) {
        switch (n) {
            case 0: {
                GameDisplay.drawImage(graphics, images[36], 0, 260, 36);
                break;
            }
            case 1: {
                GameDisplay.drawImage(graphics, images[34], 240, 260, 40);
                break;
            }
            case 2: {
                GameDisplay.drawImage(graphics, images[35], 240, 260, 40);
            }
        }
    }

    void drawCredit(Graphics graphics) {
        this.drawAlertPage(graphics, 3);
        this.drawButton(graphics, 1);
    }

    void drawDetailRecord(Graphics graphics) {
        GameDisplay.drawImage(graphics, images[1], 0, 0, 20);
        if (GameResource.detailRecordList == null || GameResource.detailRecordList.length == 0) {
            this.drawLoading(graphics);
        }
        UIHelper.setDrawRegion(9, 41, 217, 187);
        UIHelper.drawRecord(graphics, GameResource.detailRecordList, this.res.currentIndex, 2, 21, markupDetailPos, null);
        this.drawScrollBar(graphics, this.res.currentIndex, GameResource.detailRecordList.length / 2, 21);
        this.drawImageTitle(graphics, 5);
        GameDisplay.resetClip(graphics);
        this.drawButton(graphics, 1);
    }

    public void drawLoading(Graphics graphics) {
        this.drawLoadingBar(graphics);
    }

    void drawFaceBG(Graphics graphics, int n, int n2, int n3) {
        GameDisplay.drawImage(graphics, images[n + 30 - 1], n2, n3, 0);
    }

    void drawFlower(Graphics graphics, int n, int n2, int n3) {
        MJPlayer mJPlayer = this.res.mjGame.mjPlayers[n];
        if (mJPlayer.flowerLength > 0) {
            int n4 = 0;
            int n5 = 0;
            int n6 = 13;
            int n7 = 18;
            int n8 = 13;
            int n9 = 0;
            for (int i = 0; i < mJPlayer.flowerLength; ++i) {
                int n10 = mJPlayer.cardFlower[i] - 136;
                GameDisplay.drawClipImage(graphics, images[10], n2, n3, n4 + n8 * n10, n5 + n9 * n10, n6, n7);
                n2 += n8;
                n3 += n9;
            }
            GameDisplay.resetClip(graphics);
        }
    }

    void drawExitAlert(Graphics graphics) {
        GameDisplay.drawImage(graphics, images[1], 0, 0, 20);
        GameDisplay.drawString(graphics, this.res.iGameText[20], 120, 120, 17, 0xFCFFCC);
        this.drawButton(graphics, 0);
        this.drawButton(graphics, 2);
    }

    void drawCloseSound(Graphics graphics) {
        GameDisplay.drawImage(graphics, images[1], 0, 0, 20);
        GameDisplay.drawString(graphics, this.res.iGameText[76], 120, 120, 17, 0xFCFFCC);
        this.drawButton(graphics, 0);
        this.drawButton(graphics, 2);
    }

    void drawGameResultDraw(Graphics graphics) {
        GameDisplay.drawImage(graphics, images[1], 0, 0, 20);
        this.drawImageTitle(graphics, 4);
        int n = 26;
        int n2 = 260 - n - 21 - 4;
        int n3 = 240;
        for (int i = 0; i < 4; ++i) {
            this.drawGameResultDrawPlayer(graphics, i, 0, n + n2 * i / 4, n3, n2 / 4);
        }
        GameDisplay.resetClip(graphics);
        this.drawButton(graphics, 0);
    }

    public int getPausecolor(int n) {
        if (this.res.menuIndex == n) {
            return 0xFCFFCC;
        }
        return 0xFFFFFF;
    }

    public void initGamePause() throws Exception {
        int[] nArray = new int[]{1, 10, 30, 31, 32, 33, 88, 89, 90, 91, 49, 50, 51, 52};
        GameDisplay.loadImage(nArray);
        this.res.menuIndex = 0;
    }

    void drawGamePause(Graphics graphics) {
        GameDisplay.drawImage(graphics, images[1], 0, 0, 20);
        this.drawGamePausePlayer(graphics, 0, 0, 0);
        this.drawGamePausePlayer(graphics, 1, 0, 57);
        this.drawGamePausePlayer(graphics, 2, 0, 114);
        this.drawGamePausePlayer(graphics, 3, 0, 171);
        int n = 80;
        for (int i = 0; i < 3; ++i) {
            int n2 = 3 + n * i;
            int n3 = 0;
            switch (i) {
                case 0: {
                    n3 = 49;
                    break;
                }
                case 1: {
                    n3 = 50;
                    break;
                }
                case 2: {
                    n3 = 51;
                }
            }
            int n4 = GameDisplay.getImageWidth(images[n3]);
            int n5 = GameDisplay.getImageHeight(images[n3]);
            GameDisplay.drawImage(graphics, images[52], n2, 245, 20);
            GameDisplay.resetClip(graphics);
            if (i == this.res.menuIndex) {
                GameDisplay.drawClipImage(graphics, images[n3], n2 - 3, 230, 0, 0, n4, n5);
            } else {
                GameDisplay.drawClipImage(graphics, images[n3], n2 - 3, 225, 0, 0, n4, n5);
            }
            GameDisplay.resetClip(graphics);
        }
    }

    void drawGameExitThanks(Graphics graphics) {
        GameDisplay.drawImage(graphics, images[1], 0, 0, 20);
        String[] stringArray = StringFunction.split(this.res.iGameText[33], "\\n");
        int n = 109;
        for (int i = 0; i < stringArray.length; ++i) {
            GameDisplay.drawString(graphics, stringArray[i], 120, n, 17, 0xFCFFCC);
            n += 21;
        }
    }

    void drawAlertPage(Graphics graphics, int n) {
        GameDisplay.drawImage(graphics, images[1], 0, 0, 20);
        UIHelper.setDrawRegion(9, 41, 227, 187);
        graphics.setColor(0xFCFFCC);
        UIHelper.drawText(graphics, this.res.displayTexts, this.res.currentIndex, 22, 20, null);
        this.drawScrollBar(graphics, this.res.currentIndex, this.res.displayTexts.length, 22, 187, 36);
        this.drawImageTitle(graphics, n);
        GameDisplay.resetClip(graphics);
    }

    public void drawScrollBar(Graphics graphics, int n, int n2, int n3) {
        this.drawScrollBar(graphics, n, n2, n3, 187, 36);
    }

    public void drawScrollBar(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        UIHelper.setDrawRegion(234, n5, 6, n4);
        UIHelper.drawScrollBar(graphics, n2, n, n3, 0, 9131033, 0xFFFFCC, 0xFFFFCC, false, 10);
    }

    void drawGamePausePlayer(Graphics graphics, int n, int n2, int n3) {
        int n4 = this.res.players[n];
        if (n4 > 3) {
            n4 = 58 + this.res.players[n] - 4;
        }
        GameDisplay.drawImage(graphics, images[n4 + 30], 0, n3, 20);
        if (n4 > 3) {
            n4 = this.res.players[n] - 4;
        }
        int n5 = this.res.playersScore[n];
        String string = GameResource.trimString(this.res.getPlayername(n), GameResource.font, 120);
        GameDisplay.drawString(graphics, string, n2 + 50 + 5, n3 + 2, 20, 0xFCFFCC);
        String string2 = Integer.toString(n5);
        GameDisplay.drawString(graphics, string2, 240 - n2 - 4, n3 + 4, 24, 0xFCFFCC);
        this.drawFlower(graphics, n4, n2 + 50 + 5, n3 + 50 - GameDisplay.getImageHeight(images[10]));
    }

    void drawGameResultDrawPlayer(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6;
        GameDisplay.drawImage(graphics, images[70], 0, n3, 20);
        int n7 = this.res.players[n];
        String string = GameResource.trimString(this.res.playerInfos[n7].stringName, GameResource.font, 120);
        int n8 = 5;
        GameDisplay.drawString(graphics, string, 10, n3 + n8, 20, 0xFCFFCC);
        int n9 = this.res.playersScore[n];
        int n10 = this.res.lastOffsetScore[n];
        String string2 = Integer.toString(n9);
        GameDisplay.drawRoundString(graphics, string2, 235, n3 + n8, 24, 0xFFFFFF, 0xFF0000);
        string2 = "";
        string2 = n10 >= 0 ? this.res.iGameText[152] + n10 : this.res.iGameText[153] + -1 * n10;
        GameDisplay.drawRoundString(graphics, string2, 160, n3 + n8, 24, 0xFFFFFF, 255);
        MJPlayer mJPlayer = this.res.mjGame.mjPlayers[n];
        n3 = n3 + n5 - 26;
        n2 += 5;
        int n11 = 0;
        for (n6 = 0; n6 < mJPlayer.cardPatternIndex.size(); ++n6) {
            int n12 = (Integer)mJPlayer.cardPatternIndex.elementAt(n6);
            for (int i = 0; i < 3; ++i) {
                this.drawThrowCard(graphics, n2, n3, mJPlayer.cardShow[n11]);
                ++n11;
                n2 += 16;
            }
            if (n12 != 2) continue;
            this.drawThrowCard(graphics, n2 + -31, n3 + -5, mJPlayer.cardShow[n11]);
            ++n11;
        }
        ++n2;
        for (n6 = 0; n6 < mJPlayer.holdingLength; ++n6) {
            this.drawThrowCard(graphics, n2, n3, mJPlayer.cardHolding[n6]);
            n2 += 16;
        }
        GameDisplay.resetClip(graphics);
    }

    void initErrorState(int n) {
        this.res.isReady = false;
        try {
            MGIECanvas.unloadAllImage();
            switch (n) {
                case 14: {
                    this.initExitGamePlayAlert();
                    break;
                }
                case 18: {
                    this.initGamePause();
                }
            }
            this.res.backErrorState = this.res.gameState;
            this.res.gameState = n;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.res.isReady = true;
    }

    void backGameState() {
        this.res.isReady = false;
        while (this.res.isDraw) {
            this.res.customSleep(50);
        }
        int[] nArray = mainGameImgList;
        try {
            GameDisplay.loadImage(nArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.res.gameState = 1;
        this.res.isReady = true;
    }

    public void drawQuickMessage(Graphics graphics) {
        if (this.res.playerHoldTime >= 65) {
            int n = (this.res.playerIndex + 1 + this.res.currentPlayerPos) % 4;
            int n2 = this.res.messageIndex;
            int n3 = this.res.players[n];
            String string = "";
            switch (n2) {
                case 0: {
                    string = this.res.playerInfos[n3].stringMessage1;
                    break;
                }
                case 1: {
                    string = this.res.playerInfos[n3].stringMessage2;
                }
            }
            switch (this.res.playerIndex) {
                case 0: {
                    this.drawMessageWithBox1(graphics, n3, string, n);
                    break;
                }
                case 1: {
                    this.drawMessageWithBox2(graphics, n3, string, n);
                    break;
                }
                case 2: {
                    this.drawMessageWithBox3(graphics, n3, string, n);
                }
            }
        }
    }

    public void drawMessageWithBox2(Graphics graphics, int n, String string, int n2) {
        this.drawMessageBoxPhoto(graphics, this.res.playerInfos[n].imageFaceIndex, 0, 0, 0xFFF0F0, 0xFF0000);
        this.drawMessageBoxMessage(graphics, string, 42, 8, 0xFFF0F0, 0xFF0000, 0x860000);
        this.drawMessageBoxName(graphics, GameResource.trimString(this.res.getPlayername(n2), GameResource.font, 80), 0, 46, 0xFFF0F0, 0xFF0000, 0x860000);
    }

    public void drawMessageWithBox1(Graphics graphics, int n, String string, int n2) {
        this.drawMessageBoxPhoto(graphics, this.res.playerInfos[n].imageFaceIndex, 198, 45, 0xFFFFFF, 0xFFFFFF);
        this.drawMessageBoxMessage(graphics, string, 127, 91, 0xFFFFFF, 0xFFFFFF, 0xFCFFCC);
        this.drawMessageBoxName(graphics, GameResource.trimString(this.res.getPlayername(n2), GameResource.font, 80), 118, 54, 0xFFFFFF, 0xFFFFFF, 0xFCFFCC);
    }

    public void drawMessageWithBox3(Graphics graphics, int n, String string, int n2) {
        this.drawMessageBoxPhoto(graphics, this.res.playerInfos[n].imageFaceIndex, 0, 109, 16772572, 15288064);
        this.drawMessageBoxMessage(graphics, string, 0, 155, 16772572, 15288064, 8407808);
        this.drawMessageBoxName(graphics, GameResource.trimString(this.res.getPlayername(n2), GameResource.font, 80), 42, 118, 16772572, 15288064, 8407808);
    }

    public void drawMessageBoxPhoto(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        GameDisplay.fillRoundRect(graphics, n2, n3, 42, 46, 4, 4, n4);
        GameDisplay.drawRoundRect(graphics, n2 + 1, n3 + 1, 40, 44, 4, 4, 1, 1, n5);
        GameDisplay.drawImage(graphics, images[n + 30], n2 + 21, n3 + 23, 3);
    }

    public void drawMessageBoxMessage(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5) {
        GameDisplay.fillRoundRect(graphics, n, n2, 113, 29, 4, 4, n3);
        GameDisplay.drawRoundRect(graphics, n + 1, n2 + 1, 111, 27, 4, 4, 1, 1, n4);
        GameDisplay.drawString(graphics, string, n + 56, n2 + 4, 17, n5);
    }

    public void drawMessageBoxName(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5) {
        GameDisplay.fillRoundRect(graphics, n, n2, 80, 27, 4, 4, n3);
        GameDisplay.drawRoundRect(graphics, n + 1, n2 + 1, 78, 25, 4, 4, 1, 1, n4);
        GameDisplay.drawString(graphics, string, n + 40, n2 + 3, 17, n5);
    }

    public String[] breakStringToDisplayArrayFullScreen(String string) {
        return StringFunction.stringToDisplayArray(GameResource.font, string, 240);
    }

    public String[] breakStringToDisplayArray(String string) {
        return StringFunction.stringToDisplayArray(GameResource.font, string, 227);
    }

    public void canvasPaused() {
        GameMidlet.isPaused = true;
    }

    public void canvasResumed() {
        GameMidlet.isPaused = false;
    }

    public void loadImage() {
    }
}

