/*
 * Decompiled with CFR 0.152.
 */
package my_java.security;

import java.util.Random;
import org.bouncycastle.crypto.digests.SHA1Digest;

public final class SecureRandom
extends Random {
    private static SecureRandom rand = new SecureRandom();
    private byte[] seed;
    private long counter = 1L;
    private SHA1Digest digest = new SHA1Digest();
    private byte[] state = new byte[this.digest.getDigestSize()];
    private byte[] intBytes = new byte[4];
    private byte[] longBytes = new byte[8];

    public SecureRandom() {
        super(0L);
        this.setSeed(System.currentTimeMillis());
    }

    private SecureRandom(byte[] byArray) {
        super(0L);
        this.setSeed(byArray);
    }

    private static SecureRandom getInstance$3708fe9f() {
        return new SecureRandom();
    }

    private static SecureRandom getInstance$acce415() {
        return new SecureRandom();
    }

    private static byte[] getSeed(int n2) {
        byte[] byArray = new byte[n2];
        rand.setSeed(System.currentTimeMillis());
        rand.nextBytes(byArray);
        return byArray;
    }

    private byte[] generateSeed(int n2) {
        byte[] byArray = new byte[n2];
        this.nextBytes(byArray);
        return byArray;
    }

    private void setSeed(byte[] byArray) {
        this.digest.update(byArray, 0, byArray.length);
    }

    private void nextBytes(byte[] byArray) {
        int n2 = 0;
        this.digest.doFinal(this.state, 0);
        int n3 = 0;
        while (n3 != byArray.length) {
            if (n2 == this.state.length) {
                byte[] byArray2 = this.longToBytes(this.counter++);
                this.digest.update(byArray2, 0, byArray2.length);
                this.digest.update(this.state, 0, this.state.length);
                this.digest.doFinal(this.state, 0);
                n2 = 0;
            }
            byArray[n3] = this.state[n2++];
            ++n3;
        }
        byte[] byArray3 = this.longToBytes(this.counter++);
        this.digest.update(byArray3, 0, byArray3.length);
        this.digest.update(this.state, 0, this.state.length);
    }

    public final void setSeed(long l2) {
        if (l2 != 0L) {
            this.setSeed(this.longToBytes(l2));
        }
    }

    public final int nextInt() {
        this.nextBytes(this.intBytes);
        int n2 = 0;
        int n3 = 0;
        while (n3 < 4) {
            n2 = (n2 << 8) + (this.intBytes[n3] & 0xFF);
            ++n3;
        }
        return n2;
    }

    protected final int next(int n2) {
        int n3 = (n2 + 7) / 8;
        byte[] byArray = new byte[n3];
        this.nextBytes(byArray);
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            n4 = (n4 << 8) + (byArray[n5] & 0xFF);
            ++n5;
        }
        return n4 & (1 << n2) - 1;
    }

    private byte[] longToBytes(long l2) {
        int n2 = 0;
        while (n2 != 8) {
            this.longBytes[n2] = (byte)l2;
            l2 >>>= 8;
            ++n2;
        }
        return this.longBytes;
    }
}

