/*
 * Decompiled with CFR 0.152.
 */
package se.vitamin.ui;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import se.vitamin.ui.Button;
import se.vitamin.ui.UI;
import se.vitamin.ui.Widget;
import se.vitamin.ui.Window;

public class ButtonList
extends Widget {
    private int _currentItem;
    private Vector _buttons = new Vector();
    private int _offset = 0;

    public ButtonList(Window parent, int id, int x, int y, int w) {
        super(parent, id);
        this._x = x;
        this._y = y;
        this._w = w;
    }

    public void clear() {
        this._buttons.removeAllElements();
        System.gc();
    }

    public void activate() {
        this._active = true;
        ((Button)this._buttons.elementAt(this._currentItem)).activate();
    }

    public void deactivate() {
        this._active = false;
        ((Button)this._buttons.elementAt(this._currentItem)).deactivate();
    }

    public void setMaxHeight() {
    }

    public Button getButton(int index) {
        if (index >= this._buttons.size() || index < 0) {
            return null;
        }
        return (Button)this._buttons.elementAt(index);
    }

    public void selectButton(int index) {
        if (this._currentItem < this._buttons.size() - 1) {
            ((Button)this._buttons.elementAt(this._currentItem)).deactivate();
        }
        this._currentItem = index;
        if (this._offset > this._currentItem) {
            this._offset = this._currentItem;
        } else {
            int buttonHeight = 0;
            if (this._parent != null) {
                buttonHeight = this._parent._y;
            }
            if (this._h == 0) {
                this._h = UI.SCREEN_HEIGHT - this._y;
            }
            for (int i = this._offset; i <= this._currentItem; ++i) {
                buttonHeight += ((Button)this._buttons.elementAt(i)).getHeight() + 5;
            }
            if ((buttonHeight -= 5) > this._h) {
                int height = this._h;
                buttonHeight = 0;
                this._offset = this._currentItem;
                while (this._offset > 0 && buttonHeight + ((Button)this._buttons.elementAt(this._offset)).getHeight() + 5 < height) {
                    buttonHeight += ((Button)this._buttons.elementAt(this._offset)).getHeight() + 5;
                    --this._offset;
                }
            }
        }
        ((Button)this._buttons.elementAt(this._currentItem)).activate();
    }

    public int getIndex() {
        return this._currentItem;
    }

    public boolean handleKeyDown(int key) {
        switch (key) {
            case -1: {
                ((Button)this._buttons.elementAt(this._currentItem)).deactivate();
                --this._currentItem;
                if (this._currentItem < 0) {
                    this._currentItem = 0;
                }
                if (this._currentItem < this._offset) {
                    this._offset = this._currentItem;
                }
                ((Button)this._buttons.elementAt(this._currentItem)).activate();
                break;
            }
            case -2: {
                ((Button)this._buttons.elementAt(this._currentItem)).deactivate();
                ++this._currentItem;
                if (this._currentItem > this._buttons.size() - 1) {
                    this._currentItem = this._buttons.size() - 1;
                }
                int buttonHeight = 0;
                if (this._parent != null) {
                    buttonHeight = this._parent._y;
                }
                if (this._h == 0) {
                    this._h = UI.SCREEN_HEIGHT - this._y;
                }
                for (int i = this._offset; i <= this._currentItem; ++i) {
                    buttonHeight += ((Button)this._buttons.elementAt(i)).getHeight() + 5;
                }
                System.out.println((buttonHeight -= 5) + " - " + this._h);
                if (buttonHeight > this._h) {
                    ++this._offset;
                }
                ((Button)this._buttons.elementAt(this._currentItem)).activate();
                break;
            }
            case -5: {
                this.select();
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean handleKeyUp(int key) {
        return false;
    }

    public boolean handleLongPress(int key) {
        return this.handleKeyDown(key);
    }

    public void paint(Graphics g, int x, int y) {
        int top = y + this._y;
        for (int i = this._offset; i < this._buttons.size(); ++i) {
            Button _b = (Button)this._buttons.elementAt(i);
            _b.setDimensions(this._w, 0);
            _b.paint(g, x, top);
            top += _b.getHeight() + 5;
        }
    }

    public void setDimensions(int x, int y, int w, int h) {
    }

    public int getSize() {
        return this._buttons.size();
    }

    public void setFont(Font f) {
    }

    public void update() {
    }

    public void addButton(Button b) {
        this._minH += b.getHeight() + 5;
        this._buttons.addElement(b);
        b.setPosition(this._x, 0);
        if (this._buttons.size() == 1) {
            b.activate();
        }
    }

    public void select() {
        Button b = (Button)this._buttons.elementAt(this._currentItem);
        this._parent.widgetEvent(b._id, Integer.MIN_VALUE);
    }

    public int size() {
        return this._buttons.size();
    }

    public int getHeight() {
        int top = 0;
        for (int i = 0; i < this._buttons.size(); ++i) {
            Button _b = (Button)this._buttons.elementAt(i);
            top += _b.getHeight() + 5;
        }
        return top;
    }

    public int getScreenX() {
        return 0;
    }

    public int getScreenY() {
        return 0;
    }

    public void languageUpdate() {
        for (int i = 0; i < this._buttons.size(); ++i) {
            ((Button)this._buttons.elementAt(i)).reCenter();
        }
    }
}

