/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.paddings;

import my_java.security.SecureRandom;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;

public class PKCS7Padding
implements BlockCipherPadding {
    public void init(SecureRandom secureRandom) throws IllegalArgumentException {
    }

    public String getPaddingName() {
        return "PKCS7";
    }

    public int addPadding(byte[] byArray, int n2) {
        byte by = (byte)(byArray.length - n2);
        while (n2 < byArray.length) {
            byArray[n2] = by;
            ++n2;
        }
        return by;
    }

    public int padCount(byte[] byArray) throws InvalidCipherTextException {
        int n2 = byArray[byArray.length - 1] & 0xFF;
        if (n2 > byArray.length) {
            throw new InvalidCipherTextException("pad block corrupted");
        }
        for (int i2 = 1; i2 <= n2; ++i2) {
            if (byArray[byArray.length - i2] == n2) continue;
            throw new InvalidCipherTextException("pad block corrupted");
        }
        return n2;
    }
}

