/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.components;

import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.utils.attributes.VerifyScreenDimension;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.BorderLayout;
import java.io.IOException;

public class WaitIndicator
extends Container {
    private static Image[] angles = null;
    private static final String WAIT_INDICATOR_IMG = "waitIndicator.png";
    private static final int FPS = 7;
    private static Image image = null;
    private int angle = 0;
    private long lastRun = 0L;
    private Label iconIndicator;

    static {
        try {
            int qtdImgs = 8;
            int dimImg = 20;
            image = Image.createImage(IOUtility.getImageFromRES(WAIT_INDICATOR_IMG));
            angles = new Image[qtdImgs];
            int i = 0;
            while (i < qtdImgs) {
                WaitIndicator.angles[i] = image.subImage(0, i * dimImg, dimImg, dimImg, true);
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public WaitIndicator() {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(VerifyScreenDimension.getAttributesInstance().getWaitIndicatorWidth(), VerifyScreenDimension.getAttributesInstance().getWaitIndicatorHeight()));
        this.setProperties();
        this.setStyleProperties();
        this.addComponent("Center", (Component)this.iconIndicator);
    }

    private void setProperties() {
        if (this.iconIndicator == null) {
            this.iconIndicator = new Label();
            this.iconIndicator.setAlignment(4);
            this.iconIndicator.setIcon(angles[0]);
            this.iconIndicator.getStyle().setBgTransparency(0);
        }
    }

    private void setStyleProperties() {
        this.getStyle().setBgTransparency(120);
        this.getStyle().setBgColor(0);
    }

    public void initComponent() {
        this.getComponentForm().registerAnimated(this);
    }

    public boolean animate() {
        if (System.currentTimeMillis() - this.lastRun > 142L) {
            ++this.angle;
            if (this.iconIndicator != null) {
                this.iconIndicator.setIcon(angles[Math.abs(this.angle % angles.length)]);
            }
            this.lastRun = System.currentTimeMillis();
            return true;
        }
        return false;
    }
}

