/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.utils;

import java.util.Vector;

public abstract class TaskHandler
implements Runnable {
    private boolean running;
    private Vector taskQueue = new Vector();

    public void start() {
        this.running = true;
        Thread thread = new Thread(this);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.running = false;
        Vector vector = this.taskQueue;
        synchronized (vector) {
            this.taskQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(Object task) {
        Vector vector = this.taskQueue;
        synchronized (vector) {
            if (this.running) {
                this.taskQueue.addElement(task);
                this.taskQueue.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanTasks() {
        Vector vector = this.taskQueue;
        synchronized (vector) {
            if (this.running) {
                this.taskQueue.removeAllElements();
            }
        }
    }

    protected abstract void exec(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Object task = null;
        Vector vector = this.taskQueue;
        synchronized (vector) {
            while (true) {
                if (!this.running) {
                    return;
                }
                if (!this.taskQueue.isEmpty()) {
                    task = this.taskQueue.elementAt(0);
                    if (!this.taskQueue.isEmpty()) {
                        this.taskQueue.removeElementAt(0);
                    }
                    if (task == null) continue;
                    this.exec(task);
                    continue;
                }
                try {
                    this.taskQueue.wait();
                }
                catch (InterruptedException iex) {
                    iex.printStackTrace();
                    this.stop();
                }
            }
        }
    }
}

