/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.components.list;

import com.sonyericsson.fifa.utils.attributes.Attributes;
import com.sonyericsson.fifa.utils.attributes.VerifyScreenDimension;
import com.sonyericsson.fifa.view.Images;
import com.sonyericsson.fifa.view.components.FifaLookAndFeelManager;
import com.sun.lwuit.Container;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.CoordinateLayout;
import com.sun.lwuit.plaf.Border;

public class CountryDataItem
extends Container {
    private Label icon = null;
    private Label text = null;
    private Container iconContainer = null;
    private Container textContainer = null;
    private Attributes attributes = VerifyScreenDimension.getAttributesInstance();

    public CountryDataItem(String countryGroup, Image countryFlag) {
        this.setLayout(new CoordinateLayout(this.attributes.getCountryDataItemWidth() + 5, this.attributes.getCountryDataItemHeight()));
        this.setPreferredSize(new Dimension(this.attributes.getCountryDataItemWidth() + 5, this.attributes.getCountryDataItemHeight()));
        this.setFocusable(false);
        if (countryFlag != null) {
            this.getIcon().setIcon(countryFlag);
            this.getIconContainer().addComponent(this.getIcon());
            this.getIconContainer().setX(this.attributes.getCountryDataIconPosX());
            this.getIconContainer().setY(this.attributes.getCountryDataIconPosY());
            this.addComponent(this.getIconContainer());
            this.getTextContainer().setY(this.attributes.getCountryDataTitlePosY());
            this.setIconRoundedAndWhiteBorder();
        } else {
            this.getTextContainer().setY(0);
        }
        this.getTitle().setText(countryGroup);
        this.getTitle().setFocusable(false);
        this.getTextContainer().setX(this.attributes.getCountryDataTitlePosX());
        this.getTextContainer().addComponent(this.getTitle());
        this.addComponent(this.getTextContainer());
        this.setTitleRoundedAndWhiteBorder();
        this.setX(this.attributes.getCountryDataItemPosX());
        this.setY(this.attributes.getCountryDataItemPosY());
    }

    private Label getTitle() {
        if (this.text == null) {
            this.text = new Label();
            this.text.getStyle().setBgColor(0xFFFFFF);
            this.text.setX(4);
            this.text.setY(this.attributes.getCountryDataItemTextPosY());
        }
        return this.text;
    }

    private Container getIconContainer() {
        if (this.iconContainer == null) {
            Dimension dim = new Dimension(VerifyScreenDimension.getAttributesInstance().getFlagSmallWidth(), VerifyScreenDimension.getAttributesInstance().getFlagSmallHeight());
            this.iconContainer = new Container(new BoxLayout(2));
            this.iconContainer.setPreferredSize(dim);
            this.iconContainer.setFocusable(false);
            this.iconContainer.getStyle().setPadding(0, 0, 0, 0);
            this.iconContainer.getStyle().setMargin(5, 5, 5, 5);
        }
        return this.iconContainer;
    }

    private Container getTextContainer() {
        if (this.textContainer == null) {
            Dimension dim = new Dimension(this.attributes.getCountryDataItemWidth(), this.attributes.getCountryDataTitleHeight());
            this.textContainer = new Container(new CoordinateLayout(dim));
            this.textContainer.setPreferredSize(dim);
            this.textContainer.setFocusable(false);
            this.textContainer.getStyle().setPadding(0, 0, 0, 0);
            this.textContainer.getStyle().setMargin(5, 5, 5, 5);
        }
        return this.textContainer;
    }

    protected Label getIcon() {
        if (this.icon == null) {
            Dimension dim = new Dimension(VerifyScreenDimension.getAttributesInstance().getFlagSmallWidth() - 2, VerifyScreenDimension.getAttributesInstance().getFlagSmallHeight() - 2);
            this.icon = new Label();
            this.icon.setAlignment(4);
            this.icon.setPreferredSize(dim);
            this.icon.setSize(this.icon.getPreferredSize());
            this.icon.setFocusable(false);
            this.icon.getStyle().setBorder(Border.createEmpty());
            this.icon.getStyle().setBgTransparency(0);
            this.icon.getStyle().setPadding(0, 0, 0, 0);
            this.icon.getStyle().setMargin(1, 0, 1, 1);
        }
        return this.icon;
    }

    private void setIconRoundedAndWhiteBorder() {
        this.getIcon().getStyle().setBgTransparency(255);
        this.getIcon().setAlignment(1);
        this.getIcon().getStyle().setPadding(0, 0, this.attributes.getChangeTeamIconBorderPadLeft(), this.attributes.getChangeTeamIconBorderPadRight());
        this.getIconContainer().getStyle().setBgTransparency(255);
        this.getIcon().setPreferredSize(new Dimension(this.attributes.getIconHeadlineWidth(), this.attributes.getIconHeadlineHeight()));
        this.getIconContainer().setPreferredSize(new Dimension(this.attributes.getIconHeadlineWidth(), this.attributes.getIconHeadlineHeight()));
        this.getIconContainer().getStyle().setBgImage(Images.getCountryDataFlagBackground());
    }

    private void setTitleRoundedAndWhiteBorder() {
        FifaLookAndFeelManager.configToFirstLineBlackStyle(this.getTitle());
        this.getTextContainer().getStyle().setBgImage(Images.getCountryDataTextBackground());
    }
}

