/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.components.forms;

import com.sonyericsson.fifa.exceptions.ComponentException;
import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.utils.Logger;
import com.sonyericsson.fifa.utils.SystemProperties;
import com.sonyericsson.fifa.utils.attributes.Attributes;
import com.sonyericsson.fifa.utils.attributes.VerifyScreenDimension;
import com.sonyericsson.fifa.view.ViewFactory;
import com.sonyericsson.fifa.view.components.FifaLookAndFeelManager;
import com.sonyericsson.fifa.view.components.SoftkeyContainer;
import com.sonyericsson.fifa.view.components.listener.KeyListener;
import com.sonyericsson.fifa.view.components.listener.TouchListener;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Image;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.CoordinateLayout;
import com.sun.lwuit.layouts.Layout;
import com.sun.lwuit.plaf.Style;
import java.io.IOException;

public class BaseForm
extends Form {
    private SoftkeyContainer sfkComponent;
    Attributes attributes = VerifyScreenDimension.getAttributesInstance();
    private KeyListener keyListener = null;
    private TouchListener touchListener = null;
    protected int[] selectedItem = null;
    private static final String BACKGROUND_IMAGE = "formBG.png";
    private Container contentPane = null;

    public BaseForm() {
        this.setPreferredSize(new Dimension(this.getAttributes().getWidth(), this.getAttributes().getHeight()));
        this.contentPane = new Container();
        this.contentPane.setPreferredSize(new Dimension(this.getAttributes().getWidth(), this.getAttributes().getHeight() - this.attributes.getSoftKeyContainerGap()));
        super.addComponent(this.contentPane);
        try {
            this.getStyle().setBgImage(Image.createImage(IOUtility.getImageFromRES(BACKGROUND_IMAGE)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        FifaLookAndFeelManager.changeContainerBehaviour2(this);
        super.setLayout(new CoordinateLayout(new Dimension(this.attributes.getWidth(), this.attributes.getHeight())));
        this.setBaseFormStyle();
        FifaLookAndFeelManager.configScrollbarStyle();
    }

    protected Attributes getAttributes() {
        return this.attributes;
    }

    public void addComponent(Component cmp) {
        this.contentPane.addComponent(cmp);
    }

    protected SoftkeyContainer getSoftkeyComponent() {
        if (this.sfkComponent == null) {
            this.sfkComponent = new SoftkeyContainer();
            this.sfkComponent.setY(this.attributes.getHeight() - this.attributes.getSoftkeyHeight());
            this.sfkComponent.setPreferredSize(new Dimension(this.attributes.getWidth(), this.attributes.getSoftkeyHeight()));
        }
        return this.sfkComponent;
    }

    private void setBaseFormStyle() {
        Style temp = this.getStyle();
        temp.setMargin(1, 0);
        temp.setMargin(3, 0);
        temp.setMargin(0, 0);
        temp.setMargin(2, 0);
        temp.setPadding(1, 0);
        temp.setPadding(3, 0);
        temp.setPadding(0, 0);
        temp.setPadding(2, 0);
    }

    public void setLayout(Layout layout) {
        if (!layout.equals(this.getLayout())) {
            Logger.logError(this.getClass(), "You cannot set a new layout!");
        }
    }

    public void keyPressed(int keyCode) {
        if (SystemProperties.getPhonePlatform() == 2) {
            this.repaint();
        }
        if (keyCode == -1 || keyCode == -2) {
            super.keyPressed(keyCode);
        } else {
            this.getSoftkeyComponent().keyPressed(keyCode);
            this.notifyKeyPressed(keyCode);
        }
    }

    public void setKeyListener(KeyListener keyListener) {
        this.keyListener = keyListener;
    }

    public void setTouchListener(TouchListener touchListener) {
        this.touchListener = touchListener;
    }

    public void keyReleased(int keyCode) {
        if (keyCode == -6 || keyCode == -5 || keyCode == -7) {
            this.getSoftkeyComponent().keyReleased(keyCode);
        }
        super.keyReleased(keyCode);
    }

    public void pointerPressed(int x, int y) {
        this.repaint();
        if (Display.getInstance().isTouchScreenDevice()) {
            this.getSoftkeyComponent().pointerPressed(x, y += this.attributes.getPointerPressedY());
            this.notifyTouchPressed(x, y);
            super.pointerPressed(x, y);
        }
    }

    public void pointerReleased(int x, int y) {
        if (Display.getInstance().isTouchScreenDevice()) {
            this.getSoftkeyComponent().pointerReleased(x, y += this.attributes.getPointerPressedY());
            this.notifyTouchReleased(x, y);
            super.pointerReleased(x, y);
        }
    }

    public void pointerDragged(int x, int y) {
        if (Display.getInstance().isTouchScreenDevice()) {
            super.pointerDragged(x, y);
        }
    }

    public int getSelectedSoftkey() {
        return this.getSoftkeyComponent().getSelectedSoftkey();
    }

    public void setLeftSoftkeyLabel(String text) throws ComponentException {
        this.getSoftkeyComponent().setLeftSoftkeyText(text);
    }

    public void setMiddleSoftkeyLabel(String text) throws ComponentException {
        this.getSoftkeyComponent().setMiddleSoftkeyText(text);
    }

    public void setRightSoftkeyLabel(String text) throws ComponentException {
        this.getSoftkeyComponent().setRightSoftkeyText(text);
    }

    public void addSoftkey() {
        if (this.getComponentIndex(this.getSoftkeyComponent()) == -1) {
            super.addComponent(this.getSoftkeyComponent());
        }
    }

    public void clearSoftkey() {
        this.getSoftkeyComponent().clearSoftkey();
    }

    protected void setSoftkeyBgImage() {
        this.getSoftkeyComponent().setBgImage();
    }

    protected void notifyKeyPressed(int keyCode) {
        if (this.keyListener != null) {
            this.keyListener.onKeyPressed(keyCode);
        }
    }

    protected void notifyTouchPressed(int x, int y) {
        if (this.touchListener != null) {
            this.touchListener.onTouchPressed(x, y);
        }
    }

    private void notifyTouchReleased(int x, int y) {
        if (this.touchListener != null) {
            this.touchListener.onTouchReleased(x, y);
        }
    }

    public void scrollComponentToVisible(Component c) {
        if (c != null) {
            super.scrollComponentToVisible(c);
        }
    }

    protected void addMiddleSoftkey() {
        this.getSoftkeyComponent().addMiddleSoftkey();
    }

    protected void removeMiddleSoftkey() {
        this.getSoftkeyComponent().removeMiddleSoftkey();
    }

    protected void showNotify() {
        ViewFactory.getLanguage().verifyLocaleChanged();
    }

    protected void hideNotify() {
        if (SystemProperties.getPhonePlatform() == 2) {
            this.repaint();
        }
    }

    public void setSoftkeyEnabled(int keyCode, boolean isEnabled) {
        this.getSoftkeyComponent().setSoftkeyEnabled(keyCode, isEnabled);
    }
}

