/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.tabs;

import com.sonyericsson.fifa.data.PreloadedContent;
import com.sonyericsson.fifa.exceptions.ViewException;
import com.sonyericsson.fifa.model.Model;
import com.sonyericsson.fifa.model.preloadedContent.PreloadedContentListener;
import com.sonyericsson.fifa.view.FifaAbstractView;
import com.sonyericsson.fifa.view.FifaResources;
import com.sonyericsson.fifa.view.Images;
import com.sonyericsson.fifa.view.action.OpenGameAction;
import com.sonyericsson.fifa.view.action.OpenLinkAction;
import com.sonyericsson.fifa.view.action.OpenVideoAction;
import com.sonyericsson.fifa.view.action.SelectedAction;
import com.sonyericsson.fifa.view.action.UpdateFailureAction;
import com.sonyericsson.fifa.view.tabs.TabView;
import java.util.Enumeration;

public class EntertaimentView
extends TabView
implements PreloadedContentListener {
    private String firstGroup = null;

    public EntertaimentView(Model model) {
        super(3, model);
        this.mainForm.entertainmentAddGroups();
        if (model.isPreloadedContentUpdated()) {
            this.updateView();
        }
        model.addPreloadedContentListener(this);
    }

    protected int getNextTab() {
        return 1;
    }

    protected int getPreviousTab() {
        return 2;
    }

    protected void doHide() {
        super.doHide();
        this.mainForm.pauseCrossfade(2);
    }

    protected void doShow() throws ViewException {
        this.viewId = 3;
        if (!this.selectedItem && this.firstGroup != null) {
            this.mainForm.focusFirstItem(2, this.firstGroup, true);
        }
        this.selectedItem = false;
        this.mainForm.startCrossfade(2);
        this.mainForm.setKeyListener(this);
        this.mainForm.setTouchListener(this);
        this.mainForm.addSelectedItemListener(this);
        this.mainForm.show();
    }

    public void preloadedContentReady() {
        this.updateView();
    }

    public void selectedItem(int item, int subgroup) {
        this.selectedItem = true;
        SelectedAction action = null;
        switch (subgroup) {
            case 0: {
                action = new OpenVideoAction();
                break;
            }
            case 1: {
                action = new OpenLinkAction();
                break;
            }
            case 2: {
                action = new OpenGameAction();
            }
        }
        if (action != null) {
            action.setIndex(item);
            this.fireViewActionPerformed(action);
        }
    }

    public void performSoftkey() {
    }

    protected void doClearFormText() {
        if (!this.mainForm.isGroupEmpty(2)) {
            this.mainForm.refreshAll(2, true);
            this.updateView();
        } else {
            this.mainForm.refreshAll(2, true);
        }
    }

    protected void doUpdateView() {
        PreloadedContent content;
        this.mainForm.removeWaitIndicator(2);
        Enumeration en = this.model.getPreloadedVideos().elements();
        while (en.hasMoreElements()) {
            content = (PreloadedContent)en.nextElement();
            this.mainForm.addItem(2, FifaResources.getMessage("FANAPP_ENTERTAINMENT_VIDEOS_TXT"), FifaResources.getMessage(content.getTitle()), content.getSubtitle(), Images.getVideoIconDefault());
        }
        en = this.model.getPreloadedLinks().elements();
        while (en.hasMoreElements()) {
            content = (PreloadedContent)en.nextElement();
            this.mainForm.addItem(2, FifaResources.getMessage("FANAPP_ENTERTAINMENT_LINKS_TXT"), content.getTitle(), content.getSubtitle(), content.getIcon());
        }
        en = this.model.getPreloadedGames().elements();
        while (en.hasMoreElements()) {
            content = (PreloadedContent)en.nextElement();
            String subTitle = content.getSubtitle();
            if (subTitle != null) {
                subTitle = FifaResources.getMessage(subTitle);
            }
            this.mainForm.addItem(2, FifaResources.getMessage("FANAPP_ENTERTAINMENT_GAMES_TXT"), content.getTitle(), subTitle, content.getIcon());
        }
        int index = 0;
        String[] imagesPath = new String[this.model.getPreloadedPictures().size()];
        Enumeration en2 = this.model.getPreloadedPictures().elements();
        while (en2.hasMoreElements()) {
            PreloadedContent content2 = (PreloadedContent)en2.nextElement();
            imagesPath[index] = content2.getLink();
            ++index;
        }
        this.mainForm.fillEmptySpace(2);
        this.mainForm.setEntertainmentHeadline(imagesPath);
        this.mainForm.setCrossfadePosition(2, FifaAbstractView.attributes.getCrossfadePosX());
        this.mainForm.startCrossfade(2);
        if (this.model.getPreloadedVideos().size() > 0) {
            this.firstGroup = FifaResources.getMessage("FANAPP_ENTERTAINMENT_VIDEOS_TXT");
        } else if (this.model.getPreloadedLinks().size() > 0) {
            this.firstGroup = FifaResources.getMessage("FANAPP_ENTERTAINMENT_LINKS_TXT");
        } else if (this.model.getPreloadedGames().size() > 0) {
            this.firstGroup = FifaResources.getMessage("FANAPP_ENTERTAINMENT_GAMES_TXT");
        }
        this.mainForm.focusFirstItem(2, this.firstGroup, true);
        this.mainForm.revalidate();
    }

    public void preloadedContentFailed(byte reason) {
        this.fireViewActionPerformed(new UpdateFailureAction(reason, this.model.isPreloadedContentUpdated()));
    }
}

