/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.util;

import com.sun.lwuit.Display;
import com.sun.lwuit.EncodedImage;
import com.sun.lwuit.Font;
import com.sun.lwuit.Image;
import com.sun.lwuit.StaticAnimation;
import com.sun.lwuit.plaf.Border;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Resources {
    static final byte MAGIC_THEME_LEGACY = -9;
    static final byte MAGIC_ANIMATION_LEGACY = -8;
    static final byte MAGIC_INDEXED_IMAGE_LEGACY = -12;
    static final byte MAGIC_FONT_LEGACY = -10;
    static final byte MAGIC_INDEXED_FONT_LEGACY = -5;
    static final byte MAGIC_IMAGE_LEGACY = -13;
    static final byte MAGIC_FONT = -4;
    static final byte MAGIC_IMAGE = -3;
    static final byte MAGIC_L10N = -7;
    static final byte MAGIC_DATA = -6;
    static final byte MAGIC_HEADER = -1;
    private short majorVersion;
    private short minorVersion;
    static final byte MAGIC_THEME = -14;
    static final int BORDER_TYPE_EMPTY = 0;
    static final int BORDER_TYPE_LINE = 1;
    static final int BORDER_TYPE_ROUNDED = 2;
    static final int BORDER_TYPE_ETCHED_LOWERED = 4;
    static final int BORDER_TYPE_ETCHED_RAISED = 5;
    static final int BORDER_TYPE_BEVEL_RAISED = 6;
    static final int BORDER_TYPE_BEVEL_LOWERED = 7;
    static final int BORDER_TYPE_IMAGE = 8;
    private static Class classLoader = class$com$sun$lwuit$util$Resources == null ? (class$com$sun$lwuit$util$Resources = Resources.class$("com.sun.lwuit.util.Resources")) : class$com$sun$lwuit$util$Resources;
    private String[] metaData;
    private Hashtable resourceTypes = new Hashtable();
    private Hashtable resources = new Hashtable();
    private DataInputStream input;
    static /* synthetic */ Class class$com$sun$lwuit$util$Resources;

    static void setClassLoader(Class cls) {
        classLoader = cls;
    }

    Resources() {
    }

    Resources(InputStream input) throws IOException {
        this.openFile(input);
    }

    void clear() {
        this.majorVersion = 0;
        this.minorVersion = 0;
        this.resourceTypes.clear();
        this.resources.clear();
        this.input = null;
    }

    void startingEntry(String id, byte magic) {
    }

    void openFile(InputStream input) throws IOException {
        this.clear();
        this.input = new DataInputStream(input);
        int resourceCount = this.input.readShort();
        if (resourceCount < 0) {
            throw new IOException("Invalid resource file!");
        }
        block14: for (int iter = 0; iter < resourceCount; ++iter) {
            byte magic = this.input.readByte();
            String id = this.input.readUTF();
            this.startingEntry(id, magic);
            switch (magic) {
                case -1: {
                    this.readHeader();
                    continue block14;
                }
                case -14: {
                    this.setResource(id, (byte)-14, this.loadTheme(id, magic == -14));
                    continue block14;
                }
                case -3: {
                    this.setResource(id, magic, this.createImage());
                    continue block14;
                }
                case -4: {
                    this.setResource(id, magic, this.loadFont(this.input, id, false));
                    continue block14;
                }
                case -6: {
                    this.setResource(id, magic, this.createData());
                    continue block14;
                }
                case -7: {
                    this.setResource(id, magic, this.loadL10N());
                    continue block14;
                }
                case -13: {
                    this.setResource(id, (byte)-3, this.createImage());
                    continue block14;
                }
                case -12: {
                    this.setResource(id, (byte)-3, this.createPackedImage8());
                    continue block14;
                }
                case -9: {
                    this.setResource(id, (byte)-14, this.loadTheme(id, magic == -14));
                    continue block14;
                }
                case -10: {
                    this.setResource(id, (byte)-4, this.loadFont(this.input, id, false));
                    continue block14;
                }
                case -5: {
                    this.setResource(id, (byte)-4, this.loadFont(this.input, id, true));
                    continue block14;
                }
                case -8: {
                    this.setResource(id, (byte)-3, this.loadAnimation(this.input));
                    continue block14;
                }
                default: {
                    throw new IOException("Corrupt theme file unrecognized magic number: " + Integer.toHexString(magic & 0xFF));
                }
            }
        }
    }

    private void readHeader() throws IOException {
        short size = this.input.readShort();
        this.majorVersion = this.input.readShort();
        this.minorVersion = this.input.readShort();
        this.metaData = new String[this.input.readShort()];
        for (int iter = 0; iter < this.metaData.length; ++iter) {
            this.metaData[iter] = this.input.readUTF();
        }
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public String[] getMetaData() {
        return this.metaData;
    }

    public String[] getResourceNames() {
        String[] arr = new String[this.resourceTypes.size()];
        Enumeration e = this.resourceTypes.keys();
        for (int iter = 0; iter < arr.length; ++iter) {
            arr[iter] = (String)e.nextElement();
        }
        return arr;
    }

    public String[] getDataResourceNames() {
        return this.getResourceTypeNames((byte)-6);
    }

    void setResource(String id, byte type, Object value) {
        if (value == null) {
            this.resources.remove(id);
            this.resourceTypes.remove(id);
        } else {
            this.resources.put(id, value);
            this.resourceTypes.put(id, new Byte(type));
        }
    }

    public String[] getL10NResourceNames() {
        return this.getResourceTypeNames((byte)-7);
    }

    public String[] getFontResourceNames() {
        Vector<String> vec = new Vector<String>();
        Enumeration e = this.resourceTypes.keys();
        while (e.hasMoreElements()) {
            String c = (String)e.nextElement();
            if (!this.isFont(c)) continue;
            vec.addElement(c);
        }
        return Resources.toStringArray(vec);
    }

    public String[] getThemeResourceNames() {
        Vector<String> vec = new Vector<String>();
        Enumeration e = this.resourceTypes.keys();
        while (e.hasMoreElements()) {
            String c = (String)e.nextElement();
            if (!this.isTheme(c)) continue;
            vec.addElement(c);
        }
        return Resources.toStringArray(vec);
    }

    public String[] getImageResourceNames() {
        Vector<String> vec = new Vector<String>();
        Enumeration e = this.resourceTypes.keys();
        while (e.hasMoreElements()) {
            String c = (String)e.nextElement();
            if (!this.isImage(c)) continue;
            vec.addElement(c);
        }
        return Resources.toStringArray(vec);
    }

    public String[] getAnimationResourceNames() {
        return this.getResourceTypeNames((byte)-8);
    }

    byte getResourceType(String name) {
        return (Byte)this.resourceTypes.get(name);
    }

    private String[] getResourceTypeNames(byte b) {
        Vector<String> vec = new Vector<String>();
        Enumeration e = this.resourceTypes.keys();
        while (e.hasMoreElements()) {
            String c = (String)e.nextElement();
            if ((Byte)this.resourceTypes.get(c) != b) continue;
            vec.addElement(c);
        }
        return Resources.toStringArray(vec);
    }

    private static String[] toStringArray(Vector v) {
        String[] s = new String[v.size()];
        for (int iter = 0; iter < s.length; ++iter) {
            s[iter] = (String)v.elementAt(iter);
        }
        return s;
    }

    public boolean isL10N(String name) {
        byte b = (Byte)this.resourceTypes.get(name);
        return b == -7;
    }

    public boolean isTheme(String name) {
        byte b = (Byte)this.resourceTypes.get(name);
        return b == -9 || b == -14;
    }

    public boolean isFont(String name) {
        byte b = (Byte)this.resourceTypes.get(name);
        return b == -4 || b == -10 || b == -5;
    }

    public boolean isAnimation(String name) {
        byte b = (Byte)this.resourceTypes.get(name);
        return b == -8;
    }

    public boolean isData(String name) {
        byte b = (Byte)this.resourceTypes.get(name);
        return b == -6;
    }

    public boolean isImage(String name) {
        byte b = (Byte)this.resourceTypes.get(name);
        return b == -13 || b == -8 || b == -12 || b == -3;
    }

    public static Resources open(String resource) throws IOException {
        try {
            InputStream is = Display.getInstance().getResourceAsStream(classLoader, resource);
            Resources r = new Resources(is);
            is.close();
            return r;
        }
        catch (RuntimeException err) {
            err.printStackTrace();
            throw new IOException(err.getMessage());
        }
    }

    StaticAnimation loadAnimation(DataInputStream input) throws IOException {
        return StaticAnimation.createAnimation(input);
    }

    public static Resources open(InputStream resource) throws IOException {
        return new Resources(resource);
    }

    public Image getImage(String id) {
        return (Image)this.resources.get(id);
    }

    public StaticAnimation getAnimation(String id) {
        return (StaticAnimation)this.resources.get(id);
    }

    public InputStream getData(String id) {
        return new ByteArrayInputStream((byte[])this.resources.get(id));
    }

    public Hashtable getL10N(String id, String locale) {
        return (Hashtable)((Hashtable)this.resources.get(id)).get(locale);
    }

    public Enumeration listL10NLocales(String id) {
        return ((Hashtable)this.resources.get(id)).keys();
    }

    public Font getFont(String id) {
        return (Font)this.resources.get(id);
    }

    public Hashtable getTheme(String id) {
        Hashtable h = (Hashtable)this.resources.get(id);
        if (h != null && h.containsKey("uninitialized")) {
            Enumeration e = h.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (key.endsWith("font") || key.endsWith("Image") && !key.endsWith("scaledImage")) {
                    Object value = h.get(key);
                    if (value == null) {
                        throw new IllegalArgumentException("Couldn't find resource: " + key);
                    }
                    if (value instanceof String) {
                        Object o = this.resources.get(value);
                        if (o == null) {
                            throw new IllegalArgumentException("Theme entry for " + key + " could not be found: " + value);
                        }
                        h.put(key, o);
                    }
                }
                if (!key.endsWith("order")) continue;
                Border b = this.confirmBorder(h, key);
                if (this.majorVersion == 0 && this.minorVersion == 0) {
                    b.setPressedInstance(this.confirmBorder(h, key + "Pressed"));
                    b.setFocusedInstance(this.confirmBorder(h, key + "Focused"));
                    h.remove(key + "Pressed");
                    h.remove(key + "Focused");
                }
                h.put(key, b);
            }
            h.remove("uninitialized");
        }
        return h;
    }

    private Border confirmBorder(Hashtable h, String key) {
        Object val = h.get(key);
        if (val == null) {
            return null;
        }
        if (!(val instanceof Border)) {
            String[] value = (String[])val;
            if (value == null) {
                throw new IllegalArgumentException("Couldn't find resource: " + key);
            }
            Border imageBorder = this.createImageBorder(value);
            return imageBorder;
        }
        return (Border)val;
    }

    private Border createImageBorder(String[] value) {
        Image[] images = new Image[value.length];
        for (int iter = 0; iter < value.length; ++iter) {
            images[iter] = (Image)this.resources.get(value[iter]);
        }
        switch (images.length) {
            case 2: {
                return Border.createImageBorder(images[0], images[1], null);
            }
            case 3: {
                return Border.createImageBorder(images[0], images[1], images[2]);
            }
            case 8: {
                return Border.createImageBorder(images[0], images[1], images[2], images[3], images[4], images[5], images[6], images[7], null);
            }
        }
        return Border.createImageBorder(images[0], images[1], images[2], images[3], images[4], images[5], images[6], images[7], images[8]);
    }

    Object getResourceObject(String res) {
        return this.resources.get(res);
    }

    Image createImage() throws IOException {
        if (this.majorVersion == 0 && this.minorVersion == 0) {
            byte[] data = new byte[this.input.readInt()];
            this.input.readFully(data, 0, data.length);
            return EncodedImage.create(data);
        }
        int type = this.input.readByte() & 0xFF;
        switch (type) {
            case 241: 
            case 242: {
                byte[] data = new byte[this.input.readInt()];
                this.input.readFully(data, 0, data.length);
                return EncodedImage.create(data);
            }
            case 243: {
                return this.createPackedImage8();
            }
            case 244: {
                return this.loadAnimation(this.input);
            }
            case 245: {
                int svgSize = this.input.readInt();
                if (Image.isSVGSupported()) {
                    byte[] s = new byte[svgSize];
                    this.input.readFully(s);
                    String baseURL = this.input.readUTF();
                    boolean animated = this.input.readBoolean();
                    this.loadSVGRatios(this.input);
                    byte[] fallback = new byte[this.input.readInt()];
                    if (fallback.length > 0) {
                        this.input.readFully(fallback, 0, fallback.length);
                    }
                    return Image.createSVG(baseURL, animated, s);
                }
                svgSize = (int)((long)svgSize - this.input.skip(svgSize));
                while (svgSize > 0) {
                    svgSize = (int)((long)svgSize - this.input.skip(svgSize));
                }
                this.input.readUTF();
                this.input.readBoolean();
                this.input.readFloat();
                this.input.readFloat();
                byte[] fallback = new byte[this.input.readInt()];
                this.input.readFully(fallback, 0, fallback.length);
                return EncodedImage.create(fallback);
            }
        }
        throw new IOException("Illegal type while creating image: " + Integer.toHexString(type));
    }

    void loadSVGRatios(DataInputStream input) throws IOException {
        input.readFloat();
        input.readFloat();
    }

    private byte[] createData() throws IOException {
        byte[] data = new byte[this.input.readInt()];
        this.input.readFully(data);
        return data;
    }

    Font loadFont(DataInputStream input, String id, boolean packed) throws IOException {
        boolean bitmapIncluded;
        boolean lookupIncluded;
        if (this.majorVersion == 0 && this.minorVersion == 0) {
            Image bitmap = packed ? this.createPackedImage8() : this.createImage();
            int charCount = input.readShort();
            int[] cutOffsets = new int[charCount];
            int[] charWidth = new int[charCount];
            for (int iter = 0; iter < charCount; ++iter) {
                cutOffsets[iter] = input.readShort();
                charWidth[iter] = input.readByte();
            }
            String charset = input.readUTF();
            Font old = Font.getBitmapFont(id);
            if (old != null) {
                return old;
            }
            return Font.createBitmapFont(id, bitmap, cutOffsets, charWidth, charset);
        }
        int fallback = input.readByte() & 0xFF;
        boolean trueTypeIncluded = input.readBoolean();
        Font font = null;
        if (trueTypeIncluded) {
            int size = input.readInt();
            if (Font.isTrueTypeFileSupported()) {
                font = Font.createTrueTypeFont(input);
            } else {
                while (size > 0) {
                    size = (int)((long)size - input.skip(size));
                }
            }
        }
        if (lookupIncluded = input.readBoolean()) {
            String lookup = input.readUTF();
            if (font == null && Font.isCreationByStringSupported()) {
                font = Font.create(lookup);
            }
        }
        if (bitmapIncluded = input.readBoolean()) {
            font = this.loadBitmapFont(input, id, font);
        }
        if (font != null) {
            return font;
        }
        return Font.createSystemFont(fallback & 0x60, fallback & 7, fallback & 0x18);
    }

    void readRenderingHint(DataInputStream i) throws IOException {
        i.readByte();
    }

    Font loadBitmapFont(DataInputStream input, String id, Font font) throws IOException {
        int iter;
        Image bitmap = this.createImage();
        int charCount = input.readShort();
        int[] cutOffsets = new int[charCount];
        int[] charWidth = new int[charCount];
        for (iter = 0; iter < charCount; ++iter) {
            cutOffsets[iter] = input.readShort();
        }
        for (iter = 0; iter < charCount; ++iter) {
            charWidth[iter] = input.readByte();
        }
        String charset = input.readUTF();
        this.readRenderingHint(input);
        if (font == null && Font.isBitmapFontEnabled()) {
            Font old = Font.getBitmapFont(id);
            if (old != null) {
                return old;
            }
            return Font.createBitmapFont(id, bitmap, cutOffsets, charWidth, charset);
        }
        return font;
    }

    Hashtable loadTheme(String id, boolean newerVersion) throws IOException {
        Hashtable<String, Object> theme = new Hashtable<String, Object>();
        theme.put("name", id);
        theme.put("uninitialized", Boolean.TRUE);
        int size = this.input.readShort();
        for (int iter = 0; iter < size; ++iter) {
            String key = this.input.readUTF();
            if (key.endsWith("Color")) {
                theme.put(key, Integer.toHexString(this.input.readInt()));
                continue;
            }
            if (key.endsWith("ransparency")) {
                theme.put(key, "" + (this.input.readByte() & 0xFF));
                continue;
            }
            if (key.endsWith("adding") || key.endsWith("argin")) {
                int p1 = this.input.readByte() & 0xFF;
                int p2 = this.input.readByte() & 0xFF;
                int p3 = this.input.readByte() & 0xFF;
                int p4 = this.input.readByte() & 0xFF;
                theme.put(key, "" + p1 + "," + p2 + "," + p3 + "," + p4);
                continue;
            }
            if (key.endsWith("order")) {
                if (this.majorVersion == 0 && this.minorVersion == 0) {
                    theme.put(key, this.createBorder(this.input, newerVersion));
                    if (!newerVersion) continue;
                    if (this.input.readBoolean()) {
                        theme.put(key + "Pressed", this.createBorder(this.input, true));
                    }
                    if (!this.input.readBoolean()) continue;
                    theme.put(key + "Focused", this.createBorder(this.input, true));
                    continue;
                }
                int borderType = this.input.readShort() & 0xFFFF;
                Object b = this.createBorder(this.input, borderType);
                theme.put(key, b);
                continue;
            }
            if (key.endsWith("ont")) {
                Font f;
                if (this.input.readBoolean()) {
                    String fontId = this.input.readUTF();
                    f = (Font)this.resources.get(fontId);
                    if (f == null) {
                        theme.put(key, fontId);
                        continue;
                    }
                } else {
                    f = Font.createSystemFont(this.input.readByte(), this.input.readByte(), this.input.readByte());
                }
                theme.put(key, f);
                continue;
            }
            if (key.endsWith("ackground")) {
                int type = this.input.readByte() & 0xFF;
                int pos = key.indexOf(46);
                key = pos > -1 ? key.substring(0, pos) : "";
                theme.put(key + "bgType", new Byte((byte)type));
                switch (type) {
                    case 241: 
                    case 244: {
                        theme.put(key + "bgImage", this.input.readUTF());
                        break;
                    }
                    case 242: 
                    case 243: 
                    case 245: {
                        String imageName = this.input.readUTF();
                        theme.put(key + "bgImage", imageName);
                        byte align = this.input.readByte();
                        theme.put(key + "bgAlign", new Byte(align));
                        break;
                    }
                    case 246: 
                    case 247: {
                        Float c = new Float(0.5f);
                        theme.put(key + "bgGradient", new Object[]{new Integer(this.input.readInt()), new Integer(this.input.readInt()), c, c, new Float(1.0f)});
                        break;
                    }
                    case 248: {
                        int c1 = this.input.readInt();
                        int c2 = this.input.readInt();
                        float f1 = this.input.readFloat();
                        float f2 = this.input.readFloat();
                        float radialSize = 1.0f;
                        if (this.minorVersion > 1) {
                            radialSize = this.input.readFloat();
                        }
                        theme.put(key + "bgGradient", new Object[]{new Integer(c1), new Integer(c2), new Float(f1), new Float(f2), new Float(radialSize)});
                    }
                }
                continue;
            }
            if (key.endsWith("bgImage")) {
                String imageId = this.input.readUTF();
                Image i = (Image)this.resources.get(imageId);
                if (i == null) {
                    theme.put(key, imageId);
                    continue;
                }
                theme.put(key, i);
                continue;
            }
            if (key.endsWith("scaledImage")) {
                if (this.input.readBoolean()) {
                    theme.put(key, "true");
                    continue;
                }
                theme.put(key, "false");
                continue;
            }
            if (key.endsWith("bgType") || key.endsWith("bgAlign")) {
                theme.put(key, new Byte(this.input.readByte()));
                continue;
            }
            if (key.endsWith("bgGradient")) {
                if (this.minorVersion < 2) {
                    theme.put(key, new Object[]{new Integer(this.input.readInt()), new Integer(this.input.readInt()), new Float(this.input.readFloat()), new Float(this.input.readFloat())});
                    continue;
                }
                theme.put(key, new Object[]{new Integer(this.input.readInt()), new Integer(this.input.readInt()), new Float(this.input.readFloat()), new Float(this.input.readFloat()), new Float(this.input.readFloat())});
                continue;
            }
            throw new IOException("Error while trying to read theme property: " + key);
        }
        return theme;
    }

    private Object createBorder(DataInputStream input, int type) throws IOException {
        switch (type) {
            case 65281: {
                return Border.getEmpty();
            }
            case 65282: {
                if (input.readBoolean()) {
                    return Border.createLineBorder(input.readByte());
                }
                return Border.createLineBorder(input.readByte(), input.readInt());
            }
            case 65283: {
                if (input.readBoolean()) {
                    return Border.createRoundBorder(input.readByte(), input.readByte());
                }
                return Border.createRoundBorder((int)input.readByte(), (int)input.readByte(), input.readInt());
            }
            case 65284: {
                if (input.readBoolean()) {
                    return Border.createEtchedLowered();
                }
                return Border.createEtchedLowered(input.readInt(), input.readInt());
            }
            case 65285: {
                if (input.readBoolean()) {
                    return Border.createEtchedRaised();
                }
                return Border.createEtchedRaised(input.readInt(), input.readInt());
            }
            case 65287: {
                if (input.readBoolean()) {
                    return Border.createBevelRaised();
                }
                return Border.createBevelRaised(input.readInt(), input.readInt(), input.readInt(), input.readInt());
            }
            case 65286: {
                if (input.readBoolean()) {
                    return Border.createBevelLowered();
                }
                return Border.createBevelLowered(input.readInt(), input.readInt(), input.readInt(), input.readInt());
            }
            case 65288: {
                String[] imageBorder = this.readImageBorder(input);
                return imageBorder;
            }
        }
        return null;
    }

    private Object createBorder(DataInputStream input, boolean newerVersion) throws IOException {
        byte type = input.readByte();
        switch (type) {
            case 0: {
                return Border.getEmpty();
            }
            case 1: {
                if (input.readBoolean()) {
                    return Border.createLineBorder(input.readByte());
                }
                return Border.createLineBorder(input.readByte(), input.readInt());
            }
            case 2: {
                if (input.readBoolean()) {
                    return Border.createRoundBorder(input.readByte(), input.readByte());
                }
                return Border.createRoundBorder((int)input.readByte(), (int)input.readByte(), input.readInt());
            }
            case 4: {
                if (input.readBoolean()) {
                    return Border.createEtchedLowered();
                }
                return Border.createEtchedLowered(input.readInt(), input.readInt());
            }
            case 5: {
                if (input.readBoolean()) {
                    return Border.createEtchedRaised();
                }
                return Border.createEtchedRaised(input.readInt(), input.readInt());
            }
            case 6: {
                if (input.readBoolean()) {
                    return Border.createBevelRaised();
                }
                return Border.createBevelRaised(input.readInt(), input.readInt(), input.readInt(), input.readInt());
            }
            case 7: {
                if (input.readBoolean()) {
                    return Border.createBevelLowered();
                }
                return Border.createBevelLowered(input.readInt(), input.readInt(), input.readInt(), input.readInt());
            }
            case 8: {
                String[] imageBorder = this.readImageBorder(input);
                if (!newerVersion) {
                    input.readBoolean();
                }
                return imageBorder;
            }
        }
        return null;
    }

    private String[] readImageBorder(DataInputStream input) throws IOException {
        int size = input.readByte();
        String[] imageBorder = new String[size];
        for (int iter = 0; iter < size; ++iter) {
            imageBorder[iter] = input.readUTF();
        }
        return imageBorder;
    }

    private Hashtable loadL10N() throws IOException {
        int iter;
        Hashtable l10n = new Hashtable();
        int keys = this.input.readShort();
        short languages = this.input.readShort();
        String[] keyArray = new String[keys];
        for (iter = 0; iter < keys; ++iter) {
            String key;
            keyArray[iter] = key = this.input.readUTF();
        }
        for (iter = 0; iter < languages; ++iter) {
            Hashtable<String, String> currentLanguage = new Hashtable<String, String>();
            String lang = this.input.readUTF();
            l10n.put(lang, currentLanguage);
            for (int valueIter = 0; valueIter < keys; ++valueIter) {
                currentLanguage.put(keyArray[valueIter], this.input.readUTF());
            }
        }
        return l10n;
    }

    private Image createPackedImage8() throws IOException {
        int size = this.input.readByte() & 0xFF;
        if (size == 0) {
            size = 256;
        }
        int[] palette = new int[size];
        for (int iter = 0; iter < palette.length; ++iter) {
            palette[iter] = this.input.readInt();
        }
        short width = this.input.readShort();
        short height = this.input.readShort();
        byte[] data = new byte[width * height];
        this.input.readFully(data, 0, data.length);
        return Image.createIndexed(width, height, palette, data);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

