/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view;

import com.sonyericsson.fifa.data.feed.Enclosure;
import com.sonyericsson.fifa.exceptions.ViewException;
import com.sonyericsson.fifa.model.Model;
import com.sonyericsson.fifa.utils.attributes.Attributes;
import com.sonyericsson.fifa.utils.attributes.VerifyScreenDimension;
import com.sonyericsson.fifa.view.AbstractView;
import com.sonyericsson.fifa.view.FifaResources;
import com.sonyericsson.fifa.view.Images;
import com.sonyericsson.fifa.view.ViewFactory;
import com.sonyericsson.fifa.view.components.listener.KeyListener;
import com.sonyericsson.fifa.view.components.listener.SelectableItemListener;
import com.sonyericsson.fifa.view.components.listener.TouchListener;
import com.sonyericsson.fifa.view.language.Language;
import com.sonyericsson.fifa.view.language.UpdateLanguageListener;
import com.sun.lwuit.Display;
import com.sun.lwuit.Image;
import java.util.Vector;

public abstract class FifaAbstractView
extends AbstractView
implements UpdateLanguageListener,
KeyListener,
TouchListener,
SelectableItemListener {
    private Language language = ViewFactory.getLanguage();
    protected static final Attributes attributes = VerifyScreenDimension.getAttributesInstance();

    public FifaAbstractView(int viewId, Model model) {
        super(viewId, model);
        this.language.addLanguageListener(this);
    }

    protected Language getLanguage() {
        return this.language;
    }

    protected String getTeamGroup(String teamCode) {
        String teamGroup = null;
        if (this.model != null) {
            teamGroup = this.model.getGroupByTeamCode(teamCode);
            teamGroup = teamGroup == null ? "" : FifaResources.getMessage("FANAPP_TOURNAMSTATUS_" + teamGroup + "_TXT");
        }
        return teamGroup;
    }

    protected Vector getDefaultHeadLinePictures() {
        Vector<Image> icon = new Vector<Image>();
        icon.addElement(Images.getHeadlineIconDefault());
        return icon;
    }

    protected void updateView() {
        if (Display.getInstance().isEdt()) {
            this.doUpdateView();
        } else {
            Display.getInstance().callSerially(new Runnable(){

                public void run() {
                    FifaAbstractView.this.doUpdateView();
                }
            });
        }
    }

    protected void updateThumbnail(final int index, final Enclosure thumbnail) {
        if (Display.getInstance().isEdt()) {
            this.doUpdateThumbnail(index, thumbnail);
        } else {
            Display.getInstance().callSerially(new Runnable(){

                public void run() {
                    FifaAbstractView.this.doUpdateThumbnail(index, thumbnail);
                }
            });
        }
    }

    protected abstract void doUpdateView();

    protected void doUpdateThumbnail(int index, Enclosure thumbnail) {
    }

    public void onKeyPressed(int keyCode) {
    }

    public void onKeyReleased(int keyCode) {
    }

    public void onLongKeyPressed(int keyCode) {
    }

    public void onLongTouchPressed(int valX, int valY) {
    }

    public void onTouchDragged(int valX, int valY) {
    }

    public void onTouchPressed(int valX, int valY) {
    }

    public void onTouchReleased(int valX, int valY) {
    }

    public void updateLanguage() {
        this.clearFormText();
    }

    public void selectedItem(int item, int subgroup) {
    }

    public void pausedNotify() {
    }

    public void hide() {
        if (Display.getInstance().isEdt()) {
            this.doHide();
        } else {
            Display.getInstance().callSeriallyAndWait(new Runnable(){

                public void run() {
                    FifaAbstractView.this.doHide();
                }
            });
        }
    }

    protected void doHide() {
        this.language.removeLanguageListener(this);
    }

    public void show() throws ViewException {
        if (Display.getInstance().isEdt()) {
            this.doShow();
        } else {
            Display.getInstance().callSeriallyAndWait(new Runnable(){

                public void run() {
                    try {
                        FifaAbstractView.this.doShow();
                    }
                    catch (ViewException ve) {
                        ve.printStackTrace();
                    }
                }
            });
        }
    }

    public void clearFormText() {
        if (Display.getInstance().isEdt()) {
            this.doClearFormText();
        } else {
            Display.getInstance().callSeriallyAndWait(new Runnable(){

                public void run() {
                    try {
                        FifaAbstractView.this.doClearFormText();
                    }
                    catch (Exception ve) {
                        ve.printStackTrace();
                    }
                }
            });
        }
    }

    protected abstract void doShow() throws ViewException;

    public void showNotify() {
    }

    public void onKeyRepeated(int keyCode) {
    }

    protected abstract void performSoftkey();

    protected abstract void doClearFormText();
}

