/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.player;

import com.nokia.mid.ui.DirectUtils;
import com.sonyericsson.fifa.utils.Logger;
import com.sonyericsson.fifa.utils.SystemProperties;
import com.sonyericsson.fifa.view.FifaResources;
import com.sonyericsson.fifa.view.VideoPlayer;
import com.sonyericsson.fifa.view.VideoPlayerListener;
import com.sonyericsson.fifa.view.ViewFactory;
import com.sonyericsson.fifa.view.components.BackAction;
import com.sonyericsson.fifa.view.exceptions.VideoPlayerException;
import com.sonyericsson.fifa.view.player.VideoPlayerConstants;
import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Sprite;

public class VideoPlayerGui
extends GameCanvas
implements Runnable,
VideoPlayerListener {
    private static final int STEP = 5;
    private static final Font FONT_DEFAULT = Font.getFont((int)0, (int)0, (int)0);
    private final BackAction listener;
    private Sprite[] sprites = null;
    private Image[] images = null;
    private ImageLocation[] locations = null;
    private ImageLocation progressBarLocation = null;
    private ImageLocation backCommandLocation = null;
    private ImageLocation titleLocation = null;
    private ImageLocation currentTimeLocation = null;
    private ImageLocation durationTimeLocation = null;
    private Dimension backCommandDimension = null;
    private Dimension titleSpriteDimension = null;
    private Dimension currentSpriteDimension = null;
    private Dimension durationSpriteDimension = null;
    private boolean showInfo = true;
    private String title = "";
    private String currentTimeStr = "00:00";
    private String durationTimeStr = "00:00";
    private VideoPlayer player = null;
    private int height = -1;
    private int width = -1;
    private byte mediaPosition = 0;
    private boolean running = false;
    private long hidePanelTime;
    static /* synthetic */ Class class$0;

    public VideoPlayerGui(BackAction listener) throws IOException {
        super(false);
        this.listener = listener;
        this.width = SystemProperties.getDisplayWidth();
        this.height = SystemProperties.getDisplayHeight();
        this.setFullScreenMode(true);
        this.initializeAll();
        this.startThread();
    }

    public void setPlayer(VideoPlayer player, String filename, String title) throws VideoPlayerException {
        this.player = player;
        this.title = title;
        this.player.loadVideo(filename);
        this.player.setDisplayLocation(0, 0);
        this.player.setDisplaySize(this.width, this.height);
        this.player.setCanvas((Canvas)this);
        this.player.setVideoPlayerListener(this);
        this.mediaPosition = 0;
        this.printInfo(player);
    }

    void printInfo(VideoPlayer player) {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.sonyericsson.fifa.view.player.VideoPlayerGui");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Logger.logInfo(clazz, "Filename: " + this.title);
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("com.sonyericsson.fifa.view.player.VideoPlayerGui");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Logger.logInfo(clazz2, "Display Width: " + player.getDisplayWidth());
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("com.sonyericsson.fifa.view.player.VideoPlayerGui");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Logger.logInfo(clazz3, "Display Height: " + player.getDisplayHeight());
            Class<?> clazz4 = class$0;
            if (clazz4 == null) {
                try {
                    clazz4 = class$0 = Class.forName("com.sonyericsson.fifa.view.player.VideoPlayerGui");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Logger.logInfo(clazz4, "Display Location X: " + player.getDisplayLocationX());
            Class<?> clazz5 = class$0;
            if (clazz5 == null) {
                try {
                    clazz5 = class$0 = Class.forName("com.sonyericsson.fifa.view.player.VideoPlayerGui");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Logger.logInfo(clazz5, "Display Location Y: " + player.getDisplayLocationY());
            Class<?> clazz6 = class$0;
            if (clazz6 == null) {
                try {
                    clazz6 = class$0 = Class.forName("com.sonyericsson.fifa.view.player.VideoPlayerGui");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Logger.logInfo(clazz6, "Source Width: " + player.getSourceWidth());
            Class<?> clazz7 = class$0;
            if (clazz7 == null) {
                try {
                    clazz7 = class$0 = Class.forName("com.sonyericsson.fifa.view.player.VideoPlayerGui");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Logger.logInfo(clazz7, "Source Height: " + player.getSourceHeight());
            Class<?> clazz8 = class$0;
            if (clazz8 == null) {
                try {
                    clazz8 = class$0 = Class.forName("com.sonyericsson.fifa.view.player.VideoPlayerGui");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Logger.logInfo(clazz8, "------------------------------------------");
        }
        catch (VideoPlayerException e) {
            e.printStackTrace();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.sonyericsson.fifa.view.player.VideoPlayerGui");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Logger.logError(clazz, e.getMessage());
        }
    }

    private void startThread() {
        new Thread(this).start();
    }

    public void close() {
        this.running = false;
    }

    public void run() {
        this.running = true;
        while (this.running) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (!this.showInfo) continue;
            if (System.currentTimeMillis() > this.hidePanelTime) {
                this.hidePanel();
            }
            this.repaint();
        }
    }

    public void paint(Graphics g) {
        int i = 0;
        while (i < 11) {
            if (i == 9 || i == 10) {
                if (this.sprites[i].isVisible()) {
                    this.sprites[i].paint(g);
                }
            } else if (i == 0 || i == 1) {
                this.sprites[i].paint(g);
                this.drawSideBars(g);
            } else {
                this.sprites[i].paint(g);
            }
            ++i;
        }
        if (this.showInfo) {
            this.durationTimeStr = this.player.getTotalDuration();
            this.currentTimeStr = this.player.getCurrentTime();
            this.drawProgress(g);
            this.drawInformation(g);
            if (this.player != null) {
                this.fillProgress(g);
            }
        }
    }

    void drawSideBars(Graphics g) {
        if (this.player == null) {
            return;
        }
        int videoHeight = -1;
        try {
            videoHeight = this.player.getDisplayHeight();
        }
        catch (VideoPlayerException e) {
            e.printStackTrace();
        }
        int y = (this.height - videoHeight) / 2;
        g.fillRect(0, 0, this.height, y);
        g.fillRect(0, y + videoHeight, this.height, y);
    }

    protected void keyPressed(int keyCode) {
        this.showPanel();
        if (keyCode == -1) {
            this.leftKeyPressed();
        } else if (keyCode == -2) {
            this.rightKeyPressed();
        }
        if (keyCode == -5) {
            this.fireKeyPressed();
        } else if (keyCode == -7) {
            this.listener.back();
        } else if (keyCode != -6) {
            super.keyPressed(keyCode);
        }
        if (keyCode == -44 || keyCode == -43) {
            this.scheduleTask();
        }
    }

    protected void keyReleased(int keyCode) {
        if (this.showInfo) {
            this.scheduleTask();
        }
        super.keyReleased(keyCode);
    }

    private void leftKeyPressed() {
        try {
            this.mediaPosition = (byte)(this.player.getCurrentPercentage() - 5);
            if (this.mediaPosition <= 0) {
                this.mediaPosition = 0;
            }
            this.player.seekVideo(this.mediaPosition);
        }
        catch (VideoPlayerException e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.sonyericsson.fifa.view.player.VideoPlayerGui");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Logger.logError(clazz, "Unable to seek position in current video.");
        }
    }

    private void rightKeyPressed() {
        try {
            this.mediaPosition = (byte)(this.player.getCurrentPercentage() + 5);
            if (this.mediaPosition < 95) {
                this.player.seekVideo(this.mediaPosition);
            }
        }
        catch (VideoPlayerException e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.sonyericsson.fifa.view.player.VideoPlayerGui");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Logger.logError(clazz, "Unable to seek position in current video.");
        }
    }

    private void fireKeyPressed() {
        block10: {
            try {
                if (this.player.getCurrentState() == 2 || this.player.getCurrentState() == 6 || this.player.getCurrentState() == 7) {
                    this.playVideo();
                    break block10;
                }
                if (this.player.getCurrentState() == 4 || this.player.getCurrentState() == 3) {
                    this.stopVideo();
                    break block10;
                }
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.sonyericsson.fifa.view.player.VideoPlayerGui");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Logger.logError(clazz, "Invalid state for Video Player");
            }
            catch (VideoPlayerException e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.sonyericsson.fifa.view.player.VideoPlayerGui");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Logger.logError(clazz, e.getMessage());
            }
        }
    }

    public void playVideo() throws VideoPlayerException {
        this.player.play();
        this.scheduleTask();
        this.showPanel();
    }

    public void stopVideo() throws VideoPlayerException {
        this.player.stop();
        this.showPanel();
    }

    private void setSpriteLocations() {
        int i = 0;
        while (i < 11) {
            this.sprites[i].setPosition(this.locations[i].x, this.locations[i].y);
            ++i;
        }
    }

    private void initializeAll() throws IOException {
        this.loadImages();
        this.createLocations();
        this.createDimensions();
        this.setupLocations();
        this.setSpriteLocations();
        this.scheduleTask();
    }

    private void loadImages() throws IOException {
        this.images = new Image[11];
        this.sprites = new Sprite[11];
        int i = 0;
        while (i < 11) {
            String newPath = "/playerCommands/" + VideoPlayerConstants.IMAGE_FILES[i];
            this.images[i] = Image.createImage((String)newPath);
            this.sprites[i] = new Sprite(this.images[i]);
            this.sprites[i].setTransform(5);
            ++i;
        }
    }

    private void createLocations() {
        this.locations = new ImageLocation[11];
        int i = 0;
        while (i < 11) {
            this.locations[i] = new ImageLocation();
            ++i;
        }
        this.progressBarLocation = new ImageLocation(5, 40);
        this.backCommandLocation = new ImageLocation(205, 275);
        this.titleLocation = new ImageLocation(205, 5);
        this.currentTimeLocation = new ImageLocation(6, 40);
        this.durationTimeLocation = new ImageLocation(6, 175);
    }

    private void createDimensions() {
        this.backCommandDimension = new Dimension(50, 30);
        this.titleSpriteDimension = new Dimension(220, 30);
        this.currentSpriteDimension = new Dimension(60, 30);
        this.durationSpriteDimension = new Dimension(60, 30);
    }

    private void setupLocations() {
        this.locations[2].x = 75;
        this.locations[2].y = 212;
        this.locations[3].x = 102;
        this.locations[3].y = 245;
        this.locations[4].x = 102;
        this.locations[4].y = 243;
        this.locations[5].x = 109;
        this.locations[5].y = 210;
        this.locations[6].x = 109;
        this.locations[6].y = 280;
        this.locations[7].x = -100;
        this.locations[7].y = -100;
        this.locations[8].x = -100;
        this.locations[8].y = -100;
        this.locations[9].x = 0;
        this.locations[9].y = 0;
        this.locations[10].x = 0;
        this.locations[10].y = 2;
        this.locations[0].x = SystemProperties.getDisplayWidth() - this.images[0].getHeight() + 10;
        this.locations[0].y = 0;
        this.locations[1].x = -10;
        this.locations[1].y = 0;
    }

    private void drawProgress(Graphics g) {
        int w = -1;
        int h = -1;
        g.setColor(0x888888);
        w = 8;
        h = 180;
        g.fillRect(this.progressBarLocation.x, this.progressBarLocation.y, w, h);
    }

    private void fillProgress(Graphics g) {
        int w = -1;
        int h = -1;
        g.setColor(0xFFFFFF);
        if (this.player.getCurrentState() == 7) {
            w = 8;
            h = 180;
        } else {
            int progressValue = -1;
            progressValue = 180 * this.player.getCurrentPercentage() / 100;
            w = 8;
            h = progressValue;
        }
        g.fillRect(this.progressBarLocation.x, this.progressBarLocation.y, w, h);
    }

    private Sprite createTextSprite(String text, Font font, ImageLocation location, Dimension dimension) {
        Sprite sprite = null;
        Graphics temp = null;
        Image image = null;
        image = DirectUtils.createImage((int)dimension.width, (int)dimension.height, (int)0);
        sprite = new Sprite(image);
        sprite.setTransform(5);
        sprite.setPosition(location.x, location.y);
        temp = image.getGraphics();
        temp.setColor(0xFFFFFF);
        temp.setFont(font);
        temp.drawString(text, 0, 0, 20);
        return sprite;
    }

    private void drawInformation(Graphics g) {
        Sprite backCmdSprite = null;
        Sprite titleSprite = null;
        Sprite currentSprite = null;
        Sprite durationSprite = null;
        backCmdSprite = this.createTextSprite(FifaResources.getMessage("FANAPP_SK_BACK_TXT"), FONT_DEFAULT, this.backCommandLocation, this.backCommandDimension);
        titleSprite = this.createTextSprite(this.title, FONT_DEFAULT, this.titleLocation, this.titleSpriteDimension);
        currentSprite = this.createTextSprite(this.currentTimeStr, FONT_DEFAULT, this.currentTimeLocation, this.currentSpriteDimension);
        durationSprite = this.createTextSprite(this.durationTimeStr, FONT_DEFAULT, this.durationTimeLocation, this.durationSpriteDimension);
        backCmdSprite.paint(g);
        titleSprite.paint(g);
        currentSprite.paint(g);
        durationSprite.paint(g);
    }

    public void notifyVideoStopped() {
        if (this.player.getCurrentState() == 7) {
            this.showPanel();
        }
    }

    private void showPanel() {
        if (this.player == null) {
            return;
        }
        int i = 0;
        while (i < 11) {
            this.sprites[i].setVisible(true);
            ++i;
        }
        this.showInfo = true;
        this.panelForStatus();
        this.repaint();
    }

    private void hidePanel() {
        int i = 0;
        while (i < 11) {
            this.sprites[i].setVisible(false);
            ++i;
        }
        this.showInfo = false;
    }

    private void panelForStatus() {
        if (this.player == null) {
            return;
        }
        if (this.player.getCurrentState() == 4 || this.player.getCurrentState() == 3) {
            this.sprites[3].setVisible(false);
            this.sprites[4].setVisible(true);
            this.sprites[9].setVisible(true);
            this.sprites[10].setVisible(false);
            this.sprites[7].setVisible(false);
            this.sprites[8].setVisible(false);
        } else {
            this.sprites[3].setVisible(true);
            this.sprites[4].setVisible(false);
            this.sprites[9].setVisible(false);
            this.sprites[10].setVisible(true);
            this.sprites[7].setVisible(false);
            this.sprites[8].setVisible(false);
        }
    }

    void scheduleTask() {
        this.hidePanelTime = System.currentTimeMillis() + 5000L;
    }

    protected void hideNotify() {
        super.hideNotify();
        if (this.player.getCurrentState() == 4) {
            try {
                this.stopVideo();
            }
            catch (VideoPlayerException e) {
                e.printStackTrace();
            }
        }
    }

    protected void showNotify() {
        ViewFactory.getLanguage().verifyLocaleChanged();
        this.repaint();
        try {
            this.playVideo();
        }
        catch (VideoPlayerException e) {
            e.printStackTrace();
        }
    }

    static class Dimension {
        public int width;
        public int height;

        public Dimension() {
            this(0, 0);
        }

        public Dimension(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }

    static class ImageLocation {
        public int x;
        public int y;

        public ImageLocation() {
            this(0, 0);
        }

        public ImageLocation(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

