/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.twitter;

import com.sonyericsson.twitter.LinkedText;
import com.sonyericsson.twitter.Tweet;
import com.sonyericsson.twitter.TwitterButton;
import com.sonyericsson.twitter.TwitterClient;
import com.sonyericsson.twitter.Utils;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import se.vitamin.ui.UI;
import se.vitamin.ui.Window;

public class AvatarButton
extends TwitterButton {
    private LinkedText bodyText;
    private String header;
    private Tweet _t;
    private static final int AVATAR_Y_OFFSET = 5;
    private static final int AVATAR_X_OFFSET = 7;
    private static final int TEXT_X_OFFSET = 64;
    private static final int TITLE_Y_OFFSET = 10;
    private static final int MIN_HEIGHT = 60;
    private static final int MAX_TEXT_WIDTH = UI.SCREEN_WIDTH - 98;
    private static final int MAX_LINES = 10;
    private int color = 2;
    private int color2 = 3;
    private int linkCount = 0;

    public AvatarButton(Window parent, int id, Tweet t, Font f1, Font f2) {
        super(parent, id, -1, -1, f1, f2);
        this._t = t;
        if (f1 != null) {
            this._h = f1.getHeight() + 10;
            this.header = t.screenname;
            if (UI.smallFont.stringWidth(this.header) > MAX_TEXT_WIDTH) {
                int index = 0;
                while (UI.smallFont.stringWidth(this.header.substring(0, index + 1) + "...") < MAX_TEXT_WIDTH) {
                    ++index;
                }
                this.header = this.header.substring(0, index) + "...";
            }
            this._titleW = f1.stringWidth(this.header);
            this._subtitleW = f1.stringWidth(t.text);
        }
        if (t.text != null) {
            this.bodyText = new LinkedText(t.text, 0, 0xFFFFFF, 0, 16, MAX_TEXT_WIDTH, 10, false, false, false);
            this._h += this.bodyText.getHeight() + 10;
            this.linkCount = this.bodyText.getNumberOfLinks();
        }
        if (this._h < 60) {
            this._h = 60;
        }
        if (t.text != null && this._font2 != null) {
            this._subtitleW = f2.stringWidth(t.text);
        }
        this._minW = this._titleW < this._subtitleW ? 48 + this._subtitleW + 10 : 48 + this._titleW + 10;
        this._w = 230;
        this._minW = 230;
        this._titleX = (this._minW - this._titleW) / 2;
        this._subtitleX = (this._minW - this._subtitleW) / 2;
    }

    public void setColors(int active, int inactive) {
        this.color = active;
        this.color2 = inactive;
    }

    public void setTextColors(int active, int inactive) {
        this._activeColor = active;
        this._inactiveColor = inactive;
    }

    public String getTitle() {
        return this.header;
    }

    public boolean activateText() {
        return this.bodyText.setSelected(0);
    }

    public boolean nextLink() {
        return this.bodyText.selectNext();
    }

    public boolean prevLink() {
        return this.bodyText.selectPrev();
    }

    public String getLink() {
        return this.bodyText.getSelectedLinkURL();
    }

    public boolean activeLastLink() {
        if (this.linkCount > 0) {
            return this.bodyText.setSelected(this.linkCount - 1);
        }
        return false;
    }

    protected void paintBackground(Graphics g, int x, int y) {
        if (this._active) {
            Utils.drawGradient(x, y, this._w, this._h, this.color2, g);
        } else {
            Utils.drawGradient(x, y, this._w, this._h, this.color, g);
        }
        TwitterClient.drawRoundBorder(g, x, y, this._w, this._h, this._active);
    }

    public void paint(Graphics g, int x, int y) {
        this._screenX = x + 5;
        this._screenY = y + 5;
        if (this._screenY > UI.SCREEN_HEIGHT || this._screenY + this._h < 0) {
            return;
        }
        this.paintBackground(g, this._screenX, this._screenY);
        if (this._active) {
            g.setFont(this._font1);
            if (this._title >= 0) {
                this.header = UI.getString(this._title);
            }
            g.setColor(this._activeColor);
            g.drawString(this.header, 64 + this._screenX, this._screenY + 4, 0);
            if (this.bodyText != null) {
                this.bodyText.drawText(g, 64 + this._screenX, this._screenY + this._subtitleY + 4);
            }
        } else {
            g.setFont(this._font1);
            g.setColor(this._inactiveColor);
            g.drawString(this.header, 64 + this._screenX, this._screenY + 4, 0);
            if (this.bodyText != null) {
                this.bodyText.drawText(g, 64 + this._screenX, this._screenY + this._subtitleY + 4);
            }
        }
        g.drawImage(TwitterClient.getAvatarImage(this._t.screenname), 7 + this._screenX, 5 + this._screenY, 0);
    }

    public Tweet getTweet() {
        return this._t;
    }
}

