/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.twitter;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class OptionMenu {
    private Image[] skins = null;
    private int menuHeight;
    private int menuWidth;
    private int edgeWidth;
    private Image background;
    private Image highlight;
    private int commandHeight;
    private Vector commands;
    private int currentlySelected;
    private int hl_y_offset;
    private int leftSpacing;
    private int cmd_y_Offset;
    private int main_x_offset;
    private boolean opened = false;
    private Font m_font;
    private static final int style = 0;
    private static final int size = 0;
    private static final int face = 64;

    public OptionMenu(int desWidth, int ls, String path, int main_x_offset) {
        this.main_x_offset = main_x_offset;
        this.m_font = Font.getFont((int)64, (int)0, (int)0);
        this.leftSpacing = ls;
        this.menuWidth = 0;
        this.edgeWidth = 0;
        this.currentlySelected = 0;
        this.commands = new Vector();
        boolean ok = false;
        this.skins = new Image[6];
        try {
            for (int i = 0; i < 6; ++i) {
                this.skins[i] = Image.createImage((String)(path + i + ".png"));
            }
            ok = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (ok) {
            int nrOfBlocks = 0;
            this.edgeWidth = this.skins[0].getWidth();
            int blockWidth = this.skins[1].getWidth();
            this.menuHeight = this.skins[1].getHeight();
            while (this.menuWidth < desWidth) {
                this.menuWidth += blockWidth;
                ++nrOfBlocks;
            }
            this.background = Image.createImage((int)this.menuWidth, (int)this.menuHeight);
            this.highlight = Image.createImage((int)(this.menuWidth + 2 * this.edgeWidth), (int)this.skins[4].getHeight());
            Graphics bgOfs = this.background.getGraphics();
            Graphics hlOfs = this.highlight.getGraphics();
            hlOfs.drawImage(this.skins[3], 0, 0, 0);
            for (int cnt = 0; cnt < nrOfBlocks; ++cnt) {
                bgOfs.drawImage(this.skins[1], cnt * blockWidth, 0, 0);
                hlOfs.drawImage(this.skins[4], this.edgeWidth + cnt * blockWidth, 0, 0);
            }
            hlOfs.drawImage(this.skins[5], this.menuWidth + this.edgeWidth, 0, 0);
        }
    }

    public boolean isOpen() {
        return this.opened;
    }

    public void addCommand(String cmdLabel, int cmdId) {
        Command cmd = new Command();
        cmd.commandId = cmdId;
        cmd.commandLabel = cmdLabel;
        this.commands.addElement(cmd);
        this.commandHeight = this.menuHeight / this.commands.size();
        this.hl_y_offset = this.commandHeight - this.highlight.getHeight();
        this.cmd_y_Offset = this.commandHeight - this.m_font.getHeight();
    }

    public void selectNext() {
        ++this.currentlySelected;
        if (this.currentlySelected >= this.commands.size()) {
            this.currentlySelected = 0;
        }
    }

    public int getWidth() {
        return this.menuWidth;
    }

    public int getHighlightCommand() {
        return ((Command)this.commands.elementAt((int)this.currentlySelected)).commandId;
    }

    public void selectPrevious() {
        --this.currentlySelected;
        if (this.currentlySelected < 0) {
            this.currentlySelected = this.commands.size() - 1;
        }
    }

    public void openUp() {
        this.opened = true;
        this.currentlySelected = 0;
    }

    public void close() {
        this.opened = false;
    }

    public void paint(Graphics g, int x, int y_offset) {
        int y_top = y_offset - this.menuHeight;
        g.drawImage(this.skins[0], this.main_x_offset + x, y_top, 0);
        g.drawImage(this.background, this.main_x_offset + x + this.edgeWidth, y_top, 0);
        g.drawImage(this.skins[2], this.main_x_offset + x + this.menuWidth + this.edgeWidth, y_top, 0);
        int nrOfCommands = this.commands.size();
        g.setFont(this.m_font);
        g.setColor(0, 0, 0);
        for (int cnt = 0; cnt < nrOfCommands; ++cnt) {
            if (cnt == this.currentlySelected) continue;
            g.drawString(((Command)this.commands.elementAt((int)cnt)).commandLabel, this.main_x_offset + this.leftSpacing, y_top + cnt * this.commandHeight + this.cmd_y_Offset, 0);
        }
        g.drawImage(this.highlight, this.main_x_offset + x, y_top + this.currentlySelected * this.commandHeight + this.hl_y_offset, 0);
        g.setColor(255, 255, 255);
        g.drawString(((Command)this.commands.elementAt((int)this.currentlySelected)).commandLabel, this.main_x_offset + this.leftSpacing, y_top + this.currentlySelected * this.commandHeight + this.cmd_y_Offset, 0);
    }

    private class Command {
        public int commandId;
        public String commandLabel;

        private Command() {
        }
    }
}

