/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.twitter;

import com.sonyericsson.twitter.TwitterCanvas;
import com.sonyericsson.twitter.TwitterScrollbar;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import se.vitamin.ui.TextBox;
import se.vitamin.ui.UI;
import se.vitamin.ui.Window;

public class TwitterTextBox
extends TextBox {
    private static Image[] textBorder = null;
    private static TwitterScrollbar scrollBar;
    private static int capitalYOffset;
    private long time = -1L;

    private synchronized void init() {
        if (textBorder == null) {
            textBorder = new Image[11];
            try {
                for (int i = 0; i < 11; ++i) {
                    TwitterTextBox.textBorder[i] = Image.createImage((String)("/textbox/" + i + ".png"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        scrollBar = new TwitterScrollbar(null, 0);
        scrollBar.setHeight(UI.SCREEN_HEIGHT - 62 - 40);
        capitalYOffset = textBorder[3].getHeight() + UI.mediumFont.getHeight() - 6;
    }

    public TwitterTextBox(Window parent, int id, int left, int top, Font f, boolean forceDefault) {
        super(parent, id, left, top, f, forceDefault);
        this._screenX = 20;
        this._screenY = TwitterCanvas.largeScreen ? 130 : 70;
        this.init();
    }

    protected void calculateMaxLines() {
        this.maxLineCount = 1 + this._h / this._font.getHeight();
    }

    public void drawDropDown(Graphics g, int x, int y) {
        int drop_w = this._font.stringWidth(UI.getkeyMap(false, this.forceDefault)[this._lastkey - 48]);
        drop_w = this.capitalMode != 2 ? this._font.stringWidth(UI.getkeyMap(true, this.forceDefault)[this._lastkey - 48]) : this._font.stringWidth(UI.getkeyMap(false, this.forceDefault)[this._lastkey - 48]);
        super.drawDropDown(g, this._screenX + this._w - drop_w - 4, y - capitalYOffset);
    }

    protected void drawBackground(Graphics g, int x, int y) {
        int i;
        g.drawImage(textBorder[1], x - textBorder[1].getWidth(), y + this._h, 0);
        g.drawImage(textBorder[7], x + this._w, y + this._h, 0);
        g.drawImage(textBorder[3], x - textBorder[3].getWidth(), y - textBorder[3].getHeight(), 0);
        g.drawImage(textBorder[5], x + this._w, y - textBorder[5].getHeight(), 0);
        int w = textBorder[0].getWidth();
        int offset = this._w % w;
        int size = this._w - offset;
        for (i = 0; i < size; i += w) {
            g.drawImage(textBorder[0], x + i, y + this._h, 0);
            g.drawImage(textBorder[4], x + i, y - textBorder[4].getHeight(), 0);
        }
        int h = textBorder[2].getHeight();
        offset = this._h % h;
        size = this._h - offset;
        for (i = 0; i < size; i += w) {
            g.drawImage(textBorder[6], x - textBorder[2].getWidth(), y + i, 0);
            g.drawImage(textBorder[2], x + this._w, y + i, 0);
        }
        g.setColor(0xFFFFFF);
        g.fillRect(x, y, this._w, this._h);
        g.setColor(0);
        if (this.output.length > this.maxLineCount) {
            scrollBar.setHeight(this._h);
            scrollBar.setRange(this.output.length - this.maxLineCount);
            scrollBar.setValue(this.startLine);
            scrollBar.paint(g, x + this._w + 10, y);
        }
    }

    public void activate() {
        super.activate(false);
    }

    public void update(long time) {
        super.update(time);
    }

    public void update() {
        long now = System.currentTimeMillis();
        if (this.time != -1L && now > this.time && now - this.time < 10000L) {
            this.update(now - this.time);
        }
        this.time = now;
    }

    static {
        capitalYOffset = 0;
    }
}

