/*
 * Decompiled with CFR 0.152.
 */
package se.vitamin.ui;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import se.vitamin.ui.QuestionListener;
import se.vitamin.ui.UI;
import se.vitamin.ui.Widget;
import se.vitamin.ui.Window;

public abstract class Popup
extends Widget {
    Font _font;
    int _string;
    String[] _text = null;
    private static final int POPUP_VSPACING = 10;
    int _stringWidth;
    int _stringLeft;
    protected boolean _respond;
    QuestionListener _listener;

    public Popup(Window parent, int id, int string, int left, int top, int height, Font f, boolean respond) {
        super(parent, id);
        this._x = left;
        this._y = top;
        this._w = UI.SCREEN_WIDTH - 2 * left;
        this._stringLeft = this._x + 10;
        this._stringWidth = this._w - 20;
        this._h = height;
        this._font = f;
        this._string = string;
        this._respond = respond;
        this._listener = null;
        this._text = this.toStringArray(UI.getString(string), this._w - 10, this._font);
    }

    public Popup(Window parent, int id, int string, int left, int top, int height, Font f, QuestionListener listener) {
        super(parent, id);
        this._x = left;
        this._y = top;
        this._w = UI.SCREEN_WIDTH - 2 * left;
        this._stringLeft = this._x + 10;
        this._stringWidth = this._w - 20;
        this._h = height;
        this._font = f;
        this._string = string;
        this._respond = false;
        this._listener = listener;
        this._text = this.toStringArray(UI.getString(string), this._w - 10, this._font);
    }

    public void activate() {
    }

    public void deactivate() {
    }

    public boolean handleKeyDown(int key) {
        if (this._listener != null) {
            if (key == -5) {
                this._listener.response(true);
                return true;
            }
            if (key == -7) {
                this._listener.response(false);
                return true;
            }
            return false;
        }
        if (this._respond) {
            switch (key) {
                case -5: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean handleKeyUp(int key) {
        return false;
    }

    public boolean handleLongPress(int key) {
        return false;
    }

    protected void paintBackground(Graphics g, int x, int y) {
        g.setColor(0xFFFFFF);
        g.fillRect(x, y, this._w, this._h);
        g.setColor(0);
        g.drawRect(x, y, this._w, this._h);
    }

    public void paint(Graphics g, int x, int y) {
        this.paintBackground(g, x + this._x, y + this._y);
        g.setFont(this._font);
        g.setColor(0);
        int textY = (this._h - this._text.length * this._font.getHeight()) / 2;
        if (this._text.length == 1) {
            int textX = (this._w - this._font.stringWidth(UI.getString(this._string))) / 2;
            g.drawString(this._text[0], x + this._x + textX, y + this._y + textY, 0);
        } else {
            int textX = 5;
            for (int i = 0; i < this._text.length; ++i) {
                g.drawString(this._text[i], x + this._x + textX, y + this._y + textY, 0);
                textY += this._font.getHeight();
            }
        }
    }

    public void select() {
    }

    public void setDimensions(int x, int y, int w, int h) {
    }

    public void setFont(Font f) {
    }

    public void update() {
    }

    private int findSplit(String s, int maxLength) {
        int index = 0;
        if (this._font.stringWidth(s) < maxLength) {
            return -1;
        }
        while (this._font.stringWidth(s.substring(0, index++)) < maxLength) {
        }
        return index - 1;
    }

    public String[] toStringArray(String s, int maxLength, Font f) {
        int index = 0;
        int newPos = 0;
        boolean done = false;
        String tmp = s;
        Vector<String> strings = new Vector<String>();
        if (s.length() == 0) {
            strings.addElement(s);
        } else {
            while (!done) {
                newPos = tmp.indexOf(32, index);
                if (newPos > 0) {
                    if (f.stringWidth(tmp.substring(0, newPos)) > maxLength) {
                        if (index == 0) {
                            index = this.findSplit(tmp, maxLength);
                        }
                        strings.addElement(tmp.substring(0, index));
                        tmp = tmp.substring(index);
                        index = 0;
                        continue;
                    }
                    index = newPos + 1;
                    continue;
                }
                if (f.stringWidth(tmp) > maxLength) {
                    if (index > 0) {
                        strings.addElement(tmp.substring(0, index));
                        tmp = tmp.substring(index);
                        index = 0;
                    } else {
                        while (-1 != (index = this.findSplit(tmp, maxLength))) {
                            strings.addElement(tmp.substring(0, index));
                            tmp = tmp.substring(index);
                            index = 0;
                        }
                    }
                } else {
                    strings.addElement(tmp);
                    tmp = "";
                    index = 0;
                }
                if (tmp.length() != 0) continue;
                done = true;
            }
        }
        String[] out = new String[strings.size()];
        for (int i = 0; i < strings.size(); ++i) {
            out[i] = (String)strings.elementAt(i);
        }
        strings.removeAllElements();
        strings = null;
        return out;
    }
}

