/*
 * Decompiled with CFR 0.152.
 */
package se.vitamin.ui;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import se.vitamin.ui.Canvas;
import se.vitamin.ui.UI;
import se.vitamin.ui.Widget;

public abstract class Window {
    protected Window _parent;
    protected Canvas _canvas;
    protected int _currentWidget = -1;
    protected Vector _widgets = new Vector();
    public int _x = 0;
    public int _y = 0;
    public int _w = 0;
    public boolean _active = false;

    public Window(Canvas canvas, Window parent) {
        this._canvas = canvas;
        this._parent = parent;
        this._w = UI.SCREEN_WIDTH;
    }

    public void selectNextWidget() {
        int tmpIndex = this._currentWidget;
        ++tmpIndex;
        while (tmpIndex < this._widgets.size() && !((Widget)this._widgets.elementAt(tmpIndex)).isSelectable()) {
            ++tmpIndex;
        }
        if (tmpIndex == this._widgets.size()) {
            return;
        }
        if (this._currentWidget >= 0) {
            ((Widget)this._widgets.elementAt(this._currentWidget)).deactivate();
        }
        this._currentWidget = tmpIndex;
        ((Widget)this._widgets.elementAt(this._currentWidget)).activate();
    }

    public void selectFirstWidget() {
        if (this._currentWidget > 0) {
            ((Widget)this._widgets.elementAt(this._currentWidget)).deactivate();
        }
        this._currentWidget = 0;
        ((Widget)this._widgets.elementAt(this._currentWidget)).activate();
    }

    public void add(Widget w) {
        this._widgets.addElement(w);
    }

    public void selectPrevWidget() {
        int tmpIndex;
        if (this._currentWidget <= 0) {
            return;
        }
        for (tmpIndex = this._currentWidget - 1; tmpIndex >= 0 && !((Widget)this._widgets.elementAt(tmpIndex)).isSelectable(); --tmpIndex) {
        }
        if (tmpIndex == -1) {
            return;
        }
        if (this._currentWidget >= 0) {
            ((Widget)this._widgets.elementAt(this._currentWidget)).deactivate();
        }
        this._currentWidget = tmpIndex;
        ((Widget)this._widgets.elementAt(this._currentWidget)).activate();
    }

    public boolean handleKeyDown(int key) {
        switch (key) {
            case -1: {
                this.selectPrevWidget();
                break;
            }
            case -2: {
                this.selectNextWidget();
                break;
            }
            case -7: {
                System.exit(0);
                break;
            }
            default: {
                if (this._currentWidget >= 0) {
                    return ((Widget)this._widgets.elementAt(this._currentWidget)).handleKeyDown(key);
                }
                return false;
            }
        }
        return true;
    }

    public void removeAllWidgets() {
        this._currentWidget = -1;
        this._widgets.removeAllElements();
    }

    public Window getParent() {
        return this._parent;
    }

    public abstract boolean handleKeyUp(int var1);

    public abstract boolean handleLongPress(int var1);

    public void paint(Graphics g) {
        for (int i = 0; i < this._widgets.size(); ++i) {
            if (i == this._currentWidget) continue;
            ((Widget)this._widgets.elementAt(i)).paint(g, this._x, this._y);
        }
        if (this._currentWidget >= 0) {
            ((Widget)this._widgets.elementAt(this._currentWidget)).paint(g, this._x, this._y);
        }
    }

    public void update() {
        if (this._currentWidget >= 0) {
            ((Widget)this._widgets.elementAt(this._currentWidget)).update();
        }
    }

    public void widgetEvent(int id, int event) {
        if (this._parent != null) {
            this._parent.widgetEvent(id, event);
        } else {
            this._canvas.widgetEvent(id, event);
        }
    }

    public void activateParent() {
        Canvas.setActiveWindow(this._parent);
    }

    public abstract void activate();

    public abstract void handlePointerDown(int var1, int var2);

    public int width() {
        return UI.SCREEN_WIDTH;
    }

    public void deactivate() {
        this._active = false;
    }

    public abstract void cancel();
}

