/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.data;

import com.sonyericsson.fifa.data.Squad;
import com.sonyericsson.fifa.data.feed.Enclosure;
import com.sonyericsson.fifa.data.feed.Feed;
import com.sonyericsson.fifa.data.feed.FeedListener;
import com.sonyericsson.fifa.datastore.FeedDB;
import com.sonyericsson.fifa.datastore.SquadDB;
import com.sonyericsson.fifa.datastore.TeamLatestNewsDB;
import com.sonyericsson.fifa.datastore.storeobject.TeamLatestNews;
import com.sonyericsson.fifa.model.teamList.SquadListener;
import com.sonyericsson.fifa.model.teamList.TeamListener;
import com.sonyericsson.fifa.services.parser.ParserListener;
import com.sonyericsson.fifa.services.parser.sax.SaxParser;
import com.sonyericsson.fifa.services.parser.sax.handler.RssHandler;
import com.sonyericsson.fifa.services.parser.sax.handler.SquadHandler;
import com.sonyericsson.fifa.services.scheduler.ScheduleUpdateListener;
import com.sonyericsson.fifa.services.scheduler.UpdateTimerTask;
import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.utils.Logger;
import java.util.Vector;

public class Team
implements ScheduleUpdateListener {
    private String teamCode;
    private int numberOfTweets;
    private Feed newLatestNews;
    private int numberOfItemsNew;
    private Feed latestNews;
    private Squad squad;
    private String feedUrl;
    private String squadUrl;
    private Vector listeners = new Vector();
    private Vector squadListeners = new Vector();
    private UpdateTimerTask updateTimerTask;
    private String tempItemFeedPubDate = null;
    private int thumbdownloadfailedreason = 0;
    private int INIT_STATE = 0;
    private int UPDATING_TEAM_NEWS = 1;
    private int UPDATED_TEAM_WITH_NEW_ITEMS = 2;
    private int UPDATED_TEAM_WITHOUT_NEW_ITEMS = 3;
    private int currentState = this.INIT_STATE;
    static /* synthetic */ Class class$0;

    public Team() {
    }

    public Team(String code, String feedUrl, String squadUrl) {
        this.teamCode = code;
        this.squadUrl = squadUrl;
        this.feedUrl = feedUrl;
        this.loadData();
    }

    private void loadData() {
        TeamLatestNewsDB latestNewsDB = new TeamLatestNewsDB(this.teamCode);
        TeamLatestNews latestNews = latestNewsDB.retrieveLatestNews();
        if (latestNews.getLastItemPubDateToUse() != null) {
            SquadDB squadDB;
            Squad loadedSquad;
            FeedDB feedDB = new FeedDB(this.teamCode);
            Feed feed = feedDB.retrieveFeed();
            if (feed != null) {
                feed.setLastItemPubDate(latestNews.getLastItemPubDateToUse());
                this.setLatestNews(feed);
            }
            if ((loadedSquad = (squadDB = new SquadDB(this.teamCode)).retrieveSquad()) != null) {
                this.squad = loadedSquad;
            }
        }
    }

    public boolean hasData() {
        return this.latestNews != null;
    }

    public String getTeamCode() {
        return this.teamCode;
    }

    public int getNumberOfTweets() {
        return this.numberOfTweets;
    }

    public void setNumberOfTweets(int numberOfTweets) {
        this.numberOfTweets = numberOfTweets;
    }

    public Feed getLatestNews() {
        return this.latestNews;
    }

    public void setLatestNews(Feed latestNews) {
        if (this.latestNews == null) {
            this.latestNews = latestNews;
        } else if (latestNews.getItems().size() > 0) {
            int numberOfLatests = latestNews.getItems().size();
            if (this.latestNews.getItems().size() <= numberOfLatests) {
                this.latestNews = latestNews;
            } else {
                Vector currentItems = this.latestNews.getItems();
                int i = 0;
                while (i < numberOfLatests) {
                    currentItems.removeElementAt(currentItems.size() - 1);
                    ++i;
                }
                this.latestNews = latestNews;
                i = 0;
                while (i < currentItems.size()) {
                    this.latestNews.getItems().addElement(currentItems.elementAt(i));
                    ++i;
                }
            }
        }
    }

    public String getFeedUrl() {
        return this.feedUrl;
    }

    public void setFeedUrl(String feedUrl) {
        this.feedUrl = feedUrl;
    }

    public String getSquadUrl() {
        return this.squadUrl;
    }

    public void setSquadUrl(String squadUrl) {
        this.squadUrl = squadUrl;
    }

    public Squad getSquad() {
        return this.squad;
    }

    public void setSquad(Squad squad) {
        this.squad = squad;
    }

    public void setTeamCode(String teamCode) {
        this.teamCode = teamCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLatestNews() {
        Team team = this;
        synchronized (team) {
            this.thumbdownloadfailedreason = 0;
        }
        final RssHandler handler = new RssHandler();
        String lastItemPubDateToUse = null;
        if (this.latestNews != null) {
            lastItemPubDateToUse = this.latestNews.getLastItemPubDate();
        }
        if (lastItemPubDateToUse != null) {
            handler.setLastItemPubDate(lastItemPubDateToUse);
        }
        SaxParser parser = new SaxParser(this.getFeedUrl(), handler);
        handler.setItemsToParse(20);
        ParserListener listener = new ParserListener(){

            public void parserFinished() {
                int itemsSize = handler.getParsedFeed().getItems().size();
                if (handler.getParsedFeed() != null && itemsSize > 0) {
                    if (Team.this.latestNews == null) {
                        Team.this.setLatestNews(handler.getParsedFeed());
                        Team.this.currentState = Team.this.INIT_STATE;
                        Team.this.fireTeamUpdateFinished(true);
                        Team.this.downloadThumbnails(itemsSize);
                        TeamLatestNews ln = new TeamLatestNews();
                        ln.setLastItemPubDateToUse(handler.getParsedFeed().getLastItemPubDate());
                        TeamLatestNewsDB latestNewsDB = new TeamLatestNewsDB(Team.this.teamCode);
                        latestNewsDB.saveLatestNews(ln);
                        FeedDB feedDB = new FeedDB(Team.this.teamCode);
                        feedDB.saveFeed(handler.getParsedFeed());
                    } else {
                        if (Team.this.tempItemFeedPubDate == null) {
                            Team.this.tempItemFeedPubDate = Team.this.getLatestNews().getLastItemPubDate();
                        }
                        Team.this.numberOfItemsNew = itemsSize;
                        Team.this.setNewLatestNews(handler.getParsedFeed());
                        Team.this.currentState = Team.this.UPDATED_TEAM_WITH_NEW_ITEMS;
                        Team.this.fireTeamUpdateFinished(true);
                    }
                } else {
                    if (Team.this.currentState != Team.this.UPDATED_TEAM_WITH_NEW_ITEMS || Team.this.tempItemFeedPubDate == null && Team.this.tempItemFeedPubDate == null) {
                        Team.this.currentState = Team.this.UPDATED_TEAM_WITHOUT_NEW_ITEMS;
                    }
                    Team.this.fireTeamUpdateFinished(false);
                }
            }

            public void parserFailed(byte reason) {
                if (Team.this.currentState != Team.this.UPDATED_TEAM_WITH_NEW_ITEMS || Team.this.tempItemFeedPubDate == null && Team.this.tempItemFeedPubDate == null) {
                    Team.this.currentState = Team.this.UPDATED_TEAM_WITHOUT_NEW_ITEMS;
                }
                switch (reason) {
                    case 1: {
                        Team.this.fireTeamUpdateFailed((byte)1);
                        break;
                    }
                    case 2: {
                        Team.this.fireTeamUpdateFailed((byte)4);
                        break;
                    }
                    default: {
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("com.sonyericsson.fifa.data.Team");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Logger.logError(clazz, "updateLatestNews failed.");
                        Logger.logError(this.getClass(), "Parser failed, unexpected reason: " + reason);
                        Team.this.fireTeamUpdateFailed((byte)4);
                    }
                }
            }
        };
        parser.addParserListener(listener);
        this.currentState = this.UPDATING_TEAM_NEWS;
        new Thread(parser).start();
        this.fireTeamUpdateStarted();
    }

    public void setScheduleUpdate() {
        if (this.updateTimerTask == null) {
            this.updateTimerTask = new UpdateTimerTask(this);
            this.updateTimerTask.startTimerTask();
        }
    }

    public boolean isTeamNewsUpdating() {
        return this.currentState == this.UPDATING_TEAM_NEWS;
    }

    public boolean isTeamNewsUpdatedWithNewItems() {
        return this.newLatestNews != null;
    }

    public void updateSquadInformation() {
        if (this.squad == null) {
            final SquadHandler handler = new SquadHandler();
            SaxParser parser = new SaxParser(this.getSquadUrl(), handler);
            ParserListener listener = new ParserListener(){

                public void parserFinished() {
                    Team.this.setSquad(handler.getTeamSquad());
                    SquadDB squadDB = new SquadDB(Team.this.teamCode);
                    if (Team.this.getSquad() != null) {
                        squadDB.saveSquad(Team.this.getSquad());
                    }
                    Team.this.fireSquadUpdated();
                }

                public void parserFailed(byte reason) {
                    block8: {
                        block7: {
                            SquadDB squadDB = new SquadDB(Team.this.teamCode);
                            Team.this.squad = squadDB.retrieveSquad();
                            if (Team.this.squad != null) break block7;
                            switch (reason) {
                                case 1: {
                                    Team.this.fireSquadUpdateFailed((byte)1);
                                    break;
                                }
                                case 2: {
                                    Team.this.fireSquadUpdateFailed((byte)4);
                                    break;
                                }
                                default: {
                                    Class<?> clazz = class$0;
                                    if (clazz == null) {
                                        try {
                                            clazz = class$0 = Class.forName("com.sonyericsson.fifa.data.Team");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    Logger.logError(clazz, "updateSquadInfo failed.");
                                    Logger.logError(this.getClass(), "Parser failed, unexpected reason: " + reason);
                                    Team.this.fireSquadUpdateFailed((byte)4);
                                    break;
                                }
                            }
                            break block8;
                        }
                        Team.this.fireSquadUpdated();
                    }
                }
            };
            parser.addParserListener(listener);
            new Thread(parser).start();
        } else {
            this.fireSquadUpdated();
        }
    }

    private void downloadThumbnails(int numberOfItems) {
        if (this.latestNews != null) {
            this.latestNews.addFeedListener(new FeedListener(){

                public void enclosureDownloaded(int index, Enclosure enclosure) {
                    Team.this.fireThumbnailDownloaded(index, enclosure);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void enclosureDownloadFailed(int index, byte reason) {
                    3 var3_3 = this;
                    synchronized (var3_3) {
                        byte modelReason = 0;
                        switch (reason) {
                            case 1: {
                                modelReason = 1;
                                break;
                            }
                            case 4: {
                                modelReason = 1;
                                break;
                            }
                            case 2: {
                                modelReason = 2;
                                break;
                            }
                            default: {
                                Logger.logError(this.getClass(), "enclosureDownloadFailed, unexpected reason: " + reason);
                                modelReason = 4;
                            }
                        }
                        if ((Team.this.thumbdownloadfailedreason & modelReason) == 0) {
                            Team.this.fireTeamUpdateFailed(modelReason);
                            Team team = Team.this;
                            team.thumbdownloadfailedreason = team.thumbdownloadfailedreason | modelReason;
                        }
                    }
                }
            });
            this.latestNews.downloadEnclosures(this.getTeamCode(), numberOfItems);
        }
    }

    public void addTeamListener(TeamListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    public void removeTeamListener(TeamListener listener) {
        this.listeners.removeElement(listener);
    }

    public void addSquadListener(SquadListener listener) {
        if (listener != null && !this.squadListeners.contains(listener)) {
            this.squadListeners.addElement(listener);
        }
    }

    public void removeSquadListener(SquadListener listener) {
        this.squadListeners.removeElement(listener);
    }

    public void simulateUpdateFinished() {
        this.fireTeamUpdateFinished(true);
    }

    private void fireTeamUpdateFinished(boolean newItemsAvailable) {
        int i = 0;
        while (i < this.listeners.size()) {
            TeamListener listener = (TeamListener)this.listeners.elementAt(i);
            listener.teamUpdateFinished(newItemsAvailable, this.teamCode);
            ++i;
        }
    }

    private void fireTeamUpdateStarted() {
        int i = 0;
        while (i < this.listeners.size()) {
            TeamListener listener = (TeamListener)this.listeners.elementAt(i);
            listener.teamUpdateStarted();
            ++i;
        }
    }

    private void fireTeamUpdateFailed(byte reason) {
        int i = 0;
        while (i < this.listeners.size()) {
            TeamListener listener = (TeamListener)this.listeners.elementAt(i);
            listener.teamUpdateFailed(reason);
            ++i;
        }
    }

    private void fireSquadUpdated() {
        int i = 0;
        while (i < this.squadListeners.size()) {
            SquadListener listener = (SquadListener)this.squadListeners.elementAt(i);
            listener.squadUpdated();
            ++i;
        }
    }

    private void fireSquadUpdateFailed(byte reason) {
        int i = 0;
        while (i < this.squadListeners.size()) {
            SquadListener listener = (SquadListener)this.squadListeners.elementAt(i);
            listener.squadUpdateFailed(reason);
            ++i;
        }
    }

    private void fireThumbnailDownloaded(int index, Enclosure thumbnail) {
        int i = 0;
        while (i < this.listeners.size()) {
            TeamListener listener = (TeamListener)this.listeners.elementAt(i);
            listener.thumbnailDownloaded(index, thumbnail);
            ++i;
        }
    }

    public void update() {
        if (IOUtility.isMemoryAvailable()) {
            this.updateLatestNews();
        } else {
            this.fireTeamUpdateFailed((byte)2);
        }
    }

    public void cancelScheduledUpdate() {
        if (this.updateTimerTask != null) {
            this.updateTimerTask.cancelTimerTask();
            this.updateTimerTask = null;
        }
    }

    public String toString() {
        return "TeamCode: " + this.teamCode + ", LatestNewsUrl: " + this.feedUrl + ", SquadUrl: " + this.squadUrl;
    }

    public Feed getNewLatestNews() {
        return this.newLatestNews;
    }

    public void setNewLatestNews(Feed newLatestNews) {
        this.newLatestNews = newLatestNews;
    }

    public void changeToNewData() {
        this.currentState = this.INIT_STATE;
        if (this.newLatestNews != null) {
            this.setLatestNews(this.newLatestNews);
            TeamLatestNews ln = new TeamLatestNews();
            ln.setLastItemPubDateToUse(this.newLatestNews.getLastItemPubDate());
            TeamLatestNewsDB latestNewsDB = new TeamLatestNewsDB(this.teamCode);
            latestNewsDB.saveLatestNews(ln);
            FeedDB feedDB = new FeedDB(this.teamCode);
            feedDB.saveFeed(this.latestNews);
            this.fireTeamUpdateFinished(true);
            this.downloadThumbnails(this.numberOfItemsNew);
            this.setNewLatestNews(null);
            this.tempItemFeedPubDate = null;
            this.numberOfItemsNew = -1;
        }
    }
}

