/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.services.parser.sax.handler;

import com.sonyericsson.fifa.data.Squad;
import com.sonyericsson.fifa.data.TeamComponent;
import com.sonyericsson.fifa.services.parser.sax.contentprovider.SquadContentProvider;
import com.sonyericsson.fifa.services.parser.sax.exceptions.RssInvalidFormatException;
import com.sonyericsson.fifa.utils.Logger;
import java.util.Hashtable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SquadHandler
extends DefaultHandler
implements SquadContentProvider {
    private static final String SQUAD_TAG = "SQUAD";
    private static final String ITEM_TAG = "item";
    private static final String ITEM_NAME_ATTRIBUTE = "name";
    private static final String ITEM_TITLE_ATTRIBUTE = "title";
    private static final String ITEM_NUMBER_ATTRIBUTE = "number";
    private Squad squad;
    private TeamComponent currentTeamComponent;
    private boolean xmlStartedCorrectly;
    private Hashtable hashPosition;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String resourceId, String localName, String tagName, Attributes attributes) throws SAXException {
        if (this.xmlStartedCorrectly) {
            if (!this.xmlStartedCorrectly || !ITEM_TAG.equals(tagName) || this.currentTeamComponent != null) throw new RssInvalidFormatException();
            if (attributes == null) return;
            this.parseItem(attributes);
            return;
        } else if (SQUAD_TAG.equals(tagName)) {
            this.xmlStartedCorrectly = true;
            return;
        } else {
            Logger.logError(this.getClass(), "Error on parsing squad XML - Not started correctly");
            throw new RssInvalidFormatException();
        }
    }

    public void endElement(String resourceId, String localName, String qName) throws SAXException {
        if (this.xmlStartedCorrectly) {
            if (ITEM_TAG.equals(qName) && this.currentTeamComponent != null) {
                this.getTeamSquad().getComponents().addElement(this.currentTeamComponent);
                this.currentTeamComponent = null;
            } else if (SQUAD_TAG.equals(qName)) {
                this.xmlStartedCorrectly = false;
            }
        } else {
            throw new RssInvalidFormatException();
        }
    }

    private void parseItem(Attributes attributes) throws SAXException {
        int numberOfAttributes = attributes.getLength();
        this.currentTeamComponent = new TeamComponent();
        int i = 0;
        while (i < numberOfAttributes) {
            String attributeName = attributes.getQName(i).trim();
            String attributeValue = attributes.getValue(i).trim();
            if (attributeValue != null && !"".equals(attributeValue)) {
                if (ITEM_NAME_ATTRIBUTE.equalsIgnoreCase(attributeName)) {
                    this.currentTeamComponent.setName(attributeValue);
                } else if (ITEM_TITLE_ATTRIBUTE.equalsIgnoreCase(attributeName)) {
                    this.currentTeamComponent.setTitle(this.convertTeamPosition(attributeValue));
                } else if (ITEM_NUMBER_ATTRIBUTE.equalsIgnoreCase(attributeName)) {
                    int number = -1;
                    try {
                        number = Integer.parseInt(attributeValue);
                    }
                    catch (NumberFormatException e) {
                        Logger.logError(this.getClass(), "Warning - parsing squad XML - Item contains invalid attribute: number");
                    }
                    this.currentTeamComponent.setNumber(number);
                }
            }
            ++i;
        }
        if (this.currentTeamComponent.getName() == null || this.currentTeamComponent.getTitle() == null) {
            Logger.logError(this.getClass(), "Warning - parsing squad XML - Item does not contain required attributes");
        }
    }

    private String convertTeamPosition(String currentPosition) {
        if (this.hashPosition == null) {
            this.hashPosition = new Hashtable();
            this.hashPosition.put("MGR", "FANAPP_SQUAD_MANAGER_TXT");
            this.hashPosition.put("GK", "FANAPP_SQUAD_GOALKEEPER_TXT");
            this.hashPosition.put("MF", "FANAPP_SQUAD_MIDFIELDER_TXT");
            this.hashPosition.put("DF", "FANAPP_SQUAD_DEFENDER_TXT");
            this.hashPosition.put("FW", "FANAPP_SQUAD_FORWARD_TXT");
        }
        return "" + this.hashPosition.get(currentPosition);
    }

    public Squad getTeamSquad() {
        if (this.squad == null) {
            this.squad = new Squad();
        }
        return this.squad;
    }
}

