/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.utils;

import com.nokia.mid.iapinfo.AccessPoint;
import com.nokia.mid.iapinfo.DestinationNetwork;
import com.nokia.mid.iapinfo.IAPInfo;
import com.nokia.mid.iapinfo.IAPInfoException;
import com.sonyericsson.fifa.exceptions.FileAlreadyDownloadedException;
import com.sonyericsson.fifa.exceptions.NoDiskSpaceException;
import com.sonyericsson.fifa.utils.Logger;
import com.sonyericsson.fifa.utils.SystemProperties;
import com.sonyericsson.fifa.view.FifaResources;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.microedition.amms.GlobalManager;
import javax.microedition.amms.MediaProcessor;
import javax.microedition.amms.control.imageeffect.ImageTransformControl;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.io.file.FileConnection;
import javax.microedition.media.MediaException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;

public class IOUtility {
    public static final String FIFA_DIR = String.valueOf(System.getProperty("fileconn.dir.videos")) + "fifa/";
    public static final String FS_LOCATOR = "file:///";
    public static final String HTTP_LOCATOR = "http:";
    public static final String MOBILE_PATH = "c:/";
    public static final String MEMORY_CARD_PATH = "e:/";
    private static final String VALIDATE_LINK = "http://google.com";
    private static final String LAN_BEARER = "LANBearer";
    private static final String LAN_SERVICE = "LANService";
    static /* synthetic */ Class class$0;

    public static void deleteFiles(String path) {
        block14: {
            if (path != null) {
                Enumeration files = null;
                FileConnection fileConnection = null;
                try {
                    try {
                        fileConnection = (FileConnection)Connector.open((String)path, (int)3);
                        if (!fileConnection.exists()) break block14;
                        if (fileConnection.isDirectory()) {
                            files = fileConnection.list("*", true);
                            while (files.hasMoreElements()) {
                                IOUtility.deleteFiles(String.valueOf(path) + (String)files.nextElement());
                            }
                            fileConnection.delete();
                            break block14;
                        }
                        fileConnection.delete();
                    }
                    catch (IOException iOException) {
                        try {
                            fileConnection.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                finally {
                    try {
                        fileConnection.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static void copyFile(String source, String destination) throws IOException {
        int n;
        InputStream is = null;
        FileConnection fc = null;
        OutputStream os = null;
        is = Connector.openInputStream((String)source);
        fc = (FileConnection)Connector.open((String)destination);
        if (fc.exists()) {
            fc.delete();
        }
        fc.create();
        os = fc.openOutputStream();
        byte[] buffer = new byte[10000];
        while ((n = is.read(buffer)) != -1) {
            os.write(buffer, 0, n);
        }
        is.close();
        os.flush();
        os.close();
        fc.close();
    }

    public static void createDirectories(String fullDirPath) throws IOException {
        FileConnection createDirectory = (FileConnection)Connector.open((String)fullDirPath);
        if (!createDirectory.exists()) {
            createDirectory.mkdir();
            createDirectory.setHidden(true);
            createDirectory.close();
        }
    }

    public static OutputStream createFileAndOpen(String filePath) throws NoDiskSpaceException, FileAlreadyDownloadedException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Logger.logInfo(clazz, "createFileAndOpen: " + filePath);
        try {
            FileConnection fc = (FileConnection)Connector.open((String)filePath);
            if (fc.exists()) {
                throw new FileAlreadyDownloadedException();
            }
            fc.create();
            OutputStream output = fc.openOutputStream();
            return output;
        }
        catch (IOException e) {
            throw new NoDiskSpaceException();
        }
    }

    public static void saveByteAsFile(byte[] data, String filePath) {
        if (filePath != null && data != null && data.length > 0) {
            FilterOutputStream output = null;
            FileConnection fileConnector = null;
            try {
                try {
                    fileConnector = (FileConnection)Connector.open((String)filePath);
                    if (!fileConnector.exists()) {
                        fileConnector.create();
                    }
                    output = fileConnector.openDataOutputStream();
                    ((DataOutputStream)output).write(data, 0, data.length);
                    ((DataOutputStream)output).flush();
                }
                catch (IOException iOException) {
                    try {
                        if (output != null) {
                            output.close();
                        }
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    try {
                        if (fileConnector != null) {
                            fileConnector.close();
                        }
                    }
                    catch (IOException iOException3) {}
                }
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileConnector != null) {
                        fileConnector.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static InputStream openInputStream(String locator) throws IOException {
        InputStream is = null;
        if (locator != null) {
            is = locator.startsWith(HTTP_LOCATOR) ? Connector.openInputStream((String)locator) : IOUtility.openFileInputStream(locator);
        }
        return is;
    }

    public static InputStream openFileInputStream(String filePath) throws IOException {
        InputStream is = null;
        if (filePath != null && filePath.startsWith(FS_LOCATOR)) {
            FileConnection fc = (FileConnection)Connector.open((String)filePath);
            if (fc != null) {
                is = fc.openInputStream();
                fc.close();
            }
        } else {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            is = clazz.getResourceAsStream(filePath);
        }
        return is;
    }

    public static InputStream getImageFromRES(String filePath) throws IOException {
        InputStream is = null;
        if (filePath != null) {
            filePath = String.valueOf(FifaResources.getImageFolder()) + filePath;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            is = clazz.getResourceAsStream(filePath);
        }
        return is;
    }

    public static void resizeImage(String imageFilePath, String thumbImagePath, int width, int height) throws MediaException, IOException {
        if (imageFilePath != null && thumbImagePath != null && width > 0 && height > 0) {
            InputStream imageFileIS = null;
            InputStreamReader reader = null;
            ByteArrayOutputStream outputStream = null;
            try {
                try {
                    imageFileIS = IOUtility.openFileInputStream(imageFilePath);
                    if (imageFileIS != null) {
                        outputStream = new ByteArrayOutputStream();
                        reader = new InputStreamReader(imageFileIS);
                        if (reader.ready()) {
                            MediaProcessor mediaProc = GlobalManager.createMediaProcessor((String)"image/jpeg");
                            mediaProc.setInput(imageFileIS, -1);
                            mediaProc.setOutput((OutputStream)outputStream);
                            ImageTransformControl imgTransformCtrl = (ImageTransformControl)mediaProc.getControl("javax.microedition.amms.control.imageeffect.ImageTransformControl");
                            imgTransformCtrl.setTargetSize(width, height, 0);
                            imgTransformCtrl.setEnforced(true);
                            imgTransformCtrl.setEnabled(true);
                            mediaProc.complete();
                        }
                        IOUtility.saveByteAsFile(outputStream.toByteArray(), thumbImagePath);
                    }
                }
                catch (IOException e) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Logger.logError(clazz, "IOException: " + e.getMessage());
                    throw e;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException e) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Logger.logError(clazz, "IOException: " + e.getMessage());
                }
                try {
                    if (imageFileIS != null) {
                        imageFileIS.close();
                    }
                }
                catch (IOException e) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Logger.logError(clazz, "IOException: " + e.getMessage());
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Exception e) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Logger.logError(clazz, "IOException: " + e.getMessage());
                }
                throw throwable;
            }
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Logger.logError(clazz, "IOException: " + e.getMessage());
            }
            try {
                if (imageFileIS != null) {
                    imageFileIS.close();
                }
            }
            catch (IOException e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Logger.logError(clazz, "IOException: " + e.getMessage());
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Logger.logError(clazz, "IOException: " + e.getMessage());
            }
        }
    }

    public static void assertFileDoesntExist(String filePath) throws FileAlreadyDownloadedException {
        block11: {
            try {
                InputStream is;
                if (filePath == null) break block11;
                if (filePath.startsWith(FS_LOCATOR)) {
                    FileConnection fc = (FileConnection)Connector.open((String)filePath);
                    if (fc.exists()) {
                        throw new FileAlreadyDownloadedException();
                    }
                    fc.close();
                    break block11;
                }
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((is = clazz.getResourceAsStream(filePath)) != null) {
                    is.close();
                    throw new FileAlreadyDownloadedException();
                }
            }
            catch (IOException e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Logger.logError(clazz, "IOException: " + e.getMessage());
            }
        }
    }

    public static boolean isMemoryAvailable() {
        boolean memoryAvailable = false;
        try {
            long availablePhoneMemory = IOUtility.getMobileFreeSpace();
            RecordStore rs = RecordStore.openRecordStore((String)"/fifa_config", (boolean)true);
            int storageAvailable = rs.getSizeAvailable();
            rs.closeRecordStore();
            if (availablePhoneMemory >= 250000L && storageAvailable >= 15000) {
                memoryAvailable = true;
            }
        }
        catch (IOException e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Logger.logError(clazz, "IOException: " + e.getMessage());
        }
        catch (RecordStoreFullException e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Logger.logError(clazz, "RecordStoreFullException: " + e.getMessage());
        }
        catch (RecordStoreNotFoundException e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Logger.logError(clazz, "RecordStoreNotFoundException: " + e.getMessage());
        }
        catch (RecordStoreException e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Logger.logError(clazz, "RecordStoreException: " + e.getMessage());
        }
        return memoryAvailable;
    }

    public static long getMobileFreeSpace() throws IOException {
        long free = -1L;
        FileConnection fc = (FileConnection)Connector.open((String)"file:///c:/");
        if (fc != null) {
            free = fc.availableSize();
            fc.close();
        }
        return free;
    }

    public static long getMemoryCardFreeSpace() throws IOException {
        long free = -1L;
        FileConnection fc = (FileConnection)Connector.open((String)"file:///e:/");
        if (fc != null) {
            free = fc.availableSize();
            fc.close();
        }
        return free;
    }

    public static void assertMemorySpaceAvailable(long space) throws NoDiskSpaceException {
        try {
            if (IOUtility.getMobileFreeSpace() < space) {
                throw new NoDiskSpaceException();
            }
        }
        catch (IOException e) {
            throw new NoDiskSpaceException();
        }
    }

    public static boolean hasNetworkingConnection() {
        boolean hasNetwork = false;
        try {
            HttpConnection connection = (HttpConnection)Connector.open((String)VALIDATE_LINK, (int)1, (boolean)true);
            if (connection != null) {
                if (SystemProperties.getPhonePlatform() == 2) {
                    connection.getResponseCode();
                }
                hasNetwork = true;
                connection.close();
            }
        }
        catch (Exception e) {
            hasNetwork = false;
        }
        return hasNetwork;
    }

    public static boolean hasInternetSettings() {
        if (IOUtility.getAccessPoint() == null) {
            try {
                HttpConnection connection = (HttpConnection)Connector.open((String)VALIDATE_LINK, (int)1, (boolean)true);
                if (connection != null) {
                    if (SystemProperties.getPhonePlatform() == 2) {
                        connection.getResponseCode();
                    }
                    connection.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return IOUtility.getAccessPoint() != null;
        }
        return true;
    }

    private static AccessPoint getAccessPoint() {
        AccessPoint ap;
        block5: {
            ap = null;
            try {
                if (SystemProperties.getPhonePlatform() == 2) {
                    DestinationNetwork[] dns = IAPInfo.getIAPInfo().getDestinationNetworks();
                    int i = 0;
                    while (i < dns.length) {
                        ap = IOUtility.getAccessPoint(dns[i]);
                        if (ap == null) {
                            ++i;
                            continue;
                        }
                        break block5;
                    }
                    break block5;
                }
                ap = IOUtility.getAccessPoint(null);
            }
            catch (IAPInfoException iAPInfoException) {
                // empty catch block
            }
        }
        return ap;
    }

    private static AccessPoint getAccessPoint(DestinationNetwork dns) throws IAPInfoException {
        AccessPoint[] aps = null;
        if (dns != null) {
            aps = dns.getAccessPoints();
        } else {
            IAPInfo iapInfo = IAPInfo.getIAPInfo();
            if (iapInfo != null) {
                aps = iapInfo.getConnectionPreferences();
            }
        }
        if (aps != null) {
            int i = 0;
            while (i < aps.length) {
                if (dns != null && aps[i] != null) {
                    return aps[i];
                }
                if (!IOUtility.isLocalConnection(aps[i])) {
                    return aps[i];
                }
                ++i;
            }
        }
        return null;
    }

    private static boolean isLocalConnection(AccessPoint ap) {
        return ap.getBearerType().equals(LAN_BEARER) && ap.getServiceType().equals(LAN_SERVICE);
    }
}

