/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.utils;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public final class Logger {
    public static final int INFO = 0;
    public static final int WAR = 1;
    public static final int ERROR = 2;
    public static final int FAT = 3;
    public static final boolean SAVE_LOG_FILE = false;
    public static final boolean LOG_ON = true;
    public static final String LOG_FOLDER = String.valueOf(System.getProperty("fileconn.dir.videos")) + "logger/";
    private static final String FILE_PATH_TXT = String.valueOf(LOG_FOLDER) + "Trace";
    private static final String FILE_PATH_TXT_EXT = ".TXT";
    private static Logger logger;
    private static int level;
    private static String fileKeyName;
    private static boolean saveFile;
    private static FileConnection fileConnector;
    private static DataOutputStream stream;

    static {
        level = 0;
        fileKeyName = String.valueOf(FILE_PATH_TXT) + Logger.getDateStr() + FILE_PATH_TXT_EXT;
        saveFile = false;
        fileConnector = null;
        stream = null;
    }

    public static Logger getInstance() {
        if (logger == null) {
            logger = new Logger();
        }
        return logger;
    }

    private Logger() {
        if (saveFile) {
            Logger.openFile();
        }
    }

    public void cleanUp() {
        Logger.closeFile();
    }

    public static void log(int level, Object trace) {
        Logger.printDebug(level, trace);
    }

    public static void logInfo(Class c, Object trace) {
        String classname = c.getName();
        int packageindex = classname.lastIndexOf(46);
        Logger.printDebug(0, "[" + classname.substring(packageindex + 1) + "] " + trace);
    }

    public static void logError(Class c, Object trace) {
        String classname = c.getName();
        int packageindex = classname.lastIndexOf(46);
        Logger.printDebug(2, "[" + classname.substring(packageindex + 1) + "] " + trace);
    }

    private static void printDebug(int traceLevel, Object trace) {
        if (traceLevel >= level) {
            System.out.println("DBG_" + traceLevel + ": " + trace);
            if (saveFile) {
                try {
                    stream.writeChars("DBG_" + traceLevel + ": " + trace + "\n");
                    stream.flush();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    saveFile = false;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    saveFile = false;
                }
            }
        }
    }

    private static synchronized void openFile() {
        try {
            System.out.println("[Logger] " + fileKeyName);
            fileConnector = (FileConnection)Connector.open((String)fileKeyName);
            if (!fileConnector.exists()) {
                FileConnection dirCon = (FileConnection)Connector.open((String)LOG_FOLDER);
                if (!dirCon.exists()) {
                    dirCon.mkdir();
                }
                fileConnector.create();
            }
            stream = fileConnector.openDataOutputStream();
            saveFile = true;
        }
        catch (IOException e) {
            saveFile = false;
            System.out.println("[Logger.openFile()] failed " + e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("[Logger.openFile()] failed " + e.getMessage());
            e.printStackTrace();
            saveFile = false;
        }
    }

    private static synchronized void closeFile() {
        try {
            if (stream != null) {
                stream.close();
            }
            if (fileConnector != null) {
                fileConnector.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static String getDateStr() {
        String dataStr = null;
        Calendar calendar = null;
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int min = 0;
        int sec = 0;
        calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        year = calendar.get(1);
        month = calendar.get(2) + 1;
        day = calendar.get(5);
        hour = calendar.get(10);
        min = calendar.get(12);
        sec = calendar.get(13);
        dataStr = String.valueOf(Integer.toString(year)) + Integer.toString(month) + Integer.toString(day) + Integer.toString(hour) + Integer.toString(min) + Integer.toString(sec);
        return dataStr;
    }
}

