/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.utils;

import com.sonyericsson.fifa.utils.DateConstants;
import com.sonyericsson.fifa.utils.Logger;
import com.sun.lwuit.plaf.UIManager;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.Vector;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Display;
import javax.microedition.midlet.MIDlet;

public class SystemProperties {
    public static final int OSE_PLATFORM_HB108 = 0;
    public static final int OSE_PLATFORM_HB209 = 1;
    public static final int SYMBIAN_PLATFORM = 2;
    public static final int EMULATOR_PLATFORM = 3;
    public static final int MAX_NUMBER_FEEDS_ITEMS_TO_PARSER = 20;
    private static String MIDletVersion;
    private static String MIDletName;
    private static String PhoneLanguage;
    private static String PhoneModel;
    private static String UpgradeUrl;
    private static String UpgradeParameters;
    private static String UpgradeParametersHS;
    private static MIDlet midlet;
    private static com.sun.lwuit.Display displayProp;
    private static int displayWidth;
    private static int displayHeight;
    private static SystemProperties instance;
    private static int phonePlatform;
    private static final String DEFAULT_STRING = "???";
    static /* synthetic */ Class class$0;

    public static void initialize(MIDlet m) {
        if (instance == null) {
            midlet = m;
            displayProp = com.sun.lwuit.Display.getInstance();
            instance = new SystemProperties();
        }
    }

    private SystemProperties() {
        displayWidth = displayProp.getDisplayWidth();
        displayHeight = displayProp.getDisplayHeight();
        MIDletVersion = midlet.getAppProperty("MIDlet-Version");
        MIDletName = midlet.getClass().getName();
        PhoneLanguage = System.getProperty("microedition.locale");
        MIDletVersion = midlet.getAppProperty("MIDlet-Version");
        PhoneModel = System.getProperty("microedition.platform");
        PhoneModel = PhoneModel.substring(0, PhoneModel.indexOf("/"));
        UpgradeUrl = midlet.getAppProperty("SEMC-Server-URL");
        UpgradeParameters = "?type=app&revision=" + MIDletVersion;
        UpgradeParametersHS = "?type=hs&revision=" + MIDletVersion;
    }

    public static String getMainMidletPath() {
        String midletPath = "com.sonyericsson.fifa";
        if (midlet != null) {
            midletPath = midlet.getClass().getName();
        }
        return midletPath;
    }

    public static void platformRequest(String param) throws ConnectionNotFoundException {
        midlet.platformRequest(param);
    }

    public static void upgradeApplication() throws ConnectionNotFoundException {
        try {
            HttpConnection conn = null;
            int responseCode = 0;
            if (SystemProperties.getPhonePlatform() != 2) {
                conn = (HttpConnection)Connector.open((String)(String.valueOf(UpgradeUrl) + UpgradeParametersHS));
                conn.setRequestMethod("GET");
                conn.setRequestProperty("User-Agent", PhoneModel);
                responseCode = conn.getResponseCode();
                if (responseCode == 200 || responseCode == 302) {
                    midlet.platformRequest(String.valueOf(UpgradeUrl) + UpgradeParametersHS);
                }
                conn.close();
            }
            conn = (HttpConnection)Connector.open((String)(String.valueOf(UpgradeUrl) + UpgradeParameters));
            conn.setRequestMethod("GET");
            conn.setRequestProperty("User-Agent", PhoneModel);
            responseCode = conn.getResponseCode();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.SystemProperties");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Logger.logInfo(clazz, "url = " + UpgradeUrl + UpgradeParameters);
            if (responseCode == 200 || responseCode == 302) {
                midlet.platformRequest(String.valueOf(UpgradeUrl) + UpgradeParameters);
            }
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getDisplayWidth() {
        return displayWidth;
    }

    public static int getDisplayHeight() {
        return displayHeight;
    }

    public static int getPhonePlatform() {
        String platform = System.getProperty("microedition.platform");
        com.sun.lwuit.Display.getInstance().setTouchScreenDevice(false);
        if (platform.indexOf("SDK") != -1) {
            phonePlatform = 3;
        } else {
            String javaPlatform = System.getProperty("com.sonyericsson.java.platform");
            if (javaPlatform.indexOf("SJP") != -1) {
                com.sun.lwuit.Display.getInstance().setTouchScreenDevice(true);
                UIManager.getInstance().getLookAndFeel().setTactileTouchDuration(10);
                phonePlatform = 2;
            } else {
                phonePlatform = javaPlatform.indexOf("JP-8.5") != -1 ? 1 : 0;
            }
        }
        return phonePlatform;
    }

    public static boolean isNoInternetSettingsException(Exception e) {
        String message = "No network settings";
        if (SystemProperties.getPhonePlatform() == 2) {
            message = "-3";
        }
        String exception = e.getMessage();
        boolean contains = false;
        if (exception != null && exception.indexOf(message) != -1) {
            contains = true;
        }
        return contains;
    }

    public static boolean isConnectionNotFoundException(Exception e) {
        boolean contains = false;
        if (e instanceof ConnectionNotFoundException) {
            contains = true;
        } else {
            String message = "Host not found";
            String exception = e.getMessage();
            if (exception != null) {
                if (exception.indexOf(message) != -1) {
                    contains = true;
                }
            } else {
                contains = true;
            }
        }
        return contains;
    }

    public static Display getLCDUIDisplay() {
        return Display.getDisplay((MIDlet)midlet);
    }

    public static String getMidletName() {
        return MIDletName;
    }

    public static String getContentType(String filename) {
        String contentType = null;
        if (filename.endsWith(".3gp")) {
            contentType = "video/3gpp";
        } else if (filename.endsWith(".mp4")) {
            contentType = "video/mpeg4";
        }
        return contentType;
    }

    public static String getFilename(String filepath) {
        int index = filepath.lastIndexOf(47) + 1;
        String filename = filepath.substring(index);
        if (filename.endsWith(".mp4")) {
            index = filename.indexOf(".mp4");
            if (index > -1) {
                return filename.substring(0, index);
            }
            return null;
        }
        if (filename.endsWith(".3gp")) {
            index = filename.indexOf(".3gp");
            if (index > -1) {
                return filename.substring(0, index);
            }
            return null;
        }
        return null;
    }

    public static final String escapeHTML(String string) {
        StringBuffer sb = new StringBuffer(string.length());
        boolean lastWasBlankChar = false;
        boolean removeAllAfter = false;
        int len = string.length();
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            if (removeAllAfter && c != '>' && c != ';') {
                sb.append("");
            } else if (c == ' ') {
                if (lastWasBlankChar) {
                    lastWasBlankChar = false;
                    sb.append("");
                } else {
                    lastWasBlankChar = true;
                    sb.append(' ');
                }
            } else {
                lastWasBlankChar = false;
                if (c == '&') {
                    sb.append("");
                } else if (c == '<') {
                    removeAllAfter = true;
                    sb.append("");
                } else if (c == '>') {
                    removeAllAfter = false;
                    sb.append("");
                } else if (c == '#') {
                    removeAllAfter = true;
                    sb.append("");
                } else if (c == ';') {
                    removeAllAfter = false;
                    sb.append("");
                } else if (c == '\n') {
                    sb.append("");
                } else {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static final String removeTrashCharacters(String input) {
        String newString = input.replace('?', '_');
        newString = newString.replace('=', '_');
        newString = newString.replace('%', '_');
        newString = newString.replace('&', '_');
        return newString;
    }

    public static Calendar getTimeCalendar(String time) {
        int dayOfWeek = -1;
        int day = -1;
        int month = -1;
        int year = -1;
        int hour = -1;
        int minute = -1;
        int second = -1;
        String timeZone = null;
        int i = 0;
        String[] timeSplit = SystemProperties.splitString(time, ' ');
        while (i < timeSplit.length) {
            switch (i) {
                case 0: {
                    dayOfWeek = DateConstants.getDayOfWeek(timeSplit[i]);
                    break;
                }
                case 1: {
                    day = Integer.parseInt(timeSplit[i]);
                    break;
                }
                case 2: {
                    month = DateConstants.getMonthOfYear(timeSplit[i]);
                    break;
                }
                case 3: {
                    year = Integer.parseInt(timeSplit[i]);
                    break;
                }
                case 4: {
                    int[] timeArray = SystemProperties.parseTimeToInt(timeSplit[i]);
                    hour = timeArray[0];
                    minute = timeArray[1];
                    second = timeArray[2];
                    break;
                }
                case 5: {
                    timeZone = timeSplit[i];
                    break;
                }
            }
            ++i;
        }
        if (timeZone == null) {
            timeZone = "GMT";
        }
        TimeZone defaultTimeZone = TimeZone.getTimeZone(timeZone);
        Calendar calendar = Calendar.getInstance(defaultTimeZone);
        if (dayOfWeek != -1) {
            calendar.set(7, dayOfWeek);
        }
        if (day != -1) {
            calendar.set(5, day);
        }
        if (month != -1) {
            calendar.set(2, month);
        }
        if (year != -1) {
            calendar.set(1, year);
        }
        if (hour != -1) {
            calendar.set(10, hour);
        }
        if (minute != -1) {
            calendar.set(12, minute);
        }
        if (second != -1) {
            calendar.set(13, second);
        }
        return calendar;
    }

    public static int[] parseTimeToInt(String time) {
        int[] timeArray = new int[3];
        String[] timeSplit = SystemProperties.splitString(time, ':');
        int hour = -1;
        int minute = -1;
        int second = -1;
        int i = 0;
        while (i < timeSplit.length) {
            switch (i) {
                case 0: {
                    hour = Integer.parseInt(timeSplit[i]);
                    break;
                }
                case 1: {
                    minute = Integer.parseInt(timeSplit[i]);
                    break;
                }
                case 2: {
                    second = Integer.parseInt(timeSplit[i]);
                    break;
                }
            }
            ++i;
        }
        timeArray[0] = hour;
        timeArray[1] = minute;
        timeArray[2] = second;
        return timeArray;
    }

    public static final String[] splitString(String input, char separator) {
        if (input == null) {
            return null;
        }
        int textSize = input.length();
        if (textSize == 0) {
            return null;
        }
        Vector<String> list = new Vector<String>();
        int i = 0;
        int start = 0;
        boolean allow = false;
        while (i < textSize) {
            if (input.charAt(i) == separator) {
                if (allow) {
                    list.addElement(input.substring(start, i).trim());
                    allow = false;
                }
                start = ++i;
                continue;
            }
            allow = true;
            ++i;
        }
        if (allow) {
            list.addElement(input.substring(start, i).trim());
        }
        Object[] elements = new String[list.size()];
        list.copyInto(elements);
        return elements;
    }

    public static final int compareCalendar(Calendar first, Calendar second) {
        int i = 0;
        i = second.after(first) ? 1 : -1;
        return i;
    }

    public static boolean isRoaming() {
        boolean retValue = false;
        String isHome = System.getProperty("com.sonyericsson.net.isonhomeplmn");
        String rat = System.getProperty("com.sonyericsson.net.rat");
        String netstatus = System.getProperty("com.sonyericsson.net.status");
        if (rat != null && netstatus != null && !netstatus.equalsIgnoreCase("No Network") && !netstatus.equalsIgnoreCase("Home PLMN") && !netstatus.equalsIgnoreCase("Forbidden") && isHome != null && isHome.equalsIgnoreCase("false")) {
            retValue = true;
        }
        return retValue;
    }

    public static boolean isFlightMode() {
        boolean retValue = false;
        String isFlightMode = System.getProperty("com.sonyericsson.net.rat");
        if (isFlightMode == null) {
            retValue = true;
        }
        return retValue;
    }

    public static String getPhoneLanguage() {
        return PhoneLanguage;
    }

    public static void setPhoneLanguage(String phoneLanguage) {
        PhoneLanguage = phoneLanguage;
    }

    public static String convertString(String theString) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len);
        int x = 0;
        while (x < len) {
            int aChar;
            if ((aChar = theString.charAt(x++)) == 92) {
                if ((aChar = theString.charAt(x++)) == 117) {
                    int value = 0;
                    int i = 0;
                    while (i < 4) {
                        aChar = theString.charAt(x++);
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                break;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                break;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                break;
                            }
                            default: {
                                return DEFAULT_STRING;
                            }
                        }
                        ++i;
                    }
                    outBuffer.append((char)value);
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                outBuffer.append((char)aChar);
                continue;
            }
            outBuffer.append((char)aChar);
        }
        return outBuffer.toString();
    }
}

