/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.components.forms;

import com.sonyericsson.fifa.exceptions.ComponentException;
import com.sonyericsson.fifa.utils.SystemProperties;
import com.sonyericsson.fifa.view.FifaResources;
import com.sonyericsson.fifa.view.Images;
import com.sonyericsson.fifa.view.components.FifaTextArea;
import com.sonyericsson.fifa.view.components.forms.BaseForm;
import com.sonyericsson.fifa.view.components.list.AuthorizationGroupContainer;
import com.sonyericsson.fifa.view.components.list.AuthorizationListItem;
import com.sonyericsson.fifa.view.components.listener.SelectableItemListener;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Label;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.Style;

public class AuthorizationForm
extends BaseForm {
    private TextArea titleText = null;
    private FifaTextArea questionText = null;
    private Container headerContainer = null;
    private Container bodyContainer = null;
    private Label lineDivider = null;
    private SelectableItemListener selectListener = null;
    private AuthorizationGroupContainer listGroupContainer = null;
    private static final int ITEM_TITLE_TOP = 12;
    private static final int CONTAINER_HEIGHT = 189;

    public AuthorizationForm() {
        this.setWidth(this.getAttributes().getWidth());
        this.getHeaderContainer().addComponent(this.getTitleTextArea());
        this.getBodyContainer().addComponent(this.getHeaderContainer());
        this.getBodyContainer().addComponent(this.getQuestionArea());
        this.getBodyContainer().addComponent(this.getLineDivider());
        this.getBodyContainer().addComponent(this.getListGroup());
        this.getBodyContainer().setPreferredH(this.getContainerHeight());
        this.getBodyContainer().setScrollableY(true);
        this.setFocused(this.getListGroup());
        this.addComponent(this.getBodyContainer());
        this.addSoftkey();
        this.setSoftKeys();
    }

    private int getContainerHeight() {
        int totalHeight = 0;
        totalHeight += this.headerContainer.getPreferredH();
        totalHeight += this.questionText.getPreferredH();
        totalHeight += this.lineDivider.getPreferredH();
        if ((totalHeight += this.listGroupContainer.getPreferredH()) < this.getAttributes().getHeight()) {
            totalHeight = this.getAttributes().getHeight();
        }
        return totalHeight;
    }

    public void setSoftKeys() {
        try {
            this.setMiddleSoftkeyLabel(FifaResources.getMessage("FANAPP_SK_SELECT_TXT"));
            this.setRightSoftkeyLabel(" ");
            this.setSoftkeyEnabled(-7, false);
        }
        catch (ComponentException e) {
            e.printStackTrace();
        }
    }

    public void keyPressed(int keyCode) {
        if (keyCode == -5) {
            if (this.getListGroup().getSelectedItem() != -1) {
                int selectedItem = this.getListGroup().getSelectedItem();
                this.notifySelectedItem(selectedItem);
            }
        } else {
            this.notifyKeyPressed(keyCode);
        }
        super.keyPressed(keyCode);
    }

    private Container getHeaderContainer() {
        if (this.headerContainer == null) {
            this.headerContainer = new Container();
            this.headerContainer.setLayout(new BoxLayout(1));
            this.headerContainer.setPreferredW(this.getAttributes().getWidth());
            this.headerContainer.setPreferredH(189);
            this.headerContainer.getStyle().setMargin(0, 0, 0, 0);
            this.headerContainer.setFocusable(false);
        }
        return this.headerContainer;
    }

    private Container getBodyContainer() {
        if (this.bodyContainer == null) {
            this.bodyContainer = new Container();
            this.bodyContainer.setLayout(new BoxLayout(2));
            this.bodyContainer.setPreferredW(this.getAttributes().getWidth());
            this.bodyContainer.getStyle().setBgImage(Images.getBackgroundImg());
        }
        return this.bodyContainer;
    }

    private Label getLineDivider() {
        if (this.lineDivider == null) {
            this.lineDivider = new Label();
            this.lineDivider.getStyle().setBgTransparency(0);
            this.lineDivider.setIcon(Images.getLitsDividerImg());
            this.lineDivider.getStyle().setMargin(0, 10, 0, 0);
            this.lineDivider.setFocusable(false);
        }
        return this.lineDivider;
    }

    private TextArea getTitleTextArea() {
        if (this.titleText == null) {
            this.titleText = new TextArea();
            this.setTitleTextAreaMarginFont(this.titleText.getStyle());
            this.setTextAreaStyle(this.titleText.getStyle());
            this.titleText.setPreferredW(this.getAttributes().getWidth());
            this.titleText.setEditable(false);
            this.titleText.setFocusable(false);
            this.titleText.setGrowByContent(true);
            this.titleText.setText(FifaResources.getMessage("FANAPP_WARNING_CONNECT_MSG_COST_TXT"));
        }
        return this.titleText;
    }

    private FifaTextArea getQuestionArea() {
        if (this.questionText == null) {
            this.questionText = new FifaTextArea();
            this.setTextAreaStyle(this.questionText.getStyle());
            this.setDescriptionTextAreaMarginFont(this.questionText.getStyle());
            this.questionText.setEditable(false);
            this.questionText.setFocusable(false);
            this.questionText.setFocusPainted(false);
            this.questionText.setGrowByContent(true);
            this.questionText.setText(FifaResources.getMessage("FANAPP_WARNING_CONNECT_ANYWAY_TXT"));
        }
        return this.questionText;
    }

    private void setTitleTextAreaMarginFont(Style style) {
        style.setMargin(this.getAttributes().getSquadTitleMarginTopBottom(), this.getAttributes().getSquadTitleMarginTopBottom(), this.getAttributes().getSquadTitleMarginLeftRight(), this.getAttributes().getSquadTitleMarginLeftRight());
        style.setFont(FifaResources.getFont("Font_Alert_Network"));
    }

    private void setDescriptionTextAreaMarginFont(Style style) {
        style.setMargin(this.getAttributes().getSquadTitleMarginLeftRight(), this.getAttributes().getSquadTitleMarginLeftRight() - 5, this.getAttributes().getSquadTitleMarginLeftRight(), 0);
        style.setFont(FifaResources.getFont("Font_SansSerif_Medium_Regular"));
    }

    private void setTextAreaStyle(Style style) {
        style.setPadding(0, 0, 0, 7);
        style.setBgTransparency(0);
        style.setFgColor(0xFFFFFF);
        style.setBorder(Border.createEmpty());
    }

    public void setTitle(String text) {
        this.getTitleTextArea().setText(SystemProperties.escapeHTML(text));
    }

    public void setDescription(String text) {
        this.getQuestionArea().setText(SystemProperties.escapeHTML(text));
    }

    public void addNewOption(String titleText) {
        this.getListGroup().addComponent(this.newListItem(titleText));
        this.listGroupContainer.setHighlight();
    }

    public AuthorizationGroupContainer getListGroup() {
        if (this.listGroupContainer == null) {
            this.listGroupContainer = new AuthorizationGroupContainer();
        }
        return this.listGroupContainer;
    }

    private AuthorizationListItem newListItem(String titleText) {
        AuthorizationListItem listItem = new AuthorizationListItem(titleText);
        listItem.setListItemDimension(this.attributes.getListItemWidth(), this.attributes.getListItemHeight());
        listItem.setSubtitlePadding(0, 12);
        return listItem;
    }

    public void setSelectedItemListener(SelectableItemListener selectListener) {
        this.selectListener = selectListener;
    }

    private void notifySelectedItem(int item) {
        if (this.selectListener != null) {
            this.selectListener.selectedItem(item, 0);
        }
    }

    public void refreshAll() {
        this.getTitleTextArea().setText(FifaResources.getMessage("FANAPP_WARNING_CONNECT_MSG_COST_TXT"));
        this.getQuestionArea().setText(FifaResources.getMessage("FANAPP_WARNING_CONNECT_ANYWAY_TXT"));
        this.getListGroup().removeAll();
    }

    public void pointerPressed(int x, int y) {
        if (Display.getInstance().isTouchScreenDevice()) {
            super.pointerPressed(x, y);
            Component c = this.searchInstance(this.getComponentAt(x, y));
            if (c != null) {
                if (c.hasFocus()) {
                    this.notifySelectedItem(this.getListGroup().getComponentIndex(c));
                } else {
                    c.requestFocus();
                }
            } else {
                super.pointerPressed(x, y -= this.attributes.getPointerPressedY());
            }
        }
    }

    public void pointerDragged(int x, int y) {
        if (Display.getInstance().isTouchScreenDevice()) {
            super.pointerDragged(x, y);
        }
    }

    private Component searchInstance(Component cmp) {
        while (!(cmp instanceof AuthorizationListItem)) {
            if ((cmp = cmp.getParent()) != null) continue;
            return null;
        }
        return cmp;
    }
}

