/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.components.forms;

import com.sonyericsson.fifa.exceptions.ComponentException;
import com.sonyericsson.fifa.utils.SystemProperties;
import com.sonyericsson.fifa.view.FifaResources;
import com.sonyericsson.fifa.view.components.FifaTextAreaCentered;
import com.sonyericsson.fifa.view.components.forms.BaseForm;
import com.sonyericsson.fifa.view.components.listener.SelectableItemListener;
import com.sun.lwuit.Container;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.CoordinateLayout;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.Style;

public class DialogForm
extends BaseForm {
    private FifaTextAreaCentered textArea = null;
    private Container background = null;
    private String message = null;
    private int viewId;
    private SelectableItemListener selectListener = null;
    public static final int DIALOG_YESNO_VIEW_ID = 18;
    public static final int YES_OPTION = 1;
    public static final int NO_OPTION = 2;

    public DialogForm(String message, int viewId) {
        this.message = message;
        this.viewId = viewId;
        this.setPreferredSize(new Dimension(this.getAttributes().getWidth(), this.getAttributes().getHeight()));
    }

    public void addComponents() {
        block9: {
            this.initBackground();
            this.initTextArea();
            this.addComponent(this.background);
            this.addSoftkey();
            if (this.viewId == 18) {
                try {
                    if (SystemProperties.getPhonePlatform() == 2) {
                        this.setLeftSoftkeyLabel(FifaResources.getMessage("FANAPP_YES_TXT"));
                        this.setMiddleSoftkeyLabel(null);
                        this.setRightSoftkeyLabel(FifaResources.getMessage("FANAPP_NO_TXT"));
                        this.setSoftkeyEnabled(-6, true);
                        break block9;
                    }
                    this.setMiddleSoftkeyLabel(FifaResources.getMessage("FANAPP_YES_TXT"));
                    this.setRightSoftkeyLabel(FifaResources.getMessage("FANAPP_NO_TXT"));
                }
                catch (ComponentException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    if (SystemProperties.getPhonePlatform() == 2) {
                        this.setMiddleSoftkeyLabel(null);
                        this.setRightSoftkeyLabel(FifaResources.getMessage("FIFA_MSK_OK_SK"));
                    } else {
                        this.setMiddleSoftkeyLabel(FifaResources.getMessage("FIFA_MSK_OK_SK"));
                        this.setRightSoftkeyLabel(null);
                        this.setSoftkeyEnabled(-7, false);
                    }
                }
                catch (ComponentException e) {
                    e.printStackTrace();
                }
            }
        }
        this.background.addComponent(this.textArea);
    }

    public void refreshAll() {
        if (this.background.getComponentCount() > 0) {
            this.background.removeAll();
        }
        this.removeComponent(this.background);
    }

    public void keyPressed(int keyCode) {
        super.keyPressed(keyCode);
        if (this.viewId == 18) {
            if (SystemProperties.getPhonePlatform() == 2) {
                if (keyCode == -6) {
                    this.notifySelectedItem(1);
                } else if (keyCode == -7) {
                    this.notifySelectedItem(2);
                }
            } else if (keyCode == -5) {
                this.notifySelectedItem(1);
            } else if (keyCode == -7) {
                this.notifySelectedItem(2);
            }
        } else if (keyCode == -5) {
            this.notifySelectedItem(1);
        }
    }

    public void setSelectedItemListener(SelectableItemListener selectListener) {
        this.selectListener = selectListener;
    }

    private void notifySelectedItem(int item) {
        if (this.selectListener != null) {
            this.selectListener.selectedItem(item, 0);
        }
    }

    private void initTextArea() {
        this.textArea = new FifaTextAreaCentered();
        this.setTextAreaStyle(this.textArea.getStyle());
        this.textArea.setPreferredSize(new Dimension(this.getAttributes().getWidth(), this.getAttributes().getHeight()));
        this.textArea.setRows(10);
        this.textArea.setEditable(false);
        this.textArea.setFocusable(false);
        this.textArea.setGrowByContent(false);
        this.textArea.setText(FifaResources.getMessage(this.message));
    }

    private Container initBackground() {
        this.background = new Container();
        this.background.setLayout(new CoordinateLayout(this.getAttributes().getWidth(), this.getAttributes().getHeight()));
        this.background.getStyle().setBgTransparency(160);
        this.background.getStyle().setBgColor(0);
        this.background.setY(0);
        return this.background;
    }

    private void setTextAreaStyle(Style style) {
        style.setMargin(0, 0, 0, 0);
        style.setBgColor(0);
        style.setBgTransparency(0);
        style.setFgColor(0xFFFFFF);
        style.setFont(FifaResources.getFont("Font_SansSerif_Small_Bold"));
        style.setBorder(Border.createEmpty());
        style.setPadding(this.attributes.getDialogOkTextPosY(), 0, 15, 20);
    }
}

