/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.components.forms;

import com.sonyericsson.fifa.exceptions.ComponentException;
import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.utils.Logger;
import com.sonyericsson.fifa.utils.SystemProperties;
import com.sonyericsson.fifa.view.FifaResources;
import com.sonyericsson.fifa.view.components.forms.BaseForm;
import com.sonyericsson.fifa.view.components.list.CountryDataItem;
import com.sonyericsson.fifa.view.components.list.ListComponentsContainer;
import com.sonyericsson.fifa.view.components.list.ListItem;
import com.sonyericsson.fifa.view.components.listener.SelectableItemListener;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Image;
import com.sun.lwuit.geom.Dimension;
import java.io.IOException;
import java.util.Vector;

public class ListItemsForm
extends BaseForm {
    protected ListComponentsContainer listComponents = new ListComponentsContainer();
    protected int subGroupHeight = 0;
    private SelectableItemListener selectListener = null;

    public ListItemsForm() {
        Container container = new Container();
        container.addComponent(this.listComponents);
        container.setPreferredSize(new Dimension(this.attributes.getWidth(), this.attributes.getTabContentHeight() + this.attributes.getTabsMenuHeight()));
        this.addComponent(container);
        this.setSoftkeyLabel();
        this.addSoftkey();
    }

    protected void setSoftkeyLabel() {
        try {
            this.setRightSoftkeyLabel(FifaResources.getMessage("FANAPP_SK_BACK_TXT"));
            if (SystemProperties.getPhonePlatform() != 2) {
                this.setMiddleSoftkeyLabel(FifaResources.getMessage("FANAPP_SK_SELECT_TXT"));
            }
        }
        catch (ComponentException e) {
            e.printStackTrace();
        }
    }

    protected void addGroup(String groupName) {
        this.listComponents.addGroup(groupName);
    }

    protected void addItem(String subGroup, String titleText, String subtitleText, String iconPath) {
        this.listComponents.addItem(subGroup, this.newListItem(titleText, subtitleText, iconPath));
    }

    protected void addItem(String subGroup, String titleText, String subtitleText, Image icon) {
        this.listComponents.addItem(subGroup, this.newListItem(titleText, subtitleText, icon));
    }

    protected void addFakeItem(String subGroup, Component component) {
        this.listComponents.addFakeItem(subGroup, component);
    }

    protected void addItem(String subGroup, Component component) {
        try {
            this.listComponents.addItem(subGroup, component);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void addItem(int componentIndex, String subGroup, Component component) {
        try {
            this.listComponents.addItem(componentIndex, subGroup, component);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void addGroup(boolean anotherBg, String groupName) {
        this.listComponents.addGroup(anotherBg, groupName);
    }

    private CountryDataItem newCountryDataItem(String countryGroup, String countryFlagPath) {
        CountryDataItem countryData = null;
        if (countryFlagPath == null) {
            countryData = new CountryDataItem(countryGroup, null);
        } else {
            try {
                countryData = new CountryDataItem(countryGroup, Image.createImage(IOUtility.openFileInputStream(String.valueOf(FifaResources.getImageFolder()) + countryFlagPath + ".png")));
            }
            catch (IOException e) {
                Logger.logError(this.getClass(), "Exception to read image " + FifaResources.getImageFolder() + countryFlagPath + ".png");
            }
        }
        return countryData;
    }

    protected ListItem newListItem(String title, String subTitle, String picturePath) {
        ListItem item = this.createListItem(title, subTitle);
        item.setPicture(picturePath);
        return item;
    }

    protected ListItem newListItem(String title, String subTitle, Image picture) {
        ListItem item = this.createListItem(title, subTitle);
        item.setPicture(picture);
        return item;
    }

    private ListItem createListItem(String title, String subTitle) {
        ListItem item = new ListItem();
        item.setListItemDimension(this.getAttributes().getListItemWidth(), this.getAttributes().getListItemHeight());
        item.setTitleText(SystemProperties.escapeHTML(title));
        item.setTitlePadding(0, this.getAttributes().getListItemTop());
        item.setSubtitleText(SystemProperties.escapeHTML(subTitle));
        item.setFocusable(true);
        return item;
    }

    protected void setHeadline(String[] imagesPath, int borderType, int posX) {
        this.listComponents.setHeadline(imagesPath, borderType);
    }

    protected void setHeadline(Vector images, int borderType) {
        this.listComponents.setHeadline(images, borderType);
    }

    protected void setCrossfadePosition(int posX) {
        this.listComponents.setCrossfadePosition(posX, this.attributes.getHeadlinePosY());
    }

    protected void showWaitIndicator(String subGroup, int height) {
        this.listComponents.showWaitIndicator(subGroup, height);
    }

    public void addCountryDataItem(String countryGroup, String countryFlagPath) {
        this.listComponents.addCountryDataItem(this.newCountryDataItem(countryGroup, countryFlagPath));
    }

    public void startCrossfade() {
        this.listComponents.startHeadlineCrossfade(this);
    }

    public void pauseCrossfade() {
        this.listComponents.pauseHeadlineCrossfase(this);
    }

    public void setSelectableItemListener(SelectableItemListener selectableItemListener) {
        this.selectListener = selectableItemListener;
        this.listComponents.setSelectedItemListener(selectableItemListener);
    }

    public void setItemPicture(String subGroup, int itemIndex, String picturePath) {
        this.listComponents.setItemPicture(subGroup, itemIndex, picturePath);
    }

    public void keyPressed(int keyCode) {
        if (keyCode == -5) {
            this.selectedItem = this.listComponents.getSelectedItem();
        }
        super.keyPressed(keyCode);
    }

    public void keyReleased(int keyCode) {
        if (keyCode == -5 && this.selectedItem != null) {
            this.notifySelectedItem(this.selectedItem[0], this.selectedItem[1]);
            this.selectedItem = null;
        }
        super.keyReleased(keyCode);
    }

    private void notifySelectedItem(int item, int subgroup) {
        if (this.selectListener != null) {
            this.selectListener.selectedItem(item, subgroup);
        }
    }

    public void removeAll(String subgroupName) {
        this.listComponents.removeAll(subgroupName);
    }

    public void removeWaitIndicator(String subgroupName) {
        this.listComponents.removeWaitIndicator(subgroupName);
    }

    public void pointerPressed(int x, int y) {
        if (Display.getInstance().isTouchScreenDevice()) {
            this.listComponents.pointerPressed(x, y);
            super.pointerPressed(x, y);
        }
    }

    public void pointerDragged(int x, int y) {
        if (Display.getInstance().isTouchScreenDevice()) {
            super.pointerDragged(x, y);
        }
    }

    public void refreshAll(boolean removeHeadline) {
        this.listComponents.removeAllComponents(removeHeadline);
        this.setSoftkeyLabel();
    }

    public void focusFirstItem(String groupName) {
        this.listComponents.focusFirstItem(groupName);
        this.scrollComponentToVisible(this.listComponents.getFirstComponent(groupName, true));
    }
}

