/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.components.forms;

import com.sonyericsson.fifa.exceptions.ComponentException;
import com.sonyericsson.fifa.utils.Logger;
import com.sonyericsson.fifa.view.FifaResources;
import com.sonyericsson.fifa.view.components.forms.BaseForm;
import com.sonyericsson.fifa.view.components.list.ListItemButton;
import com.sonyericsson.fifa.view.components.list.ListItemFeedTicker;
import com.sonyericsson.fifa.view.components.list.ListItemMore;
import com.sonyericsson.fifa.view.components.listener.KeyListener;
import com.sonyericsson.fifa.view.components.listener.SelectableItemListener;
import com.sonyericsson.fifa.view.components.listener.TouchListener;
import com.sonyericsson.fifa.view.components.tabs.TabsManager;
import com.sun.lwuit.Display;
import com.sun.lwuit.Image;
import java.util.Vector;

public class MainForm
extends BaseForm {
    private SelectableItemListener selectListener = null;
    public static final int ID_MY_TEAM = 0;
    public static final int ID_TOURNAMENT = 1;
    public static final int ID_ENTERTAINMENT = 2;
    private TabsManager tabsManager = null;
    private ListItemFeedTicker ticker;

    public MainForm() {
        this.addComponent(this.getTabsManager());
        this.addSoftkey();
        this.setSoftKeyLabel();
    }

    private void setSoftKeyLabel() {
        try {
            this.setMiddleSoftkeyLabel(FifaResources.getMessage("FANAPP_SK_SELECT_TXT"));
            this.setRightSoftkeyLabel(FifaResources.getMessage("FANAPP_SK_BACK_TXT"));
        }
        catch (ComponentException e) {
            e.printStackTrace();
        }
    }

    private TabsManager getTabsManager() {
        if (this.tabsManager == null) {
            this.tabsManager = new TabsManager();
        }
        return this.tabsManager;
    }

    private void notifySelectedItem(int item, int subgroup) {
        if (this.selectListener != null) {
            this.selectListener.selectedItem(item, subgroup);
        }
    }

    private ListItemMore getMore() {
        ListItemMore more = new ListItemMore();
        more.setText(FifaResources.getMessage("FANAPP_MYTEAM_MORE_TXT"));
        return more;
    }

    private ListItemMore getAbout() {
        ListItemMore about = new ListItemMore();
        about.setText(FifaResources.getMessage("FANAPP_ABOUT_TXT"));
        return about;
    }

    private ListItemMore getSquad() {
        ListItemMore squad = new ListItemMore();
        squad.setText(FifaResources.getMessage("FANAPP_MYTEAM_SQUAD_TXT"));
        return squad;
    }

    private ListItemButton getChangeTeamItem() {
        ListItemButton changeTeam = new ListItemButton(false);
        changeTeam.setPreferredH(this.getAttributes().getListItemHeight() - 5);
        changeTeam.setText(FifaResources.getMessage("FANAPP_MYTEAM_TITLE_CHANGE_TEAM_TXT"));
        return changeTeam;
    }

    public void setKeyListener(KeyListener keyListener) {
        super.setKeyListener(keyListener);
    }

    public void addSelectedItemListener(SelectableItemListener selectableListener) {
        this.selectListener = selectableListener;
        this.getTabsManager().setSelectedItemListener(selectableListener);
    }

    public void removeSelectedItemListener(SelectableItemListener selectableListener) {
        this.selectListener = null;
        this.getTabsManager().setSelectedItemListener(null);
    }

    public void setTouchListener(TouchListener touchListener) {
        super.setTouchListener(touchListener);
    }

    public void pointerPressed(int x, int y) {
        if (Display.getInstance().isTouchScreenDevice()) {
            int action = this.getTabsManager().verifyPointerPressed(x, y);
            if (action == -1) {
                super.pointerPressed(x, y);
            } else {
                this.notifyTouchPressed(0, action);
            }
        }
    }

    public void pointerDragged(int x, int y) {
        if (Display.getInstance().isTouchScreenDevice()) {
            super.pointerDragged(x, y);
        }
    }

    public void keyPressed(int keyCode) {
        if (keyCode == -5) {
            this.selectedItem = this.getTabsManager().getSelectedItem();
            super.keyPressed(keyCode);
        } else if (this.getTabsManager().verifyKeyPressed(keyCode)) {
            super.keyPressed(keyCode);
        }
    }

    public void keyReleased(int keyCode) {
        super.keyReleased(keyCode);
        if (keyCode == -5 && this.selectedItem != null) {
            this.notifySelectedItem(this.selectedItem[0], this.selectedItem[1]);
            this.selectedItem = null;
        }
    }

    public void addItem(int tabIndex, String subGroup, String titleText, String subtitleText) {
        this.getTabsManager().addItem(tabIndex, subGroup, titleText, subtitleText);
    }

    public void addFeedTicker(boolean status) {
        this.getFeedTicker().setStatus(status);
        if (!this.getTabsManager().containsItem(0, FifaResources.getMessage("FANAPP_MYTEAM_TITLE_NEWS_TXT"), this.getFeedTicker())) {
            this.getTabsManager().changeFirstItemBackground(0, 0, FifaResources.getMessage("FANAPP_MYTEAM_TITLE_NEWS_TXT"), false);
            this.getTabsManager().addItem(0, 0, FifaResources.getMessage("FANAPP_MYTEAM_TITLE_NEWS_TXT"), this.getFeedTicker());
            this.getTabsManager().revalidate();
        }
    }

    public void removeFeedTicker() {
        this.getTabsManager().removeItem(0, FifaResources.getMessage("FANAPP_MYTEAM_TITLE_NEWS_TXT"), this.getFeedTicker());
        this.getTabsManager().changeFirstItemBackground(0, 0, FifaResources.getMessage("FANAPP_MYTEAM_TITLE_NEWS_TXT"), true);
        this.getTabsManager().revalidate();
    }

    public boolean isTickerFinished() {
        return this.getFeedTicker().isFinished();
    }

    private ListItemFeedTicker getFeedTicker() {
        if (this.ticker == null) {
            this.ticker = new ListItemFeedTicker();
        }
        return this.ticker;
    }

    public void addMoreItem() {
        this.getTabsManager().addItem(0, FifaResources.getMessage("FANAPP_MYTEAM_TITLE_NEWS_TXT"), this.getMore());
    }

    public void addSquadItem() {
        this.getTabsManager().addItem(0, FifaResources.getMessage("FANAPP_MYTEAM_TEAM_TXT"), this.getSquad());
    }

    public void addChangeTeamItem() {
        this.getTabsManager().addItem(0, FifaResources.getMessage("FANAPP_MYTEAM_TEAM_TXT"), this.getChangeTeamItem());
    }

    public void addAboutItem() {
        this.getTabsManager().addItem(0, FifaResources.getMessage("FANAPP_MYTEAM_TEAM_TXT"), this.getAbout());
    }

    public void fillEmptySpace(int tab) {
        this.getTabsManager().fillEmptySpace(tab);
    }

    public void setItemPicture(int itemIndex, String picturePath) {
        this.getTabsManager().setItemPicture(0, FifaResources.getMessage("FANAPP_MYTEAM_TITLE_NEWS_TXT"), itemIndex, picturePath);
    }

    public void addItem(int tabIndex, String subGroup, String titleText, String subtitleText, String iconPath) {
        this.getTabsManager().addItem(tabIndex, subGroup, titleText, subtitleText, iconPath);
    }

    public void addItem(int tabIndex, String subGroup, String titleText, String subtitleText, Image icon) {
        this.getTabsManager().addItem(tabIndex, subGroup, titleText, subtitleText, icon);
    }

    public void myTeamRemoveAll() {
        this.getTabsManager().removeWaitIndicator(0);
        this.getTabsManager().removeAll(0, FifaResources.getMessage("FANAPP_MYTEAM_TITLE_NEWS_TXT"));
        this.getTabsManager().removeAll(0, FifaResources.getMessage("FANAPP_MYTEAM_TEAM_TXT"));
        this.getTabsManager().removeCountryDataItem(0);
    }

    public void setEntertainmentHeadline(String[] imagesPath) {
        this.getTabsManager().setHeadline(2, imagesPath, 1);
    }

    public void setCrossfadePosition(int tabIndex, int posX) {
        this.getTabsManager().setCrossfadePosition(tabIndex, posX);
    }

    public void setMyTeamHeadline(String[] imagesPath) {
        this.getTabsManager().setHeadline(0, imagesPath, 0);
    }

    public void setMyTeamHeadline(Vector images) {
        this.getTabsManager().setHeadline(0, images, 0);
    }

    public void startCrossfade(int subgroup) {
        this.getTabsManager().startCrossfade(subgroup, this);
    }

    public void pauseCrossfade(int subgroup) {
        this.getTabsManager().pauseCrossfade(subgroup, this);
    }

    public void addCountryDataItem(String countryGroup, String countryFlagPath) {
        this.getTabsManager().addCountryDataItem(0, countryGroup, countryFlagPath);
    }

    public void refreshAll(int tabIndex, boolean isLanguageChanged) {
        this.getTabsManager().removeAll(tabIndex);
        switch (tabIndex) {
            case 0: {
                this.getTabsManager().removeCountryDataItem(tabIndex);
                this.myTeamAddGroups();
                break;
            }
            case 2: {
                this.entertainmentAddGroups();
                break;
            }
            default: {
                Logger.logError(this.getClass(), "Invalid tab index");
            }
        }
        if (isLanguageChanged) {
            this.setSoftKeyLabel();
        }
    }

    public void myTeamAddGroups() {
        this.getTabsManager().addGroup(0, FifaResources.getMessage("FANAPP_MYTEAM_TITLE_NEWS_TXT"));
        this.getTabsManager().addGroup(0, FifaResources.getMessage("FANAPP_MYTEAM_TEAM_TXT"));
    }

    public void tournamentAddGroups(Vector groupName) {
        int count = groupName.size();
        int i = 0;
        while (i < count) {
            this.getTabsManager().addGroup(1, false, groupName.elementAt(i).toString());
            ++i;
        }
    }

    public void entertainmentAddGroups() {
        this.getTabsManager().addGroup(2, FifaResources.getMessage("FANAPP_ENTERTAINMENT_VIDEOS_TXT"));
        this.getTabsManager().addGroup(2, FifaResources.getMessage("FANAPP_ENTERTAINMENT_LINKS_TXT"));
        this.getTabsManager().addGroup(2, FifaResources.getMessage("FANAPP_ENTERTAINMENT_GAMES_TXT"));
    }

    public void removeWaitIndicator(int tabIndex) {
        this.getTabsManager().removeWaitIndicator(tabIndex);
    }

    public void showWaitIndicator(int tabIndex, String groupName) {
        this.getTabsManager().showWaitIndicator(tabIndex, groupName);
    }

    public void focusFirstItem(int tabIndex, String groupName, boolean scrollToHeadline) {
        this.getTabsManager().focusFirstItem(tabIndex, groupName);
        this.scrollComponentToVisible(this.getTabsManager().getFirstComponent(tabIndex, groupName, scrollToHeadline));
    }

    public boolean isFirstItemFocused(int tabIndex, String groupName) {
        return this.getTabsManager().isFirstItemFocused(tabIndex, groupName);
    }

    public boolean isGroupEmpty(int tabIndex) {
        return this.getTabsManager().isGroupEmpty(tabIndex);
    }
}

