/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.components.forms;

import com.sonyericsson.fifa.exceptions.ComponentException;
import com.sonyericsson.fifa.view.Images;
import com.sonyericsson.fifa.view.components.FifaLookAndFeelManager;
import com.sonyericsson.fifa.view.components.forms.ListItemsForm;
import com.sonyericsson.fifa.view.components.list.ListItem;
import com.sun.lwuit.Image;
import com.sun.lwuit.TextArea;
import java.util.Vector;

public class MyTeamForm
extends ListItemsForm {
    private String group = null;

    public void addGroup(String group) {
        this.group = group;
        super.addGroup(group);
    }

    public void hideTitle() {
        this.listComponents.hideTitle(this.group);
    }

    public void addItem(String titleText, String subtitleText, String iconPath) {
        this.addItem(this.group, titleText, subtitleText, iconPath);
    }

    public void addItem(String titleText, String subtitleText, Image icon) {
        this.addItem(this.group, titleText, subtitleText, icon);
    }

    public void addFakeItem(int qtdArticles) {
        this.addFakeItem(this.group, this.newFakeListItem(qtdArticles));
    }

    public void addTextAreaItem(String message) {
        this.addItem(0, this.group, this.newTextArea(message));
    }

    protected ListItem newFakeListItem(int qtdArticles) {
        ListItem item = new ListItem();
        int height = this.getAttributes().getHeight() - this.getAttributes().getHeadlineHeight() - this.getAttributes().getSoftkeyHeight() - this.getAttributes().getMyTeamFakeItemBottomGap();
        item.setListItemDimension(this.getAttributes().getListItemWidth(), height -= qtdArticles * this.getAttributes().getListItemHeight());
        item.setTitleText(null);
        item.setSubtitleText(null);
        item.removePicture();
        item.setFocusable(false);
        item.getStyle().setBgImage(Images.getFakeItemBackground());
        return item;
    }

    private TextArea newTextArea(String message) {
        TextArea textArea = new TextArea();
        textArea.setFocusable(false);
        textArea.setEditable(false);
        textArea.getStyle().setBgImage(Images.getFakeItemBackground());
        textArea.setRows(2);
        textArea.setPreferredH(this.getAttributes().getListItemHeight());
        textArea.setPreferredW(this.getAttributes().getWidth());
        textArea.setGrowByContent(true);
        FifaLookAndFeelManager.configToFirstLineStyle(textArea);
        textArea.setText(message);
        textArea.getStyle().setPadding(0, 0, this.getAttributes().getMyTeamFormTextAreaLeftPad(), 0);
        return textArea;
    }

    public void removeMiddleSoftkey() {
        try {
            this.setSoftkeyBgImage();
            this.setMiddleSoftkeyLabel(null);
        }
        catch (ComponentException e) {
            e.printStackTrace();
        }
    }

    public void setHeadline(String[] imagesPath, int posX) {
        this.setHeadline(imagesPath, 0, posX);
    }

    public void setHeadline(Vector images) {
        this.setHeadline(images, 0);
    }

    public void setCrossfadePosition() {
        this.setCrossfadePosition(this.attributes.getCrossfadeImageBoderPosX());
    }

    public void showWaitIndicator(int height) {
        super.showWaitIndicator(this.group, height);
    }

    public void removeAll() {
        this.listComponents.removeAll(this.group);
        this.listComponents.removeCountryDataItem();
    }

    public void removeWaitIndicator() {
        this.removeWaitIndicator(this.group);
    }

    public void setItemPicture(int itemIndex, String picturePath) {
        this.listComponents.setItemPicture(this.group, itemIndex, picturePath);
    }

    public void refreshAll() {
        this.removeAll();
        super.refreshAll(true);
    }

    public boolean isTeamItems() {
        return this.listComponents.isGroupEmpty();
    }
}

