/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.components.list;

import com.sonyericsson.fifa.view.FifaResources;
import com.sonyericsson.fifa.view.components.list.ListItem;
import com.sun.lwuit.Container;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.Layout;

public class SquadItem
extends ListItem {
    private int number = 0;

    public void setNumber(int number) {
        if (number > 0) {
            this.number = number;
            this.repaint();
        }
    }

    protected Container getIconContainer() {
        if (this.iconContainer == null) {
            this.iconContainer = new SquadIcon(new BoxLayout(2));
            this.iconContainer.setPreferredSize(new Dimension(this.attributes.getPhotoPlayerDimension(), this.attributes.getPhotoPlayerDimension()));
            this.iconContainer.getStyle().setPadding(0, 0, 0, 0);
            this.iconContainer.getStyle().setMargin(this.attributes.getListItemIconContainerTopPad(), this.attributes.getListItemIconContainerBottomPad(), 5, 5);
            this.iconContainer.getStyle().setBgImage(ListItem.borderImage[1]);
        }
        return this.iconContainer;
    }

    class SquadIcon
    extends Container {
        public SquadIcon(Layout l) {
            super(l);
        }

        public void paint(Graphics g) {
            int xPos = SquadItem.this.attributes.getSquadItemPosX();
            int yPos = 18;
            super.paint(g);
            if (SquadItem.this.number > 0) {
                g.setColor(0);
                g.setFont(FifaResources.getFont("Font_SansSerif_Large_Regular"));
                if (SquadItem.this.number < 10 && SquadItem.this.number > 0) {
                    xPos = SquadItem.this.attributes.getSquadItemPosXDec();
                } else if (SquadItem.this.number > 19) {
                    ++xPos;
                }
                g.drawString(String.valueOf(SquadItem.this.number), xPos, yPos);
            }
        }
    }
}

