/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.components.tabs;

import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.utils.Logger;
import com.sonyericsson.fifa.utils.attributes.Attributes;
import com.sonyericsson.fifa.utils.attributes.VerifyScreenDimension;
import com.sonyericsson.fifa.view.FifaResources;
import com.sonyericsson.fifa.view.components.WaitIndicator;
import com.sonyericsson.fifa.view.components.list.CountryDataItem;
import com.sonyericsson.fifa.view.components.list.ListComponentsContainer;
import com.sonyericsson.fifa.view.components.list.ListItem;
import com.sonyericsson.fifa.view.components.listener.SelectableItemListener;
import com.sonyericsson.fifa.view.components.tabs.TabsMenu;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Image;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import java.io.IOException;
import java.util.Vector;

public class TabsManager
extends Container {
    private static final int MAX_TABS = 3;
    private static final int FIRST_TITLE_TOP = 18;
    private int currentIndex = 0;
    private Container[] containers = new Container[3];
    private ListComponentsContainer[] lists = new ListComponentsContainer[3];
    private TabsMenu tabsMenu = null;
    private static final Attributes attributes = VerifyScreenDimension.getAttributesInstance();

    public TabsManager() {
        this.setLayout(new BorderLayout());
        this.setFocus(false);
        this.setFocusable(false);
        int i = 0;
        while (i < 3) {
            this.containers[i] = this.createNewTab();
            this.lists[i] = new ListComponentsContainer();
            this.containers[i].addComponent(this.lists[i]);
            ++i;
        }
        this.showWaitIndicator(0);
        this.lists[0].requestFocus();
        this.currentIndex = 0;
        this.addComponent("North", (Component)this.getTabsMenu());
        this.addComponent("South", (Component)this.containers[this.currentIndex]);
    }

    private TabsMenu getTabsMenu() {
        if (this.tabsMenu == null) {
            this.tabsMenu = new TabsMenu();
        }
        return this.tabsMenu;
    }

    public boolean containsItem(int tabIndex, String subGroupName, Component component) {
        return this.lists[tabIndex].containsItem(subGroupName, component);
    }

    private Container createNewTab() {
        Container newTab = null;
        newTab = new Container(new BoxLayout(2));
        newTab.setScrollable(false);
        newTab.setFocus(false);
        newTab.setFocusable(false);
        newTab.setPreferredSize(new Dimension(attributes.getWidth(), attributes.getTabContentHeight()));
        newTab.setSize(newTab.getPreferredSize());
        newTab.getStyle().setBgTransparency(0);
        newTab.getSelectedStyle().setBgTransparency(0);
        newTab.getUnselectedStyle().setBgTransparency(0);
        return newTab;
    }

    protected Attributes getAttributes() {
        return attributes;
    }

    private ListItem newListItem(String titleText, String subtitleText) {
        ListItem listItem = this.createListItem(titleText, subtitleText);
        return listItem;
    }

    private ListItem newListItem(String titleText, String subtitleText, String iconPath) {
        ListItem listItem = this.createListItem(titleText, subtitleText);
        listItem.setPicture(iconPath);
        if (subtitleText == null) {
            listItem.setTitlePadding(0, 18);
        }
        return listItem;
    }

    private ListItem newListItem(String titleText, String subtitleText, Image icon) {
        ListItem listItem = this.createListItem(titleText, subtitleText);
        listItem.setPicture(icon);
        if (subtitleText == null) {
            listItem.setTitlePadding(0, 18);
        }
        return listItem;
    }

    private ListItem createListItem(String titleText, String subtitleText) {
        ListItem listItem = new ListItem();
        listItem.setListItemDimension(this.getAttributes().getWidth(), this.getAttributes().getListItemHeight());
        listItem.setTitlePadding(0, this.getAttributes().getListItemTop());
        listItem.setTitleText(titleText);
        listItem.setSubtitleText(subtitleText);
        return listItem;
    }

    private CountryDataItem newCountryDataItem(String countryGroup, String countryFlagPath) {
        CountryDataItem countryData = null;
        if (countryFlagPath == null) {
            countryData = new CountryDataItem(countryGroup, null);
        } else {
            try {
                countryData = new CountryDataItem(countryGroup, Image.createImage(IOUtility.openFileInputStream(String.valueOf(FifaResources.getImageFolder()) + countryFlagPath + ".png")));
            }
            catch (IOException e) {
                Logger.logError(this.getClass(), "Exception to read image " + FifaResources.getImageFolder() + countryFlagPath + ".png");
            }
        }
        return countryData;
    }

    public void addItem(int tabIndex, String titleText, String subtitleText) {
        this.lists[tabIndex].addComponent(this.newListItem(titleText, subtitleText));
    }

    public void addItem(int tabIndex, String subGroup, String titleText, String subtitleText) {
        try {
            this.lists[tabIndex].addItem(subGroup, this.newListItem(titleText, subtitleText));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addCountryDataItem(int tabIndex, String countryGroup, String countryFlagPath) {
        this.lists[tabIndex].addCountryDataItem(this.newCountryDataItem(countryGroup, countryFlagPath));
    }

    public void removeCountryDataItem(int tabIndex) {
        this.lists[tabIndex].removeCountryDataItem();
    }

    public void addItem(int tabIndex, String subGroup, Component component) {
        try {
            this.lists[tabIndex].addItem(subGroup, component);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addItem(int tabIndex, int cmpIndex, String subGroup, Component component) {
        try {
            this.lists[tabIndex].addItem(cmpIndex, subGroup, component);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addItem(int tabIndex, String subGroup, String titleText, String subtitleText, String iconPath) {
        try {
            this.lists[tabIndex].addItem(subGroup, this.newListItem(titleText, subtitleText, iconPath));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addItem(int tabIndex, String subGroup, String titleText, String subtitleText, Image icon) {
        try {
            this.lists[tabIndex].addItem(subGroup, this.newListItem(titleText, subtitleText, icon));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeItem(int tabIndex, String subGroup, Component component) {
        this.lists[tabIndex].removeItem(subGroup, component);
    }

    public void removeAll(int tabIndex, String subGroup) {
        try {
            this.lists[tabIndex].removeAll(subGroup);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setHeadline(int tabIndex, String[] imagesPath, int borderType) {
        this.lists[tabIndex].setHeadline(imagesPath, borderType);
    }

    public void setHeadline(int tabIndex, Vector images, int borderType) {
        this.lists[tabIndex].setHeadline(images, borderType);
    }

    public void setCrossfadePosition(int tabIndex, int posX) {
        this.lists[tabIndex].setCrossfadePosition(posX, attributes.getHeadlinePosY());
    }

    public void startCrossfade(int tabIndex, Form componentForm) {
        this.lists[tabIndex].startHeadlineCrossfade(componentForm);
    }

    public void pauseCrossfade(int tabIndex, Form componentForm) {
        this.lists[tabIndex].pauseHeadlineCrossfase(componentForm);
    }

    public void showTitle(int tabIndex, String subgroupName) {
        this.lists[tabIndex].showTitle(subgroupName);
    }

    public void hideTitle(int tabIndex, String subgroupName) {
        this.lists[tabIndex].hideTitle(subgroupName);
    }

    public void addGroup(int tabIndex, String name) {
        this.lists[tabIndex].addGroup(name);
    }

    public void addGroup(int tabIndex, boolean anotherBg, String name) {
        this.lists[tabIndex].addGroup(anotherBg, name);
    }

    public void fillEmptySpace(int tabIndex) {
        this.lists[tabIndex].fillEmptySpace();
    }

    public int getCurrentTab() {
        return this.currentIndex;
    }

    public int[] getSelectedItem() {
        return this.lists[this.currentIndex].getSelectedItem();
    }

    public boolean nextTab() {
        int oldIndex = this.currentIndex++;
        boolean tabChanged = true;
        if (this.currentIndex >= 3) {
            this.currentIndex = 0;
        }
        if (this.getComponentIndex(this.containers[oldIndex]) != -1) {
            this.removeComponent(this.containers[oldIndex]);
            if (this.lists[this.currentIndex].getComponentCount() == 0) {
                this.showWaitIndicator(this.currentIndex);
                this.revalidate();
            }
            this.addComponent("South", (Component)this.containers[this.currentIndex]);
            if (this.containers[this.currentIndex] != null) {
                this.containers[this.currentIndex].requestFocus();
            }
            this.getTabsMenu().nextTab(oldIndex, this.currentIndex);
        } else {
            this.currentIndex = oldIndex;
            tabChanged = false;
        }
        return tabChanged;
    }

    public boolean previousTab() {
        int oldIndex = this.currentIndex--;
        boolean tabChanged = true;
        if (this.currentIndex < 0) {
            this.currentIndex = 2;
        }
        if (this.getComponentIndex(this.containers[oldIndex]) != -1) {
            this.removeComponent(this.containers[oldIndex]);
            if (this.lists[this.currentIndex].getComponentCount() == 0) {
                this.showWaitIndicator(this.currentIndex);
                this.revalidate();
            }
            this.addComponent("South", (Component)this.containers[this.currentIndex]);
            if (this.containers[this.currentIndex] != null) {
                this.containers[this.currentIndex].requestFocus();
            }
            this.getTabsMenu().previousTab(oldIndex, this.currentIndex);
        } else {
            this.currentIndex = oldIndex;
            tabChanged = false;
        }
        return tabChanged;
    }

    public boolean verifyKeyPressed(int keyCode) {
        this.lists[this.currentIndex].keyPressed(keyCode);
        if (keyCode == -3) {
            return this.previousTab();
        }
        if (keyCode == -4) {
            return this.nextTab();
        }
        return true;
    }

    public int verifyPointerPressed(int x, int y) {
        if (Display.getInstance().isTouchScreenDevice()) {
            if (y > attributes.getTabsMenuHeight() && y < attributes.getHeight() - attributes.getSoftkeyHeight()) {
                this.lists[this.currentIndex].pointerPressed(x, y);
            } else {
                int action = this.getTabsMenu().verifyPointerPressed(x, y);
                if (action == 0 && this.previousTab()) {
                    return 0;
                }
                if (action == 1 && this.nextTab()) {
                    return 1;
                }
            }
        }
        return -1;
    }

    public void pointerDragged(int x, int y) {
        if (Display.getInstance().isTouchScreenDevice()) {
            super.pointerDragged(x, y);
        }
    }

    public void setItemPicture(int tabIndex, String subGroup, int itemIndex, String picturePath) {
        if (subGroup != null) {
            this.lists[tabIndex].setItemPicture(subGroup, itemIndex, picturePath);
        }
    }

    public void setSelectedItemListener(SelectableItemListener selectListener) {
        this.lists[this.currentIndex].setSelectedItemListener(selectListener);
    }

    public void removeAll(int tabIndex) {
        if (this.lists != null) {
            this.lists[tabIndex].removeAllComponents(true);
        }
    }

    public void removeWaitIndicator(int tabIndex) {
        this.lists[tabIndex].removeWaitIndicator();
    }

    public void showWaitIndicator(int tabIndex) {
        this.lists[tabIndex].showWaitIndicator(VerifyScreenDimension.getAttributesInstance().getWaitIndicatorHeightWithTab());
    }

    public void showWaitIndicator(int tabIndex, String groupName) {
        this.lists[tabIndex].showWaitIndicator(groupName, VerifyScreenDimension.getAttributesInstance().getWaitIndicatorHeightWithTab());
    }

    public void focusFirstItem(int tabIndex, String groupName) {
        this.lists[tabIndex].focusFirstItem(groupName);
    }

    public boolean isFirstItemFocused(int tabIndex, String groupName) {
        return this.lists[tabIndex].isFirstItemFocused(groupName);
    }

    public Component getFirstComponent(int tabIndex, String groupName, boolean scrollToHeadline) {
        return this.lists[tabIndex].getFirstComponent(groupName, scrollToHeadline);
    }

    public void changeFirstItemBackground(int tabIndex, int cmpIndex, String subGroup, boolean isFirstBack) {
        this.lists[tabIndex].changeFirstItemToSecondItemBack(cmpIndex, subGroup, isFirstBack);
    }

    public WaitIndicator getWaitIndicator(int tabIndex) {
        return this.lists[tabIndex].getWaitIndicator();
    }

    public boolean isGroupEmpty(int tabIndex) {
        return this.lists[tabIndex].isGroupEmpty();
    }
}

