/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.components.tabs;

import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.utils.attributes.VerifyScreenDimension;
import com.sonyericsson.fifa.view.components.tabs.Tab;
import com.sun.lwuit.Container;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.CoordinateLayout;
import java.io.IOException;

public class TabsMenu
extends Container {
    private static final String TAB_GREEN_BAR = "tab_greenbar.png";
    private static final String ENTERTAINMENT_SELECTED = "entertainment_tab_on.png";
    private static final String ENTERTAINMENT_UNSELECTED = "entertainment_tab_off.png";
    private static final String TOURNAMENT_SELECTED = "tournament_tab_on.png";
    private static final String TOURNAMENT_UNSELECTED = "tournament_tab_off.png";
    private static final String MY_TEAM_SELECTED = "myteam_tab_on.png";
    private static final String MY_TEAM_UNSELECTED = "myteam_tab_off.png";
    private static Label backImage;
    private Tab tabRight;
    private Tab tabLeft;
    private Tab tabMiddle;
    private int currentTab;

    public TabsMenu() {
        this.setLayout(new CoordinateLayout(VerifyScreenDimension.getAttributesInstance().getWidth(), VerifyScreenDimension.getAttributesInstance().getTabsMenuHeight()));
        this.setPreferredSize(new Dimension(VerifyScreenDimension.getAttributesInstance().getWidth(), VerifyScreenDimension.getAttributesInstance().getTabsMenuHeight()));
        this.getStyle().setBgTransparency(160);
        this.getStyle().setBgColor(0);
        this.addComponent(this.getBackImage());
        this.addComponent(this.getTabLeft());
        this.addComponent(this.getTabMiddle());
        this.addComponent(this.getTabRight());
        this.currentTab = 0;
    }

    private Tab getTabLeft() {
        if (this.tabLeft == null) {
            this.tabLeft = new Tab();
            this.tabLeft.setY(VerifyScreenDimension.getAttributesInstance().getTabMenuTabPosY());
            this.tabLeft.setX(VerifyScreenDimension.getAttributesInstance().getTabMenuLeftTabPosX());
            this.tabLeft.setBackground(MY_TEAM_SELECTED);
        }
        return this.tabLeft;
    }

    private Tab getTabMiddle() {
        if (this.tabMiddle == null) {
            this.tabMiddle = new Tab();
            this.tabMiddle.setY(VerifyScreenDimension.getAttributesInstance().getTabMenuTabPosY());
            this.tabMiddle.setX(VerifyScreenDimension.getAttributesInstance().getTabMenuMiddleTabPosX());
            this.tabMiddle.setBackground(TOURNAMENT_UNSELECTED);
        }
        return this.tabMiddle;
    }

    private Tab getTabRight() {
        if (this.tabRight == null) {
            this.tabRight = new Tab();
            this.tabRight.setY(VerifyScreenDimension.getAttributesInstance().getTabMenuTabPosY());
            this.tabRight.setX(VerifyScreenDimension.getAttributesInstance().getTabMenuRightTabPosX());
            this.tabRight.setBackground(ENTERTAINMENT_UNSELECTED);
        }
        return this.tabRight;
    }

    private Label getBackImage() {
        if (backImage == null) {
            backImage = new Label();
            try {
                backImage.setIcon(Image.createImage(IOUtility.getImageFromRES(TAB_GREEN_BAR)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            backImage.getStyle().setBgTransparency(0);
            backImage.setX(VerifyScreenDimension.getAttributesInstance().getTabMenuBackImagePosX());
            backImage.setY(VerifyScreenDimension.getAttributesInstance().getTabMenuBackImagePosY());
        }
        return backImage;
    }

    public void nextTab(int previousTab, int currentTab) {
        this.switchState(previousTab, currentTab);
    }

    public void previousTab(int previousTab, int currentTab) {
        this.switchState(previousTab, currentTab);
    }

    private void switchState(int previousTab, int currentTab) {
        switch (currentTab) {
            case 0: {
                this.tabLeft.switchState(MY_TEAM_SELECTED);
                break;
            }
            case 1: {
                this.tabMiddle.switchState(TOURNAMENT_SELECTED);
                break;
            }
            case 2: {
                this.tabRight.switchState(ENTERTAINMENT_SELECTED);
                break;
            }
        }
        switch (previousTab) {
            case 0: {
                this.tabLeft.switchState(MY_TEAM_UNSELECTED);
                break;
            }
            case 1: {
                this.tabMiddle.switchState(TOURNAMENT_UNSELECTED);
                break;
            }
            case 2: {
                this.tabRight.switchState(ENTERTAINMENT_UNSELECTED);
                break;
            }
        }
    }

    public int verifyPointerPressed(int x, int y) {
        int oldTab = this.currentTab;
        if (this.getTabRight().contains(x, y)) {
            this.currentTab = 2;
        } else if (this.getTabMiddle().contains(x, y)) {
            this.currentTab = 1;
        } else if (this.getTabLeft().contains(x, y)) {
            this.currentTab = 0;
        }
        if (oldTab == 0 && this.currentTab == 2) {
            return 0;
        }
        if (oldTab == 2 && this.currentTab == 0) {
            return 1;
        }
        if (oldTab > this.currentTab) {
            return 0;
        }
        if (oldTab < this.currentTab) {
            return 1;
        }
        return -1;
    }
}

