/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.tabs;

import com.sonyericsson.fifa.data.Group;
import com.sonyericsson.fifa.exceptions.ViewException;
import com.sonyericsson.fifa.model.Model;
import com.sonyericsson.fifa.model.tournamentTable.TournamentTableListener;
import com.sonyericsson.fifa.view.FifaAbstractView;
import com.sonyericsson.fifa.view.FifaResources;
import com.sonyericsson.fifa.view.ViewFactory;
import com.sonyericsson.fifa.view.action.BackAction;
import com.sonyericsson.fifa.view.action.SelectedTeamAction;
import com.sonyericsson.fifa.view.action.UpdateFailureAction;
import com.sonyericsson.fifa.view.components.forms.ChangeTeamForm;
import java.util.Enumeration;
import java.util.Vector;

public class ChangeTeamView
extends FifaAbstractView
implements TournamentTableListener {
    private final Vector availableTeams = new Vector();
    private ChangeTeamForm changeTeamForm = ViewFactory.getChangeTeamForm();
    private Vector groupName;

    public ChangeTeamView(Model model) {
        super(6, model);
        this.changeTeamForm.addGroup(this.getGroupVector(true));
        model.addTournamentTableListener(this);
    }

    private Vector getGroupVector(boolean boolCreateNew) {
        if (boolCreateNew) {
            this.groupName = new Vector();
            this.groupName.addElement(FifaResources.getMessage("FANAPP_TOURNAMSTATUS_GROUPA_TXT"));
            this.groupName.addElement(FifaResources.getMessage("FANAPP_TOURNAMSTATUS_GROUPB_TXT"));
            this.groupName.addElement(FifaResources.getMessage("FANAPP_TOURNAMSTATUS_GROUPC_TXT"));
            this.groupName.addElement(FifaResources.getMessage("FANAPP_TOURNAMSTATUS_GROUPD_TXT"));
            this.groupName.addElement(FifaResources.getMessage("FANAPP_TOURNAMSTATUS_GROUPE_TXT"));
            this.groupName.addElement(FifaResources.getMessage("FANAPP_TOURNAMSTATUS_GROUPF_TXT"));
            this.groupName.addElement(FifaResources.getMessage("FANAPP_TOURNAMSTATUS_GROUPG_TXT"));
            this.groupName.addElement(FifaResources.getMessage("FANAPP_TOURNAMSTATUS_GROUPH_TXT"));
        }
        return this.groupName;
    }

    protected void doShow() throws ViewException {
        this.changeTeamForm.show();
        this.updateView();
        this.changeTeamForm.setKeyListener(this);
        this.changeTeamForm.setTouchListener(this);
        this.changeTeamForm.setSelectedItemListener(this);
    }

    protected void doHide() {
        super.doHide();
        this.changeTeamForm.setKeyListener(null);
        this.changeTeamForm.setTouchListener(null);
        this.changeTeamForm.setSelectedItemListener(null);
        this.model.removeTournamentTableListener(this);
    }

    private void addTeamGroup() {
        Vector tournamentGroups = this.model.getTournamentGroups();
        if (tournamentGroups != null) {
            int count = tournamentGroups.size();
            int i = 0;
            while (i < count) {
                Group group = (Group)tournamentGroups.elementAt(i);
                if (group != null) {
                    Enumeration teams = group.getTeams().keys();
                    while (teams.hasMoreElements()) {
                        String teamCode = (String)teams.nextElement();
                        String groupName = FifaResources.getMessage("FANAPP_TOURNAMSTATUS_" + group.getGroupName() + "_TXT");
                        this.changeTeamForm.addNewTeam(groupName, FifaResources.getMessage("FANAPP_TEAMNAME_" + teamCode + "_TXT"), teamCode);
                        this.availableTeams.addElement(teamCode);
                    }
                }
                ++i;
            }
        }
    }

    public void onKeyPressed(int keyCode) {
        this.performSoftkey();
    }

    public void selectedItem(int item, int subgroup) {
        String countryCode = (String)this.availableTeams.elementAt(item + subgroup * 4);
        SelectedTeamAction action = new SelectedTeamAction(countryCode);
        this.fireViewActionPerformed(action);
    }

    public void tournamentTableUpdated() {
        this.updateView();
    }

    public void onTouchPressed(int valX, int valY) {
        this.performSoftkey();
    }

    public void performSoftkey() {
        if (-7 == this.changeTeamForm.getSelectedSoftkey()) {
            BackAction backAction = new BackAction();
            this.fireViewActionPerformed(backAction);
        }
    }

    protected void doUpdateView() {
        this.addTeamGroup();
        this.changeTeamForm.focusFirstItem(FifaResources.getMessage("FANAPP_TOURNAMSTATUS_GROUPA_TXT"));
        this.changeTeamForm.revalidate();
    }

    protected void doClearFormText() {
        if (!this.changeTeamForm.isTeamItems()) {
            this.changeTeamForm.refreshAll();
            this.changeTeamForm.addGroup(this.getGroupVector(true));
            this.updateView();
        } else {
            this.changeTeamForm.refreshAll();
            this.changeTeamForm.addGroup(this.getGroupVector(true));
        }
    }

    public void tournamentTableUpdateFailed(byte reason) {
        this.fireViewActionPerformed(new UpdateFailureAction(reason, this.model.isTournamentUpdated()));
    }
}

