/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Button;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.animations.Transition;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import java.util.Hashtable;

public class Dialog
extends Form {
    private boolean disposed;
    public static final int TYPE_ALARM = 1;
    public static final int TYPE_CONFIRMATION = 2;
    public static final int TYPE_ERROR = 3;
    public static final int TYPE_INFO = 4;
    public static final int TYPE_WARNING = 5;
    private long time;
    private Command lastCommandPressed;
    private boolean menu;
    private String dialogUIID;
    private String dialogTitleUIID;
    private int dialogType;
    private int top = -1;
    private int bottom;
    private int left;
    private int right;
    private boolean includeTitle;
    private String position;
    private static boolean autoAdjustDialogSize = true;
    private static String defaultDialogPosition;
    private static boolean disableStaticDialogScrolling;
    private boolean autoDispose = true;
    private boolean modal = true;
    private static int defaultDialogType;
    private static boolean commandsAsButtons;
    private boolean disposeWhenPointerOutOfBounds = false;

    public Dialog(String title) {
        this();
        this.setTitle(title);
    }

    public Dialog() {
        this("Dialog", "DialogTitle");
    }

    Dialog(String dialogUIID, String dialogTitleUIID) {
        this.dialogUIID = dialogUIID;
        this.dialogTitleUIID = dialogTitleUIID;
        this.getContentPane().setUIID(dialogUIID);
        this.getTitleComponent().setUIID(dialogTitleUIID);
        super.getStyle().setBgTransparency(0);
        super.getStyle().setBgImage(null);
        this.setSmoothScrolling(false);
        this.deregisterAnimated(this);
    }

    public void setDialogStyle(Style style) {
        this.getContentPane().setUnSelectedStyle(style);
    }

    public Style getDialogStyle() {
        return this.getContentPane().getStyle();
    }

    void initLaf(LookAndFeel laf) {
        this.setTransitionOutAnimator(laf.getDefaultDialogTransitionOut());
        this.setTransitionInAnimator(laf.getDefaultDialogTransitionIn());
    }

    public Command show(int top, int bottom, int left, int right, boolean includeTitle) {
        return this.show(top, bottom, left, right, includeTitle, true);
    }

    public Command show(int top, int bottom, int left, int right, boolean includeTitle, boolean modal) {
        this.top = top;
        this.bottom = bottom;
        if (this.isRTL()) {
            this.left = right;
            this.right = left;
        } else {
            this.left = left;
            this.right = right;
        }
        this.includeTitle = includeTitle;
        this.setDisposed(false);
        this.modal = modal;
        this.lastCommandPressed = null;
        super.showModal(this.top, this.bottom, this.left, this.right, includeTitle, modal, false);
        return this.lastCommandPressed;
    }

    public void setTimeout(long time) {
        this.time = System.currentTimeMillis() + time;
        super.registerAnimatedInternal(this);
    }

    public static boolean show(String title, String text, int type, Image icon, String okText, String cancelText) {
        return Dialog.show(title, text, type, icon, okText, cancelText, 0L);
    }

    void sizeChangedInternal(int w, int h) {
        if (autoAdjustDialogSize) {
            if (this.position != null) {
                Container contentPane = this.getContentPane();
                Label title = this.getTitleComponent();
                Style contentPaneStyle = contentPane.getStyle();
                Style titleStyle = title.getStyle();
                int menuHeight = 0;
                if (this.getSoftButtonCount() > 1) {
                    Container menuBar = this.getSoftButton(0).getParent();
                    Style menuStyle = menuBar.getStyle();
                    menuHeight = menuBar.getPreferredH() + menuStyle.getMargin(false, 0) + menuStyle.getMargin(false, 2);
                }
                int prefHeight = contentPane.getPreferredH() + contentPaneStyle.getMargin(false, 0) + contentPaneStyle.getMargin(false, 2);
                int prefWidth = contentPane.getPreferredW() + contentPaneStyle.getMargin(this.isRTL(), 1) + contentPaneStyle.getMargin(this.isRTL(), 3);
                prefWidth = Math.min(prefWidth, w);
                h = h - menuHeight - title.getPreferredH() - titleStyle.getMargin(false, 0) - titleStyle.getMargin(false, 2);
                int topBottom = Math.max(0, (h - prefHeight) / 2);
                int leftRight = Math.max(0, (w - prefWidth) / 2);
                int top = topBottom;
                int bottom = topBottom;
                int left = leftRight;
                int right = leftRight;
                if (this.position.equals("East")) {
                    left = Math.max(0, w - prefWidth);
                    right = 0;
                } else if (this.position.equals("West")) {
                    right = 0;
                    left = Math.max(0, w - prefWidth);
                } else if (this.position.equals("North")) {
                    top = 0;
                    bottom = Math.max(0, h - prefHeight);
                } else if (this.position.equals("South")) {
                    top = Math.max(0, h - prefHeight);
                    bottom = 0;
                }
                Style contentStyle = this.getDialogStyle();
                if (this.includeTitle) {
                    titleStyle.setMargin(0, top, true);
                    titleStyle.setMargin(2, 0, true);
                    titleStyle.setMargin(1, left, true);
                    titleStyle.setMargin(3, right, true);
                    contentStyle.setMargin(0, 0, true);
                    contentStyle.setMargin(2, bottom, true);
                    contentStyle.setMargin(1, left, true);
                    contentStyle.setMargin(3, right, true);
                } else {
                    titleStyle.setMargin(0, 0, true);
                    titleStyle.setMargin(2, 0, true);
                    titleStyle.setMargin(1, 0, true);
                    titleStyle.setMargin(3, 0, true);
                    contentStyle.setMargin(0, top, true);
                    contentStyle.setMargin(2, bottom, true);
                    contentStyle.setMargin(1, left, true);
                    contentStyle.setMargin(3, right, true);
                }
            } else {
                int oldW = this.getWidth();
                int oldH = this.getHeight();
                if (oldW != w || oldH != h) {
                    float ratioW = (float)w / (float)oldW;
                    float ratioH = (float)h / (float)oldH;
                    Style s = this.getDialogStyle();
                    s.setMargin(0, (int)((float)s.getMargin(false, 0) * ratioH));
                    s.setMargin(2, (int)((float)s.getMargin(false, 2) * ratioH));
                    s.setMargin(1, (int)((float)s.getMargin(this.isRTL(), 1) * ratioW));
                    s.setMargin(3, (int)((float)s.getMargin(this.isRTL(), 3) * ratioW));
                    Style titleStyle = this.getTitleStyle();
                    titleStyle.setMargin(0, (int)((float)titleStyle.getMargin(false, 0) * ratioH));
                    titleStyle.setMargin(1, (int)((float)titleStyle.getMargin(this.isRTL(), 1) * ratioW));
                    titleStyle.setMargin(3, (int)((float)titleStyle.getMargin(this.isRTL(), 3) * ratioW));
                }
            }
        }
        this.top = -1;
        this.bottom = -1;
        this.left = -1;
        this.right = -1;
        this.position = null;
        super.sizeChangedInternal(w, h);
        Form frm = this.getPreviousForm();
        if (frm != null) {
            frm.sizeChangedInternal(w, h);
        }
    }

    public static boolean show(String title, String text, int type, Image icon, String okText, String cancelText, long timeout) {
        Command okCommand = new Command(okText);
        Command[] cmds = cancelText != null ? new Command[]{new Command(cancelText), okCommand} : new Command[]{okCommand};
        return Dialog.show(title, text, okCommand, cmds, type, icon, timeout) == okCommand;
    }

    public static Command show(String title, String text, Command[] cmds, int type, Image icon, long timeout) {
        return Dialog.show(title, text, null, cmds, type, icon, timeout);
    }

    public static Command show(String title, String text, Command defaultCommand, Command[] cmds, int type, Image icon, long timeout) {
        return Dialog.show(title, text, defaultCommand, cmds, type, icon, timeout, null);
    }

    public static Command show(String title, String text, Command[] cmds, int type, Image icon, long timeout, Transition transition) {
        return Dialog.show(title, text, null, cmds, type, icon, timeout, transition);
    }

    public static Command show(String title, String text, Command defaultCommand, Command[] cmds, int type, Image icon, long timeout, Transition transition) {
        Object o;
        Hashtable h = UIManager.getInstance().getResourceBundle();
        if (h != null && text != null && (o = h.get(text)) != null) {
            text = (String)o;
        }
        TextArea t = new TextArea(text, 3, 30);
        t.setUnselectedStyle(UIManager.getInstance().getComponentStyle("DialogBody"));
        t.setSelectedStyle(UIManager.getInstance().getComponentSelectedStyle("DialogBody"));
        t.setEditable(false);
        return Dialog.show(title, t, defaultCommand, cmds, type, icon, timeout, transition);
    }

    public static boolean show(String title, String text, String okText, String cancelText) {
        return Dialog.show(title, text, defaultDialogType, null, okText, cancelText);
    }

    public static Command show(String title, Component body, Command[] cmds) {
        return Dialog.show(title, body, cmds, defaultDialogType, null);
    }

    public static Command show(String title, Component body, Command[] cmds, int type, Image icon) {
        return Dialog.show(title, body, cmds, type, icon, 0L);
    }

    public static Command show(String title, Component body, Command[] cmds, int type, Image icon, long timeout) {
        return Dialog.show(title, body, cmds, type, icon, timeout, null);
    }

    public static Command show(String title, Component body, Command[] cmds, int type, Image icon, long timeout, Transition transition) {
        return Dialog.show(title, body, null, cmds, type, icon, timeout, transition);
    }

    public static Command show(String title, Component body, Command defaultCommand, Command[] cmds, int type, Image icon, long timeout, Transition transition) {
        Dialog dialog = new Dialog(title);
        dialog.dialogType = type;
        dialog.setTransitionInAnimator(transition);
        dialog.setTransitionOutAnimator(transition);
        dialog.lastCommandPressed = null;
        dialog.setLayout(new BorderLayout());
        if (cmds != null) {
            if (commandsAsButtons) {
                Container buttonArea = new Container();
                dialog.addComponent("South", (Component)buttonArea);
                if (cmds.length > 0) {
                    for (int iter = 0; iter < cmds.length; ++iter) {
                        buttonArea.addComponent(new Button(cmds[iter]));
                    }
                    buttonArea.getComponentAt(0).requestFocus();
                }
            } else {
                for (int iter = 0; iter < cmds.length; ++iter) {
                    dialog.addCommand(cmds[iter]);
                }
            }
            if (cmds.length == 1) {
                dialog.setBackCommand(cmds[0]);
            } else if (cmds.length == 2 && defaultCommand == null) {
                defaultCommand = cmds[0];
                dialog.setBackCommand(cmds[1]);
            }
        }
        dialog.addComponent("Center", body);
        if (icon != null) {
            dialog.addComponent("East", (Component)new Label(icon));
        }
        if (timeout != 0L) {
            dialog.setTimeout(timeout);
        }
        if (body.isScrollable() || disableStaticDialogScrolling) {
            dialog.setScrollable(false);
        }
        dialog.show();
        return dialog.lastCommandPressed;
    }

    protected void onShow() {
        if (this.dialogType > 0) {
            Display.getInstance().playDialogSound(this.dialogType);
        }
    }

    public void showBack() {
        this.showImpl(true);
    }

    public void show() {
        this.showImpl(false);
    }

    private void showImpl(boolean reverse) {
        this.setDisposed(false);
        if (this.top > -1) {
            this.show(this.top, this.bottom, this.left, this.right, this.includeTitle, this.modal);
        } else if (this.modal) {
            if (defaultDialogPosition == null) {
                super.showModal(reverse);
            } else {
                this.showPacked(defaultDialogPosition, true);
            }
        } else {
            this.showModeless();
        }
    }

    public void showModeless() {
        this.modal = false;
        this.setDisposed(false);
        if (this.top > -1) {
            this.show(this.top, this.bottom, this.left, this.right, this.includeTitle, false);
        } else if (defaultDialogPosition == null) {
            this.showDialog(false, false);
        } else {
            this.showPacked(defaultDialogPosition, false);
        }
    }

    public Command showPacked(String position, boolean modal) {
        this.position = position;
        int height = Display.getInstance().getDisplayHeight();
        int width = Display.getInstance().getDisplayWidth();
        if (this.top > -1) {
            this.refreshTheme();
        }
        Container contentPane = this.getContentPane();
        Label title = this.getTitleComponent();
        Style contentPaneStyle = contentPane.getStyle();
        Style titleStyle = title.getStyle();
        int menuHeight = 0;
        if (this.getSoftButtonCount() > 1) {
            Container menuBar = this.getSoftButton(0).getParent();
            Style menuStyle = menuBar.getStyle();
            menuHeight = menuBar.getPreferredH() + menuStyle.getMargin(false, 0) + menuStyle.getMargin(false, 2);
        }
        int prefHeight = contentPane.getPreferredH() + contentPaneStyle.getMargin(false, 0) + contentPaneStyle.getMargin(false, 2);
        int prefWidth = contentPane.getPreferredW() + contentPaneStyle.getMargin(this.isRTL(), 1) + contentPaneStyle.getMargin(this.isRTL(), 3);
        prefWidth = Math.min(prefWidth, width);
        height = height - menuHeight - title.getPreferredH() - titleStyle.getMargin(false, 0) - titleStyle.getMargin(false, 2);
        int topBottom = Math.max(0, (height - prefHeight) / 2);
        int leftRight = Math.max(0, (width - prefWidth) / 2);
        if (position.equals("Center")) {
            this.show(topBottom, topBottom, leftRight, leftRight, true, modal);
            return this.lastCommandPressed;
        }
        if (position.equals("East")) {
            this.show(topBottom, topBottom, Math.max(0, width - prefWidth), 0, true, modal);
            return this.lastCommandPressed;
        }
        if (position.equals("West")) {
            this.show(topBottom, topBottom, 0, Math.max(0, width - prefWidth), true, modal);
            return this.lastCommandPressed;
        }
        if (position.equals("North")) {
            this.show(0, Math.max(0, height - prefHeight), leftRight, leftRight, true, modal);
            return this.lastCommandPressed;
        }
        if (position.equals("South")) {
            this.show(Math.max(0, height - prefHeight), 0, leftRight, leftRight, true, modal);
            return this.lastCommandPressed;
        }
        throw new IllegalArgumentException("Unknown position: " + position);
    }

    public void dispose() {
        this.setDisposed(true);
        if (!this.menu) {
            super.dispose();
        }
    }

    public Command showDialog() {
        this.lastCommandPressed = null;
        this.show();
        return this.lastCommandPressed;
    }

    protected void actionCommand(Command cmd) {
        if (!this.autoDispose || this.lastCommandPressed == null) {
            this.lastCommandPressed = cmd;
        }
        if (this.menu || this.autoDispose && cmd.isDisposesDialog()) {
            this.dispose();
        }
    }

    public boolean animate() {
        this.isTimedOut();
        return false;
    }

    private boolean isTimedOut() {
        if (this.time != 0L && System.currentTimeMillis() >= this.time) {
            this.time = 0L;
            this.dispose();
            this.deregisterAnimatedInternal(this);
            return true;
        }
        return false;
    }

    boolean isMenu() {
        return this.menu;
    }

    void setMenu(boolean menu) {
        this.menu = menu;
    }

    void addSelectCommand() {
        if (!this.menu) {
            super.addSelectCommand(this.getSelectCommandText());
        }
    }

    boolean isDisposed() {
        return this.disposed || this.isTimedOut();
    }

    void setDisposed(boolean disposed) {
        this.disposed = disposed;
    }

    public boolean isAutoDispose() {
        return this.autoDispose;
    }

    public void setAutoDispose(boolean autoDispose) {
        this.autoDispose = autoDispose;
    }

    public static void setDefaultDialogPosition(String p) {
        defaultDialogPosition = p;
    }

    public static String getDefaultDialogPosition() {
        return defaultDialogPosition;
    }

    public int getDialogType() {
        return this.dialogType;
    }

    public void setDialogType(int dialogType) {
        this.dialogType = dialogType;
    }

    public static void setDefaultDialogType(int d) {
        defaultDialogType = d;
    }

    public static int getDefaultDialogType() {
        return defaultDialogType;
    }

    public static void setAutoAdjustDialogSize(boolean a) {
        autoAdjustDialogSize = a;
    }

    public static void setDisableStaticDialogScrolling(boolean d) {
        disableStaticDialogScrolling = d;
    }

    public static boolean isDisableStaticDialogScrolling() {
        return disableStaticDialogScrolling;
    }

    public static void setCommandsAsButtons(boolean c) {
        commandsAsButtons = c;
    }

    public static boolean isCommandsAsButtons() {
        return commandsAsButtons;
    }

    protected void setDisposeWhenPointerOutOfBounds(boolean disposeWhenPointerOutOfBounds) {
        this.disposeWhenPointerOutOfBounds = disposeWhenPointerOutOfBounds;
    }

    public void pointerReleased(int x, int y) {
        super.pointerReleased(x, y);
        if (this.disposeWhenPointerOutOfBounds && !this.getTitleComponent().contains(x, y) && !this.getContentPane().contains(x, y) && !this.getMenuBar().contains(x, y)) {
            this.dispose();
        }
    }

    static {
        defaultDialogType = 4;
    }
}

