/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.impl.midp;

import com.sun.lwuit.Button;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Dialog;
import com.sun.lwuit.Display;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Label;
import com.sun.lwuit.Painter;
import com.sun.lwuit.TextField;
import com.sun.lwuit.animations.CommonTransitions;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import java.util.Hashtable;
import java.util.Vector;

public class VirtualKeyboard
extends Dialog {
    public static final String[][] DEFAULT_QWERTY = new String[][]{{"q", "w", "e", "r", "t", "y", "u", "i", "o", "p"}, {"a", "s", "d", "f", "g", "h", "j", "k", "l"}, {"$Shift$", "z", "x", "c", "v", "b", "n", "m", "$Delete$"}, {"$Mode$", "$T9$", "$Space$", "$OK$"}};
    public static final String[][] DEFAULT_NUMBERS = new String[][]{{"1", "2", "3"}, {"4", "5", "6"}, {"7", "8", "9"}, {"*", "0", "#"}, {"$Mode$", "$Space$", "$Delete$", "$OK$"}};
    public static final String[][] DEFAULT_NUMBERS_SYMBOLS = new String[][]{{"1", "2", "3", "4", "5", "6", "7", "8", "9", "0"}, {"-", "/", ":", ";", "(", ")", "$", "&", "@"}, {".", ",", "?", "!", "'", "\"", "$Delete$"}, {"$Mode$", "$Space$", "$OK$"}};
    public static final String[][] DEFAULT_SYMBOLS = new String[][]{{"[", "]", "{", "}", "#", "%", "^", "*", "+", "="}, {"_", "\\", "|", "~", "<", ">", "\u00a3", "\u00a5"}, {":-0", ";-)", ":-)", ":-(", ":P", ":D", "$Delete$"}, {"$Mode$", "$Space$", "$OK$"}};
    public static final String QWERTY_MODE = "ABC";
    public static final String NUMBERS_MODE = "123";
    public static final String NUMBERS_SYMBOLS_MODE = ".,123";
    public static final String SYMBOLS_MODE = ".,?";
    private String currentMode = "ABC";
    private Vector modesKeys = new Vector();
    private Hashtable modesMap = new Hashtable();
    private TextField inputField;
    private Container buttons = new Container(new BoxLayout(2));
    private TextPainter txtPainter = new TextPainter();
    private boolean upperCase = false;
    private Button currentButton;
    private static final int INSERT_CHAR = 1;
    private static final int DELETE_CHAR = 2;
    private static final int CHANGE_MODE = 3;
    private static final int SHIFT = 4;
    private static final int OK = 5;
    private static final int SPACE = 6;
    private static final int T9 = 7;
    private Hashtable specialButtons = new Hashtable();
    private TextField field;
    private boolean finishedT9Edit = false;

    public VirtualKeyboard() {
        this.setLayout(new BorderLayout());
        this.getContentPane().setUIID("VKB");
        this.setAutoDispose(false);
        this.setDisposeWhenPointerOutOfBounds(true);
        this.setTransitionInAnimator(CommonTransitions.createSlide(1, true, 500));
        this.setTransitionOutAnimator(CommonTransitions.createSlide(1, false, 500));
        this.setGlassPane(this.txtPainter);
    }

    public void setTextField(TextField field) {
        this.field = field;
        this.removeAll();
        field.setUseSoftkeys(false);
        this.inputField = new TextField(){

            public boolean hasFocus() {
                return true;
            }

            public String getUIID() {
                return "VKBTextInput";
            }
        };
        this.inputField.setText(field.getText());
        this.inputField.setConstraint(field.getConstraint());
        this.inputField.setInputModeOrder(new String[]{QWERTY_MODE});
        this.initModes();
        this.initSpecialButtons();
        this.addComponent("North", (Component)this.inputField);
        this.buttons.getStyle().setPadding(0, 0, 0, 0);
        this.addComponent("Center", (Component)this.buttons);
        this.initInputButtons(this.upperCase);
        this.inputField.setUseSoftkeys(false);
        this.applyRTL(false);
    }

    public void show() {
        super.showPacked("South", true);
    }

    protected void sizeChanged(int w, int h) {
        if (!this.finishedT9Edit) {
            this.setTransitionOutAnimator(CommonTransitions.createEmpty());
            this.dispose();
        } else {
            this.finishedT9Edit = false;
        }
        super.sizeChanged(w, h);
    }

    protected void initModes() {
        this.modesKeys.removeAllElements();
        this.modesMap.clear();
        if (this.inputField.getConstraint() == 2) {
            this.setCurrentMode(NUMBERS_SYMBOLS_MODE);
            this.addInputMode(NUMBERS_SYMBOLS_MODE, DEFAULT_NUMBERS_SYMBOLS);
            this.addInputMode(NUMBERS_MODE, DEFAULT_NUMBERS);
        } else {
            this.setCurrentMode(QWERTY_MODE);
            this.addInputMode(QWERTY_MODE, DEFAULT_QWERTY);
            this.addInputMode(NUMBERS_SYMBOLS_MODE, DEFAULT_NUMBERS_SYMBOLS);
            this.addInputMode(SYMBOLS_MODE, DEFAULT_SYMBOLS);
            this.addInputMode(NUMBERS_MODE, DEFAULT_NUMBERS);
        }
    }

    protected void setCurrentMode(String mode) {
        this.currentMode = mode;
    }

    protected String getCurrentMode() {
        return this.currentMode;
    }

    private void initInputButtons(boolean upperCase) {
        this.buttons.removeAll();
        int largestLine = 0;
        String[][] currentKeyboardChars = (String[][])this.modesMap.get(this.currentMode);
        for (int i = 1; i < currentKeyboardChars.length; ++i) {
            if (currentKeyboardChars[i].length <= currentKeyboardChars[largestLine].length) continue;
            largestLine = i;
        }
        int length = currentKeyboardChars[largestLine].length;
        Button dummy = this.createButton(new Command("dummy"), 0);
        int buttonMargins = dummy.getUnselectedStyle().getMargin(dummy.isRTL(), 1) + dummy.getUnselectedStyle().getMargin(dummy.isRTL(), 3);
        Container row = null;
        int rowW = Display.getInstance().getDisplayWidth() - this.getContentPane().getUnselectedStyle().getPadding(false, 1) - this.getContentPane().getUnselectedStyle().getPadding(false, 3) - this.getContentPane().getUnselectedStyle().getMargin(false, 1) - this.getContentPane().getUnselectedStyle().getMargin(false, 3);
        int availableSpace = rowW - length * buttonMargins;
        int buttonSpace = availableSpace / length;
        for (int i = 0; i < currentKeyboardChars.length; ++i) {
            int rowWidth = rowW;
            row = new Container(new BoxLayout(1));
            row.getUnselectedStyle().setMargin(0, 0, 0, 0);
            Vector<Button> specialsButtons = new Vector<Button>();
            for (int j = 0; j < currentKeyboardChars[i].length; ++j) {
                String txt = currentKeyboardChars[i][j];
                Button b = null;
                if (txt.startsWith("$") && txt.endsWith("$") && txt.length() > 1) {
                    Button cmd = (Button)this.specialButtons.get(txt.substring(1, txt.length() - 1));
                    int prefW = 0;
                    int space = (Integer)cmd.getClientProperty("space");
                    if (space != -1) {
                        prefW = availableSpace * space / 100;
                    }
                    b = this.createButton(cmd.getCommand(), prefW, "VKBSpecialButton");
                    if (prefW != 0) {
                        rowWidth -= b.getPreferredW() + buttonMargins;
                    } else {
                        specialsButtons.addElement(b);
                    }
                } else {
                    if (upperCase) {
                        txt = txt.toUpperCase();
                    }
                    b = this.createInputButton(txt, buttonSpace);
                    rowWidth -= b.getPreferredW() + buttonMargins;
                }
                if (this.currentButton != null) {
                    if (this.currentButton.getCommand().getId() == b.getCommand().getId()) {
                        this.currentButton = b;
                    }
                    if (this.currentButton.getText().equals(b.getText())) {
                        this.currentButton = b;
                    }
                }
                row.addComponent(b);
            }
            int emptySpace = Math.max(rowWidth, 0);
            if (specialsButtons.size() > 0) {
                int prefW = emptySpace / specialsButtons.size();
                for (int j = 0; j < specialsButtons.size(); ++j) {
                    Button special = (Button)specialsButtons.elementAt(j);
                    special.setPreferredW(prefW);
                }
            } else {
                row.getUnselectedStyle().setPadding(1, 0);
                row.getUnselectedStyle().setPadding(3, 0);
                row.getUnselectedStyle().setMargin(1, emptySpace / 2);
                row.getUnselectedStyle().setMargin(3, emptySpace / 2);
            }
            this.buttons.addComponent(row);
        }
        this.applyRTL(false);
    }

    private Button createInputButton(String text, int prefSize) {
        Button b = this.createButton(new Command(text, 1), prefSize);
        b.putClientProperty("glasspane", "true");
        return b;
    }

    private Button createButton(Command cmd, int prefSize) {
        return this.createButton(cmd, prefSize, "VKBButton");
    }

    private Button createButton(Command cmd, int prefSize, String uiid) {
        final Button b = new Button(cmd);
        b.setUIID(uiid);
        b.setEndsWith3Points(false);
        b.setAlignment(4);
        prefSize = Math.max(prefSize, b.getPreferredW());
        b.setPreferredW(prefSize);
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VirtualKeyboard.this.currentButton = b;
            }
        });
        return b;
    }

    public void addInputMode(String mode, String[][] inputChars) {
        this.modesKeys.addElement(mode);
        this.modesMap.put(mode, inputChars);
    }

    public void addSpecialButton(String key, Command cmd) {
        this.addSpecialButton(key, cmd, -1);
    }

    public void addSpecialButton(String key, Command cmd, int space) {
        Button b = new Button(cmd);
        b.putClientProperty("space", new Integer(space));
        this.specialButtons.put(key, b);
    }

    private String getNextMode(String current) {
        int index = this.modesKeys.indexOf(current);
        if (index == this.modesKeys.size() - 1) {
            return (String)this.modesKeys.elementAt(0);
        }
        return (String)this.modesKeys.elementAt(index + 1);
    }

    public void pointerPressed(int x, int y) {
        super.pointerPressed(x, y);
        Component cmp = this.getComponentAt(x, y);
        if (cmp != null && cmp instanceof Button && cmp.getClientProperty("glasspane") != null) {
            this.txtPainter.showButtonOnGlasspane((Button)cmp);
        }
    }

    public void pointerDragged(int x, int y) {
        super.pointerDragged(x, y);
        Component cmp = this.getComponentAt(x, y);
        if (cmp != null && cmp instanceof Button && cmp.getClientProperty("glasspane") != null) {
            this.txtPainter.showButtonOnGlasspane((Button)cmp);
        }
    }

    public void pointerReleased(int x, int y) {
        this.txtPainter.clear();
        super.pointerReleased(x, y);
    }

    protected void initSpecialButtons() {
        this.specialButtons.clear();
        this.addSpecialButton("Shift", new Command("SH", 4), 15);
        this.addSpecialButton("Delete", new Command("Del", 2), 15);
        this.addSpecialButton("T9", new Command("T9", 7), 15);
        this.addSpecialButton("Mode", new Command(this.getNextMode(this.currentMode), 3));
        this.addSpecialButton("Space", new Command("Space", 6), 50);
        this.addSpecialButton("OK", new Command("Ok", 5));
    }

    protected void actionCommand(Command cmd) {
        super.actionCommand(cmd);
        switch (cmd.getId()) {
            case 5: {
                this.field.setText(this.inputField.getText());
                this.field.setCursorPosition(this.field.getText().length());
                this.dispose();
                break;
            }
            case 1: {
                Button btn = this.currentButton;
                String text = btn.getText();
                if (this.inputField.getText().length() == 0) {
                    this.inputField.setText(text);
                    this.inputField.setCursorPosition(text.length());
                    break;
                }
                this.inputField.insertChars(text);
                break;
            }
            case 6: {
                if (this.inputField.getText().length() == 0) {
                    this.inputField.setText(" ");
                    break;
                }
                this.inputField.insertChars(" ");
                break;
            }
            case 2: {
                this.inputField.deleteChar();
                break;
            }
            case 3: {
                this.currentMode = this.getNextMode(this.currentMode);
                Display.getInstance().callSerially(new Runnable(){

                    public void run() {
                        VirtualKeyboard.this.initInputButtons(VirtualKeyboard.this.upperCase);
                        VirtualKeyboard.this.currentButton.setText(VirtualKeyboard.this.getNextMode(VirtualKeyboard.this.currentMode));
                        VirtualKeyboard.this.setTransitionOutAnimator(CommonTransitions.createEmpty());
                        VirtualKeyboard.this.setTransitionInAnimator(CommonTransitions.createEmpty());
                        VirtualKeyboard.this.getTitleComponent().getStyle().setMargin(0, 0);
                        VirtualKeyboard.this.dispose();
                        VirtualKeyboard.this.show();
                        VirtualKeyboard.this.setTransitionOutAnimator(CommonTransitions.createSlide(1, false, 500));
                    }
                });
                return;
            }
            case 4: {
                if (this.currentMode.equals(QWERTY_MODE)) {
                    this.upperCase = !this.upperCase;
                    Display.getInstance().callSerially(new Runnable(){

                        public void run() {
                            VirtualKeyboard.this.initInputButtons(VirtualKeyboard.this.upperCase);
                            VirtualKeyboard.this.revalidate();
                        }
                    });
                }
                return;
            }
            case 7: {
                Display.getInstance().editString(this.inputField, this.inputField.getMaxSize(), this.inputField.getConstraint(), this.inputField.getText());
                this.finishedT9Edit = true;
            }
        }
    }

    protected TextField getInputField() {
        return this.inputField;
    }

    class TextPainter
    implements Painter {
        private Label label = new Label();
        private boolean paint = true;

        public TextPainter() {
            this.label.setUIID("VKBtooltip");
        }

        public void showButtonOnGlasspane(Button button) {
            if (this.label.getText().equals(button.getText())) {
                return;
            }
            this.paint = true;
            VirtualKeyboard.this.repaint(this.label.getAbsoluteX() - 2, this.label.getAbsoluteY() - 2, this.label.getWidth() + 4, this.label.getHeight() + 4);
            this.label.setText(button.getText());
            this.label.setSize(this.label.getPreferredSize());
            this.label.setX(button.getAbsoluteX() + (button.getWidth() - this.label.getWidth()) / 2);
            this.label.setY(button.getAbsoluteY() - this.label.getPreferredH() * 4 / 3);
            VirtualKeyboard.this.repaint(this.label.getAbsoluteX() - 2, this.label.getAbsoluteY() - 2, this.label.getPreferredW() + 4, this.label.getPreferredH() + 4);
        }

        public void paint(Graphics g, Rectangle rect) {
            if (this.paint) {
                this.label.paintComponent(g);
            }
        }

        private void clear() {
            this.paint = false;
            VirtualKeyboard.this.repaint();
        }
    }
}

