/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.table;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Label;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.TextField;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.events.DataChangedListener;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.table.TableLayout;
import com.sun.lwuit.table.TableModel;

public class Table
extends Container {
    private TableModel model;
    private Listener listener = new Listener();
    private boolean drawBorder = true;
    private int titleAlignment = 4;
    private int cellAlignment = 1;

    public Table(TableModel model) {
        this.model = model;
        this.updateModel();
        this.setUIID("Table");
    }

    private void updateModel() {
        Component c;
        int selectionRow = -1;
        int selectionColumn = -1;
        Form f = this.getComponentForm();
        if (f != null && (c = f.getFocused()) != null) {
            selectionRow = this.getCellRow(c);
            selectionColumn = this.getCellColumn(c);
        }
        this.removeAll();
        int columnCount = this.model.getColumnCount();
        this.setLayout(new TableLayout(this.model.getRowCount() + 1, columnCount));
        for (int iter = 0; iter < columnCount; ++iter) {
            Component header = this.createCellImpl(this.model.getColumnName(iter), -1, columnCount, false);
            this.addComponent(null, header);
        }
        for (int r = 0; r < this.model.getRowCount(); ++r) {
            for (int c2 = 0; c2 < columnCount; ++c2) {
                Object value = this.model.getValueAt(r, c2);
                boolean e = this.model.isCellEditable(r, c2);
                Component cell = this.createCellImpl(value, r, c2, e);
                this.addComponent(null, cell);
                cell.setFocusable(true);
                if (r != selectionRow || c2 != selectionColumn) continue;
                cell.requestFocus();
            }
        }
    }

    private Component createCellImpl(Object value, final int row, final int column, boolean editable) {
        Component c = this.createCell(value, row, column, editable);
        c.putClientProperty("row", new Integer(row));
        c.putClientProperty("column", new Integer(column));
        if (c instanceof TextArea) {
            ((TextArea)c).addActionListener(this.listener);
        }
        Style s = c.getSelectedStyle();
        s.setMargin(0, 0, 0, 0);
        if (this.drawBorder) {
            Border b = new Border(){

                public void paint(Graphics g, Component c) {
                    g.setColor(Table.this.getUnselectedStyle().getFgColor());
                    if (row == Table.this.getModel().getRowCount() - 1) {
                        if (column == Table.this.getModel().getColumnCount() - 1) {
                            g.drawRect(c.getX(), c.getY(), c.getWidth() - 1, c.getHeight() - 1);
                        } else {
                            g.drawRect(c.getX(), c.getY(), c.getWidth(), c.getHeight() - 1);
                        }
                    } else if (column == Table.this.getModel().getColumnCount() - 1) {
                        g.drawRect(c.getX(), c.getY(), c.getWidth() - 1, c.getHeight());
                    } else {
                        g.drawRect(c.getX(), c.getY(), c.getWidth(), c.getHeight());
                    }
                }
            };
            s.setBorder(b);
            s = c.getUnselectedStyle();
            s.setBorder(b);
        } else {
            s = c.getUnselectedStyle();
        }
        s.setBgTransparency(0);
        s.setMargin(0, 0, 0, 0);
        return c;
    }

    protected Component createCell(Object value, int row, int column, boolean editable) {
        if (row == -1) {
            Label header = new Label((String)value);
            header.setUIID("TableHeader");
            header.setAlignment(this.titleAlignment);
            return header;
        }
        if (editable) {
            TextField cell = new TextField(value.toString(), -1);
            cell.setLeftAndRightEditingTrigger(false);
            cell.setUIID("TableCell");
            return cell;
        }
        Label cell = new Label(value.toString());
        cell.setUIID("TableCell");
        cell.setAlignment(this.cellAlignment);
        return cell;
    }

    public void initComponent() {
        this.model.addDataChangeListener(this.listener);
    }

    public void deinitialize() {
        this.model.removeDataChangeListener(this.listener);
    }

    public void setModel(TableModel model) {
        this.model = model;
        this.updateModel();
        this.revalidate();
    }

    public TableModel getModel() {
        return this.model;
    }

    public boolean isDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean drawBorder) {
        this.drawBorder = drawBorder;
        this.repaint();
    }

    public int getTitleAlignment() {
        return this.titleAlignment;
    }

    public void setTitleAlignment(int titleAlignment) {
        this.titleAlignment = titleAlignment;
        this.repaint();
    }

    public int getCellColumn(Component cell) {
        Integer i = (Integer)cell.getClientProperty("column");
        if (i != null) {
            return i;
        }
        return -1;
    }

    public int getCellRow(Component cell) {
        Integer i = (Integer)cell.getClientProperty("row");
        if (i != null) {
            return i;
        }
        return -1;
    }

    public int getCellAlignment() {
        return this.cellAlignment;
    }

    public void setCellAlignment(int cellAlignment) {
        this.cellAlignment = cellAlignment;
        this.repaint();
    }

    class Listener
    implements DataChangedListener,
    ActionListener {
        Listener() {
        }

        public final void dataChanged(int row, int column) {
            Object value = Table.this.model.getValueAt(row, column);
            boolean e = Table.this.model.isCellEditable(row, column);
            Component cell = Table.this.createCellImpl(value, row, column, e);
            TableLayout t = (TableLayout)Table.this.getLayout();
            Table.this.removeComponent(t.getComponentAt(row + 1, column));
            Table.this.addComponent(t.createConstraint(row + 1, column), cell);
            Table.this.layoutContainer();
            cell.setFocusable(true);
            cell.requestFocus();
            Table.this.revalidate();
        }

        public void actionPerformed(ActionEvent evt) {
            TextArea t = (TextArea)evt.getSource();
            int row = Table.this.getCellRow(t);
            int column = Table.this.getCellColumn(t);
            Table.this.getModel().setValueAt(row, column, t.getText());
        }
    }
}

