/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.datastore;

import com.sonyericsson.fifa.data.feed.Feed;
import com.sonyericsson.fifa.data.feed.FeedItem;
import com.sonyericsson.fifa.datastore.FifaDB;
import java.util.Vector;

public class FeedDB
extends FifaDB {
    private static final String SUFIX_STORE_NAME = "_NEWS";
    private String storeName;
    private String teamCode;

    protected String getDBName() {
        return this.storeName;
    }

    public FeedDB(String teamCode) {
        this.teamCode = teamCode;
        this.storeName = String.valueOf(teamCode) + SUFIX_STORE_NAME;
    }

    public boolean saveFeed(Feed feed) {
        boolean result = false;
        if (feed != null) {
            result = true;
            Vector feeds = feed.getItems();
            int i = 0;
            while (i < feeds.size()) {
                ((FeedItem)feeds.elementAt(i)).setTeamCode(this.teamCode);
                ++i;
            }
            this.saveAll(feeds);
        }
        return result;
    }

    public Feed retrieveFeed() {
        Feed feed = new Feed();
        Vector records = this.retrieveAll();
        int i = 0;
        while (i < records.size()) {
            byte[] data = (byte[])records.elementAt(i);
            FeedItem feedItem = new FeedItem();
            feedItem.loadFromByteArray(data);
            feed.addItem(feedItem);
            ++i;
        }
        return feed;
    }

    public boolean deleteAllRecords() {
        return this.deleteAll();
    }
}

