/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.datastore;

import com.sonyericsson.fifa.data.Squad;
import com.sonyericsson.fifa.data.TeamComponent;
import com.sonyericsson.fifa.datastore.FifaDB;
import java.util.Vector;

public class SquadDB
extends FifaDB {
    private static final String SUFIX_STORE_NAME = "_SQUAD";
    private String storeName;

    protected String getDBName() {
        return this.storeName;
    }

    public SquadDB(String teamCode) {
        this.storeName = String.valueOf(teamCode) + SUFIX_STORE_NAME;
    }

    public boolean saveSquad(Squad squad) {
        boolean result = false;
        if (squad != null) {
            result = true;
            Vector teamComponents = squad.getComponents();
            this.saveAll(teamComponents);
        }
        return result;
    }

    public Squad retrieveSquad() {
        Squad squad = null;
        Vector records = this.retrieveAll();
        if (records.size() > 0) {
            squad = new Squad();
        }
        int i = 0;
        while (i < records.size()) {
            byte[] data = (byte[])records.elementAt(i);
            TeamComponent teamComponent = new TeamComponent();
            teamComponent.loadFromByteArray(data);
            squad.getComponents().addElement(teamComponent);
            ++i;
        }
        return squad;
    }

    public boolean deleteAllRecords() {
        return this.deleteAll();
    }
}

