/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.twitter;

import com.sonyericsson.twitter.APIListener;
import com.sonyericsson.twitter.Parser;
import com.sonyericsson.twitter.TwitterClient;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreNotFoundException;

public class APIHandler
implements APIListener {
    private boolean exit = false;
    private APIListener listener;
    private Vector extentRequests = new Vector(10, 10);
    private int TIMEOUT = 40000;
    private String auth = null;
    private String user = null;
    private int IDcounter = 0;
    private int signinID = -1;
    private static final String POS_NUM = "twitter";
    private static final String POS_PASS = "tweet3033";
    private String tUser = null;
    private String tAuth = null;
    private boolean tSave = false;
    private static final String RMS_NAME = "TwitterAccount";
    private static final String RMS_MIDLET = "Twitter";
    private static final String RMS_VENDOR = "Sony Ericsson Mobile Communications AB";
    private Vector locationRequests;
    private float longitude = Float.NaN;
    private float latitude = Float.NaN;
    private long dataCounter = 0L;
    private long dataSentCounter = 0L;
    private Timer dataTimer;
    private long lastUpdateTime = -1L;
    private long cacheInterval = 240000L;
    private TimerTask dataSender = new TimerTask(){

        public void run() {
            APIHandler.this.sendData();
        }
    };
    private Runnable dataRunnable = new Runnable(){

        public void run() {
            try {
                String url = TwitterClient._instance.getAppProperty("dataURL");
                if (url != null) {
                    String imei = System.getProperty("com.sonyericsson.imei");
                    url = url + "?IMEI=" + imei.substring(imei.indexOf(" ") + 1) + "&app=TwitterHS&appversion=" + TwitterClient._instance.getAppProperty("MIDlet-Version") + "&model=" + System.getProperty("microedition.platform") + "&mcc=" + System.getProperty("com.sonyericsson.net.mcc") + "&mnc=" + System.getProperty("com.sonyericsson.net.mnc") + "&cmcc=" + System.getProperty("com.sonyericsson.net.cmcc") + "&cmnc=" + System.getProperty("com.sonyericsson.net.cmnc") + "&dataReceived=" + Long.toString(APIHandler.this.dataCounter / 1024L) + "&dataSent=" + Long.toString(APIHandler.this.dataSentCounter / 1024L);
                    HttpConnection conn = (HttpConnection)Connector.open((String)url);
                    int code = conn.getResponseCode();
                    System.out.println(code + " - " + APIHandler.this.dataCounter + " - " + APIHandler.this.dataSentCounter);
                }
                APIHandler.this.dataCounter = 0L;
                APIHandler.this.dataSentCounter = 0L;
                APIHandler.this.saveData();
            }
            catch (Exception e) {
                System.out.println("Data transmission failed");
            }
        }
    };
    private static char[] map1;
    private boolean[] shallEncode = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, true, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, true};
    private static final String percent = "%";

    public void addToDataCounter(long size) {
        this.dataCounter += size;
    }

    public APIHandler(APIListener l) {
        this.listener = l;
        this.locationRequests = new Vector(1, 1);
        try {
            RecordStore r = RecordStore.openRecordStore((String)"TwitterDataAmount", (boolean)false);
            this.dataCounter = Long.parseLong(new String(r.getRecord(1)));
            this.dataSentCounter = Long.parseLong(new String(r.getRecord(2)));
        }
        catch (RecordStoreNotFoundException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dataTimer = new Timer();
        this.dataTimer.schedule(this.dataSender, 1L, 86400000L);
    }

    public int signIn(String user, String password, boolean saveUser, APIListener l) {
        int ID;
        this.tUser = user;
        this.tAuth = user + ":" + password;
        this.tSave = saveUser;
        try {
            this.tAuth = APIHandler.base64Encode(this.tAuth.getBytes("UTF8"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.signinID = ID = this.IDcounter++;
        new MonitorThread("https://twitter.com/account/verify_credentials.xml", ID, false, true, l);
        return ID;
    }

    public int tweet(String message, APIListener l) {
        if (this.user == null || message.length() > 140) {
            return -1;
        }
        int ID = this.IDcounter++;
        new MonitorThread("https://twitter.com/statuses/update.xml?status=" + this.urlEncode(message), ID, true, true, l);
        return ID;
    }

    public int tweetReply(String message, String messageID, String replyToUser, APIListener l) {
        if (this.user == null || message.length() > 140) {
            return -1;
        }
        if (!message.startsWith("@" + replyToUser)) {
            return this.tweet(message, l);
        }
        int ID = this.IDcounter++;
        new MonitorThread("https://twitter.com/statuses/update.xml?status=" + this.urlEncode(message) + "&in_reply_to_status_id=" + messageID, ID, true, true, l);
        return ID;
    }

    public int getTweet(String messageID, APIListener l) {
        int ID = this.IDcounter++;
        new MonitorThread("https://twitter.com/statuses/show/" + messageID + ".xml", ID, false, this.user != null, l);
        return ID;
    }

    public int deleteTweet(String messageID) {
        if (this.user == null) {
            return -1;
        }
        int ID = this.IDcounter++;
        new MonitorThread("https://twitter.com/statuses/destroy/" + messageID + ".xml", ID, true, true, null);
        return ID;
    }

    public int getUserByName(String name, APIListener l) {
        return this.getUser(name, true, l);
    }

    public int getUserByID(String ID, APIListener l) {
        return this.getUser(ID, false, l);
    }

    private int getUser(String userHandle, boolean isScreenName, APIListener l) {
        if (userHandle == null) {
            return -1;
        }
        int ID = this.IDcounter++;
        new MonitorThread("https://twitter.com/users/show.xml?" + (isScreenName ? "screen_name=" : "user_id=") + userHandle, ID, false, this.user != null, l);
        return ID;
    }

    public int getPublicTimeline(APIListener l, Parser p) {
        int ID = this.IDcounter++;
        new MonitorThread("https://twitter.com/statuses/public_timeline.xml", ID, false, false, l, p);
        return ID;
    }

    public int getFriendsTimeline(String olderThan, String newerThan, int count, int page, APIListener l, Parser p) {
        if (this.user == null) {
            return -1;
        }
        String params = "";
        String separator = "?";
        if (olderThan != null) {
            params = params + separator + "max_id=" + olderThan;
            separator = "&";
        }
        if (newerThan != null) {
            params = params + separator + "since_id=" + newerThan;
            separator = "&";
        }
        if (count != -1) {
            params = params + separator + "count=" + count;
            separator = "&";
        }
        if (page != -1) {
            params = params + separator + "page=" + page;
        }
        int ID = this.IDcounter++;
        new MonitorThread("https://twitter.com/statuses/friends_timeline.xml" + params, ID, false, true, l, p);
        return ID;
    }

    public int getUserTimeLineByName(String screenName, String olderThan, String newerThan, int count, int page, APIListener l) {
        return this.getUserTimeline(this.urlEncode(screenName), true, olderThan, newerThan, count, page, l);
    }

    public int getUserTimeLineByID(String userID, String olderThan, String newerThan, int count, int page, APIListener l) {
        return this.getUserTimeline(userID, false, olderThan, newerThan, count, page, l);
    }

    private int getUserTimeline(String userHandle, boolean isScreenName, String olderThan, String newerThan, int count, int page, APIListener l) {
        if (userHandle == null) {
            return -1;
        }
        String params = "";
        if (olderThan != null) {
            params = params + "&max_id=" + olderThan;
        }
        if (newerThan != null) {
            params = params + "&since_id=" + newerThan;
        }
        if (count != -1) {
            params = params + "&count=" + count;
        }
        if (page != -1) {
            params = params + "&page=" + page;
        }
        int ID = this.IDcounter++;
        new MonitorThread("https://twitter.com/statuses/user_timeline.xml?" + (isScreenName ? "screen_name=" : "user_id=") + userHandle + params, ID, false, this.user != null, l);
        return ID;
    }

    public int getMentions(String olderThan, String newerThan, int count, int page, APIListener l) {
        if (this.user == null) {
            return -1;
        }
        String params = "";
        String separator = "?";
        if (olderThan != null) {
            params = params + separator + "max_id=" + olderThan;
            separator = "&";
        }
        if (newerThan != null) {
            params = params + separator + "since_id=" + newerThan;
            separator = "&";
        }
        if (count != -1) {
            params = params + separator + "count=" + count;
            separator = "&";
        }
        if (page != -1) {
            params = params + separator + "page=" + page;
        }
        int ID = this.IDcounter++;
        new MonitorThread("https://twitter.com/statuses/mentions.xml" + params, ID, false, true, l);
        return ID;
    }

    public int getMyFollowers(int page, APIListener l) {
        if (this.user == null) {
            return -1;
        }
        int ID = this.IDcounter++;
        new MonitorThread("https://twitter.com/statuses/followers.xml" + (page != -1 ? "?page=" + page : ""), ID, false, true, l);
        return ID;
    }

    public int getMyFriends(int page, APIListener l) {
        if (this.user == null) {
            return -1;
        }
        int ID = this.IDcounter++;
        new MonitorThread("https://twitter.com/statuses/friends.xml" + (page != -1 ? "?page=" + page : ""), ID, false, true, l);
        return ID;
    }

    public int addFriendByName(String name) {
        return this.addFriend(this.urlEncode(name), true);
    }

    public int addFriendByID(String ID) {
        return this.addFriend(ID, false);
    }

    private int addFriend(String userHandle, boolean isScreenName) {
        if (this.user == null) {
            return -1;
        }
        int ID = this.IDcounter++;
        new MonitorThread("https://twitter.com/friendships/create.xml?" + (isScreenName ? "screen_name=" : "user_id=") + userHandle, ID, true, true, null);
        return ID;
    }

    public int removeFriendByName(String name) {
        return this.removeFriend(this.urlEncode(name), true);
    }

    public int removeFriendByID(String ID) {
        return this.removeFriend(ID, false);
    }

    private int removeFriend(String userHandle, boolean isScreenName) {
        if (this.user == null) {
            return -1;
        }
        int ID = this.IDcounter++;
        new MonitorThread("https://twitter.com/friendships/destroy.xml?" + (isScreenName ? "screen_name=" : "user_id=") + userHandle, ID, true, true, null);
        return ID;
    }

    public int addBlock(String userHandle) {
        if (this.user == null) {
            return -1;
        }
        int ID = this.IDcounter++;
        new MonitorThread("https://twitter.com/blocks/create/" + this.urlEncode(userHandle) + ".xml", ID, true, true, null);
        return ID;
    }

    public int removeBlock(String userHandle) {
        if (this.user == null) {
            return -1;
        }
        int ID = this.IDcounter++;
        new MonitorThread("https://twitter.com/blocks/destroy/" + this.urlEncode(userHandle) + ".xml", ID, true, true, null);
        return ID;
    }

    public int getUserFriendsByName(String name, int page, APIListener l) {
        return this.getUserFriends(this.urlEncode(name), true, page, l);
    }

    public int getUserFriendsByID(String ID, int page, APIListener l) {
        return this.getUserFriends(ID, false, page, l);
    }

    private int getUserFriends(String userHandle, boolean isScreenName, int page, APIListener l) {
        if (userHandle == null) {
            return -1;
        }
        int ID = this.IDcounter++;
        new MonitorThread("https://twitter.com/statuses/friends.xml?" + (isScreenName ? "screen_name=" : "user_id=") + userHandle + (page != -1 ? "&page=" + page : ""), ID, false, this.user != null, l);
        return ID;
    }

    public int getUserFollowersByName(String name, int page, APIListener l) {
        return this.getUserFollowers(this.urlEncode(name), true, page, l);
    }

    public int getUserFollowersByID(String ID, int page, APIListener l) {
        return this.getUserFollowers(ID, false, page, l);
    }

    private int getUserFollowers(String userHandle, boolean isScreenName, int page, APIListener l) {
        if (userHandle == null) {
            return -1;
        }
        int ID = this.IDcounter++;
        new MonitorThread("https://twitter.com/statuses/followers.xml?" + (isScreenName ? "screen_name=" : "user_id=") + userHandle + (page != -1 ? "&page=" + page : ""), ID, false, this.user != null, l);
        return ID;
    }

    public int getFriendsShort(String userID, APIListener l) {
        int ID = this.IDcounter++;
        new MonitorThread("https://twitter.com/friends/ids.xml?user_id=" + userID, ID, false, false, l);
        return ID;
    }

    public int getFollowersShort(String userID, APIListener l) {
        int ID = this.IDcounter++;
        new MonitorThread("https://twitter.com/followers/ids.xml?user_id=" + userID, ID, false, false, l);
        return ID;
    }

    public int createFavourite(String messageID, APIListener l) {
        if (this.user == null) {
            return -1;
        }
        int ID = this.IDcounter++;
        new MonitorThread("https://twitter.com/favorites/create/" + messageID + ".xml", ID, true, true, l);
        return ID;
    }

    public int getFavourites(int page, APIListener l) {
        if (this.user == null) {
            return -1;
        }
        int ID = this.IDcounter++;
        new MonitorThread("https://twitter.com/favorites.xml" + (page != -1 ? "?page=" + page : ""), ID, false, true, l);
        return ID;
    }

    public int removeFavourite(String messageID) {
        if (this.user == null) {
            return -1;
        }
        int ID = this.IDcounter++;
        new MonitorThread("https://twitter.com/favorites/destroy/" + messageID + ".xml", ID, true, true, null);
        return ID;
    }

    public int getPrivateMessages(String olderThan, String newerThan, int count, int page, APIListener l) {
        if (this.user == null) {
            return -1;
        }
        String params = "";
        String separator = "?";
        if (olderThan != null) {
            params = params + separator + "max_id=" + olderThan;
            separator = "&";
        }
        if (newerThan != null) {
            params = params + separator + "since_id=" + newerThan;
            separator = "&";
        }
        if (count != -1) {
            params = params + separator + "count=" + count;
            separator = "&";
        }
        if (page != -1) {
            params = params + separator + "page=" + page;
        }
        int ID = this.IDcounter++;
        new MonitorThread("https://twitter.com/direct_messages.xml" + params, ID, false, true, l);
        return ID;
    }

    public int getPrivateMessagesSent(String olderThan, String newerThan, int page, APIListener l) {
        if (this.user == null) {
            return -1;
        }
        String params = "";
        String separator = "?";
        if (olderThan != null) {
            params = params + separator + "max_id=" + olderThan;
            separator = "&";
        }
        if (newerThan != null) {
            params = params + separator + "since_id=" + newerThan;
            separator = "&";
        }
        if (page != -1) {
            params = params + separator + "page=" + page;
        }
        int ID = this.IDcounter++;
        new MonitorThread("https://twitter.com/direct_messages/sent.xml" + params, ID, false, true, l);
        return ID;
    }

    public int deletePrivateMessage(String messageID) {
        if (this.user == null) {
            return -1;
        }
        int ID = this.IDcounter++;
        new MonitorThread("https://twitter.com/direct_messages/destroy/" + messageID + ".xml", ID, true, true, null);
        return ID;
    }

    public int sendPrivateMessage(String recipient, String message, APIListener l) {
        if (this.user == null || recipient == null || message == null || message.length() > 140) {
            return -1;
        }
        int ID = this.IDcounter++;
        new MonitorThread("https://twitter.com/direct_messages/new.xml?user=" + this.urlEncode(recipient) + "&text=" + this.urlEncode(message), ID, true, true, l);
        return ID;
    }

    public int getTrends(boolean excludeHashTags, APIListener l) {
        int ID = this.IDcounter++;
        new MonitorThread("http://search.twitter.com/trends/current.json" + (excludeHashTags ? "?exclude=hashtags" : ""), ID, false, false, l);
        return ID;
    }

    public boolean needLocationUpdate() {
        if (this.lastUpdateTime == -1L) {
            return true;
        }
        return System.currentTimeMillis() - this.lastUpdateTime > this.cacheInterval;
    }

    public int searchAny(String searchString, int count, int page, APIListener l, Parser p) {
        int ID = this.IDcounter++;
        new MonitorThread("http://search.twitter.com/search.json?q=" + this.urlEncode(searchString) + (count != -1 ? "&rpp=" + count : "") + (page != -1 ? "&page=" + page : ""), ID, false, false, l, p);
        return ID;
    }

    public int searchFromUser(String searchString, int count, int page, APIListener l) {
        int ID = this.IDcounter++;
        new MonitorThread("http://search.twitter.com/search.json?q=from%3A" + this.urlEncode(searchString) + (count != -1 ? "&rpp=" + count : "") + (page != -1 ? "&page=" + page : ""), ID, false, false, l);
        return ID;
    }

    public int searchLocation(int range, boolean kilometers, boolean updateLocation, int count, int page, APIListener l, Parser p) {
        if (updateLocation && this.needLocationUpdate() || Float.isNaN(this.latitude) || Float.isNaN(this.longitude)) {
            int locationID = this.getLocation();
            if (locationID == -1) {
                return -1;
            }
            int ID = this.IDcounter++;
            this.locationRequests.addElement(new LocationRequest(locationID, ID, new SearchParams(null, range, kilometers, count, page), l, p));
            return ID;
        }
        int ID = this.IDcounter++;
        new MonitorThread("http://search.twitter.com/search.json?geocode=" + this.latitude + "%2C" + this.longitude + "%2C" + range + (kilometers ? "km" : "mi") + (count != -1 ? "&rpp=" + count : "") + (page != -1 ? "&page=" + page : ""), ID, false, false, l, p);
        return ID;
    }

    public int searchAnyWithLocation(String searchString, int range, boolean kilometers, boolean updateLocation, int count, int page, APIListener l) {
        if (searchString == null || searchString.equalsIgnoreCase("")) {
            return this.searchLocation(range, kilometers, updateLocation, count, page, l, null);
        }
        if (updateLocation && this.needLocationUpdate() || Float.isNaN(this.latitude) || Float.isNaN(this.longitude)) {
            int locationID = this.getLocation();
            if (locationID == -1) {
                return -1;
            }
            int ID = this.IDcounter++;
            this.locationRequests.addElement(new LocationRequest(locationID, ID, new SearchParams(searchString, range, kilometers, count, page), l, null));
            return ID;
        }
        int ID = this.IDcounter++;
        new MonitorThread("http://search.twitter.com/search.json?q=" + this.urlEncode(searchString) + "&geocode=" + this.latitude + "%2C" + this.longitude + "%2C" + range + (kilometers ? "km" : "mi") + (count != -1 ? "&rpp=" + count : "") + (page != -1 ? "&page=" + page : ""), ID, false, false, l);
        return ID;
    }

    private int getLocation() {
        String s = System.getProperty("com.sonyericsson.net.rat");
        if (s == null) {
            return -1;
        }
        int ID = this.IDcounter++;
        new MonitorThread("https://cell.sonyericsson.com", "phonenumber=twitter;password=tweet3033;cell=" + s.substring(0, 1) + "," + System.getProperty("com.sonyericsson.net.cmcc") + "," + System.getProperty("com.sonyericsson.net.cmnc") + "," + System.getProperty("com.sonyericsson.net.lac") + ",{" + System.getProperty("com.sonyericsson.net.cellid") + "}", ID, this);
        return ID;
    }

    public int updateMyLocation(APIListener l) {
        String lon;
        if (this.user == null) {
            return -1;
        }
        if (this.needLocationUpdate() || Float.isNaN(this.latitude) || Float.isNaN(this.longitude)) {
            int locationID = this.getLocation();
            if (locationID == -1) {
                return -1;
            }
            int ID = this.IDcounter++;
            this.locationRequests.addElement(new LocationRequest(locationID, ID, null, l, null));
            return ID;
        }
        int ID = this.IDcounter++;
        String lat = Float.toString(this.latitude);
        if (lat.length() > 13) {
            lat = lat.substring(0, 13);
        }
        if ((lon = Float.toString(this.longitude)).length() > 13) {
            lon = lon.substring(0, 13);
        }
        new MonitorThread("https://twitter.com/account/update_profile.xml?location=" + lat + "%2C" + lon, ID, true, true, l);
        return ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void twitterEvent(int ID, String response) {
        LocationRequest r = null;
        Vector vector = this.locationRequests;
        synchronized (vector) {
            for (int i = 0; i < this.locationRequests.size(); ++i) {
                r = (LocationRequest)this.locationRequests.elementAt(i);
                if (r.listenID != ID) continue;
                this.locationRequests.removeElement(r);
                break;
            }
        }
        if (r != null) {
            try {
                boolean error = false;
                if (!response.startsWith("cell=")) {
                    error = true;
                }
                int start = response.indexOf(",") + 1;
                int end = response.indexOf(",", start);
                if (start == 0) {
                    error = true;
                }
                if (!error && response.indexOf(",,") == -1) {
                    float newLat = Float.parseFloat(response.substring(start, end));
                    start = end + 1;
                    end = response.indexOf(",", start + 1);
                    float newLong = Float.parseFloat(response.substring(start, end));
                    this.latitude = newLat;
                    this.longitude = newLong;
                    this.saveLocation();
                }
                if (Float.isNaN(this.latitude) || Float.isNaN(this.longitude)) {
                    throw new Exception();
                }
                if (r.searchParams != null) {
                    if (r.searchParams.searchString == null) {
                        new MonitorThread("http://search.twitter.com/search.json?geocode=" + this.latitude + "%2C" + this.longitude + "%2C" + r.searchParams.range + (r.searchParams.kilometers ? "km" : "mi") + (r.searchParams.count != -1 ? "&rpp=" + r.searchParams.count : "") + (r.searchParams.page != -1 ? "&page=" + r.searchParams.page : ""), r.requestingID, false, false, r.listener, r.p);
                    } else {
                        new MonitorThread("http://search.twitter.com/search.json?q=" + this.urlEncode(r.searchParams.searchString) + "&geocode=" + this.latitude + "%2C" + this.longitude + "%2C" + r.searchParams.range + (r.searchParams.kilometers ? "km" : "mi") + (r.searchParams.count != -1 ? "&rpp=" + r.searchParams.count : "") + (r.searchParams.page != -1 ? "&page=" + r.searchParams.page : ""), r.requestingID, false, false, r.listener, r.p);
                    }
                } else {
                    String lon;
                    String lat = Float.toString(this.latitude);
                    if (lat.length() > 13) {
                        lat = lat.substring(0, 13);
                    }
                    if ((lon = Float.toString(this.longitude)).length() > 13) {
                        lon = lon.substring(0, 13);
                    }
                    new MonitorThread("https://twitter.com/account/update_profile.xml?location=" + lat + "%2C" + lon, r.requestingID, true, true, r.listener);
                }
            }
            catch (Exception e) {
                if (r.listener == null) {
                    this.listener.twitterEvent(r.requestingID, "901");
                }
                r.listener.twitterEvent(r.requestingID, "901");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveLocation() {
        this.lastUpdateTime = System.currentTimeMillis();
        String RMS_NAME = "TwitterLocation";
        String RMS_MIDLET = RMS_MIDLET;
        String RMS_VENDOR = RMS_VENDOR;
        RecordStore r = null;
        try {
            r = RecordStore.openRecordStore((String)RMS_NAME, (String)RMS_VENDOR, (String)RMS_MIDLET);
            String s = Float.toString(this.latitude) + "," + Float.toString(this.longitude);
            byte[] b = s.getBytes();
            if (r.getNumRecords() == 0) {
                r.addRecord(b, 0, b.length);
            } else {
                r.setRecord(1, b, 0, b.length);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (r != null) {
                try {
                    r.closeRecordStore();
                }
                catch (Exception e) {}
                r = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadLocation() {
        RecordStore r = null;
        String RMS_NAME = "TwitterLocation";
        String RMS_MIDLET = RMS_MIDLET;
        String RMS_VENDOR = RMS_VENDOR;
        try {
            r = RecordStore.openRecordStore((String)RMS_NAME, (String)RMS_VENDOR, (String)RMS_MIDLET);
            String s = new String(r.getRecord(1));
            this.lastUpdateTime = r.getLastModified();
            int index = s.indexOf(",");
            this.latitude = Float.parseFloat(s.substring(0, index));
            this.longitude = Float.parseFloat(s.substring(index + 1));
        }
        catch (Exception exception) {
        }
        finally {
            if (r != null) {
                try {
                    r.closeRecordStore();
                }
                catch (Exception e) {}
                r = null;
            }
        }
    }

    public int checkRateLimitIP(APIListener l) {
        int ID = this.IDcounter++;
        new MonitorThread("http://twitter.com/account/rate_limit_status.xml", ID, false, false, l);
        return ID;
    }

    public int checkRateLimitUser(APIListener l) {
        if (this.user == null) {
            return -1;
        }
        int ID = this.IDcounter++;
        new MonitorThread("http://twitter.com/account/rate_limit_status.xml", ID, false, true, l);
        return ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadUserFromRMS() {
        RecordStore r = null;
        try {
            r = RecordStore.openRecordStore((String)RMS_NAME, (String)RMS_VENDOR, (String)RMS_MIDLET);
            if (r.getNumRecords() == 0) {
                boolean bl = false;
                return bl;
            }
            this.user = new String(r.getRecord(1), "UTF8");
            this.auth = new String(r.getRecord(2), "UTF8");
            if (this.auth.equals(" ")) {
                this.user = null;
                this.auth = null;
                boolean bl = false;
                return bl;
            }
            TwitterClient.userName = this.user;
            boolean bl = true;
            return bl;
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (r != null) {
                try {
                    r.closeRecordStore();
                }
                catch (Exception e) {}
                r = null;
            }
        }
        return false;
    }

    private void sendData() {
        System.out.println("Sending data");
        if (this.dataCounter > 0L || this.dataSentCounter > 0L) {
            Thread t = new Thread(this.dataRunnable);
            t.start();
        }
    }

    public void endData() {
        this.dataSender.cancel();
        this.dataTimer.cancel();
        this.saveData();
    }

    private void saveData() {
        try {
            RecordStore r = RecordStore.openRecordStore((String)"TwitterDataAmount", (boolean)true);
            byte[] b = Long.toString(this.dataCounter).getBytes();
            if (r.getNumRecords() == 0) {
                r.addRecord(b, 0, b.length);
            } else {
                r.setRecord(1, b, 0, b.length);
            }
            b = Long.toString(this.dataSentCounter).getBytes();
            if (r.getNumRecords() < 2) {
                r.addRecord(b, 0, b.length);
            } else {
                r.setRecord(2, b, 0, b.length);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveUser() {
        RecordStore r = null;
        try {
            r = RecordStore.openRecordStore((String)RMS_NAME, (boolean)true, (int)1, (boolean)false);
            if (r.getNumRecords() == 0) {
                byte[] b = this.user.getBytes("UTF8");
                r.addRecord(b, 0, b.length);
                b = this.auth.getBytes("UTF8");
                r.addRecord(b, 0, b.length);
            } else {
                byte[] b = this.user.getBytes("UTF8");
                r.setRecord(1, b, 0, b.length);
                b = this.auth.getBytes("UTF8");
                r.setRecord(2, b, 0, b.length);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (r != null) {
                try {
                    r.closeRecordStore();
                }
                catch (Exception e) {}
                r = null;
            }
        }
    }

    public void clearRMS() {
        try {
            RecordStore.deleteRecordStore((String)RMS_NAME);
        }
        catch (RecordStoreNotFoundException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void closeAllConnections() {
        this.exit = true;
        while (!this.extentRequests.isEmpty()) {
            ConnectionThread t = (ConnectionThread)this.extentRequests.firstElement();
            t.cancel();
            this.extentRequests.removeElement(t);
        }
    }

    public boolean cancelConnection(int connectionID) {
        for (int i = 0; i < this.extentRequests.size(); ++i) {
            ConnectionThread t = (ConnectionThread)this.extentRequests.elementAt(i);
            if (t.ID != connectionID) continue;
            t.cancel();
            return true;
        }
        return false;
    }

    private static String base64Encode(byte[] in) {
        int iLen = in.length;
        int oDataLen = (iLen * 4 + 2) / 3;
        int oLen = (iLen + 2) / 3 * 4;
        char[] out = new char[oLen];
        int ip = 0;
        int op = 0;
        while (ip < iLen) {
            int i0 = in[ip++] & 0xFF;
            int i1 = ip < iLen ? in[ip++] & 0xFF : 0;
            int i2 = ip < iLen ? in[ip++] & 0xFF : 0;
            int o0 = i0 >>> 2;
            int o1 = (i0 & 3) << 4 | i1 >>> 4;
            int o2 = (i1 & 0xF) << 2 | i2 >>> 6;
            int o3 = i2 & 0x3F;
            out[op++] = map1[o0];
            out[op++] = map1[o1];
            out[op] = op < oDataLen ? map1[o2] : 61;
            int n = ++op < oDataLen ? map1[o3] : 61;
            out[op] = n;
            ++op;
        }
        return new String(out);
    }

    private String urlEncode(String input) {
        StringBuffer sb = new StringBuffer(100);
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if (ch > '\u007f' || this.shallEncode[ch]) {
                if (ch == ' ') {
                    sb.append('+');
                    continue;
                }
                sb.append(this.CTU(ch));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private String CTU(int in) {
        StringBuffer sb = new StringBuffer(12);
        if (in > 0x10FFFF) {
            return "?";
        }
        if (in > 65535) {
            int temp = in >>> 18;
            sb.append(percent);
            sb.append(Integer.toHexString(0xF0 | temp));
            temp = (in & 0x3F000) >>> 12;
            sb.append(percent);
            sb.append(Integer.toHexString(0x80 | temp));
            temp = (in & 0xFC0) >>> 6;
            sb.append(percent);
            sb.append(Integer.toHexString(0x80 | temp));
            temp = in & 0x3F;
            sb.append(percent);
            sb.append(Integer.toHexString(0x80 | temp));
        } else if (in > 2047) {
            int temp = in >>> 12;
            sb.append(percent);
            sb.append(Integer.toHexString(0xE0 | temp));
            temp = (in & 0xFC0) >>> 6;
            sb.append(percent);
            sb.append(Integer.toHexString(0x80 | temp));
            temp = in & 0x3F;
            sb.append(percent);
            sb.append(Integer.toHexString(0x80 | temp));
        } else if (in > 127) {
            int temp = in >>> 6;
            sb.append(percent);
            sb.append(Integer.toHexString(0xC0 | temp));
            temp = in & 0x3F;
            sb.append(percent);
            sb.append(Integer.toHexString(0x80 | temp));
        } else if (in > 15) {
            sb.append(percent);
            sb.append(Integer.toHexString(in));
        } else {
            sb.append(percent);
            sb.append("0");
            sb.append(Integer.toHexString(in));
        }
        return sb.toString();
    }

    static {
        int c;
        map1 = new char[64];
        int i = 0;
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            APIHandler.map1[i++] = c;
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            APIHandler.map1[i++] = c;
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            APIHandler.map1[i++] = c;
        }
        APIHandler.map1[i++] = 43;
        APIHandler.map1[i++] = 47;
    }

    private class SearchParams {
        String searchString;
        int range;
        boolean kilometers;
        int count;
        int page;

        public SearchParams(String searchString, int range, boolean kilometers, int count, int page) {
            this.searchString = searchString;
            this.range = range;
            this.kilometers = kilometers;
            this.count = count;
            this.page = page;
        }
    }

    private class LocationRequest {
        public int listenID;
        public int requestingID;
        public APIListener listener;
        public SearchParams searchParams;
        public Parser p = null;

        public LocationRequest(int internalID, int externalID, SearchParams searchParams, APIListener l, Parser p) {
            this.listenID = internalID;
            this.requestingID = externalID;
            this.listener = l;
            this.searchParams = searchParams;
            this.p = p;
        }
    }

    private class ConnectionThread
    implements Runnable {
        boolean canceled = false;
        HttpConnection connection = null;
        InputStream is = null;
        ByteArrayOutputStream bos = null;
        OutputStream os = null;
        String connectionString;
        String response = null;
        Object notify;
        int ID;
        boolean POST;
        boolean AUTH;
        int code;
        String content = null;
        Parser p = null;

        public ConnectionThread(String connectionString, String contentString, int ID, Object notify) {
            this.ID = ID;
            this.connectionString = connectionString;
            this.notify = notify;
            this.POST = true;
            this.AUTH = false;
            this.content = contentString;
            Thread t = new Thread(this);
            t.start();
        }

        public ConnectionThread(String connectionString, int ID, Object notify, boolean POST, boolean AUTH) {
            this.ID = ID;
            this.connectionString = connectionString;
            this.notify = notify;
            this.POST = POST;
            this.AUTH = AUTH;
            Thread t = new Thread(this);
            t.start();
        }

        public ConnectionThread(String connectionString, int ID, Object notify, boolean POST, boolean AUTH, Parser p) {
            this.ID = ID;
            this.connectionString = connectionString;
            this.notify = notify;
            this.POST = POST;
            this.AUTH = AUTH;
            this.p = p;
            Thread t = new Thread(this);
            t.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block100: {
                try {
                    byte[] data;
                    if (this.content != null) {
                        this.connection = (HttpConnection)Connector.open((String)this.connectionString);
                        this.connection.setRequestMethod("POST");
                        this.connection.setRequestProperty("User-Agent", "cellbatch");
                        this.os = this.connection.openOutputStream();
                        byte[] b = this.content.getBytes();
                        this.os.write(b);
                        APIHandler.this.dataSentCounter += b.length;
                    } else {
                        int pos;
                        this.connection = (HttpConnection)Connector.open((String)this.connectionString);
                        this.connection.setRequestMethod(this.POST ? "POST" : "GET");
                        if (this.AUTH) {
                            if (this.ID == APIHandler.this.signinID) {
                                this.connection.setRequestProperty("Authorization", "Basic " + APIHandler.this.tAuth);
                            } else {
                                this.connection.setRequestProperty("Authorization", "Basic " + APIHandler.this.auth);
                            }
                        }
                        if ((pos = this.connectionString.indexOf("?")) != -1) {
                            APIHandler.this.dataSentCounter += this.connectionString.substring(pos).length();
                        }
                    }
                    this.code = this.connection.getResponseCode();
                    this.is = this.connection.openInputStream();
                    int len = (int)this.connection.getLength();
                    if (this.p == null) {
                        if (len > 0) {
                            int actual = 0;
                            data = new byte[len];
                            for (int bytesread = 0; bytesread != len && actual != -1; bytesread += actual) {
                                actual = this.is.read(data, bytesread, len - bytesread);
                            }
                        } else {
                            int read;
                            len = 0;
                            this.bos = new ByteArrayOutputStream(32768);
                            while ((read = this.is.read()) != -1) {
                                this.bos.write(read);
                                ++len;
                            }
                            data = this.bos.toByteArray();
                        }
                        if (len > 0) {
                            APIHandler.this.dataCounter += data.length;
                            this.response = new String(data, "UTF8");
                        } else {
                            this.response = Integer.toString(this.code);
                        }
                        break block100;
                    }
                    this.p.startParse();
                    if (len > 0) {
                        int actual = 0;
                        data = new byte[1024];
                        String s = "";
                        for (int bytesread = 0; bytesread != len && actual != -1; bytesread += actual) {
                            actual = this.is.read(data);
                            if (actual <= 0) continue;
                            APIHandler.this.dataCounter += actual;
                            s = s + new String(data, 0, actual, "UTF8");
                            if (this.p.isCancelled()) {
                                this.response = "902";
                                return;
                            }
                            if (this.p.parsePartial(s) != -2) {
                                if (this.p.getRead() <= 0) continue;
                                s = s.substring(this.p.getRead());
                                continue;
                            }
                            break;
                        }
                    } else {
                        int read;
                        data = new byte[1024];
                        int i = 0;
                        String s = "";
                        while ((read = this.is.read()) != -1) {
                            data[i] = (byte)read;
                            if (++i != 1024) continue;
                            s = s + new String(data, 0, i, "UTF8");
                            if (this.p.isCancelled()) {
                                this.response = "902";
                                return;
                            }
                            APIHandler.this.dataCounter += i;
                            i = 0;
                            if (this.p.parsePartial(s) == -2) break;
                            if (this.p.getRead() <= 0) continue;
                            s = s.substring(this.p.getRead());
                        }
                        if (i != 0) {
                            APIHandler.this.dataCounter += i;
                            s = s + new String(data, 0, i, "UTF8");
                            this.p.parsePartial(s);
                        }
                    }
                    this.response = this.p.getType();
                }
                catch (IOException e) {
                    if (!this.canceled) {
                        e.printStackTrace();
                        this.cancel();
                        this.response = "901";
                    }
                }
                catch (NullPointerException e) {
                    if (!this.canceled) {
                        e.printStackTrace();
                        this.cancel();
                        this.response = "901";
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (!this.canceled) {
                        this.cancel();
                        this.response = "901";
                    }
                }
                finally {
                    if (this.bos != null) {
                        try {
                            this.bos.close();
                        }
                        catch (Exception e) {}
                        this.bos = null;
                    }
                    if (this.os != null) {
                        try {
                            this.os.close();
                        }
                        catch (Exception e) {}
                        this.os = null;
                    }
                    if (this.is != null) {
                        try {
                            this.is.close();
                        }
                        catch (Exception e) {}
                        this.is = null;
                    }
                    if (this.connection != null) {
                        try {
                            this.connection.close();
                        }
                        catch (Exception e) {}
                        this.connection = null;
                    }
                }
            }
            Object object = this.notify;
            synchronized (object) {
                try {
                    this.notify.notify();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void cancel() {
            this.canceled = true;
            this.response = "902";
            if (this.is != null) {
                try {
                    this.is.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.is = null;
            }
            if (this.bos != null) {
                try {
                    this.bos.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.bos = null;
            }
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.connection = null;
            }
        }
    }

    private class MonitorThread
    implements Runnable {
        Object notify;
        ConnectionThread connection;
        int ID;
        APIListener apiListener;

        public MonitorThread(String connectionString, String contentString, int ID, APIListener l) {
            System.out.println("MonitorThread: " + connectionString);
            this.apiListener = l != null ? l : APIHandler.this.listener;
            this.notify = new Object();
            this.ID = ID;
            this.connection = new ConnectionThread(connectionString, contentString, ID, this.notify);
            APIHandler.this.extentRequests.addElement(this.connection);
            Thread t = new Thread(this);
            t.start();
        }

        public MonitorThread(String connectionString, int ID, boolean POST, boolean AUTH, APIListener l) {
            System.out.println("MonitorThread: " + connectionString);
            this.apiListener = l != null ? l : APIHandler.this.listener;
            this.notify = new Object();
            this.ID = ID;
            this.connection = new ConnectionThread(connectionString, ID, this.notify, POST, AUTH);
            APIHandler.this.extentRequests.addElement(this.connection);
            Thread t = new Thread(this);
            t.start();
        }

        public MonitorThread(String connectionString, int ID, boolean POST, boolean AUTH, APIListener l, Parser p) {
            System.out.println("MonitorThread: " + connectionString);
            this.apiListener = l != null ? l : APIHandler.this.listener;
            this.notify = new Object();
            this.ID = ID;
            this.connection = new ConnectionThread(connectionString, ID, this.notify, POST, AUTH, p);
            APIHandler.this.extentRequests.addElement(this.connection);
            Thread t = new Thread(this);
            t.start();
        }

        public void run() {
            String response = this.monitorConnection();
            if (!APIHandler.this.exit && this.apiListener != null) {
                if (this.ID == APIHandler.this.signinID && this.connection.code == 200) {
                    APIHandler.this.user = APIHandler.this.tUser;
                    APIHandler.this.auth = APIHandler.this.tAuth;
                    if (APIHandler.this.tSave) {
                        APIHandler.this.saveUser();
                    }
                }
                this.apiListener.twitterEvent(this.ID, response);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String monitorConnection() {
            boolean timed = false;
            if (this.connection.response == null) {
                Object object = this.notify;
                synchronized (object) {
                    try {
                        if (APIHandler.this.TIMEOUT > 0) {
                            long t = System.currentTimeMillis();
                            this.notify.wait(APIHandler.this.TIMEOUT);
                            t = System.currentTimeMillis() - t;
                            if (t >= (long)APIHandler.this.TIMEOUT) {
                                timed = true;
                                this.connection.cancel();
                            }
                        } else {
                            this.notify.wait();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (APIHandler.this.exit) {
                return null;
            }
            APIHandler.this.extentRequests.removeElement(this.connection);
            if (timed) {
                return "903";
            }
            return this.connection.response;
        }
    }
}

