/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.twitter;

public class JSONParser {
    protected String json;
    protected int index;

    public void setJSON(String s) {
        if (s != null && (s.startsWith("{\"error\":\"") || s.startsWith("{\"results\":[]"))) {
            this.json = null;
            return;
        }
        this.json = s;
    }

    public int getNextItem(int index) {
        String k = "},{";
        int i = this.json.indexOf(k, index);
        if (i < 0) {
            return i;
        }
        return i + 1;
    }

    public int getEnd(int index) {
        String k = "}]";
        int i = this.json.indexOf(k, index);
        if (i < 0) {
            return i;
        }
        return i + 1;
    }

    private String entityDecode(String s) {
        String tmp = s.substring(this.index);
        if (tmp.startsWith("&amp;amp;")) {
            this.index += 6;
            return "&";
        }
        if (tmp.startsWith("&amp;gt;")) {
            this.index += 6;
            return ">";
        }
        if (tmp.startsWith("&amp;lt;")) {
            this.index += 6;
            return "<";
        }
        if (tmp.startsWith("&amp;")) {
            return "&";
        }
        if (tmp.startsWith("&gt;")) {
            return ">";
        }
        if (tmp.startsWith("&lt;")) {
            return "<";
        }
        if (tmp.startsWith("&quot;")) {
            return "\"";
        }
        return "&";
    }

    private String decode(String s) {
        int valueAsShort;
        String out = "";
        this.index = 0;
        int lastIndex = 0;
        this.index = s.indexOf("&");
        if (this.index > 0) {
            out = s.substring(0, this.index);
        }
        while (this.index >= 0) {
            if (s.charAt(this.index + 1) != '#') {
                out = out + this.entityDecode(s);
            } else {
                try {
                    valueAsShort = Integer.parseInt(s.substring(this.index + 2, s.indexOf(";", this.index + 2)), 10);
                    out = out + String.valueOf((char)valueAsShort);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            lastIndex = s.indexOf(";", this.index) >= 0 ? s.indexOf(";", this.index) + 1 : this.index + 1;
            this.index = s.indexOf("&", lastIndex);
            if (this.index <= 0) continue;
            out = out + s.substring(lastIndex, this.index);
        }
        out = out + s.substring(lastIndex);
        this.index = out.indexOf("\\");
        while (this.index >= 0) {
            if (out.charAt(this.index + 1) == 'u') {
                valueAsShort = Integer.parseInt(out.substring(this.index + 2, this.index + 6), 16);
                out = this.index == 0 ? String.valueOf((char)valueAsShort) + out.substring(this.index + 6) : out.substring(0, this.index) + String.valueOf((char)valueAsShort) + out.substring(this.index + 6);
            } else {
                out = this.index == 0 ? out.substring(this.index + 1) : out.substring(0, this.index) + out.substring(this.index + 1);
            }
            this.index = out.indexOf("\\", this.index + 1);
        }
        return out;
    }

    public String getValue(int index, String tag) {
        String k = "\"" + tag + "\":\"";
        int newIndex = this.json.indexOf(k, index);
        if (newIndex == -1) {
            return null;
        }
        newIndex = this.json.indexOf("\":\"", newIndex) + 3;
        int endIndex = this.json.indexOf("\",\"", newIndex);
        int e2 = this.json.indexOf("\"}", newIndex);
        if (e2 > -1 && (e2 < endIndex || endIndex == -1)) {
            endIndex = e2;
        }
        String tmp = this.json.substring(newIndex, endIndex);
        return this.decode(tmp);
    }

    public String getNumericValue(int index, String tag) {
        String k = "\"" + tag + "\":";
        int newIndex = this.json.indexOf(k, index);
        if (newIndex == -1) {
            return null;
        }
        newIndex = this.json.indexOf("\":", newIndex) + 2;
        int endIndex = this.json.indexOf(",", newIndex);
        int e2 = this.json.indexOf("}", newIndex);
        if (e2 > -1 && (e2 < endIndex || endIndex == -1)) {
            endIndex = e2;
        }
        String tmp = this.json.substring(newIndex, endIndex);
        return this.decode(tmp);
    }
}

