/*
 * Decompiled with CFR 0.152.
 */
package at.calista.framework.gui.core;

import at.calista.framework.debug.Debug;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.amms.GlobalManager;
import javax.microedition.amms.MediaProcessor;
import javax.microedition.amms.control.imageeffect.ImageTransformControl;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Calculation {
    public static Image scale2(Image image, int n2, int n3) {
        try {
            int[] nArray = new int[image.getWidth()];
            int[] nArray2 = new int[n2 * n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = image.getHeight() * ((i2 << 1) + 1) / (n3 * 2);
                if (-1 != n4) {
                    image.getRGB(nArray, 0, image.getWidth(), 0, n4, image.getWidth(), 1);
                }
                for (n4 = 0; n4 < n2; ++n4) {
                    int n5 = image.getWidth() * ((n4 << 1) + 1) / (n2 * 2);
                    nArray2[i2 * n2 + n4] = nArray[n5];
                }
            }
            return Image.createRGBImage((int[])nArray2, (int)n2, (int)n3, (boolean)false);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return null;
        }
    }

    public static Image scale2alt(Image image, int n2, int n3) {
        int[] nArray = new int[image.getHeight() * image.getWidth()];
        image.getRGB(nArray, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
        int[] nArray2 = new int[n2 * n3];
        int n4 = image.getHeight() / n3 * image.getWidth() - image.getWidth();
        int n5 = image.getHeight() % n3;
        int n6 = image.getWidth() / n2;
        int n7 = image.getWidth() % n2;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        for (int i2 = n3; i2 > 0; --i2) {
            int n11 = 0;
            for (int i3 = n2; i3 > 0; --i3) {
                nArray2[n8++] = nArray[n9];
                n9 += n6;
                if ((n11 += n7) < n2) continue;
                n11 -= n2;
                ++n9;
            }
            n9 += n4;
            if ((n10 += n5) < n3) continue;
            n10 -= n3;
            n9 += image.getWidth();
        }
        return Image.createRGBImage((int[])nArray2, (int)n2, (int)n3, (boolean)false);
    }

    public static Image scale(Image object, int n2, int n3) {
        int n4 = object.getWidth();
        int n5 = object.getWidth();
        int n6 = object.getHeight();
        int[] nArray = new int[n5 * n6];
        object.getRGB(nArray, 0, n4, 0, 0, n5, n6);
        object = new int[n2 * n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            int n7 = i2 * n2;
            int n8 = i2 * n6 / n3 * n4;
            for (int i3 = 0; i3 < n2; ++i3) {
                object[n7 + i3] = (Image)nArray[n8 + i3 * n5 / n2];
            }
        }
        Image image = Image.createRGBImage((int[])object, (int)n2, (int)n3, (boolean)true);
        return image;
    }

    public static Image rotateImage(Image image, int n2) {
        int n3 = image.getWidth();
        int n4 = image.getHeight();
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3 * n4];
        int n5 = 0;
        for (int i2 = 0; i2 < n4; ++i2) {
            image.getRGB(nArray, 0, n3, 0, i2, n3, 1);
            for (int i3 = 0; i3 < n3; ++i3) {
                n5 = n2 == 90 ? n4 - i2 - 1 + i3 * n4 : (n2 == 270 ? i2 + n4 * (n3 - i3 - 1) : n3 * n4 - (i2 * n3 + i3) - 1);
                nArray2[n5] = nArray[i3];
            }
        }
        if (n2 == 90 || n2 == 270) {
            return Image.createRGBImage((int[])nArray2, (int)n4, (int)n3, (boolean)true);
        }
        return Image.createRGBImage((int[])nArray2, (int)n3, (int)n4, (boolean)true);
    }

    public static final String getCaptureSupport(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        String string2 = System.getProperty("supports." + string + ".capture");
        if (string2 != null && !string2.trim().equals("")) {
            stringBuffer.append(" capture supported");
            string2 = System.getProperty("supports.recording");
            if (string2 != null && !string2.trim().equals("")) {
                string2 = System.getProperty(string + ".encodings");
                if (string2 != null && !string2.trim().equals("")) {
                    stringBuffer.append(", recording supported to ");
                    stringBuffer.append(string2);
                } else {
                    stringBuffer.append(", recording not supported for this media format");
                }
            } else {
                stringBuffer.append(", recording not supported");
            }
            string2 = System.getProperty(string + ".snapshot.encodings");
            if (string2 != null) {
                stringBuffer.append(", snapshots supported to ");
                stringBuffer.append(string2);
            }
        } else {
            stringBuffer.append(" capture not supported");
        }
        return stringBuffer.toString();
    }

    public static final Image getThumbFromFile(InputStream inputStream, String object) {
        if (inputStream == null) {
            return null;
        }
        object = new byte[25600];
        byte[] byArray = new byte[]{0};
        byte by = 0;
        int n2 = 0;
        try {
            inputStream.read(byArray);
            byte by2 = byArray[0];
            inputStream.read(byArray);
            by = byArray[0];
            int n3 = 0;
            if (Calculation.isJPEG(by2, by)) {
                by2 = 0;
                while (true) {
                    if (by2 != -1) {
                        inputStream.read(byArray);
                        by2 = byArray[0];
                        if (++n3 <= 25600) continue;
                        inputStream.close();
                        return null;
                    }
                    inputStream.read(byArray);
                    by2 = byArray[0];
                    if ((by2 & 0xFF) == 216) break;
                }
                ++n2;
                object[0] = -1;
                ++n2;
                object[1] = by2;
                by2 = 0;
                while (true) {
                    if (by2 != -1) {
                        inputStream.read(byArray);
                        by2 = byArray[0];
                        object[n2++] = by2;
                        continue;
                    }
                    inputStream.read(byArray);
                    by2 = byArray[0];
                    object[n2++] = by2;
                    if ((by2 & 0xFF) == 217) break;
                }
                byArray = new byte[n2];
                object[n2] = -1;
                System.arraycopy(object, 0, byArray, 0, n2);
                object = null;
                try {
                    object = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
                }
                catch (Exception exception) {
                    Debug.appenderror(" createImg " + exception.toString());
                }
                inputStream.close();
                return object;
            }
            inputStream.close();
        }
        catch (Exception exception) {
            Debug.appenderror(" getThumbFromFile " + exception.toString());
        }
        return null;
    }

    public static Image resizeImage(InputStream inputStream, int n2, int n3) {
        if (Calculation.hasAMMS()) {
            try {
                GlobalManager.getSupportedMediaProcessorInputTypes();
                MediaProcessor mediaProcessor = null;
                mediaProcessor = GlobalManager.createMediaProcessor((String)"image/jpeg");
                mediaProcessor.setInput(inputStream, -1);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                mediaProcessor.setOutput((OutputStream)byteArrayOutputStream);
                ImageTransformControl imageTransformControl = (ImageTransformControl)mediaProcessor.getControl("javax.microedition.amms.control.imageeffect.ImageTransformControl");
                imageTransformControl.setTargetSize(n2, n3, 0);
                imageTransformControl.setEnforced(true);
                imageTransformControl.setEnabled(true);
                mediaProcessor.complete();
                inputStream.close();
                return Image.createImage((byte[])byteArrayOutputStream.toByteArray(), (int)0, (int)byteArrayOutputStream.size());
            }
            catch (Exception exception) {
                Debug.appenderror("resImg:" + exception.getMessage() + " no mediaprocessor");
            }
        } else {
            Debug.appenddebug("no amms!");
        }
        return null;
    }

    public static final boolean isJPEG(byte by, byte by2) {
        return (by & 0xFF) == 255 && (by2 & 0xFF) == 216;
    }

    public static final Image colorGradiant(int n2, int n3, int n4) {
        int[] nArray = new int[n3 * n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = n2 * i2 / (n4 - 1);
            n5 = n5 | n5 << 8 | n5 << 16;
            for (int i3 = 0; i3 < n3; ++i3) {
                nArray[i2 * n3 + i3] = n5;
            }
        }
        Image image = Image.createRGBImage((int[])nArray, (int)n3, (int)n4, (boolean)false);
        return image;
    }

    public static final boolean hasAMMS() {
        return System.getProperty("microedition.amms.version") != null && System.getProperty("microedition.amms.version").equals("1.0");
    }

    public static final Image createText(String string, Font font, int n2) {
        int n3 = font.stringWidth(string);
        int n4 = font.getHeight();
        Image image = Image.createImage((int)n3, (int)n4);
        Graphics graphics = image.getGraphics();
        graphics.setFont(font);
        graphics.setColor(0);
        graphics.fillRect(0, 0, n3, n4);
        graphics.setColor(0xFFFFFF);
        graphics.drawString(string, 0, 0, 20);
        return Calculation.rotateImage(image, n2);
    }
}

