MI             +<!DOCTYPE config SYSTEM "config.dtd">
<config info="FRANCE CONFIGURATION FILE Frida CA1" >

	<!-- Options -->
	<options searchDialler="false"
		myNumber="false"
		maxSidebarMenus="12"
		maxShortcutItems="7"
		maxVips="5" 
		maxEmailAccounts="5">
	
		<iconPaths>
			<sidebarMenus>/Icons/SideBarMenus/</sidebarMenus>
			<dataDisplayArea>/Icons/SideBar/DataDisplayArea/</dataDisplayArea>
			<indicators>/Icons/SideBar/Indicators/</indicators>
		</iconPaths>
		
		<dataIcon type="EMAIL" indicatorHint="downright">Email.png</dataIcon>
		<dataIcon type="EVENT" indicatorHint="downright">Event.png</dataIcon>
		<dataIcon type="IMCONVERSATION" indicatorHint="downright">IM.png</dataIcon>
		<dataIcon type="MISSEDCALL" indicatorHint="topleft">MissedCall.png</dataIcon>
		<dataIcon type="MISSEDVISIO" indicatorHint="topleft">MissedVideoCall.png</dataIcon>
		<dataIcon type="MMS" indicatorHint="downright">MMS.png</dataIcon>
		<dataIcon type="SMS" indicatorHint="downright">SMS.png</dataIcon>	
		
		
		<shortcutRSK id="back" language_id="185">
			<defaultAction type="custom">back</defaultAction>
		</shortcutRSK>
		
	</options>
	
	
	<!-- List of sidebar menus -->
	<sidebar>
		<!-- menus displayed on the sidebar !! ORDERED !! MUST NOT EXCEED max_sidebar_menus options -->
		<displayed> 
			<menuId>orangeWorld</menuId>
			<menuId>call_log</menuId>
			<menuId>contacts</menuId>
			<menuId>messaging</menuId>
			<menuId>musicPlayer</menuId>
			<menuId>orangeDownloads</menuId>
			<menuId>orangeMaps</menuId>
			<menuId>orangeTV</menuId>
			<menuId>orangeGames</menuId>
			<menuId>orangeMusic</menuId>
			<menuId>orangeWidgets</menuId>
		</displayed>
		<!-- menus available for add -->
		<available>
			<menuId>calendar</menuId>
			<menuId>profile</menuId>
			<menuId>alarm</menuId>
			<menuId>email</menuId>
			<menuId>orangePhoto</menuId>
			<menuId>mediaMenu</menuId>		
			<menuId>connections</menuId>
			<menuId>mobile_backup</menuId>
		</available>
	</sidebar>
	
	<!-- List of all handlers -->
	<handlers>
		<!-- one handler created for each data type (handler= type name) -->
		<type>SMS</type>		
		<type>MMS</type>		
		<type>EMAIL</type>		
		<type>IMCONVERSATION</type>		
		<type>EVENT</type>		
		<type>MISSEDCALL</type>		
		<type>MISSEDVISIO</type>	
		
		<!-- multi-type handlers -->
		<handler id="all">
			<type>SMS</type>
			<type>MMS</type>
			<type>EMAIL</type>
			<type>IMCONVERSATION</type>
			<type>MISSEDCALL</type>
			<type>MISSEDVISIO</type>			
		</handler>
		<handler id="missedAllCalls">
			<type>MISSEDCALL</type>
			<type>MISSEDVISIO</type>			
		</handler>
		<handler id="unifiedWithoutEmail">
			<type>SMS</type>
			<type>MMS</type>			
		</handler>
	</handlers>

	<!-- Orange WORLD -->
	<menu id="orangeWorld" language_id="1">
		<iconUnselected>hs3_orangeworld_unselected.png</iconUnselected>		
		<item id="orangeWorld" language_id="1">
			<defaultAction type="url">http://www.orange.fr</defaultAction>
		</item>
		<item id="music" language_id="9">
			<defaultAction type="url">http://musique.mob3.orange.fr</defaultAction>
		</item>
		<item id="games" language_id="31">
			<defaultAction type="url">http://jeux.mob3.orange.fr</defaultAction>
		</item>
		<item id="tv_video" language_id="30">
			<defaultAction type="url">http://tvvideo.mob3.orange.fr</defaultAction>
		</item>
		<item id="my_communities" language_id="35">
			<defaultAction type="url">http://mobile.orange.fr/0/accueil/Retour?SA=MOCDEVICE</defaultAction>
		</item>
		<item id="gallery" language_id="36">
			<defaultAction type="url">http://gallery.mob3.orange.fr</defaultAction>
		</item>
		<item id="myBookmark" language_id="33">
			<defaultAction type="launch">browser:bookmarks</defaultAction>
		</item>
	</menu>

	<!-- CALL LOG -->
	<menu id="call_log" language_id="5" locked="true">
		<iconUnselected>hs3_callhistory_unselected.png</iconUnselected>
		<item id="voicemail" language_id="58">
			<defaultAction type="call">888</defaultAction>
		</item>
		<item id="missedCalls" language_id="60" custom="handler">
			<defaultAction type="launch">calls:missed</defaultAction>
			<action id="call_log_sc" language_id="57" nbData="0" type="launch">calls</action>
			<action id="missedCalls" language_id="60" nbData="1" type="custom">data</action>
			<handlerId>missedAllCalls</handlerId><!-- Handler name MUST refers to those ones listed between <handlersList></handlersList> tags above -->
			<indicator>MISSEDCALL</indicator>
			<indicator>MISSEDVISIO</indicator>
		</item>		
		<item id="call_plan" language_id="61">
			<defaultAction type="call">#123#</defaultAction>  <!-- FR -->
		</item>
	</menu>

	<!-- CONTACTS -->
	<menu id="contacts" language_id="4" locked="true">
		<iconUnselected>hs3_contact_unselected.png</iconUnselected>
		<item id="contact_list" language_id="54">
			<defaultAction type="launch">contacts</defaultAction>
		</item>		
		<item id="vipContact" language_id="56" custom="vip">
			<defaultAction type="custom"></defaultAction>
		</item>		
	</menu>
	
		
	<!-- MESSAGES -->
	<menu id="messaging" language_id="6" locked="true">
		<iconUnselected>hs3_messages_unselected.png</iconUnselected>
		<item id="writeMessage" language_id="62">
			<defaultAction type="launch">message:new</defaultAction>
		</item>
		<item id="inbox" language_id="64" custom="handler">
			<defaultAction type="launch">message:inbox</defaultAction>
			<action nbData="1" id="view_message" language_id="65" type="custom">data</action>
			<handlerId>unifiedWithoutEmail</handlerId>			
			<indicator>SMS</indicator>
			<indicator>MMS</indicator>			
		</item>		
		<item id="orangeMessenger" language_id="18">
			<defaultAction type="java_launch">Messenger</defaultAction>
		</item>	
	</menu>
	
	<!-- Music Player -->
	<menu id="musicPlayer" language_id="10">
		<iconUnselected>hs3_music_playing_unselected.png</iconUnselected>
		<item id="musicPlayer" language_id="10" custom="mplayer">
			<defaultAction type="custom" />
		</item>	
	</menu>
	
	<!-- Orange DOWNLOADS -->
	<menu id="orangeDownloads" language_id="17">
		<iconUnselected>hs3_orangedownload_unselected.png</iconUnselected>
		<item id="orangeDownloads" language_id="17">
			<defaultAction type="java_launch">Orange Downloads</defaultAction>
		</item>	
	</menu>
		
	<!-- Orange MUSIC -->
	<menu id="orangeMusic" language_id="8">
		<iconUnselected>hs3_music_unselected.png</iconUnselected>
		<item id="musicStore" language_id="70">
			<defaultAction type="url">http://musicstore.mob2.orange.fr</defaultAction>
		</item>
		<item id="myMusic" language_id="69">
			<defaultAction type="launch">music:playlist</defaultAction>
		</item>
	</menu>
		
	<!-- Orange GAMES -->
	<menu id="orangeGames" language_id="20">
		<iconUnselected>hs3_games_unselected.png</iconUnselected>
		<item id="orangeGames" language_id="20">
			<defaultAction type="java_launch">Orange Games</defaultAction>
		</item>	
	</menu>
	
	<!-- Orange WIDGETS PLAYER - MEMO -->
	<menu id="orangeWidgets" language_id="21">
		<iconUnselected>hs3_orangewidgetsplayer_unselected.png</iconUnselected>
		<item id="orangeWidgets" language_id="21">
			<defaultAction type="java_launch">Orange Widgets</defaultAction>
		</item>	
	</menu>
	
	<!-- Orange MAPS -->
	<menu id="orangeMaps" language_id="22">
		<iconUnselected>hs3_orangemaps_unselected.png</iconUnselected>
		<item id="orangeMaps" language_id="22">
			<defaultAction type="java_launch">Orange Maps</defaultAction>
		</item>	
	</menu>
	
	<!-- Orange TV -->
	<menu id="orangeTV" language_id="15">
		<iconUnselected>hs3_tv_unselected.png</iconUnselected>
		<item id="orangeTV" language_id="15">
			<defaultAction type="java_launch">Orange TV player</defaultAction>
		</item>
	</menu>
	
	
		
	<!-- CALENDAR -->
	<menu id="calendar" language_id="3">
		<iconUnselected>hs3_calendar_unselected.png</iconUnselected>
		<item id="today" language_id="52" custom="handler" time="true" >
			<defaultAction type="launch">calendar</defaultAction>
			<action nbData="0" id="calendar" language_id="3" type="launch">calendar</action>
			<action nbData="1" id="today" language_id="52" type="custom">data</action>
			<handlerId>EVENT</handlerId>	
			<indicator>EVENT</indicator>
		</item>
		<item id="addAppointment" language_id="53">
			<defaultAction type="launch">calendar:new</defaultAction>
		</item>
	</menu>
		
	<!-- Profile -->
	<menu id="profile" language_id="11">
		<iconUnselected>hs3_profile_unselected.png</iconUnselected>
		<item id="set_profile" language_id="71">
			<defaultAction type="launch">profile</defaultAction>
		</item>	
	</menu>
	
	<!-- Alarm -->
	<menu id="alarm" language_id="12">
		<iconUnselected>hs3_alarm_unselected.png</iconUnselected>		
		<item id="alarm" language_id="12" custom="alarm">
			<defaultAction type="launch">alarm</defaultAction>
		</item>	
	</menu>		
	
	<!-- EMAIL -->
	<menu id="email" language_id="13">
		<iconUnselected>hs3_emails_unselected.png</iconUnselected>
		<item id="write_email" language_id="75" >
			<defaultAction type="launch">email:new</defaultAction>						
		</item>
		<item id="EmailInbox" language_id="74" custom="handler" >
			<defaultAction type="launch">email:inbox</defaultAction>
			<action nbData="1" id="view_message" language_id="65" type="custom">data</action>
			<handlerId>EMAIL</handlerId>
			<indicator>EMAIL</indicator>
		</item>
		<item id="email" language_id="13" custom="email" >
			<defaultAction type="launch">email:accounts</defaultAction>
		</item>	
	</menu>

	<!-- Orange PHOTOGRAPHY -->
	<menu id="orangePhoto" language_id="19" >
		<iconUnselected>hs3_orange_photo_unselected.png</iconUnselected>
		<item id="orangePhoto" language_id="19" >
			<defaultAction type="java_launch">Orange Photo</defaultAction>
		</item>	
	</menu>
	
	<!-- MEDIA -->
	<menu id="mediaMenu" language_id="7" >
		<iconUnselected>hs3_gen_media_unselected.png</iconUnselected>
		<item id="takePicture" language_id="66">
			<defaultAction type="launch">camera</defaultAction>
		</item>
		<item id="mediaMenu" language_id="7">
			<defaultAction type="launch">multimedia</defaultAction>
		</item>
	</menu>
		
	
	<!-- CONNECTIONS -->
	<menu id="connections" language_id="23">
		<iconUnselected>hs3_connection_unselected.png</iconUnselected>
		<item id="bluetooth" language_id="80" custom="connection">
			<defaultAction type="launch">bluetooth</defaultAction>			
		</item>
		<item id="flight_mode" language_id="81" custom="connection">
			<defaultAction type="launch">flightmode</defaultAction>			
		</item>
	</menu>
	  
	<!-- MOBILE BACKUP AND RESTORE -->
	<menu id="mobile_backup" language_id="25">
		<iconUnselected>hs3_backup_unselected.png</iconUnselected>
		<item id="mobile_backup" language_id="25">
			<defaultAction type="launch">synchronisation</defaultAction>
		</item>
	</menu>
	
	
		
</config>
